#!/usr/bin/perl
#
# Convert RDFStore RDQL queries into the RDF Query Tests and Results format
# see - http://www.w3.org/2003/03/rdfqr-tests/
#
# The script reads RDF/XML inputs/ and writes into queries/ and results/
# It prints on the STDOUT the Manifest into RDF/XML format.
# To run this script you need the latest RDFStore installation at
# http://rdfstore.sourceforge.net/downloads/snap.tgz or direclty check
# out the CVS distribution (see http://rdfstore.sf.net howto)
#
# Author: Alberto Reggiori <alberto@asemantics.com>
# Date: Wed May 14 12:58:54 CEST 2003

use strict ;
 
umask(0);
 
use RDQL::Parser;
use DBI;
use RDFStore::NodeFactory;
use RDFStore::Parser::SiRPAC;
use File::Path qw(rmtree mkpath);

my $factory= new RDFStore::NodeFactory();
my $tt=0;
#RDQL queries
my  $dbh= DBI->connect("DBI:RDFStore:", "root", 0, { nodeFactory => $factory, asRDF => 1 } );

my $now = `date`;
chop($now);
my $num=0;

print <<HEADER;
<?xml version="1.0" encoding="UTF-8"?>

<!DOCTYPE rdf:RDF [ 
  <!ENTITY mf "http://www.w3.org/2003/03/rdfqr-tests/manifest.rdfs#">
  <!ENTITY tq "http://www.w3.org/2003/03/rdfqr-tests/query.rdfs#">
 ]>

<rdf:RDF
    xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#"
    xmlns:mf="&mf;"
    xmlns:tq="&tq;"
    xmlns:dc="http://purl.org/dc/elements/1.1/" >

<rdf:Description>
   <dc:author>Alberto Reggiori</dc:author>
   <dc:date>$now</dc:date>
   <mf:tests rdf:parseType='Collection'>
HEADER

dump_query(<<QUERY, 'rss10', 'Basic RSS 1.0 channel RDF query', 'rss10-01' );
SELECT ?title, ?link
FROM <file:inputs/rss10.php>
WHERE
	(?item, <rdf:type>, <rss:item>),
	(?item, <rss::title>, ?title),
	(?item, <rss::link>, ?link)
USING
	rdf for <http://www.w3.org/1999/02/22-rdf-syntax-ns#>,
	rss for <http://purl.org/rss/1.0/>
QUERY

dump_query(<<QUERY, 'rss10-ft1', 'RSS 1.0 channel RDF query with free-text in triple-patterns', 'rss10-02' );
SELECT ?link, ?title
FROM <file:inputs/rss10.php>
WHERE
	(?item, <rdf:type>, <rss:item>),
	(?item, <rss::title>, %"February"% ),
	(?item, <rss::title>, ?title ),
	(?item, <rss::link>, ?link)
USING
	rdf for <http://www.w3.org/1999/02/22-rdf-syntax-ns#>,
	rss for <http://purl.org/rss/1.0/>
QUERY

my $kk;
my $query;

dump_query(<<QUERY, 'rss10-ft2', 'RSS 1.0 channel RDF query with free-text in constratins', 'rss10-03' );
SELECT ?title, ?link
FROM <file:inputs/rss10.php>
WHERE
	(?item, <rdf:type>, <rss:item>),
	(?item, <rss::title>, ?title),
	(?item, <rss::link>, ?link)
AND 
        ?title LIKE '/(4 February)/i'
USING
	rdf for <http://www.w3.org/1999/02/22-rdf-syntax-ns#>,
	rss for <http://purl.org/rss/1.0/>
QUERY

dump_query(<<QUERY, 'mkdoc', 'MKDoc testers example', 'mkdoc-01' );
SELECT 	?x, ?title, ?a, ?moddate, ?createddate, ?name, ?creatormail
FROM 	<file:inputs/dc3.rdf>
WHERE
	( ?x, <dc:title>, ?title),
	( ?x, <dcq:modified>, ?m),
	( ?m, <rdf:value>, ?moddate),
	( ?x, <dcq:created>, ?cd),
	( ?cd, <rdf:value>, ?createddate),
	( ?x, <dcq:abstract>, ?a),
	( ?cr, <vcard:FN>, ?name),
	( ?x, <dc:creator>, ?cr),
	( ?cr, <vcard:EMAIL>, ?creatormail)
USING 	dcq for <http://dublincore.org/2000/03/13/dcq#>,
	rdf for <http://www.w3.org/1999/02/22-rdf-syntax-ns#>,
	vcard for <http://www.w3.org/2001/vcard-rdf/3.0#>,
	dc for <http://purl.org/dc/elements/1.1/>
QUERY

dump_query(<<QUERY, 'jobs-rss', 'RSS 1.0 for job advertisements', 'rss10-04' );
SELECT ?sal, ?t, ?x  
FROM	<file:inputs/jobs-rss.rdf>,
	<file:inputs/jobs.rss>
WHERE 
   (?x, <job:advertises>, ?y),
   (?y, <job:title>, ?t) ,
   (?y, <job:salary>, ?sal)
AND (?sal == 100000) && (?x eq <http://www.lotsofjobs.com/job2>)
USING job for <http://ilrt.org/discovery/2000/11/rss-query/jobvocab.rdf#>

QUERY

dump_query(<<QUERY, 'etb-mandatory', 'ETB sample RDF record query', 'etb-01' );
SELECT
	?titlevalue, ?titlelanguage,
	?subjectvalue,?subjectlanguage,
	?descriptionvalue, ?descriptionlanguage,
	?language,
	?identifier
FROM
	<file:inputs/example10.xml>
WHERE
	( ?tt, <rdf:value>, ?titlevalue),
	( ?x, <dc:title>, ?tt),
	( ?ttl, <dcq:RFC1766>, ?titlelanguage),
	( ?ss1, <etbthes:ETBT>, ?ss2),
	( ?x, <dc:subject>, ?ss1),
	( ?ss2, <rdf:value>, ?subjectvalue),
	( ?tt, <dc:language>, ?ttl),
	( ?ss2, <dc:language>, ?ss3),
	( ?ss3, <dcq:RFC1766>, ?subjectlanguage),
	( ?x, <dc:description>, ?dd),
	( ?ddl, <dcq:RFC1766>, ?descriptionlanguage),
	( ?dd, <rdf:value>, ?descriptionvalue),
	( ?x, <dc:identifier>, ?identifier),
	( ?dd, <dc:language>, ?ddl),
	( ?ll1, <dcq:RFC1766>, ?language),
	( ?x, <dc:language>, ?ll1)
USING
	rdf for <http://www.w3.org/1999/02/22-rdf-syntax-ns#>,
	rdfs for <http://www.w3.org/2000/01/rdf-schema#>,
	dc for <http://purl.org/dc/elements/1.1/>,
	dcq for <http://purl.org/dc/terms/>,
	dct for <http://purl.org/dc/dcmitype/>,
	etb for <http://eun.org/etb/elements/>,
	etbthes for <http://eun.org/etb/thesaurus/elements/>
QUERY

dump_query(<<QUERY, 'etb-subject', 'ETB sample RDF record dc:subject query', 'etb-02' );
SELECT
        ?subjectkeywordsvalue,?subjectkeywordslanguage
FROM
	<file:inputs/example10.xml>
WHERE
	( ?x, <dc:subject>, ?ss1),
        ( ?ss1, <etb:Keywords>, ?ss2),
        ( ?ss2, <rdf:value>, ?subjectkeywordsvalue),
        ( ?ss2, <dc:language>, ?ss3),
        ( ?ss3, <dcq:RFC1766>, ?subjectkeywordslanguage)
USING
	rdf for <http://www.w3.org/1999/02/22-rdf-syntax-ns#>,
	rdfs for <http://www.w3.org/2000/01/rdf-schema#>,
	dc for <http://purl.org/dc/elements/1.1/>,
	dcq for <http://purl.org/dc/terms/>,
	dct for <http://purl.org/dc/dcmitype/>,
	etb for <http://eun.org/etb/elements/>,
	etbthes for <http://eun.org/etb/thesaurus/elements/>
QUERY

dump_query(<<QUERY, 'etb-subject2', 'ETB sample RDF record dc:subject false query', 'etb-03' );
SELECT
        ?subjectkeywordsvalue,?subjectkeywordslanguage
FROM
	<file:inputs/example10.xml>
WHERE
	( ?x, <dc:subject>, ?ss1),
        ( ?ss1, <etb:BREAKQUERY>, ?ss2),
        ( ?ss2, <rdf:value>, ?subjectkeywordsvalue),
        ( ?ss2, <dc:language>, ?ss3),
        ( ?ss3, <dcq:RFC1766>, ?subjectkeywordslanguage)
USING
	rdf for <http://www.w3.org/1999/02/22-rdf-syntax-ns#>,
	rdfs for <http://www.w3.org/2000/01/rdf-schema#>,
	dc for <http://purl.org/dc/elements/1.1/>,
	dcq for <http://purl.org/dc/terms/>,
	dct for <http://purl.org/dc/dcmitype/>,
	etb for <http://eun.org/etb/elements/>,
	etbthes for <http://eun.org/etb/thesaurus/elements/>
QUERY

dump_query(<<QUERY, 'mkdoc2', 'MKDoc testers example with two files', 'mkdoc-02' );
SELECT 	?x, ?y, ?title1, ?title2, ?abstract1, ?abstract2, ?lastmod
FROM	
	<file:inputs/features_fix.rdf>,
	<file:inputs/humans_fix.rdf>
WHERE
	(?x, <dc:title>, ?title1),
        (?y, <dc:title>, ?title2),
        (?x, <dcq:abstract>, ?abstract1),
        (?y, <dcq:abstract>, ?abstract2),
        (?x, <dcq:references>, ?y),
        (?y, <dcq:modified>, ?m),
        (?m, <rdf:value>, ?lastmod)
USING 	dcq for <http://dublincore.org/2000/03/13/dcq#>,
	rdf for <http://www.w3.org/1999/02/22-rdf-syntax-ns#>,
	vcard for <http://www.w3.org/2001/vcard-rdf/3.0#>,
	dc for <http://purl.org/dc/elements/1.1/>
QUERY

dump_query(<<QUERY, 'swws', 'Semantic Web Working Symposium schedule example', 'swws-01' );
SELECT  ?name, ?info 
SOURCE <file:inputs/swws2001-07-30.rdf>
WHERE  
(?cal, <dc::source>, <http://www.SemanticWeb.org/SWWS/program/>),
(?cal, <ical::VEVENT-PROP>, ?event),
(?event, <ical::LOCATION>, ?geo),
(?geo, <ical::GEO-NAME>, ?text),
(?text, <rdf::value>, ?name),
(?geo, <rdfs::seeAlso>, ?info)  
USING 
rdf FOR <http://www.w3.org/1999/02/22-rdf-syntax-ns#>,
rdfs FOR <http://www.w3.org/2000/01/rdf-schema#>,
ical FOR <http://ilrt.org/discovery/2001/06/schemas/ical-full/hybrid.rdf#>,
util FOR <http://ilrt.org/discovery/2001/06/schemas/swws/index.rdf#>,
foaf FOR <http://xmlns.com/foaf/0.1/>,
dc FOR <http://purl.org/dc/elements/1.1/>
QUERY

dump_query(<<QUERY, 'rss10-news1', 'Italian newspaper RSS 1.0 feed sample query', 'rss10-05' );
SELECT  ?link
SOURCE <file:inputs/lastampaEconomia.rdf>
WHERE  
(?x, <rdf:type>, <rss:item>),
(?x, <rss::title>, ?title),
(?x, <rss::link>, ?link)
AND ?title LIKE '/incombe/i'
USING
rss for <http://purl.org/rss/1.0/>,
rdf for <http://www.w3.org/1999/02/22-rdf-syntax-ns#>
QUERY

dump_query(<<QUERY, 'rss10-news2', 'Italian newspaper RSS 1.0 feed another sample query', 'rss10-06' );
SELECT  *
SOURCE <file:inputs/lastampaEconomia.rdf>
WHERE  
(?x, <rdf:type>, <rss:item>),
(?x, <rss::title>, ?title),
(?x, <rss::link>, ?link)
USING
rss for <http://purl.org/rss/1.0/>,
rdf for <http://www.w3.org/1999/02/22-rdf-syntax-ns#>
QUERY

dump_query(<<QUERY, 'rss10-news3', 'Italian newspaper RSS 1.0 feed false sample query', 'rss10-07' );
SELECT  ?y
SOURCE <file:inputs/lastampaEconomia.rdf>
WHERE  
(?x, <rdf:type>, <rss:item>),
(?x, <rss::title>, ?title),
(?x, <rss::link>, ?link)
USING
rss for <http://purl.org/rss/1.0/>,
rdf for <http://www.w3.org/1999/02/22-rdf-syntax-ns#>
QUERY

dump_query(<<QUERY, 'rss10-news4', 'Another italian newspaper RSS 1.0 feed sample query', 'rss10-08' );
SELECT  ?link, ?title
SOURCE <file:inputs/repubblica.rdf>
WHERE  
(?x, <rdf:type>, <rss:item>),
(?x, <rss::title>, ?title),
(?x, <rss::link>, ?link)
USING
rss for <http://purl.org/rss/1.0/>,
rdf for <http://www.w3.org/1999/02/22-rdf-syntax-ns#>
QUERY

dump_query(<<QUERY, 'rss10-news5', 'Another italian newspaper RSS 1.0 feed detailed sample query', 'rss10-09' );
SELECT
    ?newsitem, ?title, ?date, ?description, ?section, ?subsection, ?source
FROM <file:inputs/repubblica.rdf>
WHERE
    (?newsitem, <rdf:type>, <rss:item>),
    (?newsitem, <rss:title>, ?title),
    (?newsitem, <dc:date>, ?date),
    (?newsitem, <rss:description>, ?description),
    (?newsitem, <lmn:section>, ?section),
    (?newsitem, <lmn:subsection>, ?subsection),
    (?items, ?ii, ?newsitem),
    (?items, <rdf:type>, <rdf:Seq>),
    (?s, <rss:items>, ?items),
    (?s, <rdf:type>, <rss:channel>),
    (?s, <rss:title>, ?source)
USING
    rss FOR <http://purl.org/rss/1.0/>,
    lmn FOR <http://www.asemantics.com/schemas/lastminutenews/>,
    dc FOR <http://purl.org/dc/elements/1.1/>,
    dctypes FOR <http://purl.org/dc/dcmitype/>,
    h FOR <http://www.w3.org/1999/xhtml>,
    rdf FOR <http://www.w3.org/1999/02/22-rdf-syntax-ns#>
QUERY

dump_query(<<QUERY, 'esa-isc', 'Simple satellite image RDF description query', 'esa-isc-01' );
SELECT
        ?item, ?title, ?description, ?orbit, ?satellite, ?sensor, ?date,
        ?thumb, ?thumbwidth, ?thumbheight, ?thumbsize
FROM <file:inputs/France_Mosaic_MER_FR_Orbit05072_20030218_20030402.rdf>
WHERE
        (?item, <dc:title>, ?title),
        (?item, <dc:description>, ?description),
        (?item, <isc:orbit>, ?orbit),
        (?item, <isc:satellite>, ?satellite),
        (?item, <isc:sensor>, ?sensor),
        (?item, <dc:date>, ?date),
        (?item, <dcterms:references>, ?rr1),
        (?rr1, <rdf:type>, <rdf:Seq> ),
        (?rr1, ?pp1, ?thumb),
        (?thumb, <rdf:type>, <isc:Lowres>),
        (?thumb, <h:width>, ?thumbwidth),
        (?thumb, <h:height>, ?thumbheight),
        (?thumb, <dcterms:extent>, ?thumbsize)
USING
        isc FOR <http://earth.esa.int/standards/isc/draft/>,
        dc FOR <http://purl.org/dc/elements/1.1/>,
        dcterms FOR <http://purl.org/dc/terms/>,
        dctypes FOR <http://purl.org/dc/dcmitype/>,
        h FOR <http://www.w3.org/1999/xhtml>,
        rdf FOR <http://www.w3.org/1999/02/22-rdf-syntax-ns#>,
        rdfs FOR <http://www.w3.org/2000/01/rdf-schema#>
QUERY

dump_query(<<QUERY, 'esa-isc-images', 'Simple satellite image information query', 'esa-isc-02' );
SELECT
        ?highres, ?highreswidth, ?highresheight, ?highressize, ?highresformat, ?thumb, ?html
FROM <file:inputs/France_Mosaic_MER_FR_Orbit05072_20030218_20030402.rdf>
WHERE
        (?x, <dcterms:references>, ?rr2),
        (?rr2, <rdf:type>, <rdf:Seq> ),
        (?rr2, ?pp2, ?highres),
        (?highres, <rdf:type>, <dctypes:Image>),
        (?highres, <h:width>, ?highreswidth),
        (?highres, <h:height>, ?highresheight),
        (?highres, <dcterms:extent>, ?highressize),
        (?highres, <dcterms:format>, ?highresformat),
        (?highres, <dcterms:hasVersion>, ?thumb),
        (?highres, <dcterms:isReferencedBy>, ?html)
USING
        isc FOR <http://earth.esa.int/standards/isc/draft/>,
        dc FOR <http://purl.org/dc/elements/1.1/>,
        dcterms FOR <http://purl.org/dc/terms/>,
        dctypes FOR <http://purl.org/dc/dcmitype/>,
        h FOR <http://www.w3.org/1999/xhtml>,
        rdf FOR <http://www.w3.org/1999/02/22-rdf-syntax-ns#>,
        rdfs FOR <http://www.w3.org/2000/01/rdf-schema#>
QUERY

print <<FOOTER;
   </mf:tests>
</rdf:Description>

</rdf:RDF>
FOOTER

# we assume the RDQL query has a FROM/SOURCE clause in it
sub dump_query {
	my ($query, $name, $description, $label ) = @_;
	
	my $sth = $dbh->prepare($query) or return;
	my $nt = $sth->{Statement}->serialize;
	my $query_file;
	my $query_file_type;
	if($nt) {
		$query_file = "queries/$name.nt";
		$query_file_type = "NT-Document";
        	open(QQ, ">".$query_file) or die $!;
        	print QQ $nt;
        	close(QQ);
	} else {
        	$query_file = "queries/$name.rdfstore";
		$query_file_type = "RDFStore-RDQL-Document";
        	open(QQ, ">".$query_file) or die $!;
        	print QQ $query;
        	close(QQ);
        	};
	$sth->execute() or return;

	my $output_file="results/$name.rdf";
	open(OUTPUT,">".$output_file) or die $!;
	select(OUTPUT);
	my $num_rows=0;
	while ($sth->fetchrow_array()) { $num_rows++; };
	select(STDOUT);
	close(OUTPUT);

	my $status = ($num_rows>0) ? 'true' : 'false';

	$num++;

print <<TEMPLATE;
         <mf:Test mf:num='$num'>
            <mf:name>$name</mf:name>
            <mf:description>$description</mf:description>
            <mf:status>$status</mf:status>
            <mf:author>Alberto Reggiori</mf:author>
            <mf:submissionDate>$now</mf:submissionDate>
            <mf:label>$label</mf:label>
            <mf:input rdf:parseType='Resource'>
               <tq:queryDocument rdf:resource='file:$query_file'
                                 rdf:type='&tq;$query_file_type' />
TEMPLATE
	map {
		my $ss=$_;
		$ss =~ s/^\<//;
		$ss =~ s/\>$//;
print <<TEMPLATE;
               <tq:inputDocument rdf:resource='$ss'
                                 rdf:type='&tq;RDF-XML-Document'/>
TEMPLATE
	} @{$sth->{Statement}->{sources}};
print <<TEMPLATE;
            </mf:input>
            <mf:output rdf:parseType='Resource'>
               <tq:outputDocument rdf:resource='file:$output_file'
                                  rdf:type='&tq;RDF-XML-Document'
                                  tq:numberRows='$num_rows'/>
            </mf:output>
         </mf:Test>
TEMPLATE
	$sth->finish();
	};
