#
#   environment
#
. ../setenv.sh

#
#  specified patterns
#
inclusions=$1

#
#  skipped patterns
#
exclusions=$(xsltproc $EXAMPLES_DIR/exclusions.xsl toolkit.xml)

#
#  generate bespoke wsdl
#
xsltproc  \
    --stringparam exclude "$exclusions" \
    --stringparam include "$inclusions" \
    $EXAMPLES_DIR/examples2wsdl.xsl \
    $EXAMPLES_DIR/examples.xml |
    sed 's/localhost\/SoapPort/localhost:8082/' > examples.wsdl

#
#  generate server code
#
wsdl2py -t TYPES -b -e -f examples.wsdl
wsdl2dispatch -f examples.wsdl

#
#  implement functions
#
cp Service_services_server.py Service_services_server.py.old
perl -nle '

    if (/^\s*return /) {
	my ($spaces, $name) = /^(\s*)return\s+echo(.*)Response\(\)$/;
	print "${spaces}return self.request";
    }
    else
    {
	print;
    }

' < Service_services_server.py.old > Service_services_server.py

#
#  run server
#
python ./server.py
