#!/bin/sh
#
#   include environment
#
. ./setenv.sh

#inclusions=":StringElement:"
inclusions=$1

#
#  skipped patterns
#
exclusions=$(xsltproc $EXAMPLES_DIR/exclusions.xsl toolkit.xml)

xsltproc  \
    --stringparam exclude "$exclusions" \
    --stringparam include "$inclusions" \
    $EXAMPLES_DIR/examples2wsdl.xsl \
    $EXAMPLES_DIR/examples.xml > examples.wsdl

xsltproc  \
    --stringparam exclude "$exclusions" \
    --stringparam include "$inclusions" \
    $EXAMPLES_DIR/examples2wsdlxsd.xsl \
    $EXAMPLES_DIR/examples.xml > examples.xsd
#
#  generate xfire code
#
ant clean generate || exit 1

#
#  implement echo methods
#
IMP=build/generated/org/w3c/dbwg/ServiceImpl.java
mv ${IMP} ${IMP}.old

perl -nle '

    if (/^\s*public.*\(/) {
        $p = $_;
		@words = split(/\s+/, $p);
		$t1 = $words[3];
		@t2 = split(/\(/, $t1);
		$method = $t2[0];
        $p =~ s/^.*\s([\w\d\.]*)\).*$/$1/;
    }

    if (/UnsupportedOperationException/) {
		print "        long total = Runtime.getRuntime().totalMemory();";
        print "        System.out.println(\"total mem: \" + total);";
        print "        long free = Runtime.getRuntime().freeMemory();";
        print "        System.out.println(\"free mem : \" + free);";
		print "        if ((total / free) > 3 )";
        print "            System.gc();";
        print "        System.out.println(\"" . $method . "\");";
        print "        return $p;";
    }
    else {
        print
    }

' < ${IMP}.old > ${IMP}

#
# build war file
#
ant deploy || exit 1
