#!/bin/sh
#
#   include environment
#
. ./setenv.sh

#inclusions=":StringElement:"
inclusions=$1

#
#  skipped patterns
#
exclusions=$(xsltproc $EXAMPLES_DIR/exclusions.xsl toolkit.xml)

xsltproc  \
    --stringparam exclude "$exclusions" \
    --stringparam include "$inclusions" \
    $EXAMPLES_DIR/examples2wsdl.xsl \
    $EXAMPLES_DIR/examples.xml > examples.wsdl

#
# use ant to generate code from WSDL
#    
ant clean generate

#
#  implement echo methods
#
IMP=build/generated/org/w3c/dbwg/PortTypeImpl.java
mv ${IMP} ${IMP}.old

perl -nle '

    if (/^\s*public org.*\(/) {
        $p = $_;
		@words = split(/\s+/, $p);
		$t1 = $words[4];
		$t2 = substr($t1, 0, length($t1)-1);
    }

    if (/return null/) {
        print "        return $t2;";
    }
    else {
        print
    }

' < ${IMP}.old > ${IMP}

#
# build ear file
#
ant package

#
# deploy to WLS
#
ant deploy