#!/bin/sh
#
#   include environment
#
. ./setenv.sh

echo $EXAMPLES_DIR
#
#  specified patterns
#
inclusions=$1
#inclusions=":StringElement:"

#
#  skipped patterns
#
exclusions=$(xsltproc $EXAMPLES_DIR/exclusions.xsl toolkit.xml)

#
#  generate bespoke wsdl
#
xsltproc  \
    --stringparam exclude "$exclusions" \
    --stringparam include "$inclusions" \
    $EXAMPLES_DIR/examples2wsdl.xsl \
    $EXAMPLES_DIR/examples.xml > examples.wsdl

./SvcUtil examples.wsdl


INTERFACE=Service.cs
IMPL=PortTypeImpl.cs
rm -f ${IMPL}

echo "public class PortTypeImpl : PortType {" >> ${IMPL}
perl -nle '

    if (/^\s*public interface PortType.*/) {
		$flag = 1;
		@words = split(/\s+/, $p);
		$t1 = $words[2];
		$t2 = substr($t1, 0, length($t1)-1);
    }
	
	if ($flag == 1 && /^\s*echo.*/) {
		$line = $_;
		@words = split(/\s+/, $line);
		$returnType = $words[1];
		print "    public " . substr($line, 0, length($line) - 2) . "{";
		print "        " . $returnType . " result = new " . $returnType . "();";
		print "        result." . substr($returnType, 0, length($returnType) - 8) . " = request." . substr($returnType, 0, length($returnType) - 8) . ";";
		print "        return result;";
		print "    }";
	}
	
	if ($flag == 1 && /}/) {
		$flag = 2;
	}

' < ${INTERFACE} >> ${IMPL}

echo "}" >> ${IMPL}

"C:/WINDOWS/Microsoft.NET/Framework/v2.0.50727/csc.exe" /reference:"C:/WINDOWS/Microsoft.NET/Framework/v3.0/Windows Communication Foundation/System.ServiceModel.dll" /out:Server.exe ${INTERFACE} ${IMPL} Server.cs

exit 0
