<?xml version="1.0"?>
<!-- 

    Copyright (C) 2006 W3C (R) (MIT ERCIM Keio), All Rights Reserved.
    W3C liability, trademark and document use rules apply.

    http://www.w3.org/Consortium/Legal/ipr-notice
    http://www.w3.org/Consortium/Legal/copyright-documents

    $Header: /w3ccvs/WWW/2002/ws/databinding/edcopy/toolkits/spring_java_1.0m3_castor_1.1/springprops.xsl,v 1.3 2007/04/21 09:22:14 pdowney Exp $
-->


<xsl:stylesheet
    xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
    xmlns:ex="http://www.w3.org/2002/ws/databinding/examples/6/09/"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    version="1.0">

   <xsl:output method="text"/>
   <xsl:param name="exclude" select="''"/>
   <xsl:param name="include" select="''"/>

   <xsl:template match="/">
      <xsl:param name="tns"><xsl:value-of select="/ex:examples/@targetNamespace"/></xsl:param>

	<xsl:text>spring.mappings=</xsl:text>
    <xsl:for-each select="//ex:example">
      <xsl:variable name="m1"><xsl:value-of select="./@xml:id"/></xsl:variable>
      <xsl:variable name="m2">:<xsl:value-of select="./@xml:id"/>:</xsl:variable>
	  
      <xsl:if test="not(contains($exclude,$m2))">
	    <xsl:if test="$include = '' or contains($include,$m2)">
	      <xsl:text>&lt;prop key="{</xsl:text>
	      <xsl:value-of select="$tns"/>
	      <xsl:text>}echo</xsl:text>
	      <xsl:value-of select="$m1"/>
	      <xsl:text>"&gt;serviceEndpoint&lt;/prop&gt;</xsl:text>
	    </xsl:if>
      </xsl:if>
   </xsl:for-each>

   </xsl:template>
</xsl:stylesheet>
