#!/bin/sh
#
#   include environment
#
. ./setenv.sh

#inclusions=":StringElement:"
inclusions=$1

#
#  skipped patterns
#
exclusions=$(xsltproc $EXAMPLES_DIR/exclusions.xsl toolkit.xml)

xsltproc  \
    --stringparam exclude "$exclusions" \
    --stringparam include "$inclusions" \
    $EXAMPLES_DIR/examples2wsdl.xsl \
    $EXAMPLES_DIR/examples.xml > examples.wsdl

xsltproc  \
    --stringparam exclude "$exclusions" \
    --stringparam include "$inclusions" \
    $EXAMPLES_DIR/examples2wsdlxsd.xsl \
    $EXAMPLES_DIR/examples.xml > examples.xsd
    
xsltproc  \
    --stringparam exclude "$exclusions" \
    --stringparam include "$inclusions" \
    springprops.xsl \
    $EXAMPLES_DIR/examples.xml > spring.properties
    
#
# build war file
#
ant clean compile || exit 1

#
# create a list of classes for the Mapping Tool
#
sep="="
package="org.w3c.dbwg.schema."

props=$(
ls -1 build/classes/org/w3c/dbwg/schema/*.class |
while read filename 
do
	base=$(basename $filename)
	echo ${sep}${package}${base}
	sep=";"
done
)

echo "mappingclasses"${props} > mappingclasses.properties

#
# deploy
#
ant deploy || exit 1