#!/bin/sh
#
#   include environment
#
. setenv.sh

#
#  specified patterns
#
inclusions=$1

#
#  skipped patterns
#
exclusions=$(xsltproc $EXAMPLES_DIR/exclusions.xsl toolkit.xml)

#
#  generate bespoke wsdl
#
xsltproc  \
    --stringparam exclude "$exclusions" \
    --stringparam include "$inclusions" \
    $EXAMPLES_DIR/examples2wsdl.xsl \
    $EXAMPLES_DIR/examples.xml > examples.wsdl

#
#  generate server functions
#
ruby $SOAP4R_DIR/bin/wsdl2ruby.rb \
    --wsdl examples.wsdl \
    --type server --force

#
#   implement echo functions
#
mv defaultServant.rb defaultServant.rb.old
perl -nle '

    if (/^\s*p \[.*\]\s*$/) {
	$p = $_;
	$p =~ s/^\s*p \[(.*)\]\s*$/$1/;
    }

    if (/NotImplementedError/) {
	print "    return $p"
    } 
    else { 
	print 
    }

' < defaultServant.rb.old > defaultServant.rb

#
#   capture databinding code snippets
#
perl -e '

    print "<pre>";
 
    while (<STDIN>)
    {
	my $line = $_;
	if ($line =~ /^\# \{/) {
	    my ($f, $ns, $type) =  split(/[{}\s]+/, $line);
	    print "</pre>";
	    print "<a name=\"" . $type ."\"></a><b>$type</b>";
	    print "<pre>";
	}
	#$line =~ s/</&lt;/sg;
	#$line =~ s/>/&gt;/sg;
	#$line =~ s/&/&amp;/sg;
	print $line;
    }

    print "</pre>";

' < default.rb > snippets.html

#
#  to run the service:
#
ruby Service.rb
