require 'default.rb'
require 'soap/mapping'

module DefaultMappingRegistry
  EncodedRegistry = ::SOAP::Mapping::EncodedRegistry.new
  LiteralRegistry = ::SOAP::Mapping::LiteralRegistry.new
  NsC_09 = "http://www.w3.org/2002/ws/databinding/examples/6/09/"
  NsXMLSchema = "http://www.w3.org/2001/XMLSchema"

  EncodedRegistry.register(
    :class => StringAttribute,
    :schema_type => XSD::QName.new(NsC_09, "StringAttribute"),
    :schema_element => [
      ["text", "SOAP::SOAPString", [0, 1]]
    ],
    :schema_attribute => {
      XSD::QName.new(nil, "string") => "SOAP::SOAPString"
    }
  )

  EncodedRegistry.register(
    :class => BooleanAttribute,
    :schema_type => XSD::QName.new(NsC_09, "BooleanAttribute"),
    :schema_element => [
      ["text", "SOAP::SOAPString", [0, 1]]
    ],
    :schema_attribute => {
      XSD::QName.new(nil, "boolean") => "SOAP::SOAPBoolean"
    }
  )

  EncodedRegistry.register(
    :class => DecimalAttribute,
    :schema_type => XSD::QName.new(NsC_09, "DecimalAttribute"),
    :schema_element => [
      ["text", "SOAP::SOAPString", [0, 1]]
    ],
    :schema_attribute => {
      XSD::QName.new(nil, "decimal") => "SOAP::SOAPDecimal"
    }
  )

  EncodedRegistry.register(
    :class => FloatAttribute,
    :schema_type => XSD::QName.new(NsC_09, "FloatAttribute"),
    :schema_element => [
      ["text", "SOAP::SOAPString", [0, 1]]
    ],
    :schema_attribute => {
      XSD::QName.new(nil, "float") => "SOAP::SOAPFloat"
    }
  )

  EncodedRegistry.register(
    :class => DoubleAttribute,
    :schema_type => XSD::QName.new(NsC_09, "DoubleAttribute"),
    :schema_element => [
      ["text", "SOAP::SOAPString", [0, 1]]
    ],
    :schema_attribute => {
      XSD::QName.new(nil, "double") => "SOAP::SOAPDouble"
    }
  )

  EncodedRegistry.register(
    :class => DurationAttribute,
    :schema_type => XSD::QName.new(NsC_09, "DurationAttribute"),
    :schema_element => [
      ["text", "SOAP::SOAPString", [0, 1]]
    ],
    :schema_attribute => {
      XSD::QName.new(nil, "duration") => "SOAP::SOAPDuration"
    }
  )

  EncodedRegistry.register(
    :class => DateTimeAttribute,
    :schema_type => XSD::QName.new(NsC_09, "DateTimeAttribute"),
    :schema_element => [
      ["text", "SOAP::SOAPString", [0, 1]]
    ],
    :schema_attribute => {
      XSD::QName.new(nil, "dateTime") => "SOAP::SOAPDateTime"
    }
  )

  EncodedRegistry.register(
    :class => TimeAttribute,
    :schema_type => XSD::QName.new(NsC_09, "TimeAttribute"),
    :schema_element => [
      ["text", "SOAP::SOAPString", [0, 1]]
    ],
    :schema_attribute => {
      XSD::QName.new(nil, "time") => "SOAP::SOAPTime"
    }
  )

  EncodedRegistry.register(
    :class => DateAttribute,
    :schema_type => XSD::QName.new(NsC_09, "DateAttribute"),
    :schema_element => [
      ["text", "SOAP::SOAPString", [0, 1]]
    ],
    :schema_attribute => {
      XSD::QName.new(nil, "date") => "SOAP::SOAPDate"
    }
  )

  EncodedRegistry.register(
    :class => GYearMonthAttribute,
    :schema_type => XSD::QName.new(NsC_09, "GYearMonthAttribute"),
    :schema_element => [
      ["text", "SOAP::SOAPString", [0, 1]]
    ],
    :schema_attribute => {
      XSD::QName.new(nil, "gYearMonth") => "SOAP::SOAPGYearMonth"
    }
  )

  EncodedRegistry.register(
    :class => GYearAttribute,
    :schema_type => XSD::QName.new(NsC_09, "GYearAttribute"),
    :schema_element => [
      ["text", "SOAP::SOAPString", [0, 1]]
    ],
    :schema_attribute => {
      XSD::QName.new(nil, "gYear") => "SOAP::SOAPGYear"
    }
  )

  EncodedRegistry.register(
    :class => GMonthDayAttribute,
    :schema_type => XSD::QName.new(NsC_09, "GMonthDayAttribute"),
    :schema_element => [
      ["text", "SOAP::SOAPString", [0, 1]]
    ],
    :schema_attribute => {
      XSD::QName.new(nil, "gMonthDay") => "SOAP::SOAPGMonthDay"
    }
  )

  EncodedRegistry.register(
    :class => GDayAttribute,
    :schema_type => XSD::QName.new(NsC_09, "GDayAttribute"),
    :schema_element => [
      ["text", "SOAP::SOAPString", [0, 1]]
    ],
    :schema_attribute => {
      XSD::QName.new(nil, "gDay") => "SOAP::SOAPGDay"
    }
  )

  EncodedRegistry.register(
    :class => GMonthAttribute,
    :schema_type => XSD::QName.new(NsC_09, "GMonthAttribute"),
    :schema_element => [
      ["text", "SOAP::SOAPString", [0, 1]]
    ],
    :schema_attribute => {
      XSD::QName.new(nil, "gMonth") => "SOAP::SOAPGMonth"
    }
  )

  EncodedRegistry.register(
    :class => HexBinaryAttribute,
    :schema_type => XSD::QName.new(NsC_09, "HexBinaryAttribute"),
    :schema_element => [
      ["text", "SOAP::SOAPString", [0, 1]]
    ],
    :schema_attribute => {
      XSD::QName.new(nil, "hexBinary") => "SOAP::SOAPHexBinary"
    }
  )

  EncodedRegistry.register(
    :class => Base64BinaryAttribute,
    :schema_type => XSD::QName.new(NsC_09, "Base64BinaryAttribute"),
    :schema_element => [
      ["text", "SOAP::SOAPString", [0, 1]]
    ],
    :schema_attribute => {
      XSD::QName.new(nil, "base64Binary") => "SOAP::SOAPBase64"
    }
  )

  EncodedRegistry.register(
    :class => AnyURIAttribute,
    :schema_type => XSD::QName.new(NsC_09, "AnyURIAttribute"),
    :schema_element => [
      ["text", "SOAP::SOAPString", [0, 1]]
    ],
    :schema_attribute => {
      XSD::QName.new(nil, "anyURI") => "SOAP::SOAPAnyURI"
    }
  )

  EncodedRegistry.register(
    :class => QNameAttribute,
    :schema_type => XSD::QName.new(NsC_09, "QNameAttribute"),
    :schema_element => [
      ["text", "SOAP::SOAPString", [0, 1]]
    ],
    :schema_attribute => {
      XSD::QName.new(nil, "QName") => "SOAP::SOAPQName"
    }
  )

  EncodedRegistry.register(
    :class => NormalizedStringAttribute,
    :schema_type => XSD::QName.new(NsC_09, "NormalizedStringAttribute"),
    :schema_element => [
      ["text", "SOAP::SOAPString", [0, 1]]
    ],
    :schema_attribute => {
      XSD::QName.new(nil, "normalizedString") => "SOAP::SOAPNormalizedString"
    }
  )

  EncodedRegistry.register(
    :class => TokenAttribute,
    :schema_type => XSD::QName.new(NsC_09, "TokenAttribute"),
    :schema_element => [
      ["text", "SOAP::SOAPString", [0, 1]]
    ],
    :schema_attribute => {
      XSD::QName.new(nil, "token") => "SOAP::SOAPToken"
    }
  )

  EncodedRegistry.register(
    :class => LanguageAttribute,
    :schema_type => XSD::QName.new(NsC_09, "LanguageAttribute"),
    :schema_element => [
      ["text", "SOAP::SOAPString", [0, 1]]
    ],
    :schema_attribute => {
      XSD::QName.new(nil, "language") => "SOAP::SOAPLanguage"
    }
  )

  EncodedRegistry.register(
    :class => NMTOKENAttribute,
    :schema_type => XSD::QName.new(NsC_09, "NMTOKENAttribute"),
    :schema_element => [
      ["text", "SOAP::SOAPString", [0, 1]]
    ],
    :schema_attribute => {
      XSD::QName.new(nil, "NMTOKEN") => "SOAP::SOAPNMTOKEN"
    }
  )

  EncodedRegistry.register(
    :class => NMTOKENSAttribute,
    :schema_type => XSD::QName.new(NsC_09, "NMTOKENSAttribute"),
    :schema_element => [
      ["text", "SOAP::SOAPString", [0, 1]]
    ],
    :schema_attribute => {
      XSD::QName.new(nil, "NMTOKENS") => "SOAP::SOAPNMTOKENS"
    }
  )

  EncodedRegistry.register(
    :class => NameAttribute,
    :schema_type => XSD::QName.new(NsC_09, "NameAttribute"),
    :schema_element => [
      ["text", "SOAP::SOAPString", [0, 1]]
    ],
    :schema_attribute => {
      XSD::QName.new(nil, "name") => "SOAP::SOAPName"
    }
  )

  EncodedRegistry.register(
    :class => NCNameAttribute,
    :schema_type => XSD::QName.new(NsC_09, "NCNameAttribute"),
    :schema_element => [
      ["text", "SOAP::SOAPString", [0, 1]]
    ],
    :schema_attribute => {
      XSD::QName.new(nil, "NCName") => "SOAP::SOAPNCName"
    }
  )

  EncodedRegistry.register(
    :class => IDAttribute,
    :schema_type => XSD::QName.new(NsC_09, "IDAttribute"),
    :schema_element => [
      ["text", "SOAP::SOAPString", [0, 1]]
    ],
    :schema_attribute => {
      XSD::QName.new(nil, "ID") => "SOAP::SOAPID"
    }
  )

  EncodedRegistry.register(
    :class => IDREFAttribute,
    :schema_type => XSD::QName.new(NsC_09, "IDREFAttribute"),
    :schema_element => [
      ["text", "SOAP::SOAPString", [0, 1]]
    ],
    :schema_attribute => {
      XSD::QName.new(nil, "IDREF") => "SOAP::SOAPIDREF"
    }
  )

  EncodedRegistry.register(
    :class => IDREFSAttribute,
    :schema_type => XSD::QName.new(NsC_09, "IDREFSAttribute"),
    :schema_element => [
      ["text", "SOAP::SOAPString", [0, 1]]
    ],
    :schema_attribute => {
      XSD::QName.new(nil, "IDREFS") => "SOAP::SOAPIDREFS"
    }
  )

  EncodedRegistry.register(
    :class => ENTITYAttribute,
    :schema_type => XSD::QName.new(NsC_09, "ENTITYAttribute"),
    :schema_element => [
      ["text", "SOAP::SOAPString", [0, 1]]
    ],
    :schema_attribute => {
      XSD::QName.new(nil, "ENTITY") => "SOAP::SOAPENTITY"
    }
  )

  EncodedRegistry.register(
    :class => ENTITIESAttribute,
    :schema_type => XSD::QName.new(NsC_09, "ENTITIESAttribute"),
    :schema_element => [
      ["text", "SOAP::SOAPString", [0, 1]]
    ],
    :schema_attribute => {
      XSD::QName.new(nil, "ENTITIES") => "SOAP::SOAPENTITIES"
    }
  )

  EncodedRegistry.register(
    :class => IntegerAttribute,
    :schema_type => XSD::QName.new(NsC_09, "IntegerAttribute"),
    :schema_element => [
      ["text", "SOAP::SOAPString", [0, 1]]
    ],
    :schema_attribute => {
      XSD::QName.new(nil, "integer") => "SOAP::SOAPInteger"
    }
  )

  EncodedRegistry.register(
    :class => NonPositiveIntegerAttribute,
    :schema_type => XSD::QName.new(NsC_09, "NonPositiveIntegerAttribute"),
    :schema_element => [
      ["text", "SOAP::SOAPString", [0, 1]]
    ],
    :schema_attribute => {
      XSD::QName.new(nil, "nonPositiveInteger") => "SOAP::SOAPNonPositiveInteger"
    }
  )

  EncodedRegistry.register(
    :class => LongAttribute,
    :schema_type => XSD::QName.new(NsC_09, "LongAttribute"),
    :schema_element => [
      ["text", "SOAP::SOAPString", [0, 1]]
    ],
    :schema_attribute => {
      XSD::QName.new(nil, "long") => "SOAP::SOAPLong"
    }
  )

  EncodedRegistry.register(
    :class => IntAttribute,
    :schema_type => XSD::QName.new(NsC_09, "IntAttribute"),
    :schema_element => [
      ["text", "SOAP::SOAPString", [0, 1]]
    ],
    :schema_attribute => {
      XSD::QName.new(nil, "int") => "SOAP::SOAPInt"
    }
  )

  EncodedRegistry.register(
    :class => ShortAttribute,
    :schema_type => XSD::QName.new(NsC_09, "ShortAttribute"),
    :schema_element => [
      ["text", "SOAP::SOAPString", [0, 1]]
    ],
    :schema_attribute => {
      XSD::QName.new(nil, "short") => "SOAP::SOAPShort"
    }
  )

  EncodedRegistry.register(
    :class => ByteAttribute,
    :schema_type => XSD::QName.new(NsC_09, "ByteAttribute"),
    :schema_element => [
      ["text", "SOAP::SOAPString", [0, 1]]
    ],
    :schema_attribute => {
      XSD::QName.new(nil, "byte") => "SOAP::SOAPByte"
    }
  )

  EncodedRegistry.register(
    :class => NonNegativeIntegerAttribute,
    :schema_type => XSD::QName.new(NsC_09, "NonNegativeIntegerAttribute"),
    :schema_element => [
      ["text", "SOAP::SOAPString", [0, 1]]
    ],
    :schema_attribute => {
      XSD::QName.new(nil, "nonNegativeInteger") => "SOAP::SOAPNonNegativeInteger"
    }
  )

  EncodedRegistry.register(
    :class => UnsignedLongAttribute,
    :schema_type => XSD::QName.new(NsC_09, "UnsignedLongAttribute"),
    :schema_element => [
      ["text", "SOAP::SOAPString", [0, 1]]
    ],
    :schema_attribute => {
      XSD::QName.new(nil, "unsignedLong") => "SOAP::SOAPUnsignedLong"
    }
  )

  EncodedRegistry.register(
    :class => UnsignedIntAttribute,
    :schema_type => XSD::QName.new(NsC_09, "UnsignedIntAttribute"),
    :schema_element => [
      ["text", "SOAP::SOAPString", [0, 1]]
    ],
    :schema_attribute => {
      XSD::QName.new(nil, "unsignedInt") => "SOAP::SOAPUnsignedInt"
    }
  )

  EncodedRegistry.register(
    :class => UnsignedShortAttribute,
    :schema_type => XSD::QName.new(NsC_09, "UnsignedShortAttribute"),
    :schema_element => [
      ["text", "SOAP::SOAPString", [0, 1]]
    ],
    :schema_attribute => {
      XSD::QName.new(nil, "unsignedShort") => "SOAP::SOAPUnsignedShort"
    }
  )

  EncodedRegistry.register(
    :class => NegativeIntegerAttribute,
    :schema_type => XSD::QName.new(NsC_09, "NegativeIntegerAttribute"),
    :schema_element => [
      ["text", "SOAP::SOAPString", [0, 1]]
    ],
    :schema_attribute => {
      XSD::QName.new(nil, "negativeInteger") => "SOAP::SOAPNegativeInteger"
    }
  )

  EncodedRegistry.register(
    :class => UnsignedByteAttribute,
    :schema_type => XSD::QName.new(NsC_09, "UnsignedByteAttribute"),
    :schema_element => [
      ["text", "SOAP::SOAPString", [0, 1]]
    ],
    :schema_attribute => {
      XSD::QName.new(nil, "unsignedByte") => "SOAP::SOAPUnsignedByte"
    }
  )

  EncodedRegistry.register(
    :class => PositiveIntegerAttribute,
    :schema_type => XSD::QName.new(NsC_09, "PositiveIntegerAttribute"),
    :schema_element => [
      ["text", "SOAP::SOAPString", [0, 1]]
    ],
    :schema_attribute => {
      XSD::QName.new(nil, "positiveInteger") => "SOAP::SOAPPositiveInteger"
    }
  )

  EncodedRegistry.register(
    :class => ComplexTypeSequence,
    :schema_type => XSD::QName.new(NsC_09, "ComplexTypeSequence"),
    :schema_element => [
      ["name", "SOAP::SOAPString"],
      ["shade", "SOAP::SOAPString"],
      ["length", "SOAP::SOAPInt"]
    ],
    :schema_attribute => {
      XSD::QName.new(nil, "id") => "SOAP::SOAPString",
      XSD::QName.new(nil, "inStock") => "SOAP::SOAPInt"
    }
  )

  EncodedRegistry.register(
    :class => ComplexTypeAll,
    :schema_type => XSD::QName.new(NsC_09, "ComplexTypeAll"),
    :schema_element => [
      ["name", "SOAP::SOAPString"],
      ["shade", "SOAP::SOAPString"],
      ["length", "SOAP::SOAPInt"]
    ],
    :schema_attribute => {
      XSD::QName.new(nil, "id") => "SOAP::SOAPString",
      XSD::QName.new(nil, "inStock") => "SOAP::SOAPInt"
    }
  )

  EncodedRegistry.register(
    :class => Fruit,
    :schema_type => XSD::QName.new(NsC_09, "Fruit"),
    :schema_element => [ :choice,
      ["apple", "SOAP::SOAPInt"],
      ["orange", "SOAP::SOAPString"],
      ["banana", "SOAP::SOAPInt"]
    ]
  )

  EncodedRegistry.register(
    :class => Mortgage,
    :schema_type => XSD::QName.new(NsC_09, "Mortgage"),
    :schema_element => [
      ["amount", "SOAP::SOAPInt"],
      [ :choice,
        ["repayment", "Repayment"],
        ["interestonly", "InterestOnly"]
      ]
    ]
  )

  EncodedRegistry.register(
    :class => Repayment,
    :schema_type => XSD::QName.new(NsC_09, "Repayment"),
    :schema_element => [
      ["years", "SOAP::SOAPInt"],
      ["months", "SOAP::SOAPInt"],
      ["rate", "SOAP::SOAPString"]
    ]
  )

  EncodedRegistry.register(
    :class => InterestOnly,
    :schema_type => XSD::QName.new(NsC_09, "InterestOnly"),
    :schema_element => [
      ["years", "SOAP::SOAPInt"],
      ["rate", "SOAP::SOAPString"]
    ]
  )

  EncodedRegistry.register(
    :class => ElementMinOccurs1,
    :schema_type => XSD::QName.new(NsC_09, "ElementMinOccurs1"),
    :schema_element => [
      ["elementMinOccurs1item", "SOAP::SOAPString"]
    ]
  )

  EncodedRegistry.register(
    :class => ItemColors2,
    :schema_type => XSD::QName.new(NsC_09, "ItemColors2"),
    :schema_element => [
      ["itemColor", "SOAP::SOAPString[]", [2, 2]]
    ]
  )

  EncodedRegistry.register(
    :class => ItemColors,
    :schema_type => XSD::QName.new(NsC_09, "ItemColors"),
    :schema_element => [
      ["itemColor", "SOAP::SOAPString[]", [2, nil]]
    ]
  )

  EncodedRegistry.register(
    :class => ElementMaxOccurs1,
    :schema_type => XSD::QName.new(NsC_09, "ElementMaxOccurs1"),
    :schema_element => [
      ["value", "SOAP::SOAPString"]
    ]
  )

  EncodedRegistry.register(
    :class => Publications,
    :schema_type => XSD::QName.new(NsC_09, "Publications"),
    :schema_element => [
      ["day", "SOAP::SOAPString[]", [1, nil]]
    ]
  )

  EncodedRegistry.register(
    :class => Summer,
    :schema_type => XSD::QName.new(NsC_09, "Summer"),
    :schema_element => [
      ["mnth", "SOAP::SOAPString[]", [1, 4]]
    ]
  )

  EncodedRegistry.register(
    :class => Premium,
    :schema_type => XSD::QName.new(NsC_09, "Premium"),
    :schema_element => [
      ["amount", "SOAP::SOAPString"]
    ],
    :schema_attribute => {
      XSD::QName.new(nil, "id") => "SOAP::SOAPString",
      XSD::QName.new(nil, "currency") => "SOAP::SOAPString"
    }
  )

  EncodedRegistry.register(
    :class => Discount,
    :schema_type => XSD::QName.new(NsC_09, "Discount"),
    :schema_element => [
      ["percentage", "SOAP::SOAPInt"]
    ],
    :schema_attribute => {
      XSD::QName.new(nil, "id") => "SOAP::SOAPString",
      XSD::QName.new(nil, "seasonal") => "SOAP::SOAPBoolean"
    }
  )

  EncodedRegistry.register(
    :class => Survey,
    :schema_type => XSD::QName.new(NsC_09, "Survey"),
    :schema_element => [
      ["fee", "SOAP::SOAPInt"]
    ],
    :schema_attribute => {
      XSD::QName.new(nil, "id") => "SOAP::SOAPString",
      XSD::QName.new(nil, "currency") => "SOAP::SOAPString"
    }
  )

  EncodedRegistry.register(
    :class => ElementMinOccurs0,
    :schema_type => XSD::QName.new(NsC_09, "ElementMinOccurs0"),
    :schema_element => [
      ["firstName", "SOAP::SOAPString"],
      ["middleName", "SOAP::SOAPString", [0, 1]],
      ["lastName", "SOAP::SOAPString"]
    ]
  )

  EncodedRegistry.register(
    :class => NillableMiddleName,
    :schema_type => XSD::QName.new(NsC_09, "NillableMiddleName"),
    :schema_element => [
      ["firstName", "SOAP::SOAPString"],
      ["middleName", "SOAP::SOAPString"],
      ["lastName", "SOAP::SOAPString"]
    ]
  )

  EncodedRegistry.register(
    :class => NillableOptionalMiddleName,
    :schema_type => XSD::QName.new(NsC_09, "NillableOptionalMiddleName"),
    :schema_element => [
      ["firstName", "SOAP::SOAPString"],
      ["middleName", "SOAP::SOAPString", [0, 1]],
      ["lastName", "SOAP::SOAPString"]
    ]
  )

  EncodedRegistry.register(
    :class => SequenceElementList,
    :schema_type => XSD::QName.new(NsC_09, "SequenceElementList"),
    :schema_element => [
      ["item", "SOAP::SOAPString[]", [0, nil]]
    ]
  )

  EncodedRegistry.register(
    :class => NestedItem,
    :schema_type => XSD::QName.new(NsC_09, "NestedItem"),
    :schema_element => [
      ["item", "SOAP::SOAPString[]", [0, nil]]
    ]
  )

  EncodedRegistry.register(
    :class => NestedSequenceElementList,
    :schema_type => XSD::QName.new(NsC_09, "NestedSequenceElementList"),
    :schema_element => [
      ["nestedItem", "NestedItem[]", [0, nil]]
    ]
  )

  EncodedRegistry.register(
    :class => MixedContentType,
    :schema_type => XSD::QName.new(NsC_09, "MixedContentType"),
    :schema_element => [
      ["elem1", "SOAP::SOAPString"],
      ["elem2", "SOAP::SOAPString"]
    ]
  )

  EncodedRegistry.register(
    :class => CustomerName,
    :schema_type => XSD::QName.new(NsC_09, "CustomerName"),
    :schema_element => [
      ["firstName", "SOAP::SOAPString"],
      ["lastName", "SOAP::SOAPString"]
    ]
  )

  EncodedRegistry.register(
    :class => ClientName,
    :schema_type => XSD::QName.new(NsC_09, "ClientName"),
    :schema_element => [
      ["firstName", "SOAP::SOAPString"],
      ["lastName", "SOAP::SOAPString"]
    ],
    :schema_attribute => {
      XSD::QName.new(NsC_09, "phoneNumber") => "SOAP::SOAPString"
    }
  )

  EncodedRegistry.register(
    :class => ClientDetails,
    :schema_type => XSD::QName.new(NsC_09, "ClientDetails"),
    :schema_element => [
      ["forename", "SOAP::SOAPString"],
      ["surname", "SOAP::SOAPString"],
      ["title", "SOAP::SOAPString"]
    ],
    :schema_attribute => {
      XSD::QName.new(nil, "phone") => "SOAP::SOAPLong",
      XSD::QName.new(nil, "title") => "SOAP::SOAPBoolean"
    }
  )

  EncodedRegistry.register(
    :class => ExtendedSequenceStrict,
    :schema_type => XSD::QName.new(NsC_09, "ExtendedSequenceStrict"),
    :schema_element => [
      ["firstName", "SOAP::SOAPString"],
      ["lastName", "SOAP::SOAPString"],
      ["extension", "StrictExtension", [0, 1]]
    ]
  )

  EncodedRegistry.register(
    :class => StrictExtension,
    :schema_type => XSD::QName.new(NsC_09, "StrictExtension"),
    :schema_element => [
      ["any", [nil, XSD::QName.new(NsXMLSchema, "anyType")]]
    ]
  )

  EncodedRegistry.register(
    :class => ExtendedSequenceLax,
    :schema_type => XSD::QName.new(NsC_09, "ExtendedSequenceLax"),
    :schema_element => [
      ["firstName", "SOAP::SOAPString"],
      ["lastName", "SOAP::SOAPString"],
      ["extension", "LaxExtension", [0, 1]]
    ]
  )

  EncodedRegistry.register(
    :class => LaxExtension,
    :schema_type => XSD::QName.new(NsC_09, "LaxExtension"),
    :schema_element => [
      ["any", [nil, XSD::QName.new(NsXMLSchema, "anyType")]]
    ]
  )

  EncodedRegistry.register(
    :class => ExtendedSequenceSkip,
    :schema_type => XSD::QName.new(NsC_09, "ExtendedSequenceSkip"),
    :schema_element => [
      ["firstName", "SOAP::SOAPString"],
      ["lastName", "SOAP::SOAPString"],
      ["extension", "SkipExtension", [0, 1]]
    ]
  )

  EncodedRegistry.register(
    :class => SkipExtension,
    :schema_type => XSD::QName.new(NsC_09, "SkipExtension"),
    :schema_element => [
      ["any", [nil, XSD::QName.new(NsXMLSchema, "anyType")]]
    ]
  )

  EncodedRegistry.register(
    :class => BareVector,
    :schema_type => XSD::QName.new(NsC_09, "BareVector"),
    :schema_element => [
      ["item1", "SOAP::SOAPString[]", [0, nil]],
      ["item2", "SOAP::SOAPString[]", [0, nil]],
      ["item3", "SOAP::SOAPString[]", [0, nil]]
    ]
  )

  EncodedRegistry.register(
    :class => ComplexTypeSequenceBase,
    :schema_type => XSD::QName.new(NsC_09, "ComplexTypeSequenceBase"),
    :schema_element => [
      ["name", "SOAP::SOAPString"]
    ]
  )

  EncodedRegistry.register(
    :class => ComplexTypeSequenceExtension,
    :schema_type => XSD::QName.new(NsC_09, "ComplexTypeSequenceExtension"),
    :schema_basetype => XSD::QName.new(NsC_09, "ComplexTypeSequenceBase"),
    :schema_element => [
      ["name", "SOAP::SOAPString"],
      ["description", "SOAP::SOAPString"]
    ]
  )

  EncodedRegistry.register(
    :class => Assembly,
    :schema_type => XSD::QName.new(NsC_09, "Assembly"),
    :schema_element => [
      ["part", "Part[]", [0, nil]]
    ]
  )

  EncodedRegistry.register(
    :class => Part,
    :schema_type => XSD::QName.new(NsC_09, "Part"),
    :schema_element => [
      ["number", "SOAP::SOAPString"]
    ]
  )

  EncodedRegistry.register(
    :class => Part2,
    :schema_type => XSD::QName.new(NsC_09, "Part2"),
    :schema_basetype => XSD::QName.new(NsC_09, "Part"),
    :schema_element => [
      ["number", "SOAP::SOAPString"],
      ["description", "SOAP::SOAPString"]
    ]
  )

  EncodedRegistry.register(
    :class => SimpleTypeAttributes,
    :schema_type => XSD::QName.new(NsC_09, "SimpleTypeAttributes"),
    :schema_attribute => {
      XSD::QName.new(nil, "a1") => "SOAP::SOAPString",
      XSD::QName.new(nil, "a2") => "SOAP::SOAPString"
    }
  )

  EncodedRegistry.register(
    :class => ExtendedSimpleType,
    :schema_type => XSD::QName.new(NsC_09, "ExtendedSimpleType")
  )

  EncodedRegistry.register(
    :class => SequenceMinOccurs1,
    :schema_type => XSD::QName.new(NsC_09, "SequenceMinOccurs1"),
    :schema_element => [
      ["sequenceMinOccurs1item", "SOAP::SOAPString"]
    ]
  )

  EncodedRegistry.register(
    :class => ArticleColors,
    :schema_type => XSD::QName.new(NsC_09, "ArticleColors"),
    :schema_element => [
      ["articleColor", "SOAP::SOAPString[]"],
      ["articleContrast", "SOAP::SOAPString[]"]
    ]
  )

  EncodedRegistry.register(
    :class => MyAgeDetails,
    :schema_type => XSD::QName.new(NsC_09, "MyAgeDetails"),
    :schema_element => [
      ["myAge", "SOAP::SOAPShort"]
    ]
  )

  EncodedRegistry.register(
    :class => DurationList,
    :schema_type => XSD::QName.new(NsC_09, "DurationList"),
    :schema_element => [
      ["durationValue", "SOAP::SOAPShort[]", [0, nil]]
    ]
  )

  EncodedRegistry.register(
    :class => DurationListSequence,
    :schema_type => XSD::QName.new(NsC_09, "DurationListSequence"),
    :schema_element => [
      ["durationVal", "SOAP::SOAPString[]"],
      ["durationPercentage", "SOAP::SOAPString[]"]
    ]
  )

  EncodedRegistry.register(
    :class => AgeList,
    :schema_type => XSD::QName.new(NsC_09, "AgeList"),
    :schema_element => [
      ["ageValue", "SOAP::SOAPShort[]", [1, nil]]
    ]
  )

  EncodedRegistry.register(
    :class => AgeListSequence,
    :schema_type => XSD::QName.new(NsC_09, "AgeListSequence"),
    :schema_element => [
      ["ageVal", "SOAP::SOAPString[]"],
      ["agePercentage", "SOAP::SOAPString[]"]
    ]
  )

  EncodedRegistry.register(
    :class => BookPublications,
    :schema_type => XSD::QName.new(NsC_09, "BookPublications"),
    :schema_element => [
      ["pubDate", "SOAP::SOAPString[]"],
      ["pubISBN", "SOAP::SOAPString[]"]
    ]
  )

  EncodedRegistry.register(
    :class => Winter,
    :schema_type => XSD::QName.new(NsC_09, "Winter"),
    :schema_element => [
      ["mnth", "SOAP::SOAPString[]"],
      ["weather", "SOAP::SOAPString[]"]
    ]
  )

  EncodedRegistry.register(
    :class => SequenceMinOccurs0,
    :schema_type => XSD::QName.new(NsC_09, "SequenceMinOccurs0"),
    :schema_element => [
      ["firstName", "SOAP::SOAPString"],
      ["middleName", "SOAP::SOAPString"],
      ["lastName", "SOAP::SOAPString"]
    ]
  )

  EncodedRegistry.register(
    :class => SequenceSequenceElement,
    :schema_type => XSD::QName.new(NsC_09, "SequenceSequenceElement"),
    :schema_element => [
      ["firstName", "SOAP::SOAPString"],
      [
        ["middleName", "SOAP::SOAPString"],
        [
          ["lastName", "SOAP::SOAPString"]
        ]
      ]
    ]
  )

  EncodedRegistry.register(
    :class => AttributeTypeReference,
    :schema_type => XSD::QName.new(NsC_09, "AttributeTypeReference"),
    :schema_element => [
      ["text", "SOAP::SOAPString", [0, 1]]
    ],
    :schema_attribute => {
      XSD::QName.new(nil, "number") => "SOAP::SOAPDecimal"
    }
  )

  EncodedRegistry.register(
    :class => ElementTypeReferenced,
    :schema_type => XSD::QName.new(NsC_09, "ElementTypeReferenced"),
    :schema_element => [
      ["referenced", "SOAP::SOAPString"]
    ]
  )

  EncodedRegistry.register(
    :class => ElementTypeReference,
    :schema_type => XSD::QName.new(NsC_09, "ElementTypeReference"),
    :schema_element => [
      ["text", "ElementTypeReferenced"]
    ]
  )

  EncodedRegistry.register(
    :class => LocalElementComplexType,
    :schema_type => XSD::QName.new(NsC_09, "LocalElementComplexType"),
    :schema_element => [
      ["name", "LocalElementComplexType::Name"]
    ]
  )

  EncodedRegistry.register(
    :class => LocalElementComplexType::Name,
    :schema_name => XSD::QName.new(NsC_09, "name"),
    :is_anonymous => true,
    :schema_qualified => true,
    :schema_element => [
      ["firstName", "SOAP::SOAPString"],
      ["lastName", "SOAP::SOAPString"]
    ]
  )

  EncodedRegistry.register(
    :class => IdExample,
    :schema_type => XSD::QName.new(NsC_09, "IdExample"),
    :schema_element => [
      ["text", "SOAP::SOAPString", [0, 1]]
    ],
    :schema_attribute => {
      XSD::QName.new(nil, "string") => "SOAP::SOAPString"
    }
  )

  EncodedRegistry.register(
    :class => AttributeGroupExample,
    :schema_type => XSD::QName.new(NsC_09, "AttributeGroupExample"),
    :schema_element => [
      ["contract", "SOAP::SOAPString"]
    ],
    :schema_attribute => {
      XSD::QName.new(nil, "id") => "SOAP::SOAPID"
    }
  )

  EncodedRegistry.register(
    :class => GlobalSimpleType,
    :schema_type => XSD::QName.new(NsC_09, "GlobalSimpleType")
  )

  EncodedRegistry.register(
    :class => Beatle,
    :schema_type => XSD::QName.new(NsC_09, "Beatle")
  )

  EncodedRegistry.register(
    :class => NMTOKENEnumerationType,
    :schema_type => XSD::QName.new(NsC_09, "NMTOKENEnumerationType")
  )

  EncodedRegistry.register(
    :class => IntEnumerationType,
    :schema_type => XSD::QName.new(NsC_09, "IntEnumerationType")
  )

  EncodedRegistry.register(
    :class => ShortEnumerationType,
    :schema_type => XSD::QName.new(NsC_09, "ShortEnumerationType")
  )

  EncodedRegistry.register(
    :class => LongEnumerationType,
    :schema_type => XSD::QName.new(NsC_09, "LongEnumerationType")
  )

  EncodedRegistry.register(
    :class => DoubleEnumerationType,
    :schema_type => XSD::QName.new(NsC_09, "DoubleEnumerationType")
  )

  EncodedRegistry.register(
    :class => IntegerEnumerationType,
    :schema_type => XSD::QName.new(NsC_09, "IntegerEnumerationType")
  )

  EncodedRegistry.register(
    :class => DecimalEnumerationType,
    :schema_type => XSD::QName.new(NsC_09, "DecimalEnumerationType")
  )

  EncodedRegistry.register(
    :class => FloatEnumerationType,
    :schema_type => XSD::QName.new(NsC_09, "FloatEnumerationType")
  )

  EncodedRegistry.register(
    :class => NonNegativeIntegerEnumerationType,
    :schema_type => XSD::QName.new(NsC_09, "NonNegativeIntegerEnumerationType")
  )

  EncodedRegistry.register(
    :class => PositiveIntegerEnumerationType,
    :schema_type => XSD::QName.new(NsC_09, "PositiveIntegerEnumerationType")
  )

  EncodedRegistry.register(
    :class => UnsignedLongEnumerationType,
    :schema_type => XSD::QName.new(NsC_09, "UnsignedLongEnumerationType")
  )

  EncodedRegistry.register(
    :class => UnsignedIntEnumerationType,
    :schema_type => XSD::QName.new(NsC_09, "UnsignedIntEnumerationType")
  )

  EncodedRegistry.register(
    :class => UnsignedShortEnumerationType,
    :schema_type => XSD::QName.new(NsC_09, "UnsignedShortEnumerationType")
  )

  EncodedRegistry.register(
    :class => TokenEnumerationType,
    :schema_type => XSD::QName.new(NsC_09, "TokenEnumerationType")
  )

  EncodedRegistry.register(
    :class => NullEnumerationType,
    :schema_type => XSD::QName.new(NsC_09, "NullEnumerationType")
  )

  LiteralRegistry.register(
    :class => StringAttribute,
    :schema_type => XSD::QName.new(NsC_09, "StringAttribute"),
    :schema_element => [
      ["text", "SOAP::SOAPString", [0, 1]]
    ],
    :schema_attribute => {
      XSD::QName.new(nil, "string") => "SOAP::SOAPString"
    }
  )

  LiteralRegistry.register(
    :class => BooleanAttribute,
    :schema_type => XSD::QName.new(NsC_09, "BooleanAttribute"),
    :schema_element => [
      ["text", "SOAP::SOAPString", [0, 1]]
    ],
    :schema_attribute => {
      XSD::QName.new(nil, "boolean") => "SOAP::SOAPBoolean"
    }
  )

  LiteralRegistry.register(
    :class => DecimalAttribute,
    :schema_type => XSD::QName.new(NsC_09, "DecimalAttribute"),
    :schema_element => [
      ["text", "SOAP::SOAPString", [0, 1]]
    ],
    :schema_attribute => {
      XSD::QName.new(nil, "decimal") => "SOAP::SOAPDecimal"
    }
  )

  LiteralRegistry.register(
    :class => FloatAttribute,
    :schema_type => XSD::QName.new(NsC_09, "FloatAttribute"),
    :schema_element => [
      ["text", "SOAP::SOAPString", [0, 1]]
    ],
    :schema_attribute => {
      XSD::QName.new(nil, "float") => "SOAP::SOAPFloat"
    }
  )

  LiteralRegistry.register(
    :class => DoubleAttribute,
    :schema_type => XSD::QName.new(NsC_09, "DoubleAttribute"),
    :schema_element => [
      ["text", "SOAP::SOAPString", [0, 1]]
    ],
    :schema_attribute => {
      XSD::QName.new(nil, "double") => "SOAP::SOAPDouble"
    }
  )

  LiteralRegistry.register(
    :class => DurationAttribute,
    :schema_type => XSD::QName.new(NsC_09, "DurationAttribute"),
    :schema_element => [
      ["text", "SOAP::SOAPString", [0, 1]]
    ],
    :schema_attribute => {
      XSD::QName.new(nil, "duration") => "SOAP::SOAPDuration"
    }
  )

  LiteralRegistry.register(
    :class => DateTimeAttribute,
    :schema_type => XSD::QName.new(NsC_09, "DateTimeAttribute"),
    :schema_element => [
      ["text", "SOAP::SOAPString", [0, 1]]
    ],
    :schema_attribute => {
      XSD::QName.new(nil, "dateTime") => "SOAP::SOAPDateTime"
    }
  )

  LiteralRegistry.register(
    :class => TimeAttribute,
    :schema_type => XSD::QName.new(NsC_09, "TimeAttribute"),
    :schema_element => [
      ["text", "SOAP::SOAPString", [0, 1]]
    ],
    :schema_attribute => {
      XSD::QName.new(nil, "time") => "SOAP::SOAPTime"
    }
  )

  LiteralRegistry.register(
    :class => DateAttribute,
    :schema_type => XSD::QName.new(NsC_09, "DateAttribute"),
    :schema_element => [
      ["text", "SOAP::SOAPString", [0, 1]]
    ],
    :schema_attribute => {
      XSD::QName.new(nil, "date") => "SOAP::SOAPDate"
    }
  )

  LiteralRegistry.register(
    :class => GYearMonthAttribute,
    :schema_type => XSD::QName.new(NsC_09, "GYearMonthAttribute"),
    :schema_element => [
      ["text", "SOAP::SOAPString", [0, 1]]
    ],
    :schema_attribute => {
      XSD::QName.new(nil, "gYearMonth") => "SOAP::SOAPGYearMonth"
    }
  )

  LiteralRegistry.register(
    :class => GYearAttribute,
    :schema_type => XSD::QName.new(NsC_09, "GYearAttribute"),
    :schema_element => [
      ["text", "SOAP::SOAPString", [0, 1]]
    ],
    :schema_attribute => {
      XSD::QName.new(nil, "gYear") => "SOAP::SOAPGYear"
    }
  )

  LiteralRegistry.register(
    :class => GMonthDayAttribute,
    :schema_type => XSD::QName.new(NsC_09, "GMonthDayAttribute"),
    :schema_element => [
      ["text", "SOAP::SOAPString", [0, 1]]
    ],
    :schema_attribute => {
      XSD::QName.new(nil, "gMonthDay") => "SOAP::SOAPGMonthDay"
    }
  )

  LiteralRegistry.register(
    :class => GDayAttribute,
    :schema_type => XSD::QName.new(NsC_09, "GDayAttribute"),
    :schema_element => [
      ["text", "SOAP::SOAPString", [0, 1]]
    ],
    :schema_attribute => {
      XSD::QName.new(nil, "gDay") => "SOAP::SOAPGDay"
    }
  )

  LiteralRegistry.register(
    :class => GMonthAttribute,
    :schema_type => XSD::QName.new(NsC_09, "GMonthAttribute"),
    :schema_element => [
      ["text", "SOAP::SOAPString", [0, 1]]
    ],
    :schema_attribute => {
      XSD::QName.new(nil, "gMonth") => "SOAP::SOAPGMonth"
    }
  )

  LiteralRegistry.register(
    :class => HexBinaryAttribute,
    :schema_type => XSD::QName.new(NsC_09, "HexBinaryAttribute"),
    :schema_element => [
      ["text", "SOAP::SOAPString", [0, 1]]
    ],
    :schema_attribute => {
      XSD::QName.new(nil, "hexBinary") => "SOAP::SOAPHexBinary"
    }
  )

  LiteralRegistry.register(
    :class => Base64BinaryAttribute,
    :schema_type => XSD::QName.new(NsC_09, "Base64BinaryAttribute"),
    :schema_element => [
      ["text", "SOAP::SOAPString", [0, 1]]
    ],
    :schema_attribute => {
      XSD::QName.new(nil, "base64Binary") => "SOAP::SOAPBase64"
    }
  )

  LiteralRegistry.register(
    :class => AnyURIAttribute,
    :schema_type => XSD::QName.new(NsC_09, "AnyURIAttribute"),
    :schema_element => [
      ["text", "SOAP::SOAPString", [0, 1]]
    ],
    :schema_attribute => {
      XSD::QName.new(nil, "anyURI") => "SOAP::SOAPAnyURI"
    }
  )

  LiteralRegistry.register(
    :class => QNameAttribute,
    :schema_type => XSD::QName.new(NsC_09, "QNameAttribute"),
    :schema_element => [
      ["text", "SOAP::SOAPString", [0, 1]]
    ],
    :schema_attribute => {
      XSD::QName.new(nil, "QName") => "SOAP::SOAPQName"
    }
  )

  LiteralRegistry.register(
    :class => NormalizedStringAttribute,
    :schema_type => XSD::QName.new(NsC_09, "NormalizedStringAttribute"),
    :schema_element => [
      ["text", "SOAP::SOAPString", [0, 1]]
    ],
    :schema_attribute => {
      XSD::QName.new(nil, "normalizedString") => "SOAP::SOAPNormalizedString"
    }
  )

  LiteralRegistry.register(
    :class => TokenAttribute,
    :schema_type => XSD::QName.new(NsC_09, "TokenAttribute"),
    :schema_element => [
      ["text", "SOAP::SOAPString", [0, 1]]
    ],
    :schema_attribute => {
      XSD::QName.new(nil, "token") => "SOAP::SOAPToken"
    }
  )

  LiteralRegistry.register(
    :class => LanguageAttribute,
    :schema_type => XSD::QName.new(NsC_09, "LanguageAttribute"),
    :schema_element => [
      ["text", "SOAP::SOAPString", [0, 1]]
    ],
    :schema_attribute => {
      XSD::QName.new(nil, "language") => "SOAP::SOAPLanguage"
    }
  )

  LiteralRegistry.register(
    :class => NMTOKENAttribute,
    :schema_type => XSD::QName.new(NsC_09, "NMTOKENAttribute"),
    :schema_element => [
      ["text", "SOAP::SOAPString", [0, 1]]
    ],
    :schema_attribute => {
      XSD::QName.new(nil, "NMTOKEN") => "SOAP::SOAPNMTOKEN"
    }
  )

  LiteralRegistry.register(
    :class => NMTOKENSAttribute,
    :schema_type => XSD::QName.new(NsC_09, "NMTOKENSAttribute"),
    :schema_element => [
      ["text", "SOAP::SOAPString", [0, 1]]
    ],
    :schema_attribute => {
      XSD::QName.new(nil, "NMTOKENS") => "SOAP::SOAPNMTOKENS"
    }
  )

  LiteralRegistry.register(
    :class => NameAttribute,
    :schema_type => XSD::QName.new(NsC_09, "NameAttribute"),
    :schema_element => [
      ["text", "SOAP::SOAPString", [0, 1]]
    ],
    :schema_attribute => {
      XSD::QName.new(nil, "name") => "SOAP::SOAPName"
    }
  )

  LiteralRegistry.register(
    :class => NCNameAttribute,
    :schema_type => XSD::QName.new(NsC_09, "NCNameAttribute"),
    :schema_element => [
      ["text", "SOAP::SOAPString", [0, 1]]
    ],
    :schema_attribute => {
      XSD::QName.new(nil, "NCName") => "SOAP::SOAPNCName"
    }
  )

  LiteralRegistry.register(
    :class => IDAttribute,
    :schema_type => XSD::QName.new(NsC_09, "IDAttribute"),
    :schema_element => [
      ["text", "SOAP::SOAPString", [0, 1]]
    ],
    :schema_attribute => {
      XSD::QName.new(nil, "ID") => "SOAP::SOAPID"
    }
  )

  LiteralRegistry.register(
    :class => IDREFAttribute,
    :schema_type => XSD::QName.new(NsC_09, "IDREFAttribute"),
    :schema_element => [
      ["text", "SOAP::SOAPString", [0, 1]]
    ],
    :schema_attribute => {
      XSD::QName.new(nil, "IDREF") => "SOAP::SOAPIDREF"
    }
  )

  LiteralRegistry.register(
    :class => IDREFSAttribute,
    :schema_type => XSD::QName.new(NsC_09, "IDREFSAttribute"),
    :schema_element => [
      ["text", "SOAP::SOAPString", [0, 1]]
    ],
    :schema_attribute => {
      XSD::QName.new(nil, "IDREFS") => "SOAP::SOAPIDREFS"
    }
  )

  LiteralRegistry.register(
    :class => ENTITYAttribute,
    :schema_type => XSD::QName.new(NsC_09, "ENTITYAttribute"),
    :schema_element => [
      ["text", "SOAP::SOAPString", [0, 1]]
    ],
    :schema_attribute => {
      XSD::QName.new(nil, "ENTITY") => "SOAP::SOAPENTITY"
    }
  )

  LiteralRegistry.register(
    :class => ENTITIESAttribute,
    :schema_type => XSD::QName.new(NsC_09, "ENTITIESAttribute"),
    :schema_element => [
      ["text", "SOAP::SOAPString", [0, 1]]
    ],
    :schema_attribute => {
      XSD::QName.new(nil, "ENTITIES") => "SOAP::SOAPENTITIES"
    }
  )

  LiteralRegistry.register(
    :class => IntegerAttribute,
    :schema_type => XSD::QName.new(NsC_09, "IntegerAttribute"),
    :schema_element => [
      ["text", "SOAP::SOAPString", [0, 1]]
    ],
    :schema_attribute => {
      XSD::QName.new(nil, "integer") => "SOAP::SOAPInteger"
    }
  )

  LiteralRegistry.register(
    :class => NonPositiveIntegerAttribute,
    :schema_type => XSD::QName.new(NsC_09, "NonPositiveIntegerAttribute"),
    :schema_element => [
      ["text", "SOAP::SOAPString", [0, 1]]
    ],
    :schema_attribute => {
      XSD::QName.new(nil, "nonPositiveInteger") => "SOAP::SOAPNonPositiveInteger"
    }
  )

  LiteralRegistry.register(
    :class => LongAttribute,
    :schema_type => XSD::QName.new(NsC_09, "LongAttribute"),
    :schema_element => [
      ["text", "SOAP::SOAPString", [0, 1]]
    ],
    :schema_attribute => {
      XSD::QName.new(nil, "long") => "SOAP::SOAPLong"
    }
  )

  LiteralRegistry.register(
    :class => IntAttribute,
    :schema_type => XSD::QName.new(NsC_09, "IntAttribute"),
    :schema_element => [
      ["text", "SOAP::SOAPString", [0, 1]]
    ],
    :schema_attribute => {
      XSD::QName.new(nil, "int") => "SOAP::SOAPInt"
    }
  )

  LiteralRegistry.register(
    :class => ShortAttribute,
    :schema_type => XSD::QName.new(NsC_09, "ShortAttribute"),
    :schema_element => [
      ["text", "SOAP::SOAPString", [0, 1]]
    ],
    :schema_attribute => {
      XSD::QName.new(nil, "short") => "SOAP::SOAPShort"
    }
  )

  LiteralRegistry.register(
    :class => ByteAttribute,
    :schema_type => XSD::QName.new(NsC_09, "ByteAttribute"),
    :schema_element => [
      ["text", "SOAP::SOAPString", [0, 1]]
    ],
    :schema_attribute => {
      XSD::QName.new(nil, "byte") => "SOAP::SOAPByte"
    }
  )

  LiteralRegistry.register(
    :class => NonNegativeIntegerAttribute,
    :schema_type => XSD::QName.new(NsC_09, "NonNegativeIntegerAttribute"),
    :schema_element => [
      ["text", "SOAP::SOAPString", [0, 1]]
    ],
    :schema_attribute => {
      XSD::QName.new(nil, "nonNegativeInteger") => "SOAP::SOAPNonNegativeInteger"
    }
  )

  LiteralRegistry.register(
    :class => UnsignedLongAttribute,
    :schema_type => XSD::QName.new(NsC_09, "UnsignedLongAttribute"),
    :schema_element => [
      ["text", "SOAP::SOAPString", [0, 1]]
    ],
    :schema_attribute => {
      XSD::QName.new(nil, "unsignedLong") => "SOAP::SOAPUnsignedLong"
    }
  )

  LiteralRegistry.register(
    :class => UnsignedIntAttribute,
    :schema_type => XSD::QName.new(NsC_09, "UnsignedIntAttribute"),
    :schema_element => [
      ["text", "SOAP::SOAPString", [0, 1]]
    ],
    :schema_attribute => {
      XSD::QName.new(nil, "unsignedInt") => "SOAP::SOAPUnsignedInt"
    }
  )

  LiteralRegistry.register(
    :class => UnsignedShortAttribute,
    :schema_type => XSD::QName.new(NsC_09, "UnsignedShortAttribute"),
    :schema_element => [
      ["text", "SOAP::SOAPString", [0, 1]]
    ],
    :schema_attribute => {
      XSD::QName.new(nil, "unsignedShort") => "SOAP::SOAPUnsignedShort"
    }
  )

  LiteralRegistry.register(
    :class => NegativeIntegerAttribute,
    :schema_type => XSD::QName.new(NsC_09, "NegativeIntegerAttribute"),
    :schema_element => [
      ["text", "SOAP::SOAPString", [0, 1]]
    ],
    :schema_attribute => {
      XSD::QName.new(nil, "negativeInteger") => "SOAP::SOAPNegativeInteger"
    }
  )

  LiteralRegistry.register(
    :class => UnsignedByteAttribute,
    :schema_type => XSD::QName.new(NsC_09, "UnsignedByteAttribute"),
    :schema_element => [
      ["text", "SOAP::SOAPString", [0, 1]]
    ],
    :schema_attribute => {
      XSD::QName.new(nil, "unsignedByte") => "SOAP::SOAPUnsignedByte"
    }
  )

  LiteralRegistry.register(
    :class => PositiveIntegerAttribute,
    :schema_type => XSD::QName.new(NsC_09, "PositiveIntegerAttribute"),
    :schema_element => [
      ["text", "SOAP::SOAPString", [0, 1]]
    ],
    :schema_attribute => {
      XSD::QName.new(nil, "positiveInteger") => "SOAP::SOAPPositiveInteger"
    }
  )

  LiteralRegistry.register(
    :class => ComplexTypeSequence,
    :schema_type => XSD::QName.new(NsC_09, "ComplexTypeSequence"),
    :schema_element => [
      ["name", "SOAP::SOAPString"],
      ["shade", "SOAP::SOAPString"],
      ["length", "SOAP::SOAPInt"]
    ],
    :schema_attribute => {
      XSD::QName.new(nil, "id") => "SOAP::SOAPString",
      XSD::QName.new(nil, "inStock") => "SOAP::SOAPInt"
    }
  )

  LiteralRegistry.register(
    :class => ComplexTypeAll,
    :schema_type => XSD::QName.new(NsC_09, "ComplexTypeAll"),
    :schema_element => [
      ["name", "SOAP::SOAPString"],
      ["shade", "SOAP::SOAPString"],
      ["length", "SOAP::SOAPInt"]
    ],
    :schema_attribute => {
      XSD::QName.new(nil, "id") => "SOAP::SOAPString",
      XSD::QName.new(nil, "inStock") => "SOAP::SOAPInt"
    }
  )

  LiteralRegistry.register(
    :class => Fruit,
    :schema_type => XSD::QName.new(NsC_09, "Fruit"),
    :schema_element => [ :choice,
      ["apple", "SOAP::SOAPInt"],
      ["orange", "SOAP::SOAPString"],
      ["banana", "SOAP::SOAPInt"]
    ]
  )

  LiteralRegistry.register(
    :class => Mortgage,
    :schema_type => XSD::QName.new(NsC_09, "Mortgage"),
    :schema_element => [
      ["amount", "SOAP::SOAPInt"],
      [ :choice,
        ["repayment", "Repayment"],
        ["interestonly", "InterestOnly"]
      ]
    ]
  )

  LiteralRegistry.register(
    :class => Repayment,
    :schema_type => XSD::QName.new(NsC_09, "Repayment"),
    :schema_element => [
      ["years", "SOAP::SOAPInt"],
      ["months", "SOAP::SOAPInt"],
      ["rate", "SOAP::SOAPString"]
    ]
  )

  LiteralRegistry.register(
    :class => InterestOnly,
    :schema_type => XSD::QName.new(NsC_09, "InterestOnly"),
    :schema_element => [
      ["years", "SOAP::SOAPInt"],
      ["rate", "SOAP::SOAPString"]
    ]
  )

  LiteralRegistry.register(
    :class => ElementMinOccurs1,
    :schema_type => XSD::QName.new(NsC_09, "ElementMinOccurs1"),
    :schema_element => [
      ["elementMinOccurs1item", "SOAP::SOAPString"]
    ]
  )

  LiteralRegistry.register(
    :class => ItemColors2,
    :schema_type => XSD::QName.new(NsC_09, "ItemColors2"),
    :schema_element => [
      ["itemColor", "SOAP::SOAPString[]", [2, 2]]
    ]
  )

  LiteralRegistry.register(
    :class => ItemColors,
    :schema_type => XSD::QName.new(NsC_09, "ItemColors"),
    :schema_element => [
      ["itemColor", "SOAP::SOAPString[]", [2, nil]]
    ]
  )

  LiteralRegistry.register(
    :class => ElementMaxOccurs1,
    :schema_type => XSD::QName.new(NsC_09, "ElementMaxOccurs1"),
    :schema_element => [
      ["value", "SOAP::SOAPString"]
    ]
  )

  LiteralRegistry.register(
    :class => Publications,
    :schema_type => XSD::QName.new(NsC_09, "Publications"),
    :schema_element => [
      ["day", "SOAP::SOAPString[]", [1, nil]]
    ]
  )

  LiteralRegistry.register(
    :class => Summer,
    :schema_type => XSD::QName.new(NsC_09, "Summer"),
    :schema_element => [
      ["mnth", "SOAP::SOAPString[]", [1, 4]]
    ]
  )

  LiteralRegistry.register(
    :class => Premium,
    :schema_type => XSD::QName.new(NsC_09, "Premium"),
    :schema_element => [
      ["amount", "SOAP::SOAPString"]
    ],
    :schema_attribute => {
      XSD::QName.new(nil, "id") => "SOAP::SOAPString",
      XSD::QName.new(nil, "currency") => "SOAP::SOAPString"
    }
  )

  LiteralRegistry.register(
    :class => Discount,
    :schema_type => XSD::QName.new(NsC_09, "Discount"),
    :schema_element => [
      ["percentage", "SOAP::SOAPInt"]
    ],
    :schema_attribute => {
      XSD::QName.new(nil, "id") => "SOAP::SOAPString",
      XSD::QName.new(nil, "seasonal") => "SOAP::SOAPBoolean"
    }
  )

  LiteralRegistry.register(
    :class => Survey,
    :schema_type => XSD::QName.new(NsC_09, "Survey"),
    :schema_element => [
      ["fee", "SOAP::SOAPInt"]
    ],
    :schema_attribute => {
      XSD::QName.new(nil, "id") => "SOAP::SOAPString",
      XSD::QName.new(nil, "currency") => "SOAP::SOAPString"
    }
  )

  LiteralRegistry.register(
    :class => ElementMinOccurs0,
    :schema_type => XSD::QName.new(NsC_09, "ElementMinOccurs0"),
    :schema_element => [
      ["firstName", "SOAP::SOAPString"],
      ["middleName", "SOAP::SOAPString", [0, 1]],
      ["lastName", "SOAP::SOAPString"]
    ]
  )

  LiteralRegistry.register(
    :class => NillableMiddleName,
    :schema_type => XSD::QName.new(NsC_09, "NillableMiddleName"),
    :schema_element => [
      ["firstName", "SOAP::SOAPString"],
      ["middleName", "SOAP::SOAPString"],
      ["lastName", "SOAP::SOAPString"]
    ]
  )

  LiteralRegistry.register(
    :class => NillableOptionalMiddleName,
    :schema_type => XSD::QName.new(NsC_09, "NillableOptionalMiddleName"),
    :schema_element => [
      ["firstName", "SOAP::SOAPString"],
      ["middleName", "SOAP::SOAPString", [0, 1]],
      ["lastName", "SOAP::SOAPString"]
    ]
  )

  LiteralRegistry.register(
    :class => SequenceElementList,
    :schema_type => XSD::QName.new(NsC_09, "SequenceElementList"),
    :schema_element => [
      ["item", "SOAP::SOAPString[]", [0, nil]]
    ]
  )

  LiteralRegistry.register(
    :class => NestedItem,
    :schema_type => XSD::QName.new(NsC_09, "NestedItem"),
    :schema_element => [
      ["item", "SOAP::SOAPString[]", [0, nil]]
    ]
  )

  LiteralRegistry.register(
    :class => NestedSequenceElementList,
    :schema_type => XSD::QName.new(NsC_09, "NestedSequenceElementList"),
    :schema_element => [
      ["nestedItem", "NestedItem[]", [0, nil]]
    ]
  )

  LiteralRegistry.register(
    :class => MixedContentType,
    :schema_type => XSD::QName.new(NsC_09, "MixedContentType"),
    :schema_element => [
      ["elem1", "SOAP::SOAPString"],
      ["elem2", "SOAP::SOAPString"]
    ]
  )

  LiteralRegistry.register(
    :class => CustomerName,
    :schema_type => XSD::QName.new(NsC_09, "CustomerName"),
    :schema_element => [
      ["firstName", "SOAP::SOAPString"],
      ["lastName", "SOAP::SOAPString"]
    ]
  )

  LiteralRegistry.register(
    :class => ClientName,
    :schema_type => XSD::QName.new(NsC_09, "ClientName"),
    :schema_element => [
      ["firstName", "SOAP::SOAPString"],
      ["lastName", "SOAP::SOAPString"]
    ],
    :schema_attribute => {
      XSD::QName.new(NsC_09, "phoneNumber") => "SOAP::SOAPString"
    }
  )

  LiteralRegistry.register(
    :class => ClientDetails,
    :schema_type => XSD::QName.new(NsC_09, "ClientDetails"),
    :schema_element => [
      ["forename", "SOAP::SOAPString"],
      ["surname", "SOAP::SOAPString"],
      ["title", "SOAP::SOAPString"]
    ],
    :schema_attribute => {
      XSD::QName.new(nil, "phone") => "SOAP::SOAPLong",
      XSD::QName.new(nil, "title") => "SOAP::SOAPBoolean"
    }
  )

  LiteralRegistry.register(
    :class => ExtendedSequenceStrict,
    :schema_type => XSD::QName.new(NsC_09, "ExtendedSequenceStrict"),
    :schema_element => [
      ["firstName", "SOAP::SOAPString"],
      ["lastName", "SOAP::SOAPString"],
      ["extension", "StrictExtension", [0, 1]]
    ]
  )

  LiteralRegistry.register(
    :class => StrictExtension,
    :schema_type => XSD::QName.new(NsC_09, "StrictExtension"),
    :schema_element => [
      ["any", [nil, XSD::QName.new(NsXMLSchema, "anyType")]]
    ]
  )

  LiteralRegistry.register(
    :class => ExtendedSequenceLax,
    :schema_type => XSD::QName.new(NsC_09, "ExtendedSequenceLax"),
    :schema_element => [
      ["firstName", "SOAP::SOAPString"],
      ["lastName", "SOAP::SOAPString"],
      ["extension", "LaxExtension", [0, 1]]
    ]
  )

  LiteralRegistry.register(
    :class => LaxExtension,
    :schema_type => XSD::QName.new(NsC_09, "LaxExtension"),
    :schema_element => [
      ["any", [nil, XSD::QName.new(NsXMLSchema, "anyType")]]
    ]
  )

  LiteralRegistry.register(
    :class => ExtendedSequenceSkip,
    :schema_type => XSD::QName.new(NsC_09, "ExtendedSequenceSkip"),
    :schema_element => [
      ["firstName", "SOAP::SOAPString"],
      ["lastName", "SOAP::SOAPString"],
      ["extension", "SkipExtension", [0, 1]]
    ]
  )

  LiteralRegistry.register(
    :class => SkipExtension,
    :schema_type => XSD::QName.new(NsC_09, "SkipExtension"),
    :schema_element => [
      ["any", [nil, XSD::QName.new(NsXMLSchema, "anyType")]]
    ]
  )

  LiteralRegistry.register(
    :class => BareVector,
    :schema_type => XSD::QName.new(NsC_09, "BareVector"),
    :schema_element => [
      ["item1", "SOAP::SOAPString[]", [0, nil]],
      ["item2", "SOAP::SOAPString[]", [0, nil]],
      ["item3", "SOAP::SOAPString[]", [0, nil]]
    ]
  )

  LiteralRegistry.register(
    :class => ComplexTypeSequenceBase,
    :schema_type => XSD::QName.new(NsC_09, "ComplexTypeSequenceBase"),
    :schema_element => [
      ["name", "SOAP::SOAPString"]
    ]
  )

  LiteralRegistry.register(
    :class => ComplexTypeSequenceExtension,
    :schema_type => XSD::QName.new(NsC_09, "ComplexTypeSequenceExtension"),
    :schema_basetype => XSD::QName.new(NsC_09, "ComplexTypeSequenceBase"),
    :schema_element => [
      ["name", "SOAP::SOAPString"],
      ["description", "SOAP::SOAPString"]
    ]
  )

  LiteralRegistry.register(
    :class => Assembly,
    :schema_type => XSD::QName.new(NsC_09, "Assembly"),
    :schema_element => [
      ["part", "Part[]", [0, nil]]
    ]
  )

  LiteralRegistry.register(
    :class => Part,
    :schema_type => XSD::QName.new(NsC_09, "Part"),
    :schema_element => [
      ["number", "SOAP::SOAPString"]
    ]
  )

  LiteralRegistry.register(
    :class => Part2,
    :schema_type => XSD::QName.new(NsC_09, "Part2"),
    :schema_basetype => XSD::QName.new(NsC_09, "Part"),
    :schema_element => [
      ["number", "SOAP::SOAPString"],
      ["description", "SOAP::SOAPString"]
    ]
  )

  LiteralRegistry.register(
    :class => SimpleTypeAttributes,
    :schema_type => XSD::QName.new(NsC_09, "SimpleTypeAttributes"),
    :schema_attribute => {
      XSD::QName.new(nil, "a1") => "SOAP::SOAPString",
      XSD::QName.new(nil, "a2") => "SOAP::SOAPString"
    }
  )

  LiteralRegistry.register(
    :class => ExtendedSimpleType,
    :schema_type => XSD::QName.new(NsC_09, "ExtendedSimpleType")
  )

  LiteralRegistry.register(
    :class => SequenceMinOccurs1,
    :schema_type => XSD::QName.new(NsC_09, "SequenceMinOccurs1"),
    :schema_element => [
      ["sequenceMinOccurs1item", "SOAP::SOAPString"]
    ]
  )

  LiteralRegistry.register(
    :class => ArticleColors,
    :schema_type => XSD::QName.new(NsC_09, "ArticleColors"),
    :schema_element => [
      ["articleColor", "SOAP::SOAPString[]"],
      ["articleContrast", "SOAP::SOAPString[]"]
    ]
  )

  LiteralRegistry.register(
    :class => MyAgeDetails,
    :schema_type => XSD::QName.new(NsC_09, "MyAgeDetails"),
    :schema_element => [
      ["myAge", "SOAP::SOAPShort"]
    ]
  )

  LiteralRegistry.register(
    :class => DurationList,
    :schema_type => XSD::QName.new(NsC_09, "DurationList"),
    :schema_element => [
      ["durationValue", "SOAP::SOAPShort[]", [0, nil]]
    ]
  )

  LiteralRegistry.register(
    :class => DurationListSequence,
    :schema_type => XSD::QName.new(NsC_09, "DurationListSequence"),
    :schema_element => [
      ["durationVal", "SOAP::SOAPString[]"],
      ["durationPercentage", "SOAP::SOAPString[]"]
    ]
  )

  LiteralRegistry.register(
    :class => AgeList,
    :schema_type => XSD::QName.new(NsC_09, "AgeList"),
    :schema_element => [
      ["ageValue", "SOAP::SOAPShort[]", [1, nil]]
    ]
  )

  LiteralRegistry.register(
    :class => AgeListSequence,
    :schema_type => XSD::QName.new(NsC_09, "AgeListSequence"),
    :schema_element => [
      ["ageVal", "SOAP::SOAPString[]"],
      ["agePercentage", "SOAP::SOAPString[]"]
    ]
  )

  LiteralRegistry.register(
    :class => BookPublications,
    :schema_type => XSD::QName.new(NsC_09, "BookPublications"),
    :schema_element => [
      ["pubDate", "SOAP::SOAPString[]"],
      ["pubISBN", "SOAP::SOAPString[]"]
    ]
  )

  LiteralRegistry.register(
    :class => Winter,
    :schema_type => XSD::QName.new(NsC_09, "Winter"),
    :schema_element => [
      ["mnth", "SOAP::SOAPString[]"],
      ["weather", "SOAP::SOAPString[]"]
    ]
  )

  LiteralRegistry.register(
    :class => SequenceMinOccurs0,
    :schema_type => XSD::QName.new(NsC_09, "SequenceMinOccurs0"),
    :schema_element => [
      ["firstName", "SOAP::SOAPString"],
      ["middleName", "SOAP::SOAPString"],
      ["lastName", "SOAP::SOAPString"]
    ]
  )

  LiteralRegistry.register(
    :class => SequenceSequenceElement,
    :schema_type => XSD::QName.new(NsC_09, "SequenceSequenceElement"),
    :schema_element => [
      ["firstName", "SOAP::SOAPString"],
      [
        ["middleName", "SOAP::SOAPString"],
        [
          ["lastName", "SOAP::SOAPString"]
        ]
      ]
    ]
  )

  LiteralRegistry.register(
    :class => AttributeTypeReference,
    :schema_type => XSD::QName.new(NsC_09, "AttributeTypeReference"),
    :schema_element => [
      ["text", "SOAP::SOAPString", [0, 1]]
    ],
    :schema_attribute => {
      XSD::QName.new(nil, "number") => "SOAP::SOAPDecimal"
    }
  )

  LiteralRegistry.register(
    :class => ElementTypeReferenced,
    :schema_type => XSD::QName.new(NsC_09, "ElementTypeReferenced"),
    :schema_element => [
      ["referenced", "SOAP::SOAPString"]
    ]
  )

  LiteralRegistry.register(
    :class => ElementTypeReference,
    :schema_type => XSD::QName.new(NsC_09, "ElementTypeReference"),
    :schema_element => [
      ["text", "ElementTypeReferenced"]
    ]
  )

  LiteralRegistry.register(
    :class => LocalElementComplexType,
    :schema_type => XSD::QName.new(NsC_09, "LocalElementComplexType"),
    :schema_element => [
      ["name", "LocalElementComplexType::Name"]
    ]
  )

  LiteralRegistry.register(
    :class => LocalElementComplexType::Name,
    :schema_name => XSD::QName.new(NsC_09, "name"),
    :is_anonymous => true,
    :schema_qualified => true,
    :schema_element => [
      ["firstName", "SOAP::SOAPString"],
      ["lastName", "SOAP::SOAPString"]
    ]
  )

  LiteralRegistry.register(
    :class => IdExample,
    :schema_type => XSD::QName.new(NsC_09, "IdExample"),
    :schema_element => [
      ["text", "SOAP::SOAPString", [0, 1]]
    ],
    :schema_attribute => {
      XSD::QName.new(nil, "string") => "SOAP::SOAPString"
    }
  )

  LiteralRegistry.register(
    :class => AttributeGroupExample,
    :schema_type => XSD::QName.new(NsC_09, "AttributeGroupExample"),
    :schema_element => [
      ["contract", "SOAP::SOAPString"]
    ],
    :schema_attribute => {
      XSD::QName.new(nil, "id") => "SOAP::SOAPID"
    }
  )

  LiteralRegistry.register(
    :class => GlobalSimpleType,
    :schema_type => XSD::QName.new(NsC_09, "GlobalSimpleType")
  )

  LiteralRegistry.register(
    :class => Beatle,
    :schema_type => XSD::QName.new(NsC_09, "Beatle")
  )

  LiteralRegistry.register(
    :class => NMTOKENEnumerationType,
    :schema_type => XSD::QName.new(NsC_09, "NMTOKENEnumerationType")
  )

  LiteralRegistry.register(
    :class => IntEnumerationType,
    :schema_type => XSD::QName.new(NsC_09, "IntEnumerationType")
  )

  LiteralRegistry.register(
    :class => ShortEnumerationType,
    :schema_type => XSD::QName.new(NsC_09, "ShortEnumerationType")
  )

  LiteralRegistry.register(
    :class => LongEnumerationType,
    :schema_type => XSD::QName.new(NsC_09, "LongEnumerationType")
  )

  LiteralRegistry.register(
    :class => DoubleEnumerationType,
    :schema_type => XSD::QName.new(NsC_09, "DoubleEnumerationType")
  )

  LiteralRegistry.register(
    :class => IntegerEnumerationType,
    :schema_type => XSD::QName.new(NsC_09, "IntegerEnumerationType")
  )

  LiteralRegistry.register(
    :class => DecimalEnumerationType,
    :schema_type => XSD::QName.new(NsC_09, "DecimalEnumerationType")
  )

  LiteralRegistry.register(
    :class => FloatEnumerationType,
    :schema_type => XSD::QName.new(NsC_09, "FloatEnumerationType")
  )

  LiteralRegistry.register(
    :class => NonNegativeIntegerEnumerationType,
    :schema_type => XSD::QName.new(NsC_09, "NonNegativeIntegerEnumerationType")
  )

  LiteralRegistry.register(
    :class => PositiveIntegerEnumerationType,
    :schema_type => XSD::QName.new(NsC_09, "PositiveIntegerEnumerationType")
  )

  LiteralRegistry.register(
    :class => UnsignedLongEnumerationType,
    :schema_type => XSD::QName.new(NsC_09, "UnsignedLongEnumerationType")
  )

  LiteralRegistry.register(
    :class => UnsignedIntEnumerationType,
    :schema_type => XSD::QName.new(NsC_09, "UnsignedIntEnumerationType")
  )

  LiteralRegistry.register(
    :class => UnsignedShortEnumerationType,
    :schema_type => XSD::QName.new(NsC_09, "UnsignedShortEnumerationType")
  )

  LiteralRegistry.register(
    :class => TokenEnumerationType,
    :schema_type => XSD::QName.new(NsC_09, "TokenEnumerationType")
  )

  LiteralRegistry.register(
    :class => NullEnumerationType,
    :schema_type => XSD::QName.new(NsC_09, "NullEnumerationType")
  )

  LiteralRegistry.register(
    :class => EchoAnySimpleTypeElement,
    :schema_name => XSD::QName.new(NsC_09, "echoAnySimpleTypeElement"),
    :schema_element => [
      ["anySimpleTypeElement", "SOAP::SOAPAnySimpleType"]
    ]
  )

  LiteralRegistry.register(
    :class => EchoAnyTypeElement,
    :schema_name => XSD::QName.new(NsC_09, "echoAnyTypeElement"),
    :schema_element => [
      ["anyTypeElement", nil]
    ]
  )

  LiteralRegistry.register(
    :class => EchoDocumentationElement,
    :schema_name => XSD::QName.new(NsC_09, "echoDocumentationElement"),
    :schema_element => [
      ["documentationElement", "SOAP::SOAPString"]
    ]
  )

  LiteralRegistry.register(
    :class => EchoIdentifierName,
    :schema_name => XSD::QName.new(NsC_09, "echoIdentifierName"),
    :schema_element => [
      ["identifierName", "SOAP::SOAPString"]
    ]
  )

  LiteralRegistry.register(
    :class => EchoNonIdentifierName,
    :schema_name => XSD::QName.new(NsC_09, "echoNonIdentifierName"),
    :schema_element => [
      ["non_Identifier_Name", ["SOAP::SOAPString", XSD::QName.new(NsC_09, "non-Identifier-Name")]]
    ]
  )

  LiteralRegistry.register(
    :class => EchoStringElement,
    :schema_name => XSD::QName.new(NsC_09, "echoStringElement"),
    :schema_element => [
      ["stringElement", "SOAP::SOAPString"]
    ]
  )

  LiteralRegistry.register(
    :class => StringAttribute,
    :schema_name => XSD::QName.new(NsC_09, "stringAttribute"),
    :schema_element => [
      ["text", "SOAP::SOAPString", [0, 1]]
    ],
    :schema_attribute => {
      XSD::QName.new(nil, "string") => "SOAP::SOAPString"
    }
  )

  LiteralRegistry.register(
    :class => EchoStringAttribute,
    :schema_name => XSD::QName.new(NsC_09, "echoStringAttribute"),
    :schema_element => [
      ["stringAttribute", "StringAttribute"]
    ]
  )

  LiteralRegistry.register(
    :class => EchoBooleanElement,
    :schema_name => XSD::QName.new(NsC_09, "echoBooleanElement"),
    :schema_element => [
      ["booleanElement", "SOAP::SOAPBoolean"]
    ]
  )

  LiteralRegistry.register(
    :class => BooleanAttribute,
    :schema_name => XSD::QName.new(NsC_09, "booleanAttribute"),
    :schema_element => [
      ["text", "SOAP::SOAPString", [0, 1]]
    ],
    :schema_attribute => {
      XSD::QName.new(nil, "boolean") => "SOAP::SOAPBoolean"
    }
  )

  LiteralRegistry.register(
    :class => EchoBooleanAttribute,
    :schema_name => XSD::QName.new(NsC_09, "echoBooleanAttribute"),
    :schema_element => [
      ["booleanAttribute", "BooleanAttribute"]
    ]
  )

  LiteralRegistry.register(
    :class => EchoDecimalElement,
    :schema_name => XSD::QName.new(NsC_09, "echoDecimalElement"),
    :schema_element => [
      ["decimalElement", "SOAP::SOAPDecimal"]
    ]
  )

  LiteralRegistry.register(
    :class => DecimalAttribute,
    :schema_name => XSD::QName.new(NsC_09, "decimalAttribute"),
    :schema_element => [
      ["text", "SOAP::SOAPString", [0, 1]]
    ],
    :schema_attribute => {
      XSD::QName.new(nil, "decimal") => "SOAP::SOAPDecimal"
    }
  )

  LiteralRegistry.register(
    :class => EchoDecimalAttribute,
    :schema_name => XSD::QName.new(NsC_09, "echoDecimalAttribute"),
    :schema_element => [
      ["decimalAttribute", "DecimalAttribute"]
    ]
  )

  LiteralRegistry.register(
    :class => EchoFloatElement,
    :schema_name => XSD::QName.new(NsC_09, "echoFloatElement"),
    :schema_element => [
      ["floatElement", "SOAP::SOAPFloat"]
    ]
  )

  LiteralRegistry.register(
    :class => FloatAttribute,
    :schema_name => XSD::QName.new(NsC_09, "floatAttribute"),
    :schema_element => [
      ["text", "SOAP::SOAPString", [0, 1]]
    ],
    :schema_attribute => {
      XSD::QName.new(nil, "float") => "SOAP::SOAPFloat"
    }
  )

  LiteralRegistry.register(
    :class => EchoFloatAttribute,
    :schema_name => XSD::QName.new(NsC_09, "echoFloatAttribute"),
    :schema_element => [
      ["floatAttribute", "FloatAttribute"]
    ]
  )

  LiteralRegistry.register(
    :class => EchoDoubleElement,
    :schema_name => XSD::QName.new(NsC_09, "echoDoubleElement"),
    :schema_element => [
      ["doubleElement", "SOAP::SOAPDouble"]
    ]
  )

  LiteralRegistry.register(
    :class => DoubleAttribute,
    :schema_name => XSD::QName.new(NsC_09, "doubleAttribute"),
    :schema_element => [
      ["text", "SOAP::SOAPString", [0, 1]]
    ],
    :schema_attribute => {
      XSD::QName.new(nil, "double") => "SOAP::SOAPDouble"
    }
  )

  LiteralRegistry.register(
    :class => EchoDoubleAttribute,
    :schema_name => XSD::QName.new(NsC_09, "echoDoubleAttribute"),
    :schema_element => [
      ["doubleAttribute", "DoubleAttribute"]
    ]
  )

  LiteralRegistry.register(
    :class => EchoDurationElement,
    :schema_name => XSD::QName.new(NsC_09, "echoDurationElement"),
    :schema_element => [
      ["durationElement", "SOAP::SOAPDuration"]
    ]
  )

  LiteralRegistry.register(
    :class => DurationAttribute,
    :schema_name => XSD::QName.new(NsC_09, "durationAttribute"),
    :schema_element => [
      ["text", "SOAP::SOAPString", [0, 1]]
    ],
    :schema_attribute => {
      XSD::QName.new(nil, "duration") => "SOAP::SOAPDuration"
    }
  )

  LiteralRegistry.register(
    :class => EchoDurationAttribute,
    :schema_name => XSD::QName.new(NsC_09, "echoDurationAttribute"),
    :schema_element => [
      ["durationAttribute", "DurationAttribute"]
    ]
  )

  LiteralRegistry.register(
    :class => EchoDateTimeElement,
    :schema_name => XSD::QName.new(NsC_09, "echoDateTimeElement"),
    :schema_element => [
      ["dateTimeElement", "SOAP::SOAPDateTime"]
    ]
  )

  LiteralRegistry.register(
    :class => DateTimeAttribute,
    :schema_name => XSD::QName.new(NsC_09, "dateTimeAttribute"),
    :schema_element => [
      ["text", "SOAP::SOAPString", [0, 1]]
    ],
    :schema_attribute => {
      XSD::QName.new(nil, "dateTime") => "SOAP::SOAPDateTime"
    }
  )

  LiteralRegistry.register(
    :class => EchoDateTimeAttribute,
    :schema_name => XSD::QName.new(NsC_09, "echoDateTimeAttribute"),
    :schema_element => [
      ["dateTimeAttribute", "DateTimeAttribute"]
    ]
  )

  LiteralRegistry.register(
    :class => EchoTimeElement,
    :schema_name => XSD::QName.new(NsC_09, "echoTimeElement"),
    :schema_element => [
      ["timeElement", "SOAP::SOAPTime"]
    ]
  )

  LiteralRegistry.register(
    :class => TimeAttribute,
    :schema_name => XSD::QName.new(NsC_09, "timeAttribute"),
    :schema_element => [
      ["text", "SOAP::SOAPString", [0, 1]]
    ],
    :schema_attribute => {
      XSD::QName.new(nil, "time") => "SOAP::SOAPTime"
    }
  )

  LiteralRegistry.register(
    :class => EchoTimeAttribute,
    :schema_name => XSD::QName.new(NsC_09, "echoTimeAttribute"),
    :schema_element => [
      ["timeAttribute", "TimeAttribute"]
    ]
  )

  LiteralRegistry.register(
    :class => EchoDateElement,
    :schema_name => XSD::QName.new(NsC_09, "echoDateElement"),
    :schema_element => [
      ["dateElement", "SOAP::SOAPDate"]
    ]
  )

  LiteralRegistry.register(
    :class => DateAttribute,
    :schema_name => XSD::QName.new(NsC_09, "dateAttribute"),
    :schema_element => [
      ["text", "SOAP::SOAPString", [0, 1]]
    ],
    :schema_attribute => {
      XSD::QName.new(nil, "date") => "SOAP::SOAPDate"
    }
  )

  LiteralRegistry.register(
    :class => EchoDateAttribute,
    :schema_name => XSD::QName.new(NsC_09, "echoDateAttribute"),
    :schema_element => [
      ["dateAttribute", "DateAttribute"]
    ]
  )

  LiteralRegistry.register(
    :class => EchoGYearMonthElement,
    :schema_name => XSD::QName.new(NsC_09, "echoGYearMonthElement"),
    :schema_element => [
      ["gYearMonthElement", "SOAP::SOAPGYearMonth"]
    ]
  )

  LiteralRegistry.register(
    :class => GYearMonthAttribute,
    :schema_name => XSD::QName.new(NsC_09, "gYearMonthAttribute"),
    :schema_element => [
      ["text", "SOAP::SOAPString", [0, 1]]
    ],
    :schema_attribute => {
      XSD::QName.new(nil, "gYearMonth") => "SOAP::SOAPGYearMonth"
    }
  )

  LiteralRegistry.register(
    :class => EchoGYearMonthAttribute,
    :schema_name => XSD::QName.new(NsC_09, "echoGYearMonthAttribute"),
    :schema_element => [
      ["gYearMonthAttribute", "GYearMonthAttribute"]
    ]
  )

  LiteralRegistry.register(
    :class => EchoGYearElement,
    :schema_name => XSD::QName.new(NsC_09, "echoGYearElement"),
    :schema_element => [
      ["gYearElement", "SOAP::SOAPGYear"]
    ]
  )

  LiteralRegistry.register(
    :class => GYearAttribute,
    :schema_name => XSD::QName.new(NsC_09, "gYearAttribute"),
    :schema_element => [
      ["text", "SOAP::SOAPString", [0, 1]]
    ],
    :schema_attribute => {
      XSD::QName.new(nil, "gYear") => "SOAP::SOAPGYear"
    }
  )

  LiteralRegistry.register(
    :class => EchoGYearAttribute,
    :schema_name => XSD::QName.new(NsC_09, "echoGYearAttribute"),
    :schema_element => [
      ["gYearAttribute", "GYearAttribute"]
    ]
  )

  LiteralRegistry.register(
    :class => EchoGMonthDayElement,
    :schema_name => XSD::QName.new(NsC_09, "echoGMonthDayElement"),
    :schema_element => [
      ["gMonthDayElement", "SOAP::SOAPGMonthDay"]
    ]
  )

  LiteralRegistry.register(
    :class => GMonthDayAttribute,
    :schema_name => XSD::QName.new(NsC_09, "gMonthDayAttribute"),
    :schema_element => [
      ["text", "SOAP::SOAPString", [0, 1]]
    ],
    :schema_attribute => {
      XSD::QName.new(nil, "gMonthDay") => "SOAP::SOAPGMonthDay"
    }
  )

  LiteralRegistry.register(
    :class => EchoGMonthDayAttribute,
    :schema_name => XSD::QName.new(NsC_09, "echoGMonthDayAttribute"),
    :schema_element => [
      ["gMonthDayAttribute", "GMonthDayAttribute"]
    ]
  )

  LiteralRegistry.register(
    :class => EchoGDayElement,
    :schema_name => XSD::QName.new(NsC_09, "echoGDayElement"),
    :schema_element => [
      ["gDayElement", "SOAP::SOAPGDay"]
    ]
  )

  LiteralRegistry.register(
    :class => GDayAttribute,
    :schema_name => XSD::QName.new(NsC_09, "gDayAttribute"),
    :schema_element => [
      ["text", "SOAP::SOAPString", [0, 1]]
    ],
    :schema_attribute => {
      XSD::QName.new(nil, "gDay") => "SOAP::SOAPGDay"
    }
  )

  LiteralRegistry.register(
    :class => EchoGDayAttribute,
    :schema_name => XSD::QName.new(NsC_09, "echoGDayAttribute"),
    :schema_element => [
      ["gDayAttribute", "GDayAttribute"]
    ]
  )

  LiteralRegistry.register(
    :class => EchoGMonthElement,
    :schema_name => XSD::QName.new(NsC_09, "echoGMonthElement"),
    :schema_element => [
      ["gMonthElement", "SOAP::SOAPGMonth"]
    ]
  )

  LiteralRegistry.register(
    :class => GMonthAttribute,
    :schema_name => XSD::QName.new(NsC_09, "gMonthAttribute"),
    :schema_element => [
      ["text", "SOAP::SOAPString", [0, 1]]
    ],
    :schema_attribute => {
      XSD::QName.new(nil, "gMonth") => "SOAP::SOAPGMonth"
    }
  )

  LiteralRegistry.register(
    :class => EchoGMonthAttribute,
    :schema_name => XSD::QName.new(NsC_09, "echoGMonthAttribute"),
    :schema_element => [
      ["gMonthAttribute", "GMonthAttribute"]
    ]
  )

  LiteralRegistry.register(
    :class => EchoHexBinaryElement,
    :schema_name => XSD::QName.new(NsC_09, "echoHexBinaryElement"),
    :schema_element => [
      ["hexBinaryElement", "SOAP::SOAPHexBinary"]
    ]
  )

  LiteralRegistry.register(
    :class => HexBinaryAttribute,
    :schema_name => XSD::QName.new(NsC_09, "hexBinaryAttribute"),
    :schema_element => [
      ["text", "SOAP::SOAPString", [0, 1]]
    ],
    :schema_attribute => {
      XSD::QName.new(nil, "hexBinary") => "SOAP::SOAPHexBinary"
    }
  )

  LiteralRegistry.register(
    :class => EchoHexBinaryAttribute,
    :schema_name => XSD::QName.new(NsC_09, "echoHexBinaryAttribute"),
    :schema_element => [
      ["hexBinaryAttribute", "HexBinaryAttribute"]
    ]
  )

  LiteralRegistry.register(
    :class => EchoBase64BinaryElement,
    :schema_name => XSD::QName.new(NsC_09, "echoBase64BinaryElement"),
    :schema_element => [
      ["base64BinaryElement", "SOAP::SOAPBase64"]
    ]
  )

  LiteralRegistry.register(
    :class => Base64BinaryAttribute,
    :schema_name => XSD::QName.new(NsC_09, "base64BinaryAttribute"),
    :schema_element => [
      ["text", "SOAP::SOAPString", [0, 1]]
    ],
    :schema_attribute => {
      XSD::QName.new(nil, "base64Binary") => "SOAP::SOAPBase64"
    }
  )

  LiteralRegistry.register(
    :class => EchoBase64BinaryAttribute,
    :schema_name => XSD::QName.new(NsC_09, "echoBase64BinaryAttribute"),
    :schema_element => [
      ["base64BinaryAttribute", "Base64BinaryAttribute"]
    ]
  )

  LiteralRegistry.register(
    :class => EchoAnyURIElement,
    :schema_name => XSD::QName.new(NsC_09, "echoAnyURIElement"),
    :schema_element => [
      ["anyURIElement", "SOAP::SOAPAnyURI"]
    ]
  )

  LiteralRegistry.register(
    :class => AnyURIAttribute,
    :schema_name => XSD::QName.new(NsC_09, "anyURIAttribute"),
    :schema_element => [
      ["text", "SOAP::SOAPString", [0, 1]]
    ],
    :schema_attribute => {
      XSD::QName.new(nil, "anyURI") => "SOAP::SOAPAnyURI"
    }
  )

  LiteralRegistry.register(
    :class => EchoAnyURIAttribute,
    :schema_name => XSD::QName.new(NsC_09, "echoAnyURIAttribute"),
    :schema_element => [
      ["anyURIAttribute", "AnyURIAttribute"]
    ]
  )

  LiteralRegistry.register(
    :class => EchoQNameElement,
    :schema_name => XSD::QName.new(NsC_09, "echoQNameElement"),
    :schema_element => [
      ["qNameElement", ["SOAP::SOAPQName", XSD::QName.new(NsC_09, "QNameElement")]]
    ]
  )

  LiteralRegistry.register(
    :class => QNameAttribute,
    :schema_name => XSD::QName.new(NsC_09, "QNameAttribute"),
    :schema_element => [
      ["text", "SOAP::SOAPString", [0, 1]]
    ],
    :schema_attribute => {
      XSD::QName.new(nil, "QName") => "SOAP::SOAPQName"
    }
  )

  LiteralRegistry.register(
    :class => EchoQNameAttribute,
    :schema_name => XSD::QName.new(NsC_09, "echoQNameAttribute"),
    :schema_element => [
      ["qNameAttribute", ["QNameAttribute", XSD::QName.new(NsC_09, "QNameAttribute")]]
    ]
  )

  LiteralRegistry.register(
    :class => EchoNormalizedStringElement,
    :schema_name => XSD::QName.new(NsC_09, "echoNormalizedStringElement"),
    :schema_element => [
      ["normalizedStringElement", "SOAP::SOAPNormalizedString"]
    ]
  )

  LiteralRegistry.register(
    :class => NormalizedStringAttribute,
    :schema_name => XSD::QName.new(NsC_09, "normalizedStringAttribute"),
    :schema_element => [
      ["text", "SOAP::SOAPString", [0, 1]]
    ],
    :schema_attribute => {
      XSD::QName.new(nil, "normalizedString") => "SOAP::SOAPNormalizedString"
    }
  )

  LiteralRegistry.register(
    :class => EchoNormalizedStringAttribute,
    :schema_name => XSD::QName.new(NsC_09, "echoNormalizedStringAttribute"),
    :schema_element => [
      ["normalizedStringAttribute", "NormalizedStringAttribute"]
    ]
  )

  LiteralRegistry.register(
    :class => EchoTokenElement,
    :schema_name => XSD::QName.new(NsC_09, "echoTokenElement"),
    :schema_element => [
      ["tokenElement", "SOAP::SOAPToken"]
    ]
  )

  LiteralRegistry.register(
    :class => TokenAttribute,
    :schema_name => XSD::QName.new(NsC_09, "tokenAttribute"),
    :schema_element => [
      ["text", "SOAP::SOAPString", [0, 1]]
    ],
    :schema_attribute => {
      XSD::QName.new(nil, "token") => "SOAP::SOAPToken"
    }
  )

  LiteralRegistry.register(
    :class => EchoTokenAttribute,
    :schema_name => XSD::QName.new(NsC_09, "echoTokenAttribute"),
    :schema_element => [
      ["tokenAttribute", "TokenAttribute"]
    ]
  )

  LiteralRegistry.register(
    :class => EchoLanguageElement,
    :schema_name => XSD::QName.new(NsC_09, "echoLanguageElement"),
    :schema_element => [
      ["languageElement", "SOAP::SOAPLanguage"]
    ]
  )

  LiteralRegistry.register(
    :class => LanguageAttribute,
    :schema_name => XSD::QName.new(NsC_09, "languageAttribute"),
    :schema_element => [
      ["text", "SOAP::SOAPString", [0, 1]]
    ],
    :schema_attribute => {
      XSD::QName.new(nil, "language") => "SOAP::SOAPLanguage"
    }
  )

  LiteralRegistry.register(
    :class => EchoLanguageAttribute,
    :schema_name => XSD::QName.new(NsC_09, "echoLanguageAttribute"),
    :schema_element => [
      ["languageAttribute", "LanguageAttribute"]
    ]
  )

  LiteralRegistry.register(
    :class => EchoNMTOKENElement,
    :schema_name => XSD::QName.new(NsC_09, "echoNMTOKENElement"),
    :schema_element => [
      ["nMTOKENElement", ["SOAP::SOAPNMTOKEN", XSD::QName.new(NsC_09, "NMTOKENElement")]]
    ]
  )

  LiteralRegistry.register(
    :class => NMTOKENAttribute,
    :schema_name => XSD::QName.new(NsC_09, "NMTOKENAttribute"),
    :schema_element => [
      ["text", "SOAP::SOAPString", [0, 1]]
    ],
    :schema_attribute => {
      XSD::QName.new(nil, "NMTOKEN") => "SOAP::SOAPNMTOKEN"
    }
  )

  LiteralRegistry.register(
    :class => EchoNMTOKENAttribute,
    :schema_name => XSD::QName.new(NsC_09, "echoNMTOKENAttribute"),
    :schema_element => [
      ["nMTOKENAttribute", ["NMTOKENAttribute", XSD::QName.new(NsC_09, "NMTOKENAttribute")]]
    ]
  )

  LiteralRegistry.register(
    :class => EchoNMTOKENSElement,
    :schema_name => XSD::QName.new(NsC_09, "echoNMTOKENSElement"),
    :schema_element => [
      ["nMTOKENSElement", ["SOAP::SOAPNMTOKENS", XSD::QName.new(NsC_09, "NMTOKENSElement")]]
    ]
  )

  LiteralRegistry.register(
    :class => NMTOKENSAttribute,
    :schema_name => XSD::QName.new(NsC_09, "NMTOKENSAttribute"),
    :schema_element => [
      ["text", "SOAP::SOAPString", [0, 1]]
    ],
    :schema_attribute => {
      XSD::QName.new(nil, "NMTOKENS") => "SOAP::SOAPNMTOKENS"
    }
  )

  LiteralRegistry.register(
    :class => EchoNMTOKENSAttribute,
    :schema_name => XSD::QName.new(NsC_09, "echoNMTOKENSAttribute"),
    :schema_element => [
      ["nMTOKENSAttribute", ["NMTOKENSAttribute", XSD::QName.new(NsC_09, "NMTOKENSAttribute")]]
    ]
  )

  LiteralRegistry.register(
    :class => EchoNameElement,
    :schema_name => XSD::QName.new(NsC_09, "echoNameElement"),
    :schema_element => [
      ["nameElement", ["SOAP::SOAPName", XSD::QName.new(NsC_09, "NameElement")]]
    ]
  )

  LiteralRegistry.register(
    :class => NameAttribute,
    :schema_name => XSD::QName.new(NsC_09, "nameAttribute"),
    :schema_element => [
      ["text", "SOAP::SOAPString", [0, 1]]
    ],
    :schema_attribute => {
      XSD::QName.new(nil, "name") => "SOAP::SOAPName"
    }
  )

  LiteralRegistry.register(
    :class => EchoNameAttribute,
    :schema_name => XSD::QName.new(NsC_09, "echoNameAttribute"),
    :schema_element => [
      ["nameAttribute", "NameAttribute"]
    ]
  )

  LiteralRegistry.register(
    :class => EchoNCNameElement,
    :schema_name => XSD::QName.new(NsC_09, "echoNCNameElement"),
    :schema_element => [
      ["nCNameElement", ["SOAP::SOAPNCName", XSD::QName.new(NsC_09, "NCNameElement")]]
    ]
  )

  LiteralRegistry.register(
    :class => NCNameAttribute,
    :schema_name => XSD::QName.new(NsC_09, "NCNameAttribute"),
    :schema_element => [
      ["text", "SOAP::SOAPString", [0, 1]]
    ],
    :schema_attribute => {
      XSD::QName.new(nil, "NCName") => "SOAP::SOAPNCName"
    }
  )

  LiteralRegistry.register(
    :class => EchoNCNameAttribute,
    :schema_name => XSD::QName.new(NsC_09, "echoNCNameAttribute"),
    :schema_element => [
      ["nCNameAttribute", ["NCNameAttribute", XSD::QName.new(NsC_09, "NCNameAttribute")]]
    ]
  )

  LiteralRegistry.register(
    :class => EchoIDElement,
    :schema_name => XSD::QName.new(NsC_09, "echoIDElement"),
    :schema_element => [
      ["iDElement", ["SOAP::SOAPID", XSD::QName.new(NsC_09, "IDElement")]]
    ]
  )

  LiteralRegistry.register(
    :class => IDAttribute,
    :schema_name => XSD::QName.new(NsC_09, "IDAttribute"),
    :schema_element => [
      ["text", "SOAP::SOAPString", [0, 1]]
    ],
    :schema_attribute => {
      XSD::QName.new(nil, "ID") => "SOAP::SOAPID"
    }
  )

  LiteralRegistry.register(
    :class => EchoIDAttribute,
    :schema_name => XSD::QName.new(NsC_09, "echoIDAttribute"),
    :schema_element => [
      ["iDAttribute", ["IDAttribute", XSD::QName.new(NsC_09, "IDAttribute")]]
    ]
  )

  LiteralRegistry.register(
    :class => EchoIDREFElement,
    :schema_name => XSD::QName.new(NsC_09, "echoIDREFElement"),
    :schema_element => [
      ["iDREFElement", ["SOAP::SOAPIDREF", XSD::QName.new(NsC_09, "IDREFElement")]]
    ]
  )

  LiteralRegistry.register(
    :class => IDREFAttribute,
    :schema_name => XSD::QName.new(NsC_09, "IDREFAttribute"),
    :schema_element => [
      ["text", "SOAP::SOAPString", [0, 1]]
    ],
    :schema_attribute => {
      XSD::QName.new(nil, "IDREF") => "SOAP::SOAPIDREF"
    }
  )

  LiteralRegistry.register(
    :class => EchoIDREFAttribute,
    :schema_name => XSD::QName.new(NsC_09, "echoIDREFAttribute"),
    :schema_element => [
      ["iDREFAttribute", ["IDREFAttribute", XSD::QName.new(NsC_09, "IDREFAttribute")]]
    ]
  )

  LiteralRegistry.register(
    :class => EchoIDREFSElement,
    :schema_name => XSD::QName.new(NsC_09, "echoIDREFSElement"),
    :schema_element => [
      ["iDREFSElement", ["SOAP::SOAPIDREFS", XSD::QName.new(NsC_09, "IDREFSElement")]]
    ]
  )

  LiteralRegistry.register(
    :class => IDREFSAttribute,
    :schema_name => XSD::QName.new(NsC_09, "IDREFSAttribute"),
    :schema_element => [
      ["text", "SOAP::SOAPString", [0, 1]]
    ],
    :schema_attribute => {
      XSD::QName.new(nil, "IDREFS") => "SOAP::SOAPIDREFS"
    }
  )

  LiteralRegistry.register(
    :class => EchoIDREFSAttribute,
    :schema_name => XSD::QName.new(NsC_09, "echoIDREFSAttribute"),
    :schema_element => [
      ["iDREFSAttribute", ["IDREFSAttribute", XSD::QName.new(NsC_09, "IDREFSAttribute")]]
    ]
  )

  LiteralRegistry.register(
    :class => EchoENTITYElement,
    :schema_name => XSD::QName.new(NsC_09, "echoENTITYElement"),
    :schema_element => [
      ["eNTITYElement", ["SOAP::SOAPENTITY", XSD::QName.new(NsC_09, "ENTITYElement")]]
    ]
  )

  LiteralRegistry.register(
    :class => ENTITYAttribute,
    :schema_name => XSD::QName.new(NsC_09, "ENTITYAttribute"),
    :schema_element => [
      ["text", "SOAP::SOAPString", [0, 1]]
    ],
    :schema_attribute => {
      XSD::QName.new(nil, "ENTITY") => "SOAP::SOAPENTITY"
    }
  )

  LiteralRegistry.register(
    :class => EchoENTITYAttribute,
    :schema_name => XSD::QName.new(NsC_09, "echoENTITYAttribute"),
    :schema_element => [
      ["eNTITYAttribute", ["ENTITYAttribute", XSD::QName.new(NsC_09, "ENTITYAttribute")]]
    ]
  )

  LiteralRegistry.register(
    :class => EchoENTITIESElement,
    :schema_name => XSD::QName.new(NsC_09, "echoENTITIESElement"),
    :schema_element => [
      ["eNTITIESElement", ["SOAP::SOAPENTITIES", XSD::QName.new(NsC_09, "ENTITIESElement")]]
    ]
  )

  LiteralRegistry.register(
    :class => ENTITIESAttribute,
    :schema_name => XSD::QName.new(NsC_09, "ENTITIESAttribute"),
    :schema_element => [
      ["text", "SOAP::SOAPString", [0, 1]]
    ],
    :schema_attribute => {
      XSD::QName.new(nil, "ENTITIES") => "SOAP::SOAPENTITIES"
    }
  )

  LiteralRegistry.register(
    :class => EchoENTITIESAttribute,
    :schema_name => XSD::QName.new(NsC_09, "echoENTITIESAttribute"),
    :schema_element => [
      ["eNTITIESAttribute", ["ENTITIESAttribute", XSD::QName.new(NsC_09, "ENTITIESAttribute")]]
    ]
  )

  LiteralRegistry.register(
    :class => EchoIntegerElement,
    :schema_name => XSD::QName.new(NsC_09, "echoIntegerElement"),
    :schema_element => [
      ["integerElement", "SOAP::SOAPInteger"]
    ]
  )

  LiteralRegistry.register(
    :class => IntegerAttribute,
    :schema_name => XSD::QName.new(NsC_09, "integerAttribute"),
    :schema_element => [
      ["text", "SOAP::SOAPString", [0, 1]]
    ],
    :schema_attribute => {
      XSD::QName.new(nil, "integer") => "SOAP::SOAPInteger"
    }
  )

  LiteralRegistry.register(
    :class => EchoIntegerAttribute,
    :schema_name => XSD::QName.new(NsC_09, "echoIntegerAttribute"),
    :schema_element => [
      ["integerAttribute", "IntegerAttribute"]
    ]
  )

  LiteralRegistry.register(
    :class => EchoNonPositiveIntegerElement,
    :schema_name => XSD::QName.new(NsC_09, "echoNonPositiveIntegerElement"),
    :schema_element => [
      ["nonPositiveIntegerElement", "SOAP::SOAPNonPositiveInteger"]
    ]
  )

  LiteralRegistry.register(
    :class => NonPositiveIntegerAttribute,
    :schema_name => XSD::QName.new(NsC_09, "nonPositiveIntegerAttribute"),
    :schema_element => [
      ["text", "SOAP::SOAPString", [0, 1]]
    ],
    :schema_attribute => {
      XSD::QName.new(nil, "nonPositiveInteger") => "SOAP::SOAPNonPositiveInteger"
    }
  )

  LiteralRegistry.register(
    :class => EchoNonPositiveIntegerAttribute,
    :schema_name => XSD::QName.new(NsC_09, "echoNonPositiveIntegerAttribute"),
    :schema_element => [
      ["nonPositiveIntegerAttribute", "NonPositiveIntegerAttribute"]
    ]
  )

  LiteralRegistry.register(
    :class => EchoNegativeIntegerElement,
    :schema_name => XSD::QName.new(NsC_09, "echoNegativeIntegerElement"),
    :schema_element => [
      ["negativeIntegerElement", "SOAP::SOAPNegativeInteger"]
    ]
  )

  LiteralRegistry.register(
    :class => EchoLongElement,
    :schema_name => XSD::QName.new(NsC_09, "echoLongElement"),
    :schema_element => [
      ["longElement", "SOAP::SOAPLong"]
    ]
  )

  LiteralRegistry.register(
    :class => LongAttribute,
    :schema_name => XSD::QName.new(NsC_09, "longAttribute"),
    :schema_element => [
      ["text", "SOAP::SOAPString", [0, 1]]
    ],
    :schema_attribute => {
      XSD::QName.new(nil, "long") => "SOAP::SOAPLong"
    }
  )

  LiteralRegistry.register(
    :class => EchoLongAttribute,
    :schema_name => XSD::QName.new(NsC_09, "echoLongAttribute"),
    :schema_element => [
      ["longAttribute", "LongAttribute"]
    ]
  )

  LiteralRegistry.register(
    :class => EchoIntElement,
    :schema_name => XSD::QName.new(NsC_09, "echoIntElement"),
    :schema_element => [
      ["intElement", "SOAP::SOAPInt"]
    ]
  )

  LiteralRegistry.register(
    :class => IntAttribute,
    :schema_name => XSD::QName.new(NsC_09, "intAttribute"),
    :schema_element => [
      ["text", "SOAP::SOAPString", [0, 1]]
    ],
    :schema_attribute => {
      XSD::QName.new(nil, "int") => "SOAP::SOAPInt"
    }
  )

  LiteralRegistry.register(
    :class => EchoIntAttribute,
    :schema_name => XSD::QName.new(NsC_09, "echoIntAttribute"),
    :schema_element => [
      ["intAttribute", "IntAttribute"]
    ]
  )

  LiteralRegistry.register(
    :class => EchoShortElement,
    :schema_name => XSD::QName.new(NsC_09, "echoShortElement"),
    :schema_element => [
      ["shortElement", "SOAP::SOAPShort"]
    ]
  )

  LiteralRegistry.register(
    :class => ShortAttribute,
    :schema_name => XSD::QName.new(NsC_09, "shortAttribute"),
    :schema_element => [
      ["text", "SOAP::SOAPString", [0, 1]]
    ],
    :schema_attribute => {
      XSD::QName.new(nil, "short") => "SOAP::SOAPShort"
    }
  )

  LiteralRegistry.register(
    :class => EchoShortAttribute,
    :schema_name => XSD::QName.new(NsC_09, "echoShortAttribute"),
    :schema_element => [
      ["shortAttribute", "ShortAttribute"]
    ]
  )

  LiteralRegistry.register(
    :class => EchoByteElement,
    :schema_name => XSD::QName.new(NsC_09, "echoByteElement"),
    :schema_element => [
      ["byteElement", "SOAP::SOAPByte"]
    ]
  )

  LiteralRegistry.register(
    :class => ByteAttribute,
    :schema_name => XSD::QName.new(NsC_09, "byteAttribute"),
    :schema_element => [
      ["text", "SOAP::SOAPString", [0, 1]]
    ],
    :schema_attribute => {
      XSD::QName.new(nil, "byte") => "SOAP::SOAPByte"
    }
  )

  LiteralRegistry.register(
    :class => EchoByteAttribute,
    :schema_name => XSD::QName.new(NsC_09, "echoByteAttribute"),
    :schema_element => [
      ["byteAttribute", "ByteAttribute"]
    ]
  )

  LiteralRegistry.register(
    :class => EchoNonNegativeIntegerElement,
    :schema_name => XSD::QName.new(NsC_09, "echoNonNegativeIntegerElement"),
    :schema_element => [
      ["nonNegativeIntegerElement", "SOAP::SOAPNonNegativeInteger"]
    ]
  )

  LiteralRegistry.register(
    :class => NonNegativeIntegerAttribute,
    :schema_name => XSD::QName.new(NsC_09, "nonNegativeIntegerAttribute"),
    :schema_element => [
      ["text", "SOAP::SOAPString", [0, 1]]
    ],
    :schema_attribute => {
      XSD::QName.new(nil, "nonNegativeInteger") => "SOAP::SOAPNonNegativeInteger"
    }
  )

  LiteralRegistry.register(
    :class => EchoNonNegativeIntegerAttribute,
    :schema_name => XSD::QName.new(NsC_09, "echoNonNegativeIntegerAttribute"),
    :schema_element => [
      ["nonNegativeIntegerAttribute", "NonNegativeIntegerAttribute"]
    ]
  )

  LiteralRegistry.register(
    :class => EchoUnsignedLongElement,
    :schema_name => XSD::QName.new(NsC_09, "echoUnsignedLongElement"),
    :schema_element => [
      ["unsignedLongElement", "SOAP::SOAPUnsignedLong"]
    ]
  )

  LiteralRegistry.register(
    :class => UnsignedLongAttribute,
    :schema_name => XSD::QName.new(NsC_09, "unsignedLongAttribute"),
    :schema_element => [
      ["text", "SOAP::SOAPString", [0, 1]]
    ],
    :schema_attribute => {
      XSD::QName.new(nil, "unsignedLong") => "SOAP::SOAPUnsignedLong"
    }
  )

  LiteralRegistry.register(
    :class => EchoUnsignedLongAttribute,
    :schema_name => XSD::QName.new(NsC_09, "echoUnsignedLongAttribute"),
    :schema_element => [
      ["unsignedLongAttribute", "UnsignedLongAttribute"]
    ]
  )

  LiteralRegistry.register(
    :class => EchoUnsignedIntElement,
    :schema_name => XSD::QName.new(NsC_09, "echoUnsignedIntElement"),
    :schema_element => [
      ["unsignedIntElement", "SOAP::SOAPUnsignedInt"]
    ]
  )

  LiteralRegistry.register(
    :class => UnsignedIntAttribute,
    :schema_name => XSD::QName.new(NsC_09, "unsignedIntAttribute"),
    :schema_element => [
      ["text", "SOAP::SOAPString", [0, 1]]
    ],
    :schema_attribute => {
      XSD::QName.new(nil, "unsignedInt") => "SOAP::SOAPUnsignedInt"
    }
  )

  LiteralRegistry.register(
    :class => EchoUnsignedIntAttribute,
    :schema_name => XSD::QName.new(NsC_09, "echoUnsignedIntAttribute"),
    :schema_element => [
      ["unsignedIntAttribute", "UnsignedIntAttribute"]
    ]
  )

  LiteralRegistry.register(
    :class => EchoUnsignedShortElement,
    :schema_name => XSD::QName.new(NsC_09, "echoUnsignedShortElement"),
    :schema_element => [
      ["unsignedShortElement", "SOAP::SOAPUnsignedShort"]
    ]
  )

  LiteralRegistry.register(
    :class => UnsignedShortAttribute,
    :schema_name => XSD::QName.new(NsC_09, "unsignedShortAttribute"),
    :schema_element => [
      ["text", "SOAP::SOAPString", [0, 1]]
    ],
    :schema_attribute => {
      XSD::QName.new(nil, "unsignedShort") => "SOAP::SOAPUnsignedShort"
    }
  )

  LiteralRegistry.register(
    :class => EchoUnsignedShortAttribute,
    :schema_name => XSD::QName.new(NsC_09, "echoUnsignedShortAttribute"),
    :schema_element => [
      ["unsignedShortAttribute", "UnsignedShortAttribute"]
    ]
  )

  LiteralRegistry.register(
    :class => NegativeIntegerAttribute,
    :schema_name => XSD::QName.new(NsC_09, "negativeIntegerAttribute"),
    :schema_element => [
      ["text", "SOAP::SOAPString", [0, 1]]
    ],
    :schema_attribute => {
      XSD::QName.new(nil, "negativeInteger") => "SOAP::SOAPNegativeInteger"
    }
  )

  LiteralRegistry.register(
    :class => EchoNegativeIntegerAttribute,
    :schema_name => XSD::QName.new(NsC_09, "echoNegativeIntegerAttribute"),
    :schema_element => [
      ["negativeIntegerAttribute", "NegativeIntegerAttribute"]
    ]
  )

  LiteralRegistry.register(
    :class => EchoUnsignedByteElement,
    :schema_name => XSD::QName.new(NsC_09, "echoUnsignedByteElement"),
    :schema_element => [
      ["unsignedByteElement", "SOAP::SOAPUnsignedByte"]
    ]
  )

  LiteralRegistry.register(
    :class => UnsignedByteAttribute,
    :schema_name => XSD::QName.new(NsC_09, "unsignedByteAttribute"),
    :schema_element => [
      ["text", "SOAP::SOAPString", [0, 1]]
    ],
    :schema_attribute => {
      XSD::QName.new(nil, "unsignedByte") => "SOAP::SOAPUnsignedByte"
    }
  )

  LiteralRegistry.register(
    :class => EchoUnsignedByteAttribute,
    :schema_name => XSD::QName.new(NsC_09, "echoUnsignedByteAttribute"),
    :schema_element => [
      ["unsignedByteAttribute", "UnsignedByteAttribute"]
    ]
  )

  LiteralRegistry.register(
    :class => EchoPositiveIntegerElement,
    :schema_name => XSD::QName.new(NsC_09, "echoPositiveIntegerElement"),
    :schema_element => [
      ["positiveIntegerElement", "SOAP::SOAPPositiveInteger"]
    ]
  )

  LiteralRegistry.register(
    :class => PositiveIntegerAttribute,
    :schema_name => XSD::QName.new(NsC_09, "positiveIntegerAttribute"),
    :schema_element => [
      ["text", "SOAP::SOAPString", [0, 1]]
    ],
    :schema_attribute => {
      XSD::QName.new(nil, "positiveInteger") => "SOAP::SOAPPositiveInteger"
    }
  )

  LiteralRegistry.register(
    :class => EchoPositiveIntegerAttribute,
    :schema_name => XSD::QName.new(NsC_09, "echoPositiveIntegerAttribute"),
    :schema_element => [
      ["positiveIntegerAttribute", "PositiveIntegerAttribute"]
    ]
  )

  LiteralRegistry.register(
    :class => GlobalSimpleType,
    :schema_name => XSD::QName.new(NsC_09, "globalSimpleType")
  )

  LiteralRegistry.register(
    :class => EchoGlobalSimpleType,
    :schema_name => XSD::QName.new(NsC_09, "echoGlobalSimpleType"),
    :schema_element => [
      ["globalSimpleType", "GlobalSimpleType"]
    ]
  )

  LiteralRegistry.register(
    :class => Beatle,
    :schema_name => XSD::QName.new(NsC_09, "beatle")
  )

  LiteralRegistry.register(
    :class => EchoStringEnumerationType,
    :schema_name => XSD::QName.new(NsC_09, "echoStringEnumerationType"),
    :schema_element => [
      ["beatle", "Beatle"]
    ]
  )

  LiteralRegistry.register(
    :class => NMTOKENEnumerationType,
    :schema_name => XSD::QName.new(NsC_09, "nMTOKENEnumerationType")
  )

  LiteralRegistry.register(
    :class => EchoNMTOKENEnumerationType,
    :schema_name => XSD::QName.new(NsC_09, "echoNMTOKENEnumerationType"),
    :schema_element => [
      ["nMTOKENEnumerationType", "NMTOKENEnumerationType"]
    ]
  )

  LiteralRegistry.register(
    :class => IntEnumerationType,
    :schema_name => XSD::QName.new(NsC_09, "intEnumerationType")
  )

  LiteralRegistry.register(
    :class => EchoIntEnumerationType,
    :schema_name => XSD::QName.new(NsC_09, "echoIntEnumerationType"),
    :schema_element => [
      ["intEnumerationType", "IntEnumerationType"]
    ]
  )

  LiteralRegistry.register(
    :class => ShortEnumerationType,
    :schema_name => XSD::QName.new(NsC_09, "shortEnumerationType")
  )

  LiteralRegistry.register(
    :class => EchoShortEnumerationType,
    :schema_name => XSD::QName.new(NsC_09, "echoShortEnumerationType"),
    :schema_element => [
      ["shortEnumerationType", "ShortEnumerationType"]
    ]
  )

  LiteralRegistry.register(
    :class => LongEnumerationType,
    :schema_name => XSD::QName.new(NsC_09, "longEnumerationType")
  )

  LiteralRegistry.register(
    :class => EchoLongEnumerationType,
    :schema_name => XSD::QName.new(NsC_09, "echoLongEnumerationType"),
    :schema_element => [
      ["longEnumerationType", "LongEnumerationType"]
    ]
  )

  LiteralRegistry.register(
    :class => DoubleEnumerationType,
    :schema_name => XSD::QName.new(NsC_09, "doubleEnumerationType")
  )

  LiteralRegistry.register(
    :class => EchoDoubleEnumerationType,
    :schema_name => XSD::QName.new(NsC_09, "echoDoubleEnumerationType"),
    :schema_element => [
      ["doubleEnumerationType", "DoubleEnumerationType"]
    ]
  )

  LiteralRegistry.register(
    :class => IntegerEnumerationType,
    :schema_name => XSD::QName.new(NsC_09, "integerEnumerationType")
  )

  LiteralRegistry.register(
    :class => EchoIntegerEnumerationType,
    :schema_name => XSD::QName.new(NsC_09, "echoIntegerEnumerationType"),
    :schema_element => [
      ["integerEnumerationType", "IntegerEnumerationType"]
    ]
  )

  LiteralRegistry.register(
    :class => DecimalEnumerationType,
    :schema_name => XSD::QName.new(NsC_09, "decimalEnumerationType")
  )

  LiteralRegistry.register(
    :class => EchoDecimalEnumerationType,
    :schema_name => XSD::QName.new(NsC_09, "echoDecimalEnumerationType"),
    :schema_element => [
      ["decimalEnumerationType", "DecimalEnumerationType"]
    ]
  )

  LiteralRegistry.register(
    :class => FloatEnumerationType,
    :schema_name => XSD::QName.new(NsC_09, "floatEnumerationType")
  )

  LiteralRegistry.register(
    :class => EchoFloatEnumerationType,
    :schema_name => XSD::QName.new(NsC_09, "echoFloatEnumerationType"),
    :schema_element => [
      ["floatEnumerationType", "FloatEnumerationType"]
    ]
  )

  LiteralRegistry.register(
    :class => NonNegativeIntegerEnumerationType,
    :schema_name => XSD::QName.new(NsC_09, "nonNegativeIntegerEnumerationType")
  )

  LiteralRegistry.register(
    :class => EchoNonNegativeIntegerEnumerationType,
    :schema_name => XSD::QName.new(NsC_09, "echoNonNegativeIntegerEnumerationType"),
    :schema_element => [
      ["nonNegativeIntegerEnumerationType", "NonNegativeIntegerEnumerationType"]
    ]
  )

  LiteralRegistry.register(
    :class => PositiveIntegerEnumerationType,
    :schema_name => XSD::QName.new(NsC_09, "positiveIntegerEnumerationType")
  )

  LiteralRegistry.register(
    :class => EchoPositiveIntegerEnumerationType,
    :schema_name => XSD::QName.new(NsC_09, "echoPositiveIntegerEnumerationType"),
    :schema_element => [
      ["positiveIntegerEnumerationType", "PositiveIntegerEnumerationType"]
    ]
  )

  LiteralRegistry.register(
    :class => UnsignedLongEnumerationType,
    :schema_name => XSD::QName.new(NsC_09, "unsignedLongEnumerationType")
  )

  LiteralRegistry.register(
    :class => EchoUnsignedLongEnumerationType,
    :schema_name => XSD::QName.new(NsC_09, "echoUnsignedLongEnumerationType"),
    :schema_element => [
      ["unsignedLongEnumerationType", "UnsignedLongEnumerationType"]
    ]
  )

  LiteralRegistry.register(
    :class => UnsignedIntEnumerationType,
    :schema_name => XSD::QName.new(NsC_09, "unsignedIntEnumerationType")
  )

  LiteralRegistry.register(
    :class => EchoUnsignedIntEnumerationType,
    :schema_name => XSD::QName.new(NsC_09, "echoUnsignedIntEnumerationType"),
    :schema_element => [
      ["unsignedIntEnumerationType", "UnsignedIntEnumerationType"]
    ]
  )

  LiteralRegistry.register(
    :class => UnsignedShortEnumerationType,
    :schema_name => XSD::QName.new(NsC_09, "unsignedShortEnumerationType")
  )

  LiteralRegistry.register(
    :class => EchoUnsignedShortEnumerationType,
    :schema_name => XSD::QName.new(NsC_09, "echoUnsignedShortEnumerationType"),
    :schema_element => [
      ["unsignedShortEnumerationType", "UnsignedShortEnumerationType"]
    ]
  )

  LiteralRegistry.register(
    :class => TokenEnumerationType,
    :schema_name => XSD::QName.new(NsC_09, "tokenEnumerationType")
  )

  LiteralRegistry.register(
    :class => EchoTokenEnumerationType,
    :schema_name => XSD::QName.new(NsC_09, "echoTokenEnumerationType"),
    :schema_element => [
      ["tokenEnumerationType", "TokenEnumerationType"]
    ]
  )

  LiteralRegistry.register(
    :class => ComplexTypeSequence,
    :schema_name => XSD::QName.new(NsC_09, "complexTypeSequence"),
    :schema_element => [
      ["name", "SOAP::SOAPString"],
      ["shade", "SOAP::SOAPString"],
      ["length", "SOAP::SOAPInt"]
    ],
    :schema_attribute => {
      XSD::QName.new(nil, "id") => "SOAP::SOAPString",
      XSD::QName.new(nil, "inStock") => "SOAP::SOAPInt"
    }
  )

  LiteralRegistry.register(
    :class => EchoComplexTypeSequence,
    :schema_name => XSD::QName.new(NsC_09, "echoComplexTypeSequence"),
    :schema_element => [
      ["complexTypeSequence", "ComplexTypeSequence"]
    ]
  )

  LiteralRegistry.register(
    :class => ComplexTypeAll,
    :schema_name => XSD::QName.new(NsC_09, "complexTypeAll"),
    :schema_element => [
      ["name", "SOAP::SOAPString"],
      ["shade", "SOAP::SOAPString"],
      ["length", "SOAP::SOAPInt"]
    ],
    :schema_attribute => {
      XSD::QName.new(nil, "id") => "SOAP::SOAPString",
      XSD::QName.new(nil, "inStock") => "SOAP::SOAPInt"
    }
  )

  LiteralRegistry.register(
    :class => EchoComplexTypeAll,
    :schema_name => XSD::QName.new(NsC_09, "echoComplexTypeAll"),
    :schema_element => [
      ["complexTypeAll", "ComplexTypeAll"]
    ]
  )

  LiteralRegistry.register(
    :class => Fruit,
    :schema_name => XSD::QName.new(NsC_09, "fruit"),
    :schema_element => [ :choice,
      ["apple", "SOAP::SOAPInt"],
      ["orange", "SOAP::SOAPString"],
      ["banana", "SOAP::SOAPInt"]
    ]
  )

  LiteralRegistry.register(
    :class => EchoComplexTypeChoice,
    :schema_name => XSD::QName.new(NsC_09, "echoComplexTypeChoice"),
    :schema_element => [
      ["fruit", "Fruit"]
    ]
  )

  LiteralRegistry.register(
    :class => Mortgage,
    :schema_name => XSD::QName.new(NsC_09, "mortgage"),
    :schema_element => [
      ["amount", "SOAP::SOAPInt"],
      [ :choice,
        ["repayment", "Repayment"],
        ["interestonly", "InterestOnly"]
      ]
    ]
  )

  LiteralRegistry.register(
    :class => EchoComplexTypeSequenceChoice,
    :schema_name => XSD::QName.new(NsC_09, "echoComplexTypeSequenceChoice"),
    :schema_element => [
      ["mortgage", "Mortgage"]
    ]
  )

  LiteralRegistry.register(
    :class => ElementMinOccurs1,
    :schema_name => XSD::QName.new(NsC_09, "elementMinOccurs1"),
    :schema_element => [
      ["elementMinOccurs1item", "SOAP::SOAPString"]
    ]
  )

  LiteralRegistry.register(
    :class => EchoElementMinOccurs1,
    :schema_name => XSD::QName.new(NsC_09, "echoElementMinOccurs1"),
    :schema_element => [
      ["elementMinOccurs1", "ElementMinOccurs1"]
    ]
  )

  LiteralRegistry.register(
    :class => ItemColors2,
    :schema_name => XSD::QName.new(NsC_09, "itemColors2"),
    :schema_element => [
      ["itemColor", "SOAP::SOAPString[]", [2, 2]]
    ]
  )

  LiteralRegistry.register(
    :class => EchoElementMinOccurs2MaxOccurs2,
    :schema_name => XSD::QName.new(NsC_09, "echoElementMinOccurs2MaxOccurs2"),
    :schema_element => [
      ["itemColors2", "ItemColors2"]
    ]
  )

  LiteralRegistry.register(
    :class => ItemColors,
    :schema_name => XSD::QName.new(NsC_09, "itemColors"),
    :schema_element => [
      ["itemColor", "SOAP::SOAPString[]", [2, nil]]
    ]
  )

  LiteralRegistry.register(
    :class => EchoElementMinOccurs2orMore,
    :schema_name => XSD::QName.new(NsC_09, "echoElementMinOccurs2orMore"),
    :schema_element => [
      ["itemColors", "ItemColors"]
    ]
  )

  LiteralRegistry.register(
    :class => ElementMaxOccurs1,
    :schema_name => XSD::QName.new(NsC_09, "elementMaxOccurs1"),
    :schema_element => [
      ["value", "SOAP::SOAPString"]
    ]
  )

  LiteralRegistry.register(
    :class => EchoElementMaxOccurs1,
    :schema_name => XSD::QName.new(NsC_09, "echoElementMaxOccurs1"),
    :schema_element => [
      ["elementMaxOccurs1", "ElementMaxOccurs1"]
    ]
  )

  LiteralRegistry.register(
    :class => Publications,
    :schema_name => XSD::QName.new(NsC_09, "publications"),
    :schema_element => [
      ["day", "SOAP::SOAPString[]", [1, nil]]
    ]
  )

  LiteralRegistry.register(
    :class => EchoElementMaxOccursUnbounded,
    :schema_name => XSD::QName.new(NsC_09, "echoElementMaxOccursUnbounded"),
    :schema_element => [
      ["publications", "Publications"]
    ]
  )

  LiteralRegistry.register(
    :class => Summer,
    :schema_name => XSD::QName.new(NsC_09, "summer"),
    :schema_element => [
      ["mnth", "SOAP::SOAPString[]", [1, 4]]
    ]
  )

  LiteralRegistry.register(
    :class => EchoElementMaxOccursFinite,
    :schema_name => XSD::QName.new(NsC_09, "echoElementMaxOccursFinite"),
    :schema_element => [
      ["summer", "Summer"]
    ]
  )

  LiteralRegistry.register(
    :class => Premium,
    :schema_name => XSD::QName.new(NsC_09, "premium"),
    :schema_element => [
      ["amount", "SOAP::SOAPString"]
    ],
    :schema_attribute => {
      XSD::QName.new(nil, "id") => "SOAP::SOAPString",
      XSD::QName.new(nil, "currency") => "SOAP::SOAPString"
    }
  )

  LiteralRegistry.register(
    :class => EchoAttributeOptional,
    :schema_name => XSD::QName.new(NsC_09, "echoAttributeOptional"),
    :schema_element => [
      ["premium", "Premium"]
    ]
  )

  LiteralRegistry.register(
    :class => Discount,
    :schema_name => XSD::QName.new(NsC_09, "discount"),
    :schema_element => [
      ["percentage", "SOAP::SOAPInt"]
    ],
    :schema_attribute => {
      XSD::QName.new(nil, "id") => "SOAP::SOAPString",
      XSD::QName.new(nil, "seasonal") => "SOAP::SOAPBoolean"
    }
  )

  LiteralRegistry.register(
    :class => EchoAttributeRequired,
    :schema_name => XSD::QName.new(NsC_09, "echoAttributeRequired"),
    :schema_element => [
      ["discount", "Discount"]
    ]
  )

  LiteralRegistry.register(
    :class => Survey,
    :schema_name => XSD::QName.new(NsC_09, "survey"),
    :schema_element => [
      ["fee", "SOAP::SOAPInt"]
    ],
    :schema_attribute => {
      XSD::QName.new(nil, "id") => "SOAP::SOAPString",
      XSD::QName.new(nil, "currency") => "SOAP::SOAPString"
    }
  )

  LiteralRegistry.register(
    :class => EchoAttributeFixed,
    :schema_name => XSD::QName.new(NsC_09, "echoAttributeFixed"),
    :schema_element => [
      ["survey", "Survey"]
    ]
  )

  LiteralRegistry.register(
    :class => ElementMinOccurs0,
    :schema_name => XSD::QName.new(NsC_09, "elementMinOccurs0"),
    :schema_element => [
      ["firstName", "SOAP::SOAPString"],
      ["middleName", "SOAP::SOAPString", [0, 1]],
      ["lastName", "SOAP::SOAPString"]
    ]
  )

  LiteralRegistry.register(
    :class => EchoElementMinOccurs0,
    :schema_name => XSD::QName.new(NsC_09, "echoElementMinOccurs0"),
    :schema_element => [
      ["elementMinOccurs0", "ElementMinOccurs0"]
    ]
  )

  LiteralRegistry.register(
    :class => NillableMiddleName,
    :schema_name => XSD::QName.new(NsC_09, "nillableMiddleName"),
    :schema_element => [
      ["firstName", "SOAP::SOAPString"],
      ["middleName", "SOAP::SOAPString"],
      ["lastName", "SOAP::SOAPString"]
    ]
  )

  LiteralRegistry.register(
    :class => EchoNillableElement,
    :schema_name => XSD::QName.new(NsC_09, "echoNillableElement"),
    :schema_element => [
      ["nillableMiddleName", "NillableMiddleName"]
    ]
  )

  LiteralRegistry.register(
    :class => NillableOptionalMiddleName,
    :schema_name => XSD::QName.new(NsC_09, "nillableOptionalMiddleName"),
    :schema_element => [
      ["firstName", "SOAP::SOAPString"],
      ["middleName", "SOAP::SOAPString", [0, 1]],
      ["lastName", "SOAP::SOAPString"]
    ]
  )

  LiteralRegistry.register(
    :class => EchoNillableOptionalElement,
    :schema_name => XSD::QName.new(NsC_09, "echoNillableOptionalElement"),
    :schema_element => [
      ["nillableOptionalMiddleName", "NillableOptionalMiddleName"]
    ]
  )

  LiteralRegistry.register(
    :class => EchoUnionMemberTypes,
    :schema_name => XSD::QName.new(NsC_09, "echoUnionMemberTypes"),
    :schema_element => [
      ["unionMemberTypes", nil]
    ]
  )

  LiteralRegistry.register(
    :class => NullEnumerationType,
    :schema_name => XSD::QName.new(NsC_09, "nullEnumerationType")
  )

  LiteralRegistry.register(
    :class => EchoNullEnumerationType,
    :schema_name => XSD::QName.new(NsC_09, "echoNullEnumerationType"),
    :schema_element => [
      ["nullEnumerationType", "NullEnumerationType"]
    ]
  )

  LiteralRegistry.register(
    :class => ElementEmptyComplexType,
    :schema_name => XSD::QName.new(NsC_09, "elementEmptyComplexType"),
    :schema_element => []
  )

  LiteralRegistry.register(
    :class => EchoElementEmptyComplexType,
    :schema_name => XSD::QName.new(NsC_09, "echoElementEmptyComplexType"),
    :schema_element => [
      ["elementEmptyComplexType", "ElementEmptyComplexType"]
    ]
  )

  LiteralRegistry.register(
    :class => ElementEmptySequence,
    :schema_name => XSD::QName.new(NsC_09, "elementEmptySequence"),
    :schema_element => []
  )

  LiteralRegistry.register(
    :class => EchoElementEmptySequence,
    :schema_name => XSD::QName.new(NsC_09, "echoElementEmptySequence"),
    :schema_element => [
      ["elementEmptySequence", "ElementEmptySequence"]
    ]
  )

  LiteralRegistry.register(
    :class => GlobalElementSequence,
    :schema_name => XSD::QName.new(NsC_09, "globalElementSequence"),
    :schema_element => [
      ["foo", "SOAP::SOAPString"],
      ["bar", "SOAP::SOAPString"]
    ]
  )

  LiteralRegistry.register(
    :class => EchoGlobalElementSequence,
    :schema_name => XSD::QName.new(NsC_09, "echoGlobalElementSequence"),
    :schema_element => [
      ["globalElementSequence", "GlobalElementSequence"]
    ]
  )

  LiteralRegistry.register(
    :class => SequenceElementList,
    :schema_name => XSD::QName.new(NsC_09, "sequenceElementList"),
    :schema_element => [
      ["item", "SOAP::SOAPString[]", [0, nil]]
    ]
  )

  LiteralRegistry.register(
    :class => EchoSequenceElementList,
    :schema_name => XSD::QName.new(NsC_09, "echoSequenceElementList"),
    :schema_element => [
      ["sequenceElementList", "SequenceElementList"]
    ]
  )

  LiteralRegistry.register(
    :class => NestedSequenceElementList,
    :schema_name => XSD::QName.new(NsC_09, "nestedSequenceElementList"),
    :schema_element => [
      ["nestedItem", "NestedItem[]", [0, nil]]
    ]
  )

  LiteralRegistry.register(
    :class => EchoNestedSequenceElementList,
    :schema_name => XSD::QName.new(NsC_09, "echoNestedSequenceElementList"),
    :schema_element => [
      ["nestedSequenceElementList", "NestedSequenceElementList"]
    ]
  )

  LiteralRegistry.register(
    :class => MixedContentType,
    :schema_name => XSD::QName.new(NsC_09, "mixedContentType"),
    :schema_element => [
      ["elem1", "SOAP::SOAPString"],
      ["elem2", "SOAP::SOAPString"]
    ]
  )

  LiteralRegistry.register(
    :class => EchoMixedContentType,
    :schema_name => XSD::QName.new(NsC_09, "echoMixedContentType"),
    :schema_element => [
      ["mixedContentType", "MixedContentType"]
    ]
  )

  LiteralRegistry.register(
    :class => EchoStringSimpleTypePattern,
    :schema_name => XSD::QName.new(NsC_09, "echoStringSimpleTypePattern"),
    :schema_element => [
      ["stringSimpleTypePattern", nil]
    ]
  )

  LiteralRegistry.register(
    :class => EchoIntSimpleTypePattern,
    :schema_name => XSD::QName.new(NsC_09, "echoIntSimpleTypePattern"),
    :schema_element => [
      ["intSimpleTypePattern", nil]
    ]
  )

  LiteralRegistry.register(
    :class => EchoIntegerSimpleTypePattern,
    :schema_name => XSD::QName.new(NsC_09, "echoIntegerSimpleTypePattern"),
    :schema_element => [
      ["integerSimpleTypePattern", nil]
    ]
  )

  LiteralRegistry.register(
    :class => EchoLongSimpleTypePattern,
    :schema_name => XSD::QName.new(NsC_09, "echoLongSimpleTypePattern"),
    :schema_element => [
      ["longSimpleTypePattern", nil]
    ]
  )

  LiteralRegistry.register(
    :class => EchoDecimalSimpleTypePattern,
    :schema_name => XSD::QName.new(NsC_09, "echoDecimalSimpleTypePattern"),
    :schema_element => [
      ["decimalSimpleTypePattern", nil]
    ]
  )

  LiteralRegistry.register(
    :class => EchoFloatSimpleTypePattern,
    :schema_name => XSD::QName.new(NsC_09, "echoFloatSimpleTypePattern"),
    :schema_element => [
      ["floatSimpleTypePattern", nil]
    ]
  )

  LiteralRegistry.register(
    :class => EchoDoubleSimpleTypePattern,
    :schema_name => XSD::QName.new(NsC_09, "echoDoubleSimpleTypePattern"),
    :schema_element => [
      ["doubleSimpleTypePattern", nil]
    ]
  )

  LiteralRegistry.register(
    :class => EchoShortSimpleTypePattern,
    :schema_name => XSD::QName.new(NsC_09, "echoShortSimpleTypePattern"),
    :schema_element => [
      ["shortSimpleTypePattern", nil]
    ]
  )

  LiteralRegistry.register(
    :class => EchoNonNegativeIntegerSimpleTypePattern,
    :schema_name => XSD::QName.new(NsC_09, "echoNonNegativeIntegerSimpleTypePattern"),
    :schema_element => [
      ["nonNegativeIntegerSimpleTypePattern", nil]
    ]
  )

  LiteralRegistry.register(
    :class => EchoPositiveIntegerSimpleTypePattern,
    :schema_name => XSD::QName.new(NsC_09, "echoPositiveIntegerSimpleTypePattern"),
    :schema_element => [
      ["positiveIntegerSimpleTypePattern", nil]
    ]
  )

  LiteralRegistry.register(
    :class => EchoUnsignedLongSimpleTypePattern,
    :schema_name => XSD::QName.new(NsC_09, "echoUnsignedLongSimpleTypePattern"),
    :schema_element => [
      ["unsignedLongSimpleTypePattern", nil]
    ]
  )

  LiteralRegistry.register(
    :class => EchoUnsignedIntSimpleTypePattern,
    :schema_name => XSD::QName.new(NsC_09, "echoUnsignedIntSimpleTypePattern"),
    :schema_element => [
      ["unsignedIntSimpleTypePattern", nil]
    ]
  )

  LiteralRegistry.register(
    :class => EchoUnsignedShortSimpleTypePattern,
    :schema_name => XSD::QName.new(NsC_09, "echoUnsignedShortSimpleTypePattern"),
    :schema_element => [
      ["unsignedShortSimpleTypePattern", nil]
    ]
  )

  LiteralRegistry.register(
    :class => EchoDateSimpleTypePattern,
    :schema_name => XSD::QName.new(NsC_09, "echoDateSimpleTypePattern"),
    :schema_element => [
      ["dateSimpleTypePattern", nil]
    ]
  )

  LiteralRegistry.register(
    :class => EchoRestrictedMinInclusive,
    :schema_name => XSD::QName.new(NsC_09, "echoRestrictedMinInclusive"),
    :schema_element => [
      ["restrictedMinInclusive", nil]
    ]
  )

  LiteralRegistry.register(
    :class => EchoRestrictedMaxInclusive,
    :schema_name => XSD::QName.new(NsC_09, "echoRestrictedMaxInclusive"),
    :schema_element => [
      ["restrictedMaxInclusive", nil]
    ]
  )

  LiteralRegistry.register(
    :class => EchoRestrictedLength,
    :schema_name => XSD::QName.new(NsC_09, "echoRestrictedLength"),
    :schema_element => [
      ["restrictedLength", nil]
    ]
  )

  LiteralRegistry.register(
    :class => EchoRestrictedMaxLength,
    :schema_name => XSD::QName.new(NsC_09, "echoRestrictedMaxLength"),
    :schema_element => [
      ["restrictedMaxLength", nil]
    ]
  )

  LiteralRegistry.register(
    :class => EchoRestrictedMinLength,
    :schema_name => XSD::QName.new(NsC_09, "echoRestrictedMinLength"),
    :schema_element => [
      ["restrictedMinLength", nil]
    ]
  )

  LiteralRegistry.register(
    :class => CustomerName,
    :schema_name => XSD::QName.new(NsC_09, "customerName"),
    :schema_element => [
      ["firstName", "SOAP::SOAPString"],
      ["lastName", "SOAP::SOAPString"]
    ]
  )

  LiteralRegistry.register(
    :class => EchoElementReference,
    :schema_name => XSD::QName.new(NsC_09, "echoElementReference"),
    :schema_element => [
      ["customerName", "CustomerName"]
    ]
  )

  LiteralRegistry.register(
    :class => ClientName,
    :schema_name => XSD::QName.new(NsC_09, "clientName"),
    :schema_element => [
      ["firstName", "SOAP::SOAPString"],
      ["lastName", "SOAP::SOAPString"]
    ],
    :schema_attribute => {
      XSD::QName.new(NsC_09, "phoneNumber") => "SOAP::SOAPString"
    }
  )

  LiteralRegistry.register(
    :class => EchoAttributeReference,
    :schema_name => XSD::QName.new(NsC_09, "echoAttributeReference"),
    :schema_element => [
      ["clientName", "ClientName"]
    ]
  )

  LiteralRegistry.register(
    :class => ClientDetails,
    :schema_name => XSD::QName.new(NsC_09, "clientDetails"),
    :schema_element => [
      ["forename", "SOAP::SOAPString"],
      ["surname", "SOAP::SOAPString"],
      ["title", "SOAP::SOAPString"]
    ],
    :schema_attribute => {
      XSD::QName.new(nil, "phone") => "SOAP::SOAPLong",
      XSD::QName.new(nil, "title") => "SOAP::SOAPBoolean"
    }
  )

  LiteralRegistry.register(
    :class => EchoAttributeElementNameClash,
    :schema_name => XSD::QName.new(NsC_09, "echoAttributeElementNameClash"),
    :schema_element => [
      ["clientDetails", "ClientDetails"]
    ]
  )

  LiteralRegistry.register(
    :class => ExtendedSequenceStrict,
    :schema_name => XSD::QName.new(NsC_09, "extendedSequenceStrict"),
    :schema_element => [
      ["firstName", "SOAP::SOAPString"],
      ["lastName", "SOAP::SOAPString"],
      ["extension", "StrictExtension", [0, 1]]
    ]
  )

  LiteralRegistry.register(
    :class => EchoExtendedSequenceStrict,
    :schema_name => XSD::QName.new(NsC_09, "echoExtendedSequenceStrict"),
    :schema_element => [
      ["extendedSequenceStrict", "ExtendedSequenceStrict"]
    ]
  )

  LiteralRegistry.register(
    :class => ExtendedSequenceLax,
    :schema_name => XSD::QName.new(NsC_09, "extendedSequenceLax"),
    :schema_element => [
      ["firstName", "SOAP::SOAPString"],
      ["lastName", "SOAP::SOAPString"],
      ["extension", "LaxExtension", [0, 1]]
    ]
  )

  LiteralRegistry.register(
    :class => EchoExtendedSequenceLax,
    :schema_name => XSD::QName.new(NsC_09, "echoExtendedSequenceLax"),
    :schema_element => [
      ["extendedSequenceLax", "ExtendedSequenceLax"]
    ]
  )

  LiteralRegistry.register(
    :class => ExtendedSequenceSkip,
    :schema_name => XSD::QName.new(NsC_09, "extendedSequenceSkip"),
    :schema_element => [
      ["firstName", "SOAP::SOAPString"],
      ["lastName", "SOAP::SOAPString"],
      ["extension", "SkipExtension", [0, 1]]
    ]
  )

  LiteralRegistry.register(
    :class => EchoExtendedSequenceSkip,
    :schema_name => XSD::QName.new(NsC_09, "echoExtendedSequenceSkip"),
    :schema_element => [
      ["extendedSequenceSkip", "ExtendedSequenceSkip"]
    ]
  )

  LiteralRegistry.register(
    :class => EchoElementTypeDefaultNamespace,
    :schema_name => XSD::QName.new(NsC_09, "echoElementTypeDefaultNamespace"),
    :schema_element => [
      ["stringElementDefaultNamespace", "SOAP::SOAPString"]
    ]
  )

  LiteralRegistry.register(
    :class => BareVector,
    :schema_name => XSD::QName.new(NsC_09, "bareVector"),
    :schema_element => [
      ["item1", "SOAP::SOAPString[]", [0, nil]],
      ["item2", "SOAP::SOAPString[]", [0, nil]],
      ["item3", "SOAP::SOAPString[]", [0, nil]]
    ]
  )

  LiteralRegistry.register(
    :class => EchoBareVector,
    :schema_name => XSD::QName.new(NsC_09, "echoBareVector"),
    :schema_element => [
      ["bareVector", "BareVector"]
    ]
  )

  LiteralRegistry.register(
    :class => ComplexTypeSequenceExtension,
    :schema_name => XSD::QName.new(NsC_09, "complexTypeSequenceExtension"),
    :schema_element => [
      ["name", "SOAP::SOAPString"],
      ["description", "SOAP::SOAPString"]
    ]
  )

  LiteralRegistry.register(
    :class => EchoComplexTypeSequenceExtension,
    :schema_name => XSD::QName.new(NsC_09, "echoComplexTypeSequenceExtension"),
    :schema_element => [
      ["complexTypeSequenceExtension", "ComplexTypeSequenceExtension"]
    ]
  )

  LiteralRegistry.register(
    :class => Assembly,
    :schema_name => XSD::QName.new(NsC_09, "assembly"),
    :schema_element => [
      ["part", "Part[]", [0, nil]]
    ]
  )

  LiteralRegistry.register(
    :class => Part,
    :schema_name => XSD::QName.new(NsC_09, "part"),
    :schema_element => [
      ["number", "SOAP::SOAPString"]
    ]
  )

  LiteralRegistry.register(
    :class => EchoTypeSubstitutionUsingXsiType,
    :schema_name => XSD::QName.new(NsC_09, "echoTypeSubstitutionUsingXsiType"),
    :schema_element => [
      ["assembly", "Assembly"]
    ]
  )

  LiteralRegistry.register(
    :class => SimpleTypeAttributes,
    :schema_name => XSD::QName.new(NsC_09, "simpleTypeAttributes"),
    :schema_attribute => {
      XSD::QName.new(nil, "a1") => "SOAP::SOAPString",
      XSD::QName.new(nil, "a2") => "SOAP::SOAPString"
    }
  )

  LiteralRegistry.register(
    :class => EchoSimpleTypeAttributes,
    :schema_name => XSD::QName.new(NsC_09, "echoSimpleTypeAttributes"),
    :schema_element => [
      ["simpleTypeAttributes", "SimpleTypeAttributes"]
    ]
  )

  LiteralRegistry.register(
    :class => ExtendedSimpleType,
    :schema_name => XSD::QName.new(NsC_09, "extendedSimpleType")
  )

  LiteralRegistry.register(
    :class => EchoExtendedSimpleType,
    :schema_name => XSD::QName.new(NsC_09, "echoExtendedSimpleType"),
    :schema_element => [
      ["extendedSimpleType", "ExtendedSimpleType"]
    ]
  )

  LiteralRegistry.register(
    :class => SequenceMinOccurs1,
    :schema_name => XSD::QName.new(NsC_09, "sequenceMinOccurs1"),
    :schema_element => [
      ["sequenceMinOccurs1item", "SOAP::SOAPString"]
    ]
  )

  LiteralRegistry.register(
    :class => EchoSequenceMinOccurs1,
    :schema_name => XSD::QName.new(NsC_09, "echoSequenceMinOccurs1"),
    :schema_element => [
      ["sequenceMinOccurs1", "SequenceMinOccurs1"]
    ]
  )

  LiteralRegistry.register(
    :class => ArticleColors,
    :schema_name => XSD::QName.new(NsC_09, "articleColors"),
    :schema_element => [
      ["articleColor", "SOAP::SOAPString[]"],
      ["articleContrast", "SOAP::SOAPString[]"]
    ]
  )

  LiteralRegistry.register(
    :class => EchoSequenceMinOccursFinite,
    :schema_name => XSD::QName.new(NsC_09, "echoSequenceMinOccursFinite"),
    :schema_element => [
      ["articleColors", "ArticleColors"]
    ]
  )

  LiteralRegistry.register(
    :class => MyAgeDetails,
    :schema_name => XSD::QName.new(NsC_09, "myAgeDetails"),
    :schema_element => [
      ["myAge", "SOAP::SOAPShort"]
    ]
  )

  LiteralRegistry.register(
    :class => EchoSequenceMaxOccurs1,
    :schema_name => XSD::QName.new(NsC_09, "echoSequenceMaxOccurs1"),
    :schema_element => [
      ["myAgeDetails", "MyAgeDetails"]
    ]
  )

  LiteralRegistry.register(
    :class => DurationList,
    :schema_name => XSD::QName.new(NsC_09, "durationList"),
    :schema_element => [
      ["durationValue", "SOAP::SOAPShort[]", [0, nil]]
    ]
  )

  LiteralRegistry.register(
    :class => EchoElementMinOccurs0MaxOccursUnbounded,
    :schema_name => XSD::QName.new(NsC_09, "echoElementMinOccurs0MaxOccursUnbounded"),
    :schema_element => [
      ["durationList", "DurationList"]
    ]
  )

  LiteralRegistry.register(
    :class => DurationListSequence,
    :schema_name => XSD::QName.new(NsC_09, "durationListSequence"),
    :schema_element => [
      ["durationVal", "SOAP::SOAPString[]"],
      ["durationPercentage", "SOAP::SOAPString[]"]
    ]
  )

  LiteralRegistry.register(
    :class => EchoSequenceMinOccurs0MaxOccursUnbounded,
    :schema_name => XSD::QName.new(NsC_09, "echoSequenceMinOccurs0MaxOccursUnbounded"),
    :schema_element => [
      ["durationListSequence", "DurationListSequence"]
    ]
  )

  LiteralRegistry.register(
    :class => AgeList,
    :schema_name => XSD::QName.new(NsC_09, "ageList"),
    :schema_element => [
      ["ageValue", "SOAP::SOAPShort[]", [1, nil]]
    ]
  )

  LiteralRegistry.register(
    :class => EchoElementMinOccurs1MaxOccursUnbounded,
    :schema_name => XSD::QName.new(NsC_09, "echoElementMinOccurs1MaxOccursUnbounded"),
    :schema_element => [
      ["ageList", "AgeList"]
    ]
  )

  LiteralRegistry.register(
    :class => AgeListSequence,
    :schema_name => XSD::QName.new(NsC_09, "ageListSequence"),
    :schema_element => [
      ["ageVal", "SOAP::SOAPString[]"],
      ["agePercentage", "SOAP::SOAPString[]"]
    ]
  )

  LiteralRegistry.register(
    :class => EchoSequenceMinOccurs1MaxOccursUnbounded,
    :schema_name => XSD::QName.new(NsC_09, "echoSequenceMinOccurs1MaxOccursUnbounded"),
    :schema_element => [
      ["ageListSequence", "AgeListSequence"]
    ]
  )

  LiteralRegistry.register(
    :class => BookPublications,
    :schema_name => XSD::QName.new(NsC_09, "bookPublications"),
    :schema_element => [
      ["pubDate", "SOAP::SOAPString[]"],
      ["pubISBN", "SOAP::SOAPString[]"]
    ]
  )

  LiteralRegistry.register(
    :class => EchoSequenceMaxOccursUnbounded,
    :schema_name => XSD::QName.new(NsC_09, "echoSequenceMaxOccursUnbounded"),
    :schema_element => [
      ["bookPublications", "BookPublications"]
    ]
  )

  LiteralRegistry.register(
    :class => Winter,
    :schema_name => XSD::QName.new(NsC_09, "winter"),
    :schema_element => [
      ["mnth", "SOAP::SOAPString[]"],
      ["weather", "SOAP::SOAPString[]"]
    ]
  )

  LiteralRegistry.register(
    :class => EchoSequenceMaxOccursFinite,
    :schema_name => XSD::QName.new(NsC_09, "echoSequenceMaxOccursFinite"),
    :schema_element => [
      ["winter", "Winter"]
    ]
  )

  LiteralRegistry.register(
    :class => SequenceMinOccurs0,
    :schema_name => XSD::QName.new(NsC_09, "sequenceMinOccurs0"),
    :schema_element => [
      ["firstName", "SOAP::SOAPString"],
      ["middleName", "SOAP::SOAPString"],
      ["lastName", "SOAP::SOAPString"]
    ]
  )

  LiteralRegistry.register(
    :class => EchoSequenceMinOccurs0,
    :schema_name => XSD::QName.new(NsC_09, "echoSequenceMinOccurs0"),
    :schema_element => [
      ["sequenceMinOccurs0", "SequenceMinOccurs0"]
    ]
  )

  LiteralRegistry.register(
    :class => SequenceSequenceElement,
    :schema_name => XSD::QName.new(NsC_09, "sequenceSequenceElement"),
    :schema_element => [
      ["firstName", "SOAP::SOAPString"],
      [
        ["middleName", "SOAP::SOAPString"],
        [
          ["lastName", "SOAP::SOAPString"]
        ]
      ]
    ]
  )

  LiteralRegistry.register(
    :class => EchoSequenceSequenceElement,
    :schema_name => XSD::QName.new(NsC_09, "echoSequenceSequenceElement"),
    :schema_element => [
      ["sequenceSequenceElement", "SequenceSequenceElement"]
    ]
  )

  LiteralRegistry.register(
    :class => EchoDecimalSimpleTypeTotalDigits,
    :schema_name => XSD::QName.new(NsC_09, "echoDecimalSimpleTypeTotalDigits"),
    :schema_element => [
      ["decimalSimpleTypeTotalDigits", nil]
    ]
  )

  LiteralRegistry.register(
    :class => EchoDecimalSimpleTypeFractionDigits,
    :schema_name => XSD::QName.new(NsC_09, "echoDecimalSimpleTypeFractionDigits"),
    :schema_element => [
      ["decimalSimpleTypeFractionDigits", nil]
    ]
  )

  LiteralRegistry.register(
    :class => AttributeTypeReference,
    :schema_name => XSD::QName.new(NsC_09, "attributeTypeReference"),
    :schema_element => [
      ["text", "SOAP::SOAPString", [0, 1]]
    ],
    :schema_attribute => {
      XSD::QName.new(nil, "number") => "SOAP::SOAPDecimal"
    }
  )

  LiteralRegistry.register(
    :class => EchoAttributeTypeReference,
    :schema_name => XSD::QName.new(NsC_09, "echoAttributeTypeReference"),
    :schema_element => [
      ["attributeTypeReference", "AttributeTypeReference"]
    ]
  )

  LiteralRegistry.register(
    :class => ElementTypeReference,
    :schema_name => XSD::QName.new(NsC_09, "elementTypeReference"),
    :schema_element => [
      ["text", "ElementTypeReferenced"]
    ]
  )

  LiteralRegistry.register(
    :class => EchoElementTypeReference,
    :schema_name => XSD::QName.new(NsC_09, "echoElementTypeReference"),
    :schema_element => [
      ["elementTypeReference", "ElementTypeReference"]
    ]
  )

  LiteralRegistry.register(
    :class => LocalElementComplexType,
    :schema_name => XSD::QName.new(NsC_09, "localElementComplexType"),
    :schema_element => [
      ["name", "LocalElementComplexType::Name"]
    ]
  )

  LiteralRegistry.register(
    :class => LocalElementComplexType::Name,
    :schema_name => XSD::QName.new(NsC_09, "name"),
    :is_anonymous => true,
    :schema_qualified => true,
    :schema_element => [
      ["firstName", "SOAP::SOAPString"],
      ["lastName", "SOAP::SOAPString"]
    ]
  )

  LiteralRegistry.register(
    :class => EchoLocalElementComplexType,
    :schema_name => XSD::QName.new(NsC_09, "echoLocalElementComplexType"),
    :schema_element => [
      ["localElementComplexType", "LocalElementComplexType"]
    ]
  )

  LiteralRegistry.register(
    :class => IdExample,
    :schema_name => XSD::QName.new(NsC_09, "idExample"),
    :schema_element => [
      ["text", "SOAP::SOAPString", [0, 1]]
    ],
    :schema_attribute => {
      XSD::QName.new(nil, "string") => "SOAP::SOAPString"
    }
  )

  LiteralRegistry.register(
    :class => EchoIdExample,
    :schema_name => XSD::QName.new(NsC_09, "echoIdExample"),
    :schema_element => [
      ["idExample", "IdExample"]
    ]
  )

  LiteralRegistry.register(
    :class => AttributeGroupExample,
    :schema_name => XSD::QName.new(NsC_09, "attributeGroupExample"),
    :schema_element => [
      ["contract", "SOAP::SOAPString"]
    ],
    :schema_attribute => {
      XSD::QName.new(nil, "id") => "SOAP::SOAPID"
    }
  )

  LiteralRegistry.register(
    :class => EchoAttributeGroupExample,
    :schema_name => XSD::QName.new(NsC_09, "echoAttributeGroupExample"),
    :schema_element => [
      ["attributeGroupExample", "AttributeGroupExample"]
    ]
  )
end
