require 'xsd/qname'

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}StringAttribute
#   text - SOAP::SOAPString
#   xmlattr_string - SOAP::SOAPString
class StringAttribute
  AttrC_String = XSD::QName.new(nil, "string")

  attr_accessor :text

  def __xmlattr
    @__xmlattr ||= {}
  end

  def xmlattr_string
    __xmlattr[AttrC_String]
  end

  def xmlattr_string=(value)
    __xmlattr[AttrC_String] = value
  end

  def initialize(text = nil)
    @text = text
    @__xmlattr = {}
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}BooleanAttribute
#   text - SOAP::SOAPString
#   xmlattr_boolean - SOAP::SOAPBoolean
class BooleanAttribute
  AttrBoolean = XSD::QName.new(nil, "boolean")

  attr_accessor :text

  def __xmlattr
    @__xmlattr ||= {}
  end

  def xmlattr_boolean
    __xmlattr[AttrBoolean]
  end

  def xmlattr_boolean=(value)
    __xmlattr[AttrBoolean] = value
  end

  def initialize(text = nil)
    @text = text
    @__xmlattr = {}
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}DecimalAttribute
#   text - SOAP::SOAPString
#   xmlattr_decimal - SOAP::SOAPDecimal
class DecimalAttribute
  AttrDecimal = XSD::QName.new(nil, "decimal")

  attr_accessor :text

  def __xmlattr
    @__xmlattr ||= {}
  end

  def xmlattr_decimal
    __xmlattr[AttrDecimal]
  end

  def xmlattr_decimal=(value)
    __xmlattr[AttrDecimal] = value
  end

  def initialize(text = nil)
    @text = text
    @__xmlattr = {}
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}FloatAttribute
#   text - SOAP::SOAPString
#   xmlattr_float - SOAP::SOAPFloat
class FloatAttribute
  AttrC_Float = XSD::QName.new(nil, "float")

  attr_accessor :text

  def __xmlattr
    @__xmlattr ||= {}
  end

  def xmlattr_float
    __xmlattr[AttrC_Float]
  end

  def xmlattr_float=(value)
    __xmlattr[AttrC_Float] = value
  end

  def initialize(text = nil)
    @text = text
    @__xmlattr = {}
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}DoubleAttribute
#   text - SOAP::SOAPString
#   xmlattr_double - SOAP::SOAPDouble
class DoubleAttribute
  AttrDouble = XSD::QName.new(nil, "double")

  attr_accessor :text

  def __xmlattr
    @__xmlattr ||= {}
  end

  def xmlattr_double
    __xmlattr[AttrDouble]
  end

  def xmlattr_double=(value)
    __xmlattr[AttrDouble] = value
  end

  def initialize(text = nil)
    @text = text
    @__xmlattr = {}
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}DurationAttribute
#   text - SOAP::SOAPString
#   xmlattr_duration - SOAP::SOAPDuration
class DurationAttribute
  AttrDuration = XSD::QName.new(nil, "duration")

  attr_accessor :text

  def __xmlattr
    @__xmlattr ||= {}
  end

  def xmlattr_duration
    __xmlattr[AttrDuration]
  end

  def xmlattr_duration=(value)
    __xmlattr[AttrDuration] = value
  end

  def initialize(text = nil)
    @text = text
    @__xmlattr = {}
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}DateTimeAttribute
#   text - SOAP::SOAPString
#   xmlattr_dateTime - SOAP::SOAPDateTime
class DateTimeAttribute
  AttrDateTime = XSD::QName.new(nil, "dateTime")

  attr_accessor :text

  def __xmlattr
    @__xmlattr ||= {}
  end

  def xmlattr_dateTime
    __xmlattr[AttrDateTime]
  end

  def xmlattr_dateTime=(value)
    __xmlattr[AttrDateTime] = value
  end

  def initialize(text = nil)
    @text = text
    @__xmlattr = {}
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}TimeAttribute
#   text - SOAP::SOAPString
#   xmlattr_time - SOAP::SOAPTime
class TimeAttribute
  AttrC_Time = XSD::QName.new(nil, "time")

  attr_accessor :text

  def __xmlattr
    @__xmlattr ||= {}
  end

  def xmlattr_time
    __xmlattr[AttrC_Time]
  end

  def xmlattr_time=(value)
    __xmlattr[AttrC_Time] = value
  end

  def initialize(text = nil)
    @text = text
    @__xmlattr = {}
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}DateAttribute
#   text - SOAP::SOAPString
#   xmlattr_date - SOAP::SOAPDate
class DateAttribute
  AttrDate = XSD::QName.new(nil, "date")

  attr_accessor :text

  def __xmlattr
    @__xmlattr ||= {}
  end

  def xmlattr_date
    __xmlattr[AttrDate]
  end

  def xmlattr_date=(value)
    __xmlattr[AttrDate] = value
  end

  def initialize(text = nil)
    @text = text
    @__xmlattr = {}
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}GYearMonthAttribute
#   text - SOAP::SOAPString
#   xmlattr_gYearMonth - SOAP::SOAPGYearMonth
class GYearMonthAttribute
  AttrGYearMonth = XSD::QName.new(nil, "gYearMonth")

  attr_accessor :text

  def __xmlattr
    @__xmlattr ||= {}
  end

  def xmlattr_gYearMonth
    __xmlattr[AttrGYearMonth]
  end

  def xmlattr_gYearMonth=(value)
    __xmlattr[AttrGYearMonth] = value
  end

  def initialize(text = nil)
    @text = text
    @__xmlattr = {}
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}GYearAttribute
#   text - SOAP::SOAPString
#   xmlattr_gYear - SOAP::SOAPGYear
class GYearAttribute
  AttrGYear = XSD::QName.new(nil, "gYear")

  attr_accessor :text

  def __xmlattr
    @__xmlattr ||= {}
  end

  def xmlattr_gYear
    __xmlattr[AttrGYear]
  end

  def xmlattr_gYear=(value)
    __xmlattr[AttrGYear] = value
  end

  def initialize(text = nil)
    @text = text
    @__xmlattr = {}
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}GMonthDayAttribute
#   text - SOAP::SOAPString
#   xmlattr_gMonthDay - SOAP::SOAPGMonthDay
class GMonthDayAttribute
  AttrGMonthDay = XSD::QName.new(nil, "gMonthDay")

  attr_accessor :text

  def __xmlattr
    @__xmlattr ||= {}
  end

  def xmlattr_gMonthDay
    __xmlattr[AttrGMonthDay]
  end

  def xmlattr_gMonthDay=(value)
    __xmlattr[AttrGMonthDay] = value
  end

  def initialize(text = nil)
    @text = text
    @__xmlattr = {}
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}GDayAttribute
#   text - SOAP::SOAPString
#   xmlattr_gDay - SOAP::SOAPGDay
class GDayAttribute
  AttrGDay = XSD::QName.new(nil, "gDay")

  attr_accessor :text

  def __xmlattr
    @__xmlattr ||= {}
  end

  def xmlattr_gDay
    __xmlattr[AttrGDay]
  end

  def xmlattr_gDay=(value)
    __xmlattr[AttrGDay] = value
  end

  def initialize(text = nil)
    @text = text
    @__xmlattr = {}
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}GMonthAttribute
#   text - SOAP::SOAPString
#   xmlattr_gMonth - SOAP::SOAPGMonth
class GMonthAttribute
  AttrGMonth = XSD::QName.new(nil, "gMonth")

  attr_accessor :text

  def __xmlattr
    @__xmlattr ||= {}
  end

  def xmlattr_gMonth
    __xmlattr[AttrGMonth]
  end

  def xmlattr_gMonth=(value)
    __xmlattr[AttrGMonth] = value
  end

  def initialize(text = nil)
    @text = text
    @__xmlattr = {}
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}HexBinaryAttribute
#   text - SOAP::SOAPString
#   xmlattr_hexBinary - SOAP::SOAPHexBinary
class HexBinaryAttribute
  AttrHexBinary = XSD::QName.new(nil, "hexBinary")

  attr_accessor :text

  def __xmlattr
    @__xmlattr ||= {}
  end

  def xmlattr_hexBinary
    __xmlattr[AttrHexBinary]
  end

  def xmlattr_hexBinary=(value)
    __xmlattr[AttrHexBinary] = value
  end

  def initialize(text = nil)
    @text = text
    @__xmlattr = {}
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}Base64BinaryAttribute
#   text - SOAP::SOAPString
#   xmlattr_base64Binary - SOAP::SOAPBase64
class Base64BinaryAttribute
  AttrBase64Binary = XSD::QName.new(nil, "base64Binary")

  attr_accessor :text

  def __xmlattr
    @__xmlattr ||= {}
  end

  def xmlattr_base64Binary
    __xmlattr[AttrBase64Binary]
  end

  def xmlattr_base64Binary=(value)
    __xmlattr[AttrBase64Binary] = value
  end

  def initialize(text = nil)
    @text = text
    @__xmlattr = {}
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}AnyURIAttribute
#   text - SOAP::SOAPString
#   xmlattr_anyURI - SOAP::SOAPAnyURI
class AnyURIAttribute
  AttrAnyURI = XSD::QName.new(nil, "anyURI")

  attr_accessor :text

  def __xmlattr
    @__xmlattr ||= {}
  end

  def xmlattr_anyURI
    __xmlattr[AttrAnyURI]
  end

  def xmlattr_anyURI=(value)
    __xmlattr[AttrAnyURI] = value
  end

  def initialize(text = nil)
    @text = text
    @__xmlattr = {}
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}QNameAttribute
#   text - SOAP::SOAPString
#   xmlattr_QName - SOAP::SOAPQName
class QNameAttribute
  AttrQName = XSD::QName.new(nil, "QName")

  attr_accessor :text

  def __xmlattr
    @__xmlattr ||= {}
  end

  def xmlattr_QName
    __xmlattr[AttrQName]
  end

  def xmlattr_QName=(value)
    __xmlattr[AttrQName] = value
  end

  def initialize(text = nil)
    @text = text
    @__xmlattr = {}
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}NormalizedStringAttribute
#   text - SOAP::SOAPString
#   xmlattr_normalizedString - SOAP::SOAPNormalizedString
class NormalizedStringAttribute
  AttrNormalizedString = XSD::QName.new(nil, "normalizedString")

  attr_accessor :text

  def __xmlattr
    @__xmlattr ||= {}
  end

  def xmlattr_normalizedString
    __xmlattr[AttrNormalizedString]
  end

  def xmlattr_normalizedString=(value)
    __xmlattr[AttrNormalizedString] = value
  end

  def initialize(text = nil)
    @text = text
    @__xmlattr = {}
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}TokenAttribute
#   text - SOAP::SOAPString
#   xmlattr_token - SOAP::SOAPToken
class TokenAttribute
  AttrToken = XSD::QName.new(nil, "token")

  attr_accessor :text

  def __xmlattr
    @__xmlattr ||= {}
  end

  def xmlattr_token
    __xmlattr[AttrToken]
  end

  def xmlattr_token=(value)
    __xmlattr[AttrToken] = value
  end

  def initialize(text = nil)
    @text = text
    @__xmlattr = {}
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}LanguageAttribute
#   text - SOAP::SOAPString
#   xmlattr_language - SOAP::SOAPLanguage
class LanguageAttribute
  AttrLanguage = XSD::QName.new(nil, "language")

  attr_accessor :text

  def __xmlattr
    @__xmlattr ||= {}
  end

  def xmlattr_language
    __xmlattr[AttrLanguage]
  end

  def xmlattr_language=(value)
    __xmlattr[AttrLanguage] = value
  end

  def initialize(text = nil)
    @text = text
    @__xmlattr = {}
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}NMTOKENAttribute
#   text - SOAP::SOAPString
#   xmlattr_NMTOKEN - SOAP::SOAPNMTOKEN
class NMTOKENAttribute
  AttrNMTOKEN = XSD::QName.new(nil, "NMTOKEN")

  attr_accessor :text

  def __xmlattr
    @__xmlattr ||= {}
  end

  def xmlattr_NMTOKEN
    __xmlattr[AttrNMTOKEN]
  end

  def xmlattr_NMTOKEN=(value)
    __xmlattr[AttrNMTOKEN] = value
  end

  def initialize(text = nil)
    @text = text
    @__xmlattr = {}
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}NMTOKENSAttribute
#   text - SOAP::SOAPString
#   xmlattr_NMTOKENS - SOAP::SOAPNMTOKENS
class NMTOKENSAttribute
  AttrNMTOKENS = XSD::QName.new(nil, "NMTOKENS")

  attr_accessor :text

  def __xmlattr
    @__xmlattr ||= {}
  end

  def xmlattr_NMTOKENS
    __xmlattr[AttrNMTOKENS]
  end

  def xmlattr_NMTOKENS=(value)
    __xmlattr[AttrNMTOKENS] = value
  end

  def initialize(text = nil)
    @text = text
    @__xmlattr = {}
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}NameAttribute
#   text - SOAP::SOAPString
#   xmlattr_name - SOAP::SOAPName
class NameAttribute
  AttrName = XSD::QName.new(nil, "name")

  attr_accessor :text

  def __xmlattr
    @__xmlattr ||= {}
  end

  def xmlattr_name
    __xmlattr[AttrName]
  end

  def xmlattr_name=(value)
    __xmlattr[AttrName] = value
  end

  def initialize(text = nil)
    @text = text
    @__xmlattr = {}
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}NCNameAttribute
#   text - SOAP::SOAPString
#   xmlattr_NCName - SOAP::SOAPNCName
class NCNameAttribute
  AttrNCName = XSD::QName.new(nil, "NCName")

  attr_accessor :text

  def __xmlattr
    @__xmlattr ||= {}
  end

  def xmlattr_NCName
    __xmlattr[AttrNCName]
  end

  def xmlattr_NCName=(value)
    __xmlattr[AttrNCName] = value
  end

  def initialize(text = nil)
    @text = text
    @__xmlattr = {}
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}IDAttribute
#   text - SOAP::SOAPString
#   xmlattr_ID - SOAP::SOAPID
class IDAttribute
  AttrID = XSD::QName.new(nil, "ID")

  attr_accessor :text

  def __xmlattr
    @__xmlattr ||= {}
  end

  def xmlattr_ID
    __xmlattr[AttrID]
  end

  def xmlattr_ID=(value)
    __xmlattr[AttrID] = value
  end

  def initialize(text = nil)
    @text = text
    @__xmlattr = {}
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}IDREFAttribute
#   text - SOAP::SOAPString
#   xmlattr_IDREF - SOAP::SOAPIDREF
class IDREFAttribute
  AttrIDREF = XSD::QName.new(nil, "IDREF")

  attr_accessor :text

  def __xmlattr
    @__xmlattr ||= {}
  end

  def xmlattr_IDREF
    __xmlattr[AttrIDREF]
  end

  def xmlattr_IDREF=(value)
    __xmlattr[AttrIDREF] = value
  end

  def initialize(text = nil)
    @text = text
    @__xmlattr = {}
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}IDREFSAttribute
#   text - SOAP::SOAPString
#   xmlattr_IDREFS - SOAP::SOAPIDREFS
class IDREFSAttribute
  AttrIDREFS = XSD::QName.new(nil, "IDREFS")

  attr_accessor :text

  def __xmlattr
    @__xmlattr ||= {}
  end

  def xmlattr_IDREFS
    __xmlattr[AttrIDREFS]
  end

  def xmlattr_IDREFS=(value)
    __xmlattr[AttrIDREFS] = value
  end

  def initialize(text = nil)
    @text = text
    @__xmlattr = {}
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}ENTITYAttribute
#   text - SOAP::SOAPString
#   xmlattr_ENTITY - SOAP::SOAPENTITY
class ENTITYAttribute
  AttrENTITY = XSD::QName.new(nil, "ENTITY")

  attr_accessor :text

  def __xmlattr
    @__xmlattr ||= {}
  end

  def xmlattr_ENTITY
    __xmlattr[AttrENTITY]
  end

  def xmlattr_ENTITY=(value)
    __xmlattr[AttrENTITY] = value
  end

  def initialize(text = nil)
    @text = text
    @__xmlattr = {}
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}ENTITIESAttribute
#   text - SOAP::SOAPString
#   xmlattr_ENTITIES - SOAP::SOAPENTITIES
class ENTITIESAttribute
  AttrENTITIES = XSD::QName.new(nil, "ENTITIES")

  attr_accessor :text

  def __xmlattr
    @__xmlattr ||= {}
  end

  def xmlattr_ENTITIES
    __xmlattr[AttrENTITIES]
  end

  def xmlattr_ENTITIES=(value)
    __xmlattr[AttrENTITIES] = value
  end

  def initialize(text = nil)
    @text = text
    @__xmlattr = {}
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}IntegerAttribute
#   text - SOAP::SOAPString
#   xmlattr_integer - SOAP::SOAPInteger
class IntegerAttribute
  AttrC_Integer = XSD::QName.new(nil, "integer")

  attr_accessor :text

  def __xmlattr
    @__xmlattr ||= {}
  end

  def xmlattr_integer
    __xmlattr[AttrC_Integer]
  end

  def xmlattr_integer=(value)
    __xmlattr[AttrC_Integer] = value
  end

  def initialize(text = nil)
    @text = text
    @__xmlattr = {}
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}NonPositiveIntegerAttribute
#   text - SOAP::SOAPString
#   xmlattr_nonPositiveInteger - SOAP::SOAPNonPositiveInteger
class NonPositiveIntegerAttribute
  AttrNonPositiveInteger = XSD::QName.new(nil, "nonPositiveInteger")

  attr_accessor :text

  def __xmlattr
    @__xmlattr ||= {}
  end

  def xmlattr_nonPositiveInteger
    __xmlattr[AttrNonPositiveInteger]
  end

  def xmlattr_nonPositiveInteger=(value)
    __xmlattr[AttrNonPositiveInteger] = value
  end

  def initialize(text = nil)
    @text = text
    @__xmlattr = {}
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}LongAttribute
#   text - SOAP::SOAPString
#   xmlattr_long - SOAP::SOAPLong
class LongAttribute
  AttrLong = XSD::QName.new(nil, "long")

  attr_accessor :text

  def __xmlattr
    @__xmlattr ||= {}
  end

  def xmlattr_long
    __xmlattr[AttrLong]
  end

  def xmlattr_long=(value)
    __xmlattr[AttrLong] = value
  end

  def initialize(text = nil)
    @text = text
    @__xmlattr = {}
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}IntAttribute
#   text - SOAP::SOAPString
#   xmlattr_int - SOAP::SOAPInt
class IntAttribute
  AttrInt = XSD::QName.new(nil, "int")

  attr_accessor :text

  def __xmlattr
    @__xmlattr ||= {}
  end

  def xmlattr_int
    __xmlattr[AttrInt]
  end

  def xmlattr_int=(value)
    __xmlattr[AttrInt] = value
  end

  def initialize(text = nil)
    @text = text
    @__xmlattr = {}
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}ShortAttribute
#   text - SOAP::SOAPString
#   xmlattr_short - SOAP::SOAPShort
class ShortAttribute
  AttrShort = XSD::QName.new(nil, "short")

  attr_accessor :text

  def __xmlattr
    @__xmlattr ||= {}
  end

  def xmlattr_short
    __xmlattr[AttrShort]
  end

  def xmlattr_short=(value)
    __xmlattr[AttrShort] = value
  end

  def initialize(text = nil)
    @text = text
    @__xmlattr = {}
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}ByteAttribute
#   text - SOAP::SOAPString
#   xmlattr_byte - SOAP::SOAPByte
class ByteAttribute
  AttrByte = XSD::QName.new(nil, "byte")

  attr_accessor :text

  def __xmlattr
    @__xmlattr ||= {}
  end

  def xmlattr_byte
    __xmlattr[AttrByte]
  end

  def xmlattr_byte=(value)
    __xmlattr[AttrByte] = value
  end

  def initialize(text = nil)
    @text = text
    @__xmlattr = {}
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}NonNegativeIntegerAttribute
#   text - SOAP::SOAPString
#   xmlattr_nonNegativeInteger - SOAP::SOAPNonNegativeInteger
class NonNegativeIntegerAttribute
  AttrNonNegativeInteger = XSD::QName.new(nil, "nonNegativeInteger")

  attr_accessor :text

  def __xmlattr
    @__xmlattr ||= {}
  end

  def xmlattr_nonNegativeInteger
    __xmlattr[AttrNonNegativeInteger]
  end

  def xmlattr_nonNegativeInteger=(value)
    __xmlattr[AttrNonNegativeInteger] = value
  end

  def initialize(text = nil)
    @text = text
    @__xmlattr = {}
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}UnsignedLongAttribute
#   text - SOAP::SOAPString
#   xmlattr_unsignedLong - SOAP::SOAPUnsignedLong
class UnsignedLongAttribute
  AttrUnsignedLong = XSD::QName.new(nil, "unsignedLong")

  attr_accessor :text

  def __xmlattr
    @__xmlattr ||= {}
  end

  def xmlattr_unsignedLong
    __xmlattr[AttrUnsignedLong]
  end

  def xmlattr_unsignedLong=(value)
    __xmlattr[AttrUnsignedLong] = value
  end

  def initialize(text = nil)
    @text = text
    @__xmlattr = {}
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}UnsignedIntAttribute
#   text - SOAP::SOAPString
#   xmlattr_unsignedInt - SOAP::SOAPUnsignedInt
class UnsignedIntAttribute
  AttrUnsignedInt = XSD::QName.new(nil, "unsignedInt")

  attr_accessor :text

  def __xmlattr
    @__xmlattr ||= {}
  end

  def xmlattr_unsignedInt
    __xmlattr[AttrUnsignedInt]
  end

  def xmlattr_unsignedInt=(value)
    __xmlattr[AttrUnsignedInt] = value
  end

  def initialize(text = nil)
    @text = text
    @__xmlattr = {}
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}UnsignedShortAttribute
#   text - SOAP::SOAPString
#   xmlattr_unsignedShort - SOAP::SOAPUnsignedShort
class UnsignedShortAttribute
  AttrUnsignedShort = XSD::QName.new(nil, "unsignedShort")

  attr_accessor :text

  def __xmlattr
    @__xmlattr ||= {}
  end

  def xmlattr_unsignedShort
    __xmlattr[AttrUnsignedShort]
  end

  def xmlattr_unsignedShort=(value)
    __xmlattr[AttrUnsignedShort] = value
  end

  def initialize(text = nil)
    @text = text
    @__xmlattr = {}
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}NegativeIntegerAttribute
#   text - SOAP::SOAPString
#   xmlattr_negativeInteger - SOAP::SOAPNegativeInteger
class NegativeIntegerAttribute
  AttrNegativeInteger = XSD::QName.new(nil, "negativeInteger")

  attr_accessor :text

  def __xmlattr
    @__xmlattr ||= {}
  end

  def xmlattr_negativeInteger
    __xmlattr[AttrNegativeInteger]
  end

  def xmlattr_negativeInteger=(value)
    __xmlattr[AttrNegativeInteger] = value
  end

  def initialize(text = nil)
    @text = text
    @__xmlattr = {}
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}UnsignedByteAttribute
#   text - SOAP::SOAPString
#   xmlattr_unsignedByte - SOAP::SOAPUnsignedByte
class UnsignedByteAttribute
  AttrUnsignedByte = XSD::QName.new(nil, "unsignedByte")

  attr_accessor :text

  def __xmlattr
    @__xmlattr ||= {}
  end

  def xmlattr_unsignedByte
    __xmlattr[AttrUnsignedByte]
  end

  def xmlattr_unsignedByte=(value)
    __xmlattr[AttrUnsignedByte] = value
  end

  def initialize(text = nil)
    @text = text
    @__xmlattr = {}
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}PositiveIntegerAttribute
#   text - SOAP::SOAPString
#   xmlattr_positiveInteger - SOAP::SOAPPositiveInteger
class PositiveIntegerAttribute
  AttrPositiveInteger = XSD::QName.new(nil, "positiveInteger")

  attr_accessor :text

  def __xmlattr
    @__xmlattr ||= {}
  end

  def xmlattr_positiveInteger
    __xmlattr[AttrPositiveInteger]
  end

  def xmlattr_positiveInteger=(value)
    __xmlattr[AttrPositiveInteger] = value
  end

  def initialize(text = nil)
    @text = text
    @__xmlattr = {}
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}ComplexTypeSequence
#   name - SOAP::SOAPString
#   shade - SOAP::SOAPString
#   length - SOAP::SOAPInt
#   xmlattr_id - SOAP::SOAPString
#   xmlattr_inStock - SOAP::SOAPInt
class ComplexTypeSequence
  AttrId = XSD::QName.new(nil, "id")
  AttrInStock = XSD::QName.new(nil, "inStock")

  attr_accessor :name
  attr_accessor :shade
  attr_accessor :length

  def __xmlattr
    @__xmlattr ||= {}
  end

  def xmlattr_id
    __xmlattr[AttrId]
  end

  def xmlattr_id=(value)
    __xmlattr[AttrId] = value
  end

  def xmlattr_inStock
    __xmlattr[AttrInStock]
  end

  def xmlattr_inStock=(value)
    __xmlattr[AttrInStock] = value
  end

  def initialize(name = nil, shade = nil, length = nil)
    @name = name
    @shade = shade
    @length = length
    @__xmlattr = {}
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}ComplexTypeAll
#   name - SOAP::SOAPString
#   shade - SOAP::SOAPString
#   length - SOAP::SOAPInt
#   xmlattr_id - SOAP::SOAPString
#   xmlattr_inStock - SOAP::SOAPInt
class ComplexTypeAll
  AttrId = XSD::QName.new(nil, "id")
  AttrInStock = XSD::QName.new(nil, "inStock")

  attr_accessor :name
  attr_accessor :shade
  attr_accessor :length

  def __xmlattr
    @__xmlattr ||= {}
  end

  def xmlattr_id
    __xmlattr[AttrId]
  end

  def xmlattr_id=(value)
    __xmlattr[AttrId] = value
  end

  def xmlattr_inStock
    __xmlattr[AttrInStock]
  end

  def xmlattr_inStock=(value)
    __xmlattr[AttrInStock] = value
  end

  def initialize(name = nil, shade = nil, length = nil)
    @name = name
    @shade = shade
    @length = length
    @__xmlattr = {}
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}Fruit
#   apple - SOAP::SOAPInt
#   orange - SOAP::SOAPString
#   banana - SOAP::SOAPInt
class Fruit
  attr_accessor :apple
  attr_accessor :orange
  attr_accessor :banana

  def initialize(apple = nil, orange = nil, banana = nil)
    @apple = apple
    @orange = orange
    @banana = banana
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}Mortgage
#   amount - SOAP::SOAPInt
#   repayment - Repayment
#   interestonly - InterestOnly
class Mortgage
  attr_accessor :amount
  attr_accessor :repayment
  attr_accessor :interestonly

  def initialize(amount = nil, repayment = nil, interestonly = nil)
    @amount = amount
    @repayment = repayment
    @interestonly = interestonly
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}Repayment
#   years - SOAP::SOAPInt
#   months - SOAP::SOAPInt
#   rate - SOAP::SOAPString
class Repayment
  attr_accessor :years
  attr_accessor :months
  attr_accessor :rate

  def initialize(years = nil, months = nil, rate = nil)
    @years = years
    @months = months
    @rate = rate
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}InterestOnly
#   years - SOAP::SOAPInt
#   rate - SOAP::SOAPString
class InterestOnly
  attr_accessor :years
  attr_accessor :rate

  def initialize(years = nil, rate = nil)
    @years = years
    @rate = rate
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}ElementMinOccurs1
#   elementMinOccurs1item - SOAP::SOAPString
class ElementMinOccurs1
  attr_accessor :elementMinOccurs1item

  def initialize(elementMinOccurs1item = nil)
    @elementMinOccurs1item = elementMinOccurs1item
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}ItemColors2
class ItemColors2 < ::Array
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}ItemColors
class ItemColors < ::Array
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}ElementMaxOccurs1
#   value - SOAP::SOAPString
class ElementMaxOccurs1
  attr_accessor :value

  def initialize(value = nil)
    @value = value
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}Publications
class Publications < ::Array
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}Summer
class Summer < ::Array
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}Premium
#   amount - SOAP::SOAPString
#   xmlattr_id - SOAP::SOAPString
#   xmlattr_currency - SOAP::SOAPString
class Premium
  AttrCurrency = XSD::QName.new(nil, "currency")
  AttrId = XSD::QName.new(nil, "id")

  attr_accessor :amount

  def __xmlattr
    @__xmlattr ||= {}
  end

  def xmlattr_id
    __xmlattr[AttrId]
  end

  def xmlattr_id=(value)
    __xmlattr[AttrId] = value
  end

  def xmlattr_currency
    __xmlattr[AttrCurrency]
  end

  def xmlattr_currency=(value)
    __xmlattr[AttrCurrency] = value
  end

  def initialize(amount = nil)
    @amount = amount
    @__xmlattr = {}
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}Discount
#   percentage - SOAP::SOAPInt
#   xmlattr_id - SOAP::SOAPString
#   xmlattr_seasonal - SOAP::SOAPBoolean
class Discount
  AttrId = XSD::QName.new(nil, "id")
  AttrSeasonal = XSD::QName.new(nil, "seasonal")

  attr_accessor :percentage

  def __xmlattr
    @__xmlattr ||= {}
  end

  def xmlattr_id
    __xmlattr[AttrId]
  end

  def xmlattr_id=(value)
    __xmlattr[AttrId] = value
  end

  def xmlattr_seasonal
    __xmlattr[AttrSeasonal]
  end

  def xmlattr_seasonal=(value)
    __xmlattr[AttrSeasonal] = value
  end

  def initialize(percentage = nil)
    @percentage = percentage
    @__xmlattr = {}
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}Survey
#   fee - SOAP::SOAPInt
#   xmlattr_id - SOAP::SOAPString
#   xmlattr_currency - SOAP::SOAPString
class Survey
  AttrCurrency = XSD::QName.new(nil, "currency")
  AttrId = XSD::QName.new(nil, "id")

  attr_accessor :fee

  def __xmlattr
    @__xmlattr ||= {}
  end

  def xmlattr_id
    __xmlattr[AttrId]
  end

  def xmlattr_id=(value)
    __xmlattr[AttrId] = value
  end

  def xmlattr_currency
    __xmlattr[AttrCurrency]
  end

  def xmlattr_currency=(value)
    __xmlattr[AttrCurrency] = value
  end

  def initialize(fee = nil)
    @fee = fee
    @__xmlattr = {}
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}ElementMinOccurs0
#   firstName - SOAP::SOAPString
#   middleName - SOAP::SOAPString
#   lastName - SOAP::SOAPString
class ElementMinOccurs0
  attr_accessor :firstName
  attr_accessor :middleName
  attr_accessor :lastName

  def initialize(firstName = nil, middleName = nil, lastName = nil)
    @firstName = firstName
    @middleName = middleName
    @lastName = lastName
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}NillableMiddleName
#   firstName - SOAP::SOAPString
#   middleName - SOAP::SOAPString
#   lastName - SOAP::SOAPString
class NillableMiddleName
  attr_accessor :firstName
  attr_accessor :middleName
  attr_accessor :lastName

  def initialize(firstName = nil, middleName = nil, lastName = nil)
    @firstName = firstName
    @middleName = middleName
    @lastName = lastName
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}NillableOptionalMiddleName
#   firstName - SOAP::SOAPString
#   middleName - SOAP::SOAPString
#   lastName - SOAP::SOAPString
class NillableOptionalMiddleName
  attr_accessor :firstName
  attr_accessor :middleName
  attr_accessor :lastName

  def initialize(firstName = nil, middleName = nil, lastName = nil)
    @firstName = firstName
    @middleName = middleName
    @lastName = lastName
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}SequenceElementList
class SequenceElementList < ::Array
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}NestedItem
class NestedItem < ::Array
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}NestedSequenceElementList
class NestedSequenceElementList < ::Array
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}MixedContentType
#   elem1 - SOAP::SOAPString
#   elem2 - SOAP::SOAPString
class MixedContentType
  attr_accessor :elem1
  attr_accessor :elem2

  def initialize(elem1 = nil, elem2 = nil)
    @elem1 = elem1
    @elem2 = elem2
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}CustomerName
#   firstName - SOAP::SOAPString
#   lastName - SOAP::SOAPString
class CustomerName
  attr_accessor :firstName
  attr_accessor :lastName

  def initialize(firstName = nil, lastName = nil)
    @firstName = firstName
    @lastName = lastName
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}ClientName
#   firstName - SOAP::SOAPString
#   lastName - SOAP::SOAPString
#   xmlattr_phoneNumber - SOAP::SOAPString
class ClientName
  AttrPhoneNumber = XSD::QName.new("http://www.w3.org/2002/ws/databinding/examples/6/09/", "phoneNumber")

  attr_accessor :firstName
  attr_accessor :lastName

  def __xmlattr
    @__xmlattr ||= {}
  end

  def xmlattr_phoneNumber
    __xmlattr[AttrPhoneNumber]
  end

  def xmlattr_phoneNumber=(value)
    __xmlattr[AttrPhoneNumber] = value
  end

  def initialize(firstName = nil, lastName = nil)
    @firstName = firstName
    @lastName = lastName
    @__xmlattr = {}
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}ClientDetails
#   forename - SOAP::SOAPString
#   surname - SOAP::SOAPString
#   title - SOAP::SOAPString
#   xmlattr_phone - SOAP::SOAPLong
#   xmlattr_title - SOAP::SOAPBoolean
class ClientDetails
  AttrPhone = XSD::QName.new(nil, "phone")
  AttrTitle = XSD::QName.new(nil, "title")

  attr_accessor :forename
  attr_accessor :surname
  attr_accessor :title

  def __xmlattr
    @__xmlattr ||= {}
  end

  def xmlattr_phone
    __xmlattr[AttrPhone]
  end

  def xmlattr_phone=(value)
    __xmlattr[AttrPhone] = value
  end

  def xmlattr_title
    __xmlattr[AttrTitle]
  end

  def xmlattr_title=(value)
    __xmlattr[AttrTitle] = value
  end

  def initialize(forename = nil, surname = nil, title = nil)
    @forename = forename
    @surname = surname
    @title = title
    @__xmlattr = {}
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}ExtendedSequenceStrict
#   firstName - SOAP::SOAPString
#   lastName - SOAP::SOAPString
#   extension - StrictExtension
class ExtendedSequenceStrict
  attr_accessor :firstName
  attr_accessor :lastName
  attr_accessor :extension

  def initialize(firstName = nil, lastName = nil, extension = nil)
    @firstName = firstName
    @lastName = lastName
    @extension = extension
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}StrictExtension
class StrictExtension
  attr_reader :__xmlele_any

  def set_any(elements)
    @__xmlele_any = elements
  end

  def initialize
    @__xmlele_any = nil
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}ExtendedSequenceLax
#   firstName - SOAP::SOAPString
#   lastName - SOAP::SOAPString
#   extension - LaxExtension
class ExtendedSequenceLax
  attr_accessor :firstName
  attr_accessor :lastName
  attr_accessor :extension

  def initialize(firstName = nil, lastName = nil, extension = nil)
    @firstName = firstName
    @lastName = lastName
    @extension = extension
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}LaxExtension
class LaxExtension
  attr_reader :__xmlele_any

  def set_any(elements)
    @__xmlele_any = elements
  end

  def initialize
    @__xmlele_any = nil
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}ExtendedSequenceSkip
#   firstName - SOAP::SOAPString
#   lastName - SOAP::SOAPString
#   extension - SkipExtension
class ExtendedSequenceSkip
  attr_accessor :firstName
  attr_accessor :lastName
  attr_accessor :extension

  def initialize(firstName = nil, lastName = nil, extension = nil)
    @firstName = firstName
    @lastName = lastName
    @extension = extension
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}SkipExtension
class SkipExtension
  attr_reader :__xmlele_any

  def set_any(elements)
    @__xmlele_any = elements
  end

  def initialize
    @__xmlele_any = nil
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}BareVector
#   item1 - SOAP::SOAPString
#   item2 - SOAP::SOAPString
#   item3 - SOAP::SOAPString
class BareVector
  attr_accessor :item1
  attr_accessor :item2
  attr_accessor :item3

  def initialize(item1 = [], item2 = [], item3 = [])
    @item1 = item1
    @item2 = item2
    @item3 = item3
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}ComplexTypeSequenceBase
#   name - SOAP::SOAPString
class ComplexTypeSequenceBase
  attr_accessor :name

  def initialize(name = nil)
    @name = name
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}ComplexTypeSequenceExtension
#   name - SOAP::SOAPString
#   description - SOAP::SOAPString
class ComplexTypeSequenceExtension < ComplexTypeSequenceBase
  attr_accessor :name
  attr_accessor :description

  def initialize(name = nil, description = nil)
    @name = name
    @description = description
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}Assembly
class Assembly < ::Array
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}Part
#   number - SOAP::SOAPString
class Part
  attr_accessor :number

  def initialize(number = nil)
    @number = number
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}Part2
#   number - SOAP::SOAPString
#   description - SOAP::SOAPString
class Part2 < Part
  attr_accessor :number
  attr_accessor :description

  def initialize(number = nil, description = nil)
    @number = number
    @description = description
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}SimpleTypeAttributes
#   xmlattr_a1 - SOAP::SOAPString
#   xmlattr_a2 - SOAP::SOAPString
class SimpleTypeAttributes < ::String
  AttrA1 = XSD::QName.new(nil, "a1")
  AttrA2 = XSD::QName.new(nil, "a2")

  def __xmlattr
    @__xmlattr ||= {}
  end

  def xmlattr_a1
    __xmlattr[AttrA1]
  end

  def xmlattr_a1=(value)
    __xmlattr[AttrA1] = value
  end

  def xmlattr_a2
    __xmlattr[AttrA2]
  end

  def xmlattr_a2=(value)
    __xmlattr[AttrA2] = value
  end

  def initialize(*arg)
    super
    @__xmlattr = {}
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}ExtendedSimpleType
class ExtendedSimpleType < ::String
  def initialize(*arg)
    super
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}SequenceMinOccurs1
#   sequenceMinOccurs1item - SOAP::SOAPString
class SequenceMinOccurs1
  attr_accessor :sequenceMinOccurs1item

  def initialize(sequenceMinOccurs1item = nil)
    @sequenceMinOccurs1item = sequenceMinOccurs1item
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}ArticleColors
#   articleColor - SOAP::SOAPString
#   articleContrast - SOAP::SOAPString
class ArticleColors
  attr_accessor :articleColor
  attr_accessor :articleContrast

  def initialize(articleColor = [], articleContrast = [])
    @articleColor = articleColor
    @articleContrast = articleContrast
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}MyAgeDetails
#   myAge - SOAP::SOAPShort
class MyAgeDetails
  attr_accessor :myAge

  def initialize(myAge = nil)
    @myAge = myAge
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}DurationList
class DurationList < ::Array
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}DurationListSequence
#   durationVal - SOAP::SOAPString
#   durationPercentage - SOAP::SOAPString
class DurationListSequence
  attr_accessor :durationVal
  attr_accessor :durationPercentage

  def initialize(durationVal = [], durationPercentage = [])
    @durationVal = durationVal
    @durationPercentage = durationPercentage
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}AgeList
class AgeList < ::Array
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}AgeListSequence
#   ageVal - SOAP::SOAPString
#   agePercentage - SOAP::SOAPString
class AgeListSequence
  attr_accessor :ageVal
  attr_accessor :agePercentage

  def initialize(ageVal = [], agePercentage = [])
    @ageVal = ageVal
    @agePercentage = agePercentage
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}BookPublications
#   pubDate - SOAP::SOAPString
#   pubISBN - SOAP::SOAPString
class BookPublications
  attr_accessor :pubDate
  attr_accessor :pubISBN

  def initialize(pubDate = [], pubISBN = [])
    @pubDate = pubDate
    @pubISBN = pubISBN
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}Winter
#   mnth - SOAP::SOAPString
#   weather - SOAP::SOAPString
class Winter
  attr_accessor :mnth
  attr_accessor :weather

  def initialize(mnth = [], weather = [])
    @mnth = mnth
    @weather = weather
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}SequenceMinOccurs0
#   firstName - SOAP::SOAPString
#   middleName - SOAP::SOAPString
#   lastName - SOAP::SOAPString
class SequenceMinOccurs0
  attr_accessor :firstName
  attr_accessor :middleName
  attr_accessor :lastName

  def initialize(firstName = nil, middleName = nil, lastName = nil)
    @firstName = firstName
    @middleName = middleName
    @lastName = lastName
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}SequenceSequenceElement
#   firstName - SOAP::SOAPString
#   middleName - SOAP::SOAPString
#   lastName - SOAP::SOAPString
class SequenceSequenceElement
  attr_accessor :firstName
  attr_accessor :middleName
  attr_accessor :lastName

  def initialize(firstName = nil, middleName = nil, lastName = nil)
    @firstName = firstName
    @middleName = middleName
    @lastName = lastName
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}AttributeTypeReference
#   text - SOAP::SOAPString
#   xmlattr_number - SOAP::SOAPDecimal
class AttributeTypeReference
  AttrNumber = XSD::QName.new(nil, "number")

  attr_accessor :text

  def __xmlattr
    @__xmlattr ||= {}
  end

  def xmlattr_number
    __xmlattr[AttrNumber]
  end

  def xmlattr_number=(value)
    __xmlattr[AttrNumber] = value
  end

  def initialize(text = nil)
    @text = text
    @__xmlattr = {}
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}ElementTypeReferenced
#   referenced - SOAP::SOAPString
class ElementTypeReferenced
  attr_accessor :referenced

  def initialize(referenced = nil)
    @referenced = referenced
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}ElementTypeReference
#   text - ElementTypeReferenced
class ElementTypeReference
  attr_accessor :text

  def initialize(text = nil)
    @text = text
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}LocalElementComplexType
#   name - LocalElementComplexType::Name
class LocalElementComplexType

  # inner class for member: name
  # {http://www.w3.org/2002/ws/databinding/examples/6/09/}name
  #   firstName - SOAP::SOAPString
  #   lastName - SOAP::SOAPString
  class Name
    attr_accessor :firstName
    attr_accessor :lastName

    def initialize(firstName = nil, lastName = nil)
      @firstName = firstName
      @lastName = lastName
    end
  end

  attr_accessor :name

  def initialize(name = nil)
    @name = name
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}IdExample
#   text - SOAP::SOAPString
#   xmlattr_string - SOAP::SOAPString
class IdExample
  AttrC_String = XSD::QName.new(nil, "string")

  attr_accessor :text

  def __xmlattr
    @__xmlattr ||= {}
  end

  def xmlattr_string
    __xmlattr[AttrC_String]
  end

  def xmlattr_string=(value)
    __xmlattr[AttrC_String] = value
  end

  def initialize(text = nil)
    @text = text
    @__xmlattr = {}
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}AttributeGroupExample
#   contract - SOAP::SOAPString
#   xmlattr_id - SOAP::SOAPID
class AttributeGroupExample
  AttrId = XSD::QName.new(nil, "id")

  attr_accessor :contract

  def __xmlattr
    @__xmlattr ||= {}
  end

  def xmlattr_id
    __xmlattr[AttrId]
  end

  def xmlattr_id=(value)
    __xmlattr[AttrId] = value
  end

  def initialize(contract = nil)
    @contract = contract
    @__xmlattr = {}
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}GlobalSimpleType
class GlobalSimpleType < ::String
  Foo = GlobalSimpleType.new("foo")
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}Beatle
class Beatle < ::String
  George = Beatle.new("George")
  John = Beatle.new("John")
  Paul = Beatle.new("Paul")
  Pete = Beatle.new("Pete")
  Ringo = Beatle.new("Ringo")
  Stuart = Beatle.new("Stuart")
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}NMTOKENEnumerationType
class NMTOKENEnumerationType < ::String
  Token1 = NMTOKENEnumerationType.new("token1")
  Token2 = NMTOKENEnumerationType.new("token2")
  Token3 = NMTOKENEnumerationType.new("token3")
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}IntEnumerationType
class IntEnumerationType < ::String
  C_2 = IntEnumerationType.new("2")
  C_3 = IntEnumerationType.new("3")
  C_5 = IntEnumerationType.new("5")
  C_7 = IntEnumerationType.new("7")
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}ShortEnumerationType
class ShortEnumerationType < ::String
  C_11 = ShortEnumerationType.new("11")
  C_13 = ShortEnumerationType.new("13")
  C_7 = ShortEnumerationType.new("7")
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}LongEnumerationType
class LongEnumerationType < ::String
  C_7235733 = LongEnumerationType.new("7235733")
  C_7816230 = LongEnumerationType.new("7816230")
  C_9152052 = LongEnumerationType.new("9152052")
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}DoubleEnumerationType
class DoubleEnumerationType < ::String
  C_126743233E12 = DoubleEnumerationType.new("1267.43233E12")
  C_573365565E12 = DoubleEnumerationType.new("5733.65565E12")
  C_723434541E12 = DoubleEnumerationType.new("7234.34541E12")
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}IntegerEnumerationType
class IntegerEnumerationType < ::String
  C_4000000 = IntegerEnumerationType.new("4000000")
  C_5000000 = IntegerEnumerationType.new("5000000")
  C_6000000 = IntegerEnumerationType.new("6000000")
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}DecimalEnumerationType
class DecimalEnumerationType < ::String
  C_10000001 = DecimalEnumerationType.new("+1000.0001")
  C_10000001_2 = DecimalEnumerationType.new("-1000.0001")
  C_10000002 = DecimalEnumerationType.new("1000.0002")
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}FloatEnumerationType
class FloatEnumerationType < ::String
  C_126743233E12 = FloatEnumerationType.new("1267.43233E12")
  C_573365565E12 = FloatEnumerationType.new("5733.65565E12")
  C_723434541E12 = FloatEnumerationType.new("7234.34541E12")
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}NonNegativeIntegerEnumerationType
class NonNegativeIntegerEnumerationType < ::String
  C_12 = NonNegativeIntegerEnumerationType.new("12")
  C_24 = NonNegativeIntegerEnumerationType.new("24")
  C_33 = NonNegativeIntegerEnumerationType.new("33")
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}PositiveIntegerEnumerationType
class PositiveIntegerEnumerationType < ::String
  C_12 = PositiveIntegerEnumerationType.new("12")
  C_24 = PositiveIntegerEnumerationType.new("24")
  C_33 = PositiveIntegerEnumerationType.new("33")
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}UnsignedLongEnumerationType
class UnsignedLongEnumerationType < ::String
  C_11111111111111 = UnsignedLongEnumerationType.new("11111111111111")
  C_22222222222222 = UnsignedLongEnumerationType.new("22222222222222")
  C_33333333333333 = UnsignedLongEnumerationType.new("33333333333333")
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}UnsignedIntEnumerationType
class UnsignedIntEnumerationType < ::String
  C_1111111111 = UnsignedIntEnumerationType.new("1111111111")
  C_2222222222 = UnsignedIntEnumerationType.new("2222222222")
  C_3333333333 = UnsignedIntEnumerationType.new("3333333333")
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}UnsignedShortEnumerationType
class UnsignedShortEnumerationType < ::String
  C_1111 = UnsignedShortEnumerationType.new("1111")
  C_2222 = UnsignedShortEnumerationType.new("2222")
  C_3333 = UnsignedShortEnumerationType.new("3333")
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}TokenEnumerationType
class TokenEnumerationType < ::String
  C_1 = TokenEnumerationType.new("1")
  C_2 = TokenEnumerationType.new("2")
  C_3 = TokenEnumerationType.new("3")
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}UnionMemberTypes
#  any of xs:int xs:string
class UnionMemberTypes < ::String
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}NullEnumerationType
class NullEnumerationType < ::String
  C_ = NullEnumerationType.new("")
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}echoAnySimpleTypeElement
#   anySimpleTypeElement - SOAP::SOAPAnySimpleType
class EchoAnySimpleTypeElement
  attr_accessor :anySimpleTypeElement

  def initialize(anySimpleTypeElement = nil)
    @anySimpleTypeElement = anySimpleTypeElement
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}echoAnyTypeElement
#   anyTypeElement - (any)
class EchoAnyTypeElement
  attr_accessor :anyTypeElement

  def initialize(anyTypeElement = nil)
    @anyTypeElement = anyTypeElement
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}echoDocumentationElement
#   documentationElement - SOAP::SOAPString
class EchoDocumentationElement
  attr_accessor :documentationElement

  def initialize(documentationElement = nil)
    @documentationElement = documentationElement
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}echoIdentifierName
#   identifierName - SOAP::SOAPString
class EchoIdentifierName
  attr_accessor :identifierName

  def initialize(identifierName = nil)
    @identifierName = identifierName
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}echoNonIdentifierName
#   non_Identifier_Name - SOAP::SOAPString
class EchoNonIdentifierName
  attr_accessor :non_Identifier_Name

  def initialize(non_Identifier_Name = nil)
    @non_Identifier_Name = non_Identifier_Name
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}echoStringElement
#   stringElement - SOAP::SOAPString
class EchoStringElement
  attr_accessor :stringElement

  def initialize(stringElement = nil)
    @stringElement = stringElement
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}echoStringAttribute
#   stringAttribute - StringAttribute
class EchoStringAttribute
  attr_accessor :stringAttribute

  def initialize(stringAttribute = nil)
    @stringAttribute = stringAttribute
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}echoBooleanElement
#   booleanElement - SOAP::SOAPBoolean
class EchoBooleanElement
  attr_accessor :booleanElement

  def initialize(booleanElement = nil)
    @booleanElement = booleanElement
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}echoBooleanAttribute
#   booleanAttribute - BooleanAttribute
class EchoBooleanAttribute
  attr_accessor :booleanAttribute

  def initialize(booleanAttribute = nil)
    @booleanAttribute = booleanAttribute
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}echoDecimalElement
#   decimalElement - SOAP::SOAPDecimal
class EchoDecimalElement
  attr_accessor :decimalElement

  def initialize(decimalElement = nil)
    @decimalElement = decimalElement
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}echoDecimalAttribute
#   decimalAttribute - DecimalAttribute
class EchoDecimalAttribute
  attr_accessor :decimalAttribute

  def initialize(decimalAttribute = nil)
    @decimalAttribute = decimalAttribute
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}echoFloatElement
#   floatElement - SOAP::SOAPFloat
class EchoFloatElement
  attr_accessor :floatElement

  def initialize(floatElement = nil)
    @floatElement = floatElement
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}echoFloatAttribute
#   floatAttribute - FloatAttribute
class EchoFloatAttribute
  attr_accessor :floatAttribute

  def initialize(floatAttribute = nil)
    @floatAttribute = floatAttribute
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}echoDoubleElement
#   doubleElement - SOAP::SOAPDouble
class EchoDoubleElement
  attr_accessor :doubleElement

  def initialize(doubleElement = nil)
    @doubleElement = doubleElement
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}echoDoubleAttribute
#   doubleAttribute - DoubleAttribute
class EchoDoubleAttribute
  attr_accessor :doubleAttribute

  def initialize(doubleAttribute = nil)
    @doubleAttribute = doubleAttribute
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}echoDurationElement
#   durationElement - SOAP::SOAPDuration
class EchoDurationElement
  attr_accessor :durationElement

  def initialize(durationElement = nil)
    @durationElement = durationElement
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}echoDurationAttribute
#   durationAttribute - DurationAttribute
class EchoDurationAttribute
  attr_accessor :durationAttribute

  def initialize(durationAttribute = nil)
    @durationAttribute = durationAttribute
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}echoDateTimeElement
#   dateTimeElement - SOAP::SOAPDateTime
class EchoDateTimeElement
  attr_accessor :dateTimeElement

  def initialize(dateTimeElement = nil)
    @dateTimeElement = dateTimeElement
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}echoDateTimeAttribute
#   dateTimeAttribute - DateTimeAttribute
class EchoDateTimeAttribute
  attr_accessor :dateTimeAttribute

  def initialize(dateTimeAttribute = nil)
    @dateTimeAttribute = dateTimeAttribute
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}echoTimeElement
#   timeElement - SOAP::SOAPTime
class EchoTimeElement
  attr_accessor :timeElement

  def initialize(timeElement = nil)
    @timeElement = timeElement
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}echoTimeAttribute
#   timeAttribute - TimeAttribute
class EchoTimeAttribute
  attr_accessor :timeAttribute

  def initialize(timeAttribute = nil)
    @timeAttribute = timeAttribute
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}echoDateElement
#   dateElement - SOAP::SOAPDate
class EchoDateElement
  attr_accessor :dateElement

  def initialize(dateElement = nil)
    @dateElement = dateElement
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}echoDateAttribute
#   dateAttribute - DateAttribute
class EchoDateAttribute
  attr_accessor :dateAttribute

  def initialize(dateAttribute = nil)
    @dateAttribute = dateAttribute
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}echoGYearMonthElement
#   gYearMonthElement - SOAP::SOAPGYearMonth
class EchoGYearMonthElement
  attr_accessor :gYearMonthElement

  def initialize(gYearMonthElement = nil)
    @gYearMonthElement = gYearMonthElement
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}echoGYearMonthAttribute
#   gYearMonthAttribute - GYearMonthAttribute
class EchoGYearMonthAttribute
  attr_accessor :gYearMonthAttribute

  def initialize(gYearMonthAttribute = nil)
    @gYearMonthAttribute = gYearMonthAttribute
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}echoGYearElement
#   gYearElement - SOAP::SOAPGYear
class EchoGYearElement
  attr_accessor :gYearElement

  def initialize(gYearElement = nil)
    @gYearElement = gYearElement
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}echoGYearAttribute
#   gYearAttribute - GYearAttribute
class EchoGYearAttribute
  attr_accessor :gYearAttribute

  def initialize(gYearAttribute = nil)
    @gYearAttribute = gYearAttribute
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}echoGMonthDayElement
#   gMonthDayElement - SOAP::SOAPGMonthDay
class EchoGMonthDayElement
  attr_accessor :gMonthDayElement

  def initialize(gMonthDayElement = nil)
    @gMonthDayElement = gMonthDayElement
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}echoGMonthDayAttribute
#   gMonthDayAttribute - GMonthDayAttribute
class EchoGMonthDayAttribute
  attr_accessor :gMonthDayAttribute

  def initialize(gMonthDayAttribute = nil)
    @gMonthDayAttribute = gMonthDayAttribute
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}echoGDayElement
#   gDayElement - SOAP::SOAPGDay
class EchoGDayElement
  attr_accessor :gDayElement

  def initialize(gDayElement = nil)
    @gDayElement = gDayElement
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}echoGDayAttribute
#   gDayAttribute - GDayAttribute
class EchoGDayAttribute
  attr_accessor :gDayAttribute

  def initialize(gDayAttribute = nil)
    @gDayAttribute = gDayAttribute
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}echoGMonthElement
#   gMonthElement - SOAP::SOAPGMonth
class EchoGMonthElement
  attr_accessor :gMonthElement

  def initialize(gMonthElement = nil)
    @gMonthElement = gMonthElement
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}echoGMonthAttribute
#   gMonthAttribute - GMonthAttribute
class EchoGMonthAttribute
  attr_accessor :gMonthAttribute

  def initialize(gMonthAttribute = nil)
    @gMonthAttribute = gMonthAttribute
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}echoHexBinaryElement
#   hexBinaryElement - SOAP::SOAPHexBinary
class EchoHexBinaryElement
  attr_accessor :hexBinaryElement

  def initialize(hexBinaryElement = nil)
    @hexBinaryElement = hexBinaryElement
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}echoHexBinaryAttribute
#   hexBinaryAttribute - HexBinaryAttribute
class EchoHexBinaryAttribute
  attr_accessor :hexBinaryAttribute

  def initialize(hexBinaryAttribute = nil)
    @hexBinaryAttribute = hexBinaryAttribute
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}echoBase64BinaryElement
#   base64BinaryElement - SOAP::SOAPBase64
class EchoBase64BinaryElement
  attr_accessor :base64BinaryElement

  def initialize(base64BinaryElement = nil)
    @base64BinaryElement = base64BinaryElement
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}echoBase64BinaryAttribute
#   base64BinaryAttribute - Base64BinaryAttribute
class EchoBase64BinaryAttribute
  attr_accessor :base64BinaryAttribute

  def initialize(base64BinaryAttribute = nil)
    @base64BinaryAttribute = base64BinaryAttribute
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}echoAnyURIElement
#   anyURIElement - SOAP::SOAPAnyURI
class EchoAnyURIElement
  attr_accessor :anyURIElement

  def initialize(anyURIElement = nil)
    @anyURIElement = anyURIElement
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}echoAnyURIAttribute
#   anyURIAttribute - AnyURIAttribute
class EchoAnyURIAttribute
  attr_accessor :anyURIAttribute

  def initialize(anyURIAttribute = nil)
    @anyURIAttribute = anyURIAttribute
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}echoQNameElement
#   qNameElement - SOAP::SOAPQName
class EchoQNameElement
  attr_accessor :qNameElement

  def initialize(qNameElement = nil)
    @qNameElement = qNameElement
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}echoQNameAttribute
#   qNameAttribute - QNameAttribute
class EchoQNameAttribute
  attr_accessor :qNameAttribute

  def initialize(qNameAttribute = nil)
    @qNameAttribute = qNameAttribute
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}echoNormalizedStringElement
#   normalizedStringElement - SOAP::SOAPNormalizedString
class EchoNormalizedStringElement
  attr_accessor :normalizedStringElement

  def initialize(normalizedStringElement = nil)
    @normalizedStringElement = normalizedStringElement
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}echoNormalizedStringAttribute
#   normalizedStringAttribute - NormalizedStringAttribute
class EchoNormalizedStringAttribute
  attr_accessor :normalizedStringAttribute

  def initialize(normalizedStringAttribute = nil)
    @normalizedStringAttribute = normalizedStringAttribute
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}echoTokenElement
#   tokenElement - SOAP::SOAPToken
class EchoTokenElement
  attr_accessor :tokenElement

  def initialize(tokenElement = nil)
    @tokenElement = tokenElement
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}echoTokenAttribute
#   tokenAttribute - TokenAttribute
class EchoTokenAttribute
  attr_accessor :tokenAttribute

  def initialize(tokenAttribute = nil)
    @tokenAttribute = tokenAttribute
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}echoLanguageElement
#   languageElement - SOAP::SOAPLanguage
class EchoLanguageElement
  attr_accessor :languageElement

  def initialize(languageElement = nil)
    @languageElement = languageElement
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}echoLanguageAttribute
#   languageAttribute - LanguageAttribute
class EchoLanguageAttribute
  attr_accessor :languageAttribute

  def initialize(languageAttribute = nil)
    @languageAttribute = languageAttribute
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}echoNMTOKENElement
#   nMTOKENElement - SOAP::SOAPNMTOKEN
class EchoNMTOKENElement
  attr_accessor :nMTOKENElement

  def initialize(nMTOKENElement = nil)
    @nMTOKENElement = nMTOKENElement
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}echoNMTOKENAttribute
#   nMTOKENAttribute - NMTOKENAttribute
class EchoNMTOKENAttribute
  attr_accessor :nMTOKENAttribute

  def initialize(nMTOKENAttribute = nil)
    @nMTOKENAttribute = nMTOKENAttribute
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}echoNMTOKENSElement
#   nMTOKENSElement - SOAP::SOAPNMTOKENS
class EchoNMTOKENSElement
  attr_accessor :nMTOKENSElement

  def initialize(nMTOKENSElement = nil)
    @nMTOKENSElement = nMTOKENSElement
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}echoNMTOKENSAttribute
#   nMTOKENSAttribute - NMTOKENSAttribute
class EchoNMTOKENSAttribute
  attr_accessor :nMTOKENSAttribute

  def initialize(nMTOKENSAttribute = nil)
    @nMTOKENSAttribute = nMTOKENSAttribute
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}echoNameElement
#   nameElement - SOAP::SOAPName
class EchoNameElement
  attr_accessor :nameElement

  def initialize(nameElement = nil)
    @nameElement = nameElement
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}echoNameAttribute
#   nameAttribute - NameAttribute
class EchoNameAttribute
  attr_accessor :nameAttribute

  def initialize(nameAttribute = nil)
    @nameAttribute = nameAttribute
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}echoNCNameElement
#   nCNameElement - SOAP::SOAPNCName
class EchoNCNameElement
  attr_accessor :nCNameElement

  def initialize(nCNameElement = nil)
    @nCNameElement = nCNameElement
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}echoNCNameAttribute
#   nCNameAttribute - NCNameAttribute
class EchoNCNameAttribute
  attr_accessor :nCNameAttribute

  def initialize(nCNameAttribute = nil)
    @nCNameAttribute = nCNameAttribute
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}echoIDElement
#   iDElement - SOAP::SOAPID
class EchoIDElement
  attr_accessor :iDElement

  def initialize(iDElement = nil)
    @iDElement = iDElement
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}echoIDAttribute
#   iDAttribute - IDAttribute
class EchoIDAttribute
  attr_accessor :iDAttribute

  def initialize(iDAttribute = nil)
    @iDAttribute = iDAttribute
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}echoIDREFElement
#   iDREFElement - SOAP::SOAPIDREF
class EchoIDREFElement
  attr_accessor :iDREFElement

  def initialize(iDREFElement = nil)
    @iDREFElement = iDREFElement
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}echoIDREFAttribute
#   iDREFAttribute - IDREFAttribute
class EchoIDREFAttribute
  attr_accessor :iDREFAttribute

  def initialize(iDREFAttribute = nil)
    @iDREFAttribute = iDREFAttribute
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}echoIDREFSElement
#   iDREFSElement - SOAP::SOAPIDREFS
class EchoIDREFSElement
  attr_accessor :iDREFSElement

  def initialize(iDREFSElement = nil)
    @iDREFSElement = iDREFSElement
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}echoIDREFSAttribute
#   iDREFSAttribute - IDREFSAttribute
class EchoIDREFSAttribute
  attr_accessor :iDREFSAttribute

  def initialize(iDREFSAttribute = nil)
    @iDREFSAttribute = iDREFSAttribute
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}echoENTITYElement
#   eNTITYElement - SOAP::SOAPENTITY
class EchoENTITYElement
  attr_accessor :eNTITYElement

  def initialize(eNTITYElement = nil)
    @eNTITYElement = eNTITYElement
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}echoENTITYAttribute
#   eNTITYAttribute - ENTITYAttribute
class EchoENTITYAttribute
  attr_accessor :eNTITYAttribute

  def initialize(eNTITYAttribute = nil)
    @eNTITYAttribute = eNTITYAttribute
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}echoENTITIESElement
#   eNTITIESElement - SOAP::SOAPENTITIES
class EchoENTITIESElement
  attr_accessor :eNTITIESElement

  def initialize(eNTITIESElement = nil)
    @eNTITIESElement = eNTITIESElement
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}echoENTITIESAttribute
#   eNTITIESAttribute - ENTITIESAttribute
class EchoENTITIESAttribute
  attr_accessor :eNTITIESAttribute

  def initialize(eNTITIESAttribute = nil)
    @eNTITIESAttribute = eNTITIESAttribute
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}echoIntegerElement
#   integerElement - SOAP::SOAPInteger
class EchoIntegerElement
  attr_accessor :integerElement

  def initialize(integerElement = nil)
    @integerElement = integerElement
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}echoIntegerAttribute
#   integerAttribute - IntegerAttribute
class EchoIntegerAttribute
  attr_accessor :integerAttribute

  def initialize(integerAttribute = nil)
    @integerAttribute = integerAttribute
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}echoNonPositiveIntegerElement
#   nonPositiveIntegerElement - SOAP::SOAPNonPositiveInteger
class EchoNonPositiveIntegerElement
  attr_accessor :nonPositiveIntegerElement

  def initialize(nonPositiveIntegerElement = nil)
    @nonPositiveIntegerElement = nonPositiveIntegerElement
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}echoNonPositiveIntegerAttribute
#   nonPositiveIntegerAttribute - NonPositiveIntegerAttribute
class EchoNonPositiveIntegerAttribute
  attr_accessor :nonPositiveIntegerAttribute

  def initialize(nonPositiveIntegerAttribute = nil)
    @nonPositiveIntegerAttribute = nonPositiveIntegerAttribute
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}echoNegativeIntegerElement
#   negativeIntegerElement - SOAP::SOAPNegativeInteger
class EchoNegativeIntegerElement
  attr_accessor :negativeIntegerElement

  def initialize(negativeIntegerElement = nil)
    @negativeIntegerElement = negativeIntegerElement
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}echoLongElement
#   longElement - SOAP::SOAPLong
class EchoLongElement
  attr_accessor :longElement

  def initialize(longElement = nil)
    @longElement = longElement
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}echoLongAttribute
#   longAttribute - LongAttribute
class EchoLongAttribute
  attr_accessor :longAttribute

  def initialize(longAttribute = nil)
    @longAttribute = longAttribute
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}echoIntElement
#   intElement - SOAP::SOAPInt
class EchoIntElement
  attr_accessor :intElement

  def initialize(intElement = nil)
    @intElement = intElement
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}echoIntAttribute
#   intAttribute - IntAttribute
class EchoIntAttribute
  attr_accessor :intAttribute

  def initialize(intAttribute = nil)
    @intAttribute = intAttribute
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}echoShortElement
#   shortElement - SOAP::SOAPShort
class EchoShortElement
  attr_accessor :shortElement

  def initialize(shortElement = nil)
    @shortElement = shortElement
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}echoShortAttribute
#   shortAttribute - ShortAttribute
class EchoShortAttribute
  attr_accessor :shortAttribute

  def initialize(shortAttribute = nil)
    @shortAttribute = shortAttribute
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}echoByteElement
#   byteElement - SOAP::SOAPByte
class EchoByteElement
  attr_accessor :byteElement

  def initialize(byteElement = nil)
    @byteElement = byteElement
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}echoByteAttribute
#   byteAttribute - ByteAttribute
class EchoByteAttribute
  attr_accessor :byteAttribute

  def initialize(byteAttribute = nil)
    @byteAttribute = byteAttribute
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}echoNonNegativeIntegerElement
#   nonNegativeIntegerElement - SOAP::SOAPNonNegativeInteger
class EchoNonNegativeIntegerElement
  attr_accessor :nonNegativeIntegerElement

  def initialize(nonNegativeIntegerElement = nil)
    @nonNegativeIntegerElement = nonNegativeIntegerElement
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}echoNonNegativeIntegerAttribute
#   nonNegativeIntegerAttribute - NonNegativeIntegerAttribute
class EchoNonNegativeIntegerAttribute
  attr_accessor :nonNegativeIntegerAttribute

  def initialize(nonNegativeIntegerAttribute = nil)
    @nonNegativeIntegerAttribute = nonNegativeIntegerAttribute
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}echoUnsignedLongElement
#   unsignedLongElement - SOAP::SOAPUnsignedLong
class EchoUnsignedLongElement
  attr_accessor :unsignedLongElement

  def initialize(unsignedLongElement = nil)
    @unsignedLongElement = unsignedLongElement
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}echoUnsignedLongAttribute
#   unsignedLongAttribute - UnsignedLongAttribute
class EchoUnsignedLongAttribute
  attr_accessor :unsignedLongAttribute

  def initialize(unsignedLongAttribute = nil)
    @unsignedLongAttribute = unsignedLongAttribute
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}echoUnsignedIntElement
#   unsignedIntElement - SOAP::SOAPUnsignedInt
class EchoUnsignedIntElement
  attr_accessor :unsignedIntElement

  def initialize(unsignedIntElement = nil)
    @unsignedIntElement = unsignedIntElement
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}echoUnsignedIntAttribute
#   unsignedIntAttribute - UnsignedIntAttribute
class EchoUnsignedIntAttribute
  attr_accessor :unsignedIntAttribute

  def initialize(unsignedIntAttribute = nil)
    @unsignedIntAttribute = unsignedIntAttribute
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}echoUnsignedShortElement
#   unsignedShortElement - SOAP::SOAPUnsignedShort
class EchoUnsignedShortElement
  attr_accessor :unsignedShortElement

  def initialize(unsignedShortElement = nil)
    @unsignedShortElement = unsignedShortElement
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}echoUnsignedShortAttribute
#   unsignedShortAttribute - UnsignedShortAttribute
class EchoUnsignedShortAttribute
  attr_accessor :unsignedShortAttribute

  def initialize(unsignedShortAttribute = nil)
    @unsignedShortAttribute = unsignedShortAttribute
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}echoNegativeIntegerAttribute
#   negativeIntegerAttribute - NegativeIntegerAttribute
class EchoNegativeIntegerAttribute
  attr_accessor :negativeIntegerAttribute

  def initialize(negativeIntegerAttribute = nil)
    @negativeIntegerAttribute = negativeIntegerAttribute
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}echoUnsignedByteElement
#   unsignedByteElement - SOAP::SOAPUnsignedByte
class EchoUnsignedByteElement
  attr_accessor :unsignedByteElement

  def initialize(unsignedByteElement = nil)
    @unsignedByteElement = unsignedByteElement
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}echoUnsignedByteAttribute
#   unsignedByteAttribute - UnsignedByteAttribute
class EchoUnsignedByteAttribute
  attr_accessor :unsignedByteAttribute

  def initialize(unsignedByteAttribute = nil)
    @unsignedByteAttribute = unsignedByteAttribute
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}echoPositiveIntegerElement
#   positiveIntegerElement - SOAP::SOAPPositiveInteger
class EchoPositiveIntegerElement
  attr_accessor :positiveIntegerElement

  def initialize(positiveIntegerElement = nil)
    @positiveIntegerElement = positiveIntegerElement
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}echoPositiveIntegerAttribute
#   positiveIntegerAttribute - PositiveIntegerAttribute
class EchoPositiveIntegerAttribute
  attr_accessor :positiveIntegerAttribute

  def initialize(positiveIntegerAttribute = nil)
    @positiveIntegerAttribute = positiveIntegerAttribute
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}echoGlobalSimpleType
#   globalSimpleType - GlobalSimpleType
class EchoGlobalSimpleType
  attr_accessor :globalSimpleType

  def initialize(globalSimpleType = nil)
    @globalSimpleType = globalSimpleType
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}echoStringEnumerationType
#   beatle - Beatle
class EchoStringEnumerationType
  attr_accessor :beatle

  def initialize(beatle = nil)
    @beatle = beatle
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}echoNMTOKENEnumerationType
#   nMTOKENEnumerationType - NMTOKENEnumerationType
class EchoNMTOKENEnumerationType
  attr_accessor :nMTOKENEnumerationType

  def initialize(nMTOKENEnumerationType = nil)
    @nMTOKENEnumerationType = nMTOKENEnumerationType
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}echoIntEnumerationType
#   intEnumerationType - IntEnumerationType
class EchoIntEnumerationType
  attr_accessor :intEnumerationType

  def initialize(intEnumerationType = nil)
    @intEnumerationType = intEnumerationType
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}echoShortEnumerationType
#   shortEnumerationType - ShortEnumerationType
class EchoShortEnumerationType
  attr_accessor :shortEnumerationType

  def initialize(shortEnumerationType = nil)
    @shortEnumerationType = shortEnumerationType
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}echoLongEnumerationType
#   longEnumerationType - LongEnumerationType
class EchoLongEnumerationType
  attr_accessor :longEnumerationType

  def initialize(longEnumerationType = nil)
    @longEnumerationType = longEnumerationType
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}echoDoubleEnumerationType
#   doubleEnumerationType - DoubleEnumerationType
class EchoDoubleEnumerationType
  attr_accessor :doubleEnumerationType

  def initialize(doubleEnumerationType = nil)
    @doubleEnumerationType = doubleEnumerationType
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}echoIntegerEnumerationType
#   integerEnumerationType - IntegerEnumerationType
class EchoIntegerEnumerationType
  attr_accessor :integerEnumerationType

  def initialize(integerEnumerationType = nil)
    @integerEnumerationType = integerEnumerationType
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}echoDecimalEnumerationType
#   decimalEnumerationType - DecimalEnumerationType
class EchoDecimalEnumerationType
  attr_accessor :decimalEnumerationType

  def initialize(decimalEnumerationType = nil)
    @decimalEnumerationType = decimalEnumerationType
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}echoFloatEnumerationType
#   floatEnumerationType - FloatEnumerationType
class EchoFloatEnumerationType
  attr_accessor :floatEnumerationType

  def initialize(floatEnumerationType = nil)
    @floatEnumerationType = floatEnumerationType
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}echoNonNegativeIntegerEnumerationType
#   nonNegativeIntegerEnumerationType - NonNegativeIntegerEnumerationType
class EchoNonNegativeIntegerEnumerationType
  attr_accessor :nonNegativeIntegerEnumerationType

  def initialize(nonNegativeIntegerEnumerationType = nil)
    @nonNegativeIntegerEnumerationType = nonNegativeIntegerEnumerationType
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}echoPositiveIntegerEnumerationType
#   positiveIntegerEnumerationType - PositiveIntegerEnumerationType
class EchoPositiveIntegerEnumerationType
  attr_accessor :positiveIntegerEnumerationType

  def initialize(positiveIntegerEnumerationType = nil)
    @positiveIntegerEnumerationType = positiveIntegerEnumerationType
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}echoUnsignedLongEnumerationType
#   unsignedLongEnumerationType - UnsignedLongEnumerationType
class EchoUnsignedLongEnumerationType
  attr_accessor :unsignedLongEnumerationType

  def initialize(unsignedLongEnumerationType = nil)
    @unsignedLongEnumerationType = unsignedLongEnumerationType
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}echoUnsignedIntEnumerationType
#   unsignedIntEnumerationType - UnsignedIntEnumerationType
class EchoUnsignedIntEnumerationType
  attr_accessor :unsignedIntEnumerationType

  def initialize(unsignedIntEnumerationType = nil)
    @unsignedIntEnumerationType = unsignedIntEnumerationType
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}echoUnsignedShortEnumerationType
#   unsignedShortEnumerationType - UnsignedShortEnumerationType
class EchoUnsignedShortEnumerationType
  attr_accessor :unsignedShortEnumerationType

  def initialize(unsignedShortEnumerationType = nil)
    @unsignedShortEnumerationType = unsignedShortEnumerationType
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}echoTokenEnumerationType
#   tokenEnumerationType - TokenEnumerationType
class EchoTokenEnumerationType
  attr_accessor :tokenEnumerationType

  def initialize(tokenEnumerationType = nil)
    @tokenEnumerationType = tokenEnumerationType
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}echoComplexTypeSequence
#   complexTypeSequence - ComplexTypeSequence
class EchoComplexTypeSequence
  attr_accessor :complexTypeSequence

  def initialize(complexTypeSequence = nil)
    @complexTypeSequence = complexTypeSequence
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}echoComplexTypeAll
#   complexTypeAll - ComplexTypeAll
class EchoComplexTypeAll
  attr_accessor :complexTypeAll

  def initialize(complexTypeAll = nil)
    @complexTypeAll = complexTypeAll
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}echoComplexTypeChoice
#   fruit - Fruit
class EchoComplexTypeChoice
  attr_accessor :fruit

  def initialize(fruit = nil)
    @fruit = fruit
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}echoComplexTypeSequenceChoice
#   mortgage - Mortgage
class EchoComplexTypeSequenceChoice
  attr_accessor :mortgage

  def initialize(mortgage = nil)
    @mortgage = mortgage
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}echoElementMinOccurs1
#   elementMinOccurs1 - ElementMinOccurs1
class EchoElementMinOccurs1
  attr_accessor :elementMinOccurs1

  def initialize(elementMinOccurs1 = nil)
    @elementMinOccurs1 = elementMinOccurs1
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}echoElementMinOccurs2MaxOccurs2
#   itemColors2 - ItemColors2
class EchoElementMinOccurs2MaxOccurs2
  attr_accessor :itemColors2

  def initialize(itemColors2 = nil)
    @itemColors2 = itemColors2
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}echoElementMinOccurs2orMore
#   itemColors - ItemColors
class EchoElementMinOccurs2orMore
  attr_accessor :itemColors

  def initialize(itemColors = nil)
    @itemColors = itemColors
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}echoElementMaxOccurs1
#   elementMaxOccurs1 - ElementMaxOccurs1
class EchoElementMaxOccurs1
  attr_accessor :elementMaxOccurs1

  def initialize(elementMaxOccurs1 = nil)
    @elementMaxOccurs1 = elementMaxOccurs1
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}echoElementMaxOccursUnbounded
#   publications - Publications
class EchoElementMaxOccursUnbounded
  attr_accessor :publications

  def initialize(publications = nil)
    @publications = publications
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}echoElementMaxOccursFinite
#   summer - Summer
class EchoElementMaxOccursFinite
  attr_accessor :summer

  def initialize(summer = nil)
    @summer = summer
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}echoAttributeOptional
#   premium - Premium
class EchoAttributeOptional
  attr_accessor :premium

  def initialize(premium = nil)
    @premium = premium
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}echoAttributeRequired
#   discount - Discount
class EchoAttributeRequired
  attr_accessor :discount

  def initialize(discount = nil)
    @discount = discount
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}echoAttributeFixed
#   survey - Survey
class EchoAttributeFixed
  attr_accessor :survey

  def initialize(survey = nil)
    @survey = survey
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}echoElementMinOccurs0
#   elementMinOccurs0 - ElementMinOccurs0
class EchoElementMinOccurs0
  attr_accessor :elementMinOccurs0

  def initialize(elementMinOccurs0 = nil)
    @elementMinOccurs0 = elementMinOccurs0
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}echoNillableElement
#   nillableMiddleName - NillableMiddleName
class EchoNillableElement
  attr_accessor :nillableMiddleName

  def initialize(nillableMiddleName = nil)
    @nillableMiddleName = nillableMiddleName
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}echoNillableOptionalElement
#   nillableOptionalMiddleName - NillableOptionalMiddleName
class EchoNillableOptionalElement
  attr_accessor :nillableOptionalMiddleName

  def initialize(nillableOptionalMiddleName = nil)
    @nillableOptionalMiddleName = nillableOptionalMiddleName
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}echoUnionMemberTypes
#   unionMemberTypes - (any)
class EchoUnionMemberTypes
  attr_accessor :unionMemberTypes

  def initialize(unionMemberTypes = nil)
    @unionMemberTypes = unionMemberTypes
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}echoNullEnumerationType
#   nullEnumerationType - NullEnumerationType
class EchoNullEnumerationType
  attr_accessor :nullEnumerationType

  def initialize(nullEnumerationType = nil)
    @nullEnumerationType = nullEnumerationType
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}elementEmptyComplexType
class ElementEmptyComplexType
  def initialize
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}echoElementEmptyComplexType
#   elementEmptyComplexType - ElementEmptyComplexType
class EchoElementEmptyComplexType
  attr_accessor :elementEmptyComplexType

  def initialize(elementEmptyComplexType = nil)
    @elementEmptyComplexType = elementEmptyComplexType
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}elementEmptySequence
class ElementEmptySequence
  def initialize
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}echoElementEmptySequence
#   elementEmptySequence - ElementEmptySequence
class EchoElementEmptySequence
  attr_accessor :elementEmptySequence

  def initialize(elementEmptySequence = nil)
    @elementEmptySequence = elementEmptySequence
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}globalElementSequence
#   foo - SOAP::SOAPString
#   bar - SOAP::SOAPString
class GlobalElementSequence
  attr_accessor :foo
  attr_accessor :bar

  def initialize(foo = nil, bar = nil)
    @foo = foo
    @bar = bar
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}echoGlobalElementSequence
#   globalElementSequence - GlobalElementSequence
class EchoGlobalElementSequence
  attr_accessor :globalElementSequence

  def initialize(globalElementSequence = nil)
    @globalElementSequence = globalElementSequence
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}echoSequenceElementList
#   sequenceElementList - SequenceElementList
class EchoSequenceElementList
  attr_accessor :sequenceElementList

  def initialize(sequenceElementList = nil)
    @sequenceElementList = sequenceElementList
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}echoNestedSequenceElementList
#   nestedSequenceElementList - NestedSequenceElementList
class EchoNestedSequenceElementList
  attr_accessor :nestedSequenceElementList

  def initialize(nestedSequenceElementList = nil)
    @nestedSequenceElementList = nestedSequenceElementList
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}echoMixedContentType
#   mixedContentType - MixedContentType
class EchoMixedContentType
  attr_accessor :mixedContentType

  def initialize(mixedContentType = nil)
    @mixedContentType = mixedContentType
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}echoStringSimpleTypePattern
#   stringSimpleTypePattern - (any)
class EchoStringSimpleTypePattern
  attr_accessor :stringSimpleTypePattern

  def initialize(stringSimpleTypePattern = nil)
    @stringSimpleTypePattern = stringSimpleTypePattern
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}echoIntSimpleTypePattern
#   intSimpleTypePattern - (any)
class EchoIntSimpleTypePattern
  attr_accessor :intSimpleTypePattern

  def initialize(intSimpleTypePattern = nil)
    @intSimpleTypePattern = intSimpleTypePattern
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}echoIntegerSimpleTypePattern
#   integerSimpleTypePattern - (any)
class EchoIntegerSimpleTypePattern
  attr_accessor :integerSimpleTypePattern

  def initialize(integerSimpleTypePattern = nil)
    @integerSimpleTypePattern = integerSimpleTypePattern
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}echoLongSimpleTypePattern
#   longSimpleTypePattern - (any)
class EchoLongSimpleTypePattern
  attr_accessor :longSimpleTypePattern

  def initialize(longSimpleTypePattern = nil)
    @longSimpleTypePattern = longSimpleTypePattern
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}echoDecimalSimpleTypePattern
#   decimalSimpleTypePattern - (any)
class EchoDecimalSimpleTypePattern
  attr_accessor :decimalSimpleTypePattern

  def initialize(decimalSimpleTypePattern = nil)
    @decimalSimpleTypePattern = decimalSimpleTypePattern
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}echoFloatSimpleTypePattern
#   floatSimpleTypePattern - (any)
class EchoFloatSimpleTypePattern
  attr_accessor :floatSimpleTypePattern

  def initialize(floatSimpleTypePattern = nil)
    @floatSimpleTypePattern = floatSimpleTypePattern
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}echoDoubleSimpleTypePattern
#   doubleSimpleTypePattern - (any)
class EchoDoubleSimpleTypePattern
  attr_accessor :doubleSimpleTypePattern

  def initialize(doubleSimpleTypePattern = nil)
    @doubleSimpleTypePattern = doubleSimpleTypePattern
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}echoShortSimpleTypePattern
#   shortSimpleTypePattern - (any)
class EchoShortSimpleTypePattern
  attr_accessor :shortSimpleTypePattern

  def initialize(shortSimpleTypePattern = nil)
    @shortSimpleTypePattern = shortSimpleTypePattern
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}echoNonNegativeIntegerSimpleTypePattern
#   nonNegativeIntegerSimpleTypePattern - (any)
class EchoNonNegativeIntegerSimpleTypePattern
  attr_accessor :nonNegativeIntegerSimpleTypePattern

  def initialize(nonNegativeIntegerSimpleTypePattern = nil)
    @nonNegativeIntegerSimpleTypePattern = nonNegativeIntegerSimpleTypePattern
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}echoPositiveIntegerSimpleTypePattern
#   positiveIntegerSimpleTypePattern - (any)
class EchoPositiveIntegerSimpleTypePattern
  attr_accessor :positiveIntegerSimpleTypePattern

  def initialize(positiveIntegerSimpleTypePattern = nil)
    @positiveIntegerSimpleTypePattern = positiveIntegerSimpleTypePattern
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}echoUnsignedLongSimpleTypePattern
#   unsignedLongSimpleTypePattern - (any)
class EchoUnsignedLongSimpleTypePattern
  attr_accessor :unsignedLongSimpleTypePattern

  def initialize(unsignedLongSimpleTypePattern = nil)
    @unsignedLongSimpleTypePattern = unsignedLongSimpleTypePattern
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}echoUnsignedIntSimpleTypePattern
#   unsignedIntSimpleTypePattern - (any)
class EchoUnsignedIntSimpleTypePattern
  attr_accessor :unsignedIntSimpleTypePattern

  def initialize(unsignedIntSimpleTypePattern = nil)
    @unsignedIntSimpleTypePattern = unsignedIntSimpleTypePattern
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}echoUnsignedShortSimpleTypePattern
#   unsignedShortSimpleTypePattern - (any)
class EchoUnsignedShortSimpleTypePattern
  attr_accessor :unsignedShortSimpleTypePattern

  def initialize(unsignedShortSimpleTypePattern = nil)
    @unsignedShortSimpleTypePattern = unsignedShortSimpleTypePattern
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}echoDateSimpleTypePattern
#   dateSimpleTypePattern - (any)
class EchoDateSimpleTypePattern
  attr_accessor :dateSimpleTypePattern

  def initialize(dateSimpleTypePattern = nil)
    @dateSimpleTypePattern = dateSimpleTypePattern
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}echoRestrictedMinInclusive
#   restrictedMinInclusive - (any)
class EchoRestrictedMinInclusive
  attr_accessor :restrictedMinInclusive

  def initialize(restrictedMinInclusive = nil)
    @restrictedMinInclusive = restrictedMinInclusive
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}echoRestrictedMaxInclusive
#   restrictedMaxInclusive - (any)
class EchoRestrictedMaxInclusive
  attr_accessor :restrictedMaxInclusive

  def initialize(restrictedMaxInclusive = nil)
    @restrictedMaxInclusive = restrictedMaxInclusive
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}echoRestrictedLength
#   restrictedLength - (any)
class EchoRestrictedLength
  attr_accessor :restrictedLength

  def initialize(restrictedLength = nil)
    @restrictedLength = restrictedLength
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}echoRestrictedMaxLength
#   restrictedMaxLength - (any)
class EchoRestrictedMaxLength
  attr_accessor :restrictedMaxLength

  def initialize(restrictedMaxLength = nil)
    @restrictedMaxLength = restrictedMaxLength
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}echoRestrictedMinLength
#   restrictedMinLength - (any)
class EchoRestrictedMinLength
  attr_accessor :restrictedMinLength

  def initialize(restrictedMinLength = nil)
    @restrictedMinLength = restrictedMinLength
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}echoElementReference
#   customerName - CustomerName
class EchoElementReference
  attr_accessor :customerName

  def initialize(customerName = nil)
    @customerName = customerName
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}echoAttributeReference
#   clientName - ClientName
class EchoAttributeReference
  attr_accessor :clientName

  def initialize(clientName = nil)
    @clientName = clientName
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}echoAttributeElementNameClash
#   clientDetails - ClientDetails
class EchoAttributeElementNameClash
  attr_accessor :clientDetails

  def initialize(clientDetails = nil)
    @clientDetails = clientDetails
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}echoExtendedSequenceStrict
#   extendedSequenceStrict - ExtendedSequenceStrict
class EchoExtendedSequenceStrict
  attr_accessor :extendedSequenceStrict

  def initialize(extendedSequenceStrict = nil)
    @extendedSequenceStrict = extendedSequenceStrict
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}echoExtendedSequenceLax
#   extendedSequenceLax - ExtendedSequenceLax
class EchoExtendedSequenceLax
  attr_accessor :extendedSequenceLax

  def initialize(extendedSequenceLax = nil)
    @extendedSequenceLax = extendedSequenceLax
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}echoExtendedSequenceSkip
#   extendedSequenceSkip - ExtendedSequenceSkip
class EchoExtendedSequenceSkip
  attr_accessor :extendedSequenceSkip

  def initialize(extendedSequenceSkip = nil)
    @extendedSequenceSkip = extendedSequenceSkip
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}echoElementTypeDefaultNamespace
#   stringElementDefaultNamespace - SOAP::SOAPString
class EchoElementTypeDefaultNamespace
  attr_accessor :stringElementDefaultNamespace

  def initialize(stringElementDefaultNamespace = nil)
    @stringElementDefaultNamespace = stringElementDefaultNamespace
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}echoBareVector
#   bareVector - BareVector
class EchoBareVector
  attr_accessor :bareVector

  def initialize(bareVector = nil)
    @bareVector = bareVector
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}echoComplexTypeSequenceExtension
#   complexTypeSequenceExtension - ComplexTypeSequenceExtension
class EchoComplexTypeSequenceExtension
  attr_accessor :complexTypeSequenceExtension

  def initialize(complexTypeSequenceExtension = nil)
    @complexTypeSequenceExtension = complexTypeSequenceExtension
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}echoTypeSubstitutionUsingXsiType
#   assembly - Assembly
class EchoTypeSubstitutionUsingXsiType
  attr_accessor :assembly

  def initialize(assembly = nil)
    @assembly = assembly
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}echoSimpleTypeAttributes
#   simpleTypeAttributes - SimpleTypeAttributes
class EchoSimpleTypeAttributes
  attr_accessor :simpleTypeAttributes

  def initialize(simpleTypeAttributes = nil)
    @simpleTypeAttributes = simpleTypeAttributes
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}echoExtendedSimpleType
#   extendedSimpleType - ExtendedSimpleType
class EchoExtendedSimpleType
  attr_accessor :extendedSimpleType

  def initialize(extendedSimpleType = nil)
    @extendedSimpleType = extendedSimpleType
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}echoSequenceMinOccurs1
#   sequenceMinOccurs1 - SequenceMinOccurs1
class EchoSequenceMinOccurs1
  attr_accessor :sequenceMinOccurs1

  def initialize(sequenceMinOccurs1 = nil)
    @sequenceMinOccurs1 = sequenceMinOccurs1
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}echoSequenceMinOccursFinite
#   articleColors - ArticleColors
class EchoSequenceMinOccursFinite
  attr_accessor :articleColors

  def initialize(articleColors = nil)
    @articleColors = articleColors
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}echoSequenceMaxOccurs1
#   myAgeDetails - MyAgeDetails
class EchoSequenceMaxOccurs1
  attr_accessor :myAgeDetails

  def initialize(myAgeDetails = nil)
    @myAgeDetails = myAgeDetails
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}echoElementMinOccurs0MaxOccursUnbounded
#   durationList - DurationList
class EchoElementMinOccurs0MaxOccursUnbounded
  attr_accessor :durationList

  def initialize(durationList = nil)
    @durationList = durationList
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}echoSequenceMinOccurs0MaxOccursUnbounded
#   durationListSequence - DurationListSequence
class EchoSequenceMinOccurs0MaxOccursUnbounded
  attr_accessor :durationListSequence

  def initialize(durationListSequence = nil)
    @durationListSequence = durationListSequence
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}echoElementMinOccurs1MaxOccursUnbounded
#   ageList - AgeList
class EchoElementMinOccurs1MaxOccursUnbounded
  attr_accessor :ageList

  def initialize(ageList = nil)
    @ageList = ageList
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}echoSequenceMinOccurs1MaxOccursUnbounded
#   ageListSequence - AgeListSequence
class EchoSequenceMinOccurs1MaxOccursUnbounded
  attr_accessor :ageListSequence

  def initialize(ageListSequence = nil)
    @ageListSequence = ageListSequence
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}echoSequenceMaxOccursUnbounded
#   bookPublications - BookPublications
class EchoSequenceMaxOccursUnbounded
  attr_accessor :bookPublications

  def initialize(bookPublications = nil)
    @bookPublications = bookPublications
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}echoSequenceMaxOccursFinite
#   winter - Winter
class EchoSequenceMaxOccursFinite
  attr_accessor :winter

  def initialize(winter = nil)
    @winter = winter
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}echoSequenceMinOccurs0
#   sequenceMinOccurs0 - SequenceMinOccurs0
class EchoSequenceMinOccurs0
  attr_accessor :sequenceMinOccurs0

  def initialize(sequenceMinOccurs0 = nil)
    @sequenceMinOccurs0 = sequenceMinOccurs0
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}echoSequenceSequenceElement
#   sequenceSequenceElement - SequenceSequenceElement
class EchoSequenceSequenceElement
  attr_accessor :sequenceSequenceElement

  def initialize(sequenceSequenceElement = nil)
    @sequenceSequenceElement = sequenceSequenceElement
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}echoDecimalSimpleTypeTotalDigits
#   decimalSimpleTypeTotalDigits - (any)
class EchoDecimalSimpleTypeTotalDigits
  attr_accessor :decimalSimpleTypeTotalDigits

  def initialize(decimalSimpleTypeTotalDigits = nil)
    @decimalSimpleTypeTotalDigits = decimalSimpleTypeTotalDigits
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}echoDecimalSimpleTypeFractionDigits
#   decimalSimpleTypeFractionDigits - (any)
class EchoDecimalSimpleTypeFractionDigits
  attr_accessor :decimalSimpleTypeFractionDigits

  def initialize(decimalSimpleTypeFractionDigits = nil)
    @decimalSimpleTypeFractionDigits = decimalSimpleTypeFractionDigits
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}echoAttributeTypeReference
#   attributeTypeReference - AttributeTypeReference
class EchoAttributeTypeReference
  attr_accessor :attributeTypeReference

  def initialize(attributeTypeReference = nil)
    @attributeTypeReference = attributeTypeReference
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}echoElementTypeReference
#   elementTypeReference - ElementTypeReference
class EchoElementTypeReference
  attr_accessor :elementTypeReference

  def initialize(elementTypeReference = nil)
    @elementTypeReference = elementTypeReference
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}echoLocalElementComplexType
#   localElementComplexType - LocalElementComplexType
class EchoLocalElementComplexType
  attr_accessor :localElementComplexType

  def initialize(localElementComplexType = nil)
    @localElementComplexType = localElementComplexType
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}echoIdExample
#   idExample - IdExample
class EchoIdExample
  attr_accessor :idExample

  def initialize(idExample = nil)
    @idExample = idExample
  end
end

# {http://www.w3.org/2002/ws/databinding/examples/6/09/}echoAttributeGroupExample
#   attributeGroupExample - AttributeGroupExample
class EchoAttributeGroupExample
  attr_accessor :attributeGroupExample

  def initialize(attributeGroupExample = nil)
    @attributeGroupExample = attributeGroupExample
  end
end
