#
#   environment
#
. ../setenv.sh

#
#  specified patterns
#
inclusions=$1

#
#  skipped patterns
#
exclusions=$(xsltproc $EXAMPLES_DIR/exclusions.xsl toolkit.xml)

#
#  generate bespoke wsdl
#
xsltproc  \
    --stringparam exclude "$exclusions" \
    --stringparam include "$inclusions" \
    $EXAMPLES_DIR/examples2wsdl.xsl \
    $EXAMPLES_DIR/examples.xml > examples.wsdl

#
#  generate server code
#
wsdl -server -nologo -n:databinding examples.wsdl 

#
#  implement server echo methods as a .asmx
#
service="databinding.Service" 
{
         echo "<%@ WebService Language='C#'  Class='$service' %>"
         sed     -e '/----------/d'\
                 -e 's/ abstract / /' \
                 -e 's/ partial / /' \
                 -e '/CodeDom/s/^/\/\//' \
                 -e 's/1 echo/ echo/'  \
                 -e 's/\(echo[A-Za-z0-9]*\));/\1) { return \1; }/' \
	< Service.cs
} > Service.asmx

#
#  run the service:
#
xsp --port 10081
