<?xml version="1.0"?>

<xsl:stylesheet
    xmlns:xs="http://www.w3.org/2001/XMLSchema"
    xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:wsdl="http://schemas.xmlsoap.org/wsdl/" 
    version="1.0">

  <xsl:param name="lang"/>

       <xsl:output method="text"/>

	<xsl:template match="/">
	  
	  <xsl:text>
#include "soapStub.h"
#include "soapH.h"
	  </xsl:text>

	  <xsl:choose>
	    <xsl:when test="$lang = 'cpp'">
	      <xsl:apply-templates select="//wsdl:portType/wsdl:operation"
				   mode="cpp"/>
	    </xsl:when>
	    <xsl:otherwise>
	      <xsl:apply-templates select="//wsdl:portType/wsdl:operation"
				   mode="c"/>	      
	    </xsl:otherwise>
	  </xsl:choose>

	</xsl:template>

	<xsl:template match="wsdl:operation" mode="cpp">
	  <xsl:variable name="operation">
	    <xsl:value-of select="@name"/>
	  </xsl:variable>
	  <xsl:text>
int __ns1__</xsl:text><xsl:value-of select="$operation"/><xsl:text>
(soap *soap,
 _ns1__</xsl:text><xsl:value-of select="$operation"/><xsl:text>* req,
 struct __ns1__</xsl:text><xsl:value-of select="$operation"/><xsl:text>Response&amp; resp)
{
  resp.ns1__</xsl:text><xsl:value-of select="$operation"/><xsl:text> = req;
  return SOAP_OK;
}   
</xsl:text>
	</xsl:template>

	<xsl:template match="wsdl:operation" mode="c">
	  <xsl:variable name="operation">
	    <xsl:value-of select="@name"/>
	  </xsl:variable>
	  <xsl:text>
int __ns1__</xsl:text><xsl:value-of select="$operation"/><xsl:text>
(struct soap *soap,
 struct _ns1__</xsl:text><xsl:value-of select="$operation"/><xsl:text>* req,
 struct __ns1__</xsl:text><xsl:value-of select="$operation"/><xsl:text>Response* resp)
{
  resp->ns1__</xsl:text><xsl:value-of select="$operation"/><xsl:text> = req;
  return SOAP_OK;
}   
</xsl:text>
	</xsl:template>

</xsl:stylesheet>


