#!/bin/sh -e
#
#   environment
#
. ../setenv.sh

# This is assuming that gsoap's source is in the gsoap directory

EXT=${1:-c}

# Uncomment the following for:
# use DOM to populate xs:any and xsd:anyType elements
#DOM=t

GSOAPINC=${GSOAPINC:-/usr/local/include}
GSOAPLIBS=${GSOAPLIBS:-/usr/local/lib}

# Location of GSOAP *compiled* source
GSOAPSRC=/Users/ylafon/compile/gsoap-2.7/gsoap/

GSOAPIMPORT=${GSOAPSRC}/import

LINC=" -I${GSOAPSRC}"

if [ "$EXT" = "c" ]; then
    GCC=gcc
    GSOAP=${GSOAPSRC}/libgsoap.a
    WSDL2HOPT="-c"
    SOAPCPP2OPT="-c"
elif [ "$EXT" = "cpp" ]; then
    GCC=g++
    GSOAP=${GSOAPSRC}/libgsoap++.a
    WSDL2HOPT="-s"
else
    exit 1
fi

if [ ! -z "$DOM" ]; then
    GSOAPDOMOPT="-d"
    GSOAPDOM=${GSOAPSRC}/dom.${EXT}
fi


#
#  skipped patterns
#

exclusions=$(xsltproc $EXAMPLES_DIR/exclusions.xsl toolkit.xml)

#
#  generate bespoke wsdl
#
xsltproc  \
    --stringparam exclude "$exclusions" \
    $EXAMPLES_DIR/examples2wsdl.xsl \
    $EXAMPLES_DIR/examples.xml > examples.wsdl

xsltproc --stringparam lang $EXT $(dirname $0)/gsoap-server.xsl examples.wsdl > examples.$EXT

#
#  generate server code
#

WSDL2H=${GSOAPSRC}/wsdl/wsdl2h
SOAPCPP2=${GSOAPSRC}/src/soapcpp2

$WSDL2H ${WSDL2HOPT} ${GSOAPDOMOPT} examples.wsdl
$SOAPCPP2 -wx ${SOAPCPP2OPT} -I${GSOAPIMPORT} examples.h
$GCC -g -I. ${LINC} -o server $(dirname $0)/server.c examples.${EXT} soapC.${EXT} soapServer.${EXT} ${GSOAPDOM} ${GSOAP}

echo "*** ALL DONE"
