#!/usr/bin/perl

#
#  call service
#

use strict;

use LWP;
use LWP::UserAgent;
use HTTP::Request::Common;
use XML::Writer;
use IO::File;
use XML::Simple;

my $d='/Users/pauldowney/Documents/w3c/WWW/2002/ws/databinding/examples/6/05/';
my $endpoint =  'http://localhost:10080';
my $SOAPAction =  '';
my $log = "output";

sub slurp
{ 
    my ($file) = @_;
    local($/, *FH);
    open(FH, $file) or die;
    return <FH>;
}

sub makeraw
{
    my ($raw) = @_;
    $raw =~ s/<\?xml/<?xxml/;
    return $raw;
}

{
    my $output = new IO::File("> $log.xml");
    my $xml = new XML::Writer(OUTPUT => $output, UNSAFE => 1);
    my $userAgent = LWP::UserAgent->new(agent => 'databinding tester');
    $xml->startTag("report", "toolkit" => "soap4r");

    foreach my $file (<$d/*/*soap11.xml>)
    {
        my $example = $file;
        $example =~ s|.*/(\w+)/[[\w\d\.-]+$|$1|;

	print "$example\n";

	$xml->startTag('call', example => $example);

	my $message = slurp($file);

	my $request = HTTP::Request->new(POST => $endpoint);

	$request->content_type("text/xml; charset=utf-8");
	$request->header(SOAPAction => '"$SOAPAction"');

	$request->content($message);

	$xml->startTag('request');
	$xml->raw(makeraw($message));
	$xml->endTag('request');

	my $response = $userAgent->request($request);

	print $response->error_as_HTML 
	    unless $response->is_success;

	$xml->startTag('response');
	$xml->raw(makeraw($response->as_string));
	$xml->endTag('response');

	$xml->endTag('call');
    }

    $xml->endTag("report");
    $xml->end();
    $output->close();
}

exit(0);

