#!/bin/sh

. ../setenv.sh

#
#  specified patterns
#
inclusions=$1

#
#  skipped patterns
#
exclusions=$(xsltproc $EXAMPLES_DIR/exclusions.xsl toolkit.xml)

#
#  generate bespoke wsdl
#
xsltproc  \
    --stringparam exclude "$exclusions" \
    --stringparam include "$inclusions" \
    $EXAMPLES_DIR/examples2wsdl.xsl \
    $EXAMPLES_DIR/examples.xml |
    sed 's/localhost\/SoapPort/localhost:8082/' > examples.wsdl

#
#  generate server functions
#
wsdl /server /out:service.cs http://192.168.0.2/2002/ws/databinding/edcopy/toolkits/dotnet_cs_2.0.50727.42/examples.wsdl

#
#   implement echo functions
#
export service=$(awk '/: System.Web.Services.WebService {/ { print $5 }' service.cs)
{
        echo "<%@ WebService Language='C#'  Class='$service' %>"
        sed -e '/----------/d'\
	    -e 's/ abstract / /' \
	    -e 's/ partial / /' \
	    -e '/\[System.Xml.Serialization.XmlTypeAttribute(AnonymousType=true)\]/s+^+//+' \
	    -e '/CodeDom/s/^/\/\//' \
	    -e '/ echo[A-Za-z0-9_-]*(/s/;/{ return; }/'  < service.cs
    } > service.asmx

#
#   capture databinding snippits
#
# TDB ..
