<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0"
    xmlns:wsdd="http://xml.apache.org/axis/wsdd/">

    <xsl:output method="xml" indent="yes" encoding="UTF-8"/>

<xsl:template match="/">

<deployment
    xmlns="http://xml.apache.org/axis/wsdd/"
    xmlns:java="http://xml.apache.org/axis/wsdd/providers/java">

<globalConfiguration>
   <parameter name="disablePrettyXML" value="true"/>
   <parameter name="dotNetSoapEncFix" value="true"/>
   <parameter name="enableNamespacePrefixOptimization" value="false"/>
   <requestFlow>
     <handler type="java:org.apache.axis.handlers.JWSHandler">
        <parameter name="scope" value="session"/>
     </handler>
     <handler type="java:org.apache.axis.handlers.JWSHandler">
        <parameter name="scope" value="request"/>
        <parameter name="extension" value=".jwr"/>
     </handler>
   </requestFlow>

   <responseFlow>
   </responseFlow>
 </globalConfiguration>

 <handler type="java:org.apache.axis.handlers.http.URLMapper" name="URLMapper"/>
 <handler type="java:org.apache.axis.transport.local.LocalResponder" name="LocalResponder"/>
 <handler type="java:org.apache.axis.handlers.SimpleAuthenticationHandler" name="Authenticate"/>

 <transport name="http">
  <parameter name="qs:list" 
               value="org.apache.axis.transport.http.QSListHandler"/>
  <parameter name="qs:method" 
               value="org.apache.axis.transport.http.QSMethodHandler"/>
  <parameter name="qs:wsdl" 
               value="org.apache.axis.transport.http.QSWSDLHandler"/>
  <requestFlow>
   <handler type="URLMapper"/>
   <handler type="java:org.apache.axis.handlers.http.HTTPAuthHandler"/>
  </requestFlow>
 </transport>

 <transport name="local">
  <responseFlow>
   <handler type="LocalResponder"/>
  </responseFlow>
 </transport>

  <xsl:copy-of select="wsdd:deployment/wsdd:service"/>

</deployment>
</xsl:template>

</xsl:stylesheet>

