<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="2.0">
    <!-- The tab delimited document, relative to the stylesheet location or an absolute location -->
    <xsl:param name="doc" select="'example-results-invalid.txt'"/>
    <!-- The encoding for the tab delimited document -->
    <xsl:param name="enc" select="'UTF-8'"/>
    <!-- The result XML root element name -->
    <xsl:param name="root" select="'toolkit'"/>
    <!-- The result XML element name that will mark each value from the input document -->
    <xsl:param name="exclude" select="'exclude'"/>
    
    <!-- xml:id attribute on toolkit element -->    
    <xsl:param name="id" select="'axis_java_13'"/>
    <xsl:param name="name" select="'axis'"/>
    <xsl:param name="mapping" select="'java'"/>
    <xsl:param name="version" select="'1.3'"/>
    <xsl:param name="link" select="'http://ws.apache.org/axis'"/>
    <xsl:param name="content" select="'text/xml; charset=utf-8'"/>
    <xsl:param name="endpoint" select="'http://localhost:8080/databinding/services/Port'"/>
    
    <!--
        main template
    -->
    <xsl:template match="/">
<xsl:text>
</xsl:text>
        <xsl:element name="{$root}">
            <xsl:attribute name="id"><xsl:value-of select="$id"/></xsl:attribute>
            <xsl:attribute name="name"><xsl:value-of select="$name"/></xsl:attribute>
            <xsl:attribute name="mapping"><xsl:value-of select="$mapping"/></xsl:attribute>
            <xsl:attribute name="version"><xsl:value-of select="$version"/></xsl:attribute>
            <xsl:attribute name="link"><xsl:value-of select="$link"/></xsl:attribute>
            <xsl:attribute name="content"><xsl:value-of select="$content"/></xsl:attribute>
            <xsl:attribute name="endpoint"><xsl:value-of select="$endpoint"/></xsl:attribute>
    <xsl:text>
    </xsl:text>            
            <xsl:call-template name="tLines">
                <xsl:with-param name="value" select="unparsed-text($doc, $enc)"/>
            </xsl:call-template>
        </xsl:element>
    </xsl:template>
    <!--
        tokenize lines
    -->
    <xsl:template name="tLines">
        <xsl:param name="value" select="''"/>
        <xsl:analyze-string select="$value" regex="\n|\r">
            <xsl:matching-substring/>
            <xsl:non-matching-substring>
                <xsl:element name="{$exclude}">
                    <xsl:value-of select="."/>
                </xsl:element>
    <xsl:text>
    </xsl:text>
            </xsl:non-matching-substring>
        </xsl:analyze-string>
    </xsl:template>
</xsl:stylesheet> 