#!/bin/sh
#
#   include environment
#
. ./setenv.sh

echo $EXAMPLES_DIR
#
#  specified patterns
#
inclusions=$1
#inclusions=":StringElement:"

#
#  skipped patterns
#
exclusions=$(xsltproc $EXAMPLES_DIR/exclusions.xsl toolkit.xml)

#
#  generate bespoke wsdl
#
xsltproc  \
    --stringparam exclude "$exclusions" \
    --stringparam include "$inclusions" \
    $EXAMPLES_DIR/examples2wsdl.xsl \
    $EXAMPLES_DIR/examples.xml > examples.wsdl

ant -Ddbengine=adb -f build_axis2.xml delete wsdl2java

#
#  implement echo methods
#
IMP=databinding_axis2/src/databinding/ServiceSkeleton.java
mv ${IMP} ${IMP}.old

perl -nle '

    if (/^\s*org.*/) {
		$p = $_;
		@words = split(/\s+/, $p);
		$t1 = $words[2];
		$t2 = substr($t1, 0, length($t1)-1);
    }

    if (/TODO/) {
        print "        return $t2;";
    } elsif (/throw new/) {
    } elsif (/"#/) {
    } elsif (/this.getClass()/) {
    } else {
        print
    }

' < ${IMP}.old > ${IMP}

ant -Ddbengine=adb -f build_axis2.xml deploy
