/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.net.URI;
import java.net.URISyntaxException;
import java.text.Collator;
import java.text.ParseException;
import java.text.RuleBasedCollator;
import java.util.Comparator;
import java.util.Locale;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.trans.XPathException;

public class SaxonCollation
extends StyleElement {
    private String collationName;
    private Comparator collator;
    private boolean isDefault = false;

    public void prepareAttributes() throws XPathException {
        AttributeCollection attributeCollection = this.getAttributeList();
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        for (int i = 0; i < attributeCollection.getLength(); ++i) {
            int n = attributeCollection.getNameCode(i);
            String string8 = this.getNamePool().getClarkName(n);
            if (string8 == "name") {
                string = attributeCollection.getValue(i).trim();
                continue;
            }
            if (string8 == "class") {
                string2 = attributeCollection.getValue(i).trim();
                continue;
            }
            if (string8 == "strength") {
                string3 = attributeCollection.getValue(i).trim();
                continue;
            }
            if (string8 == "decomposition") {
                string4 = attributeCollection.getValue(i).trim();
                continue;
            }
            if (string8 == "lang") {
                string5 = attributeCollection.getValue(i).trim();
                continue;
            }
            if (string8 == "rules") {
                string6 = attributeCollection.getValue(i).trim();
                continue;
            }
            if (string8 == "default") {
                string7 = attributeCollection.getValue(i).trim();
                continue;
            }
            this.checkUnknownAttribute(n);
        }
        if (string != null) {
            this.collationName = string.trim();
            try {
                URI uRI = new URI(this.collationName);
                if (!uRI.isAbsolute()) {
                    URI uRI2 = new URI(this.getBaseURI());
                    uRI = uRI2.resolve(uRI);
                    this.collationName = uRI.toString();
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                this.compileError("Collation name '" + this.collationName + "' is not a valid URI");
                this.collationName = "http://www.w3.org/2005/xpath-functions/collation/codepoint";
            }
        }
        if (string2 != null) {
            if (string6 != null || string5 != null || string3 != null || string4 != null) {
                this.compileError("The class attribute cannot be combined with rules, lang, strength, or decomposition");
            }
            try {
                this.collator = this.getConfiguration().makeCollator(string2);
                return;
            }
            catch (XPathException xPathException) {
                this.collator = Collator.getInstance();
                throw xPathException;
            }
        }
        if (string6 != null) {
            if (string5 != null || string3 != null || string4 != null) {
                this.compileError("The rules attribute cannot be combined with lang, strength, or decomposition");
            }
            try {
                this.collator = new RuleBasedCollator(string6);
            }
            catch (ParseException parseException) {
                this.collator = Collator.getInstance();
                this.compileError("Invalid collation rules: " + parseException.getMessage());
            }
        }
        if (string5 != null) {
            this.collator = Collator.getInstance(Configuration.getLocale(string5));
        } else if (this.collator == null) {
            this.collator = Collator.getInstance();
        }
        if (string3 != null && this.collator instanceof Collator) {
            if (string3.equals("primary")) {
                ((Collator)this.collator).setStrength(0);
            } else if (string3.equals("secondary")) {
                ((Collator)this.collator).setStrength(1);
            } else if (string3.equals("tertiary")) {
                ((Collator)this.collator).setStrength(2);
            } else if (string3.equals("identical")) {
                ((Collator)this.collator).setStrength(3);
            } else {
                this.compileError("strength must be primary, secondary, tertiary, or identical");
            }
        }
        if (string4 != null && this.collator instanceof Collator) {
            if (string4.equals("none")) {
                ((Collator)this.collator).setDecomposition(0);
            } else if (string4.equals("standard")) {
                ((Collator)this.collator).setDecomposition(1);
            } else if (string4.equals("full")) {
                ((Collator)this.collator).setDecomposition(2);
            } else {
                this.compileError("decomposition must be none, standard, or full");
            }
        }
        if (string7 != null) {
            if (string7.equals("yes")) {
                this.isDefault = true;
            } else if (!string7.equals("no")) {
                this.compileError("default attribute must be yes or no");
            }
        }
        this.getPrincipalStylesheet().setCollation(this.collationName, this.collator, this.isDefault);
    }

    public void validate() throws XPathException {
        this.checkTopLevel(null);
        this.checkEmpty();
    }

    public Expression compile(Executable executable) throws XPathException {
        this.getPrincipalStylesheet().setCollation(this.collationName, this.collator, this.isDefault);
        executable.setReasonUnableToCompile("Cannot compile a stylesheet that uses saxon:collation (because the Java class java.text.RuleBasedCollator is not serializable)");
        return null;
    }

    public String getCollationName() {
        return this.collationName;
    }

    public boolean isDefaultCollation() {
        return this.isDefault;
    }

    public Comparator getCollator() {
        return this.collator;
    }

    public static void main(String[] stringArray) {
        System.err.println("The following locales have collations available:");
        Locale[] localeArray = Collator.getAvailableLocales();
        for (int i = 0; i < localeArray.length; ++i) {
            Locale locale = localeArray[i];
            System.err.println("Locale:" + ("".equals(locale.getCountry()) ? "" : " country='" + locale.getCountry() + "' (" + locale.getDisplayCountry() + ")") + ("".equals(locale.getLanguage()) ? "" : " language='" + locale.getLanguage() + "' (" + locale.getDisplayLanguage() + ")") + ("".equals(locale.getVariant()) ? "" : " variant='" + locale.getVariant() + "' (" + locale.getDisplayVariant() + ")"));
        }
    }
}

