/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.sort;

import java.net.URI;
import java.net.URISyntaxException;
import java.text.Collator;
import java.util.Comparator;
import java.util.Locale;
import java.util.StringTokenizer;
import net.sf.saxon.Configuration;
import net.sf.saxon.sort.CollationURIResolver;
import net.sf.saxon.trans.XPathException;

public class StandardCollationURIResolver
implements CollationURIResolver {
    private static final StandardCollationURIResolver theInstance = new StandardCollationURIResolver();

    private StandardCollationURIResolver() {
    }

    public static final StandardCollationURIResolver getInstance() {
        return theInstance;
    }

    private static Collator makeUsingProperties(String string, String string2, String string3) {
        Collator collator = string != null ? Collator.getInstance(StandardCollationURIResolver.getLocale(string)) : Collator.getInstance();
        if (string2 != null && collator instanceof Collator) {
            if (string2.equals("primary")) {
                collator.setStrength(0);
            } else if (string2.equals("secondary")) {
                collator.setStrength(1);
            } else if (string2.equals("tertiary")) {
                collator.setStrength(2);
            } else if (string2.equals("identical")) {
                collator.setStrength(3);
            }
        }
        if (string3 != null && collator instanceof Collator) {
            if (string3.equals("none")) {
                collator.setDecomposition(0);
            } else if (string3.equals("standard")) {
                collator.setDecomposition(1);
            } else if (string3.equals("full")) {
                collator.setDecomposition(2);
            }
        }
        return collator;
    }

    private static Locale getLocale(String string) {
        String string2;
        String string3;
        int n = string.indexOf("-");
        if (n < 1) {
            string3 = string;
            string2 = "";
        } else {
            string3 = string.substring(1, n);
            string2 = string.substring(n + 1);
        }
        return new Locale(string3, string2);
    }

    public Comparator resolve(String string, String string2, Configuration configuration) {
        if (string.equals("http://saxon.sf.net/collation")) {
            return StandardCollationURIResolver.makeUsingProperties(null, null, null);
        }
        if (string.startsWith("http://saxon.sf.net/collation?")) {
            URI uRI;
            try {
                uRI = new URI(string);
            }
            catch (URISyntaxException uRISyntaxException) {
                return null;
            }
            String string3 = uRI.getQuery();
            String string4 = null;
            String string5 = null;
            String string6 = null;
            String string7 = null;
            StringTokenizer stringTokenizer = new StringTokenizer(string3, ";&");
            while (stringTokenizer.hasMoreElements()) {
                String string8 = stringTokenizer.nextToken();
                int n = string8.indexOf(61);
                if (n <= 0 || n >= string8.length() - 1) continue;
                String string9 = string8.substring(0, n);
                String string10 = string8.substring(n + 1);
                if (string9.equals("lang")) {
                    string4 = string10;
                    continue;
                }
                if (string9.equals("strength")) {
                    string5 = string10;
                    continue;
                }
                if (string9.equals("decomposition")) {
                    string6 = string10;
                    continue;
                }
                if (!string9.equals("class")) continue;
                string7 = string10;
            }
            if (string7 != null) {
                try {
                    return configuration.makeCollator(string7);
                }
                catch (XPathException xPathException) {
                    return null;
                }
            }
            return StandardCollationURIResolver.makeUsingProperties(string4, string5, string6);
        }
        return null;
    }
}

