/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.om;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceDeclarations;
import net.sf.saxon.om.NamespaceResolver;

public class NamespaceResolverAsDeclarations
implements NamespaceDeclarations {
    private NamePool pool;
    private NamespaceResolver resolver;
    private List prefixes;

    public NamespaceResolverAsDeclarations(NamePool namePool, NamespaceResolver namespaceResolver) {
        this.pool = namePool;
        this.resolver = namespaceResolver;
        this.prefixes = new ArrayList(10);
        Iterator iterator = namespaceResolver.iteratePrefixes();
        while (iterator.hasNext()) {
            this.prefixes.add(iterator.next());
        }
    }

    public int getLength() {
        return this.prefixes.size();
    }

    public String getPrefix(int n) {
        return (String)this.prefixes.get(n);
    }

    public String getURI(int n) {
        return this.resolver.getURIForPrefix((String)this.prefixes.get(n), true);
    }

    public int getNamespaceCode(int n) {
        String string = this.getPrefix(n);
        String string2 = this.getURI(n);
        return this.pool.allocateNamespaceCode(string, string2);
    }

    public int[] getNamespaceCodes(int[] nArray) {
        if (nArray.length < this.getLength()) {
            nArray = new int[this.getLength()];
        }
        for (int i = 0; i < this.getLength(); ++i) {
            nArray[i] = this.getNamespaceCode(i);
        }
        return nArray;
    }
}

