/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.StaticError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.RegexTranslator;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Value;

public class Matches
extends SystemFunction {
    private Pattern regexp;

    public Expression simplify(StaticContext staticContext) throws XPathException {
        Expression expression = this.simplifyArguments(staticContext);
        if (!(expression instanceof Value)) {
            try {
                this.regexp = Matches.tryToCompile(this.argument, 1, 2);
            }
            catch (StaticError staticError) {
                staticError.setLocator(this);
                throw staticError;
            }
        }
        return expression;
    }

    public static int setFlags(CharSequence charSequence) throws StaticError {
        int n = 1;
        block6: for (int i = 0; i < charSequence.length(); ++i) {
            char c = charSequence.charAt(i);
            switch (c) {
                case 'm': {
                    n |= 8;
                    continue block6;
                }
                case 'i': {
                    n |= 2;
                    n |= 0x40;
                    continue block6;
                }
                case 's': {
                    n |= 0x20;
                    continue block6;
                }
                case 'x': {
                    n |= 4;
                    continue block6;
                }
                default: {
                    StaticError staticError = new StaticError("Invalid character '" + c + "' in regular expression flags");
                    staticError.setErrorCode("FORX0001");
                    throw staticError;
                }
            }
        }
        return n;
    }

    protected static Pattern tryToCompile(Expression[] expressionArray, int n, int n2) throws StaticError {
        if (n > expressionArray.length - 1) {
            return null;
        }
        CharSequence charSequence = null;
        if (expressionArray.length - 1 < n2) {
            charSequence = "";
        } else if (expressionArray[n2] instanceof StringValue) {
            charSequence = ((StringValue)expressionArray[n2]).getStringValueCS();
        }
        if (expressionArray[n] instanceof StringValue && charSequence != null) {
            int n3 = Matches.setFlags(charSequence);
            try {
                String string = RegexTranslator.translate(((StringValue)expressionArray[n]).getStringValueCS(), true);
                return Pattern.compile(string, n3);
            }
            catch (RegexTranslator.RegexSyntaxException regexSyntaxException) {
                StaticError staticError = new StaticError(regexSyntaxException.getMessage());
                staticError.setErrorCode("FORX0002");
                throw staticError;
            }
            catch (PatternSyntaxException patternSyntaxException) {
                StaticError staticError = new StaticError(patternSyntaxException.getMessage());
                staticError.setErrorCode("FORX0002");
                throw staticError;
            }
        }
        return null;
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        Pattern pattern;
        AtomicValue atomicValue = (AtomicValue)this.argument[0].evaluateItem(xPathContext);
        if (atomicValue == null) {
            atomicValue = StringValue.EMPTY_STRING;
        }
        if ((pattern = this.regexp) == null) {
            Object object;
            CharSequence charSequence;
            AtomicValue atomicValue2 = (AtomicValue)this.argument[1].evaluateItem(xPathContext);
            if (atomicValue2 == null) {
                return null;
            }
            if (this.argument.length == 2) {
                charSequence = "";
            } else {
                object = (AtomicValue)this.argument[2].evaluateItem(xPathContext);
                if (object == null) {
                    return null;
                }
                charSequence = ((AtomicValue)object).getStringValueCS();
            }
            try {
                object = RegexTranslator.translate(atomicValue2.getStringValueCS(), true);
                pattern = Pattern.compile((String)object, Matches.setFlags(charSequence));
            }
            catch (RegexTranslator.RegexSyntaxException regexSyntaxException) {
                DynamicError dynamicError = new DynamicError(regexSyntaxException);
                dynamicError.setErrorCode("FORX0002");
                dynamicError.setXPathContext(xPathContext);
                throw dynamicError;
            }
            catch (PatternSyntaxException patternSyntaxException) {
                DynamicError dynamicError = new DynamicError(patternSyntaxException);
                dynamicError.setErrorCode("FORX0002");
                dynamicError.setXPathContext(xPathContext);
                throw dynamicError;
            }
            catch (StaticError staticError) {
                this.dynamicError(staticError.getMessage(), staticError.getErrorCodeLocalPart(), xPathContext);
            }
        }
        return BooleanValue.get(pattern.matcher(atomicValue.getStringValueCS()).find());
    }
}

