package org.w3c.dbwg.wsdl.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Vector;

import org.apache.tools.ant.DefaultLogger;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;
import org.apache.xerces.parsers.DOMParser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class BuildWebService {

	/**
	 * Run Ant script to generate code for examples
	 */
	private static String TOOLKITS = "http://www.w3.org/2002/ws/databinding/edcopy/toolkits/";
	private static String BUILDFILESTRING = "build_webservices_from_exampleswsdl.xml";
//	private static String BUILDFILESTRING = "C:\\eclipse\\george\\workspaces\\dbwg\\TestToolkits\\scripts\\build_webservices_from_exampleswsdl.xml";
	private Vector<String> excludetests;
	
	public static void main(String[] args) {
		
		String toolkit = args[0];
		BuildWebService bws = new BuildWebService();
		bws.build(toolkit);
		
	}
	
	// build the web service
	private void build(String toolkit) {
		
		// exclude examples specified in toolkit.xml 
		System.err.println("***Build service for each example***");
		InputStream is = null;
		URL excludes = null;
		int i;

		System.err.println("*** remove excludes ");
		String excludesFile = TOOLKITS + toolkit + "/toolkit.xml";  
		try {
			excludes = new URL(excludesFile);
		} catch (MalformedURLException muex) {
			muex.printStackTrace();
			System.exit(1);
		}
		try {
			is = excludes.openStream();
		} catch (IOException ioex) {
			ioex.printStackTrace();
			System.exit(1);
		}
		DOMParser parser = new DOMParser();
		BufferedReader bf = new BufferedReader(new InputStreamReader(is));
		InputSource ins = new InputSource(bf);
		try {
			parser.parse(ins);
		} catch (org.xml.sax.SAXException saxex) {
			saxex.printStackTrace();
			System.exit(1);
		} catch (IOException ioex) {
			ioex.printStackTrace();
			System.exit(1);
		}
		Document exdoc = parser.getDocument();
		NodeList excludesNL = exdoc.getElementsByTagName("exclude");
		int totalExcludes = excludesNL.getLength();
		System.err.println("total excludes for toolkit " + toolkit + "="+ totalExcludes);
		excludetests = new Vector<String>();
		for (i = 0; i < totalExcludes; i++) {
			Element exclude = (Element) excludesNL.item(i);
			String excludeExample = exclude.getFirstChild().getNodeValue();
			excludetests.add(excludeExample);
		}
		Enumeration enumer = excludetests.elements();
		StringBuffer buf = new StringBuffer();
		// ":example::example::example:"
		while (enumer.hasMoreElements()) {
			String excludedExample = (String)enumer.nextElement();
			buf.append(":" + excludedExample + ":");
		}
		// Setup parameter to be passed to the ant build script 
		String exclude = buf.toString();
		System.err.println("Excluded examples="+exclude);
		
		// use ant script to create code, compile and create web archive
		Project project = new Project();
		project.init();
		DefaultLogger logger = new DefaultLogger();
		logger.setMessageOutputLevel(Project.MSG_INFO);
		logger.setErrorPrintStream(System.err);
		logger.setOutputPrintStream(System.out);
		project.addBuildListener(logger);
		File buildFile = new File(BUILDFILESTRING);
		ProjectHelper.configureProject(project, buildFile);
		project.setProperty("exclude", exclude); 
		try {
			project.executeTarget("init");
			// now we have examples.wsdl with exclusions
		} catch (Exception e) {
			System.err.println("Error during creation of list of examples to process:");
			System.err.println(e.getMessage());
			System.exit(1);
		}	
	}
}
