/*
 * Decompiled with CFR 0.152.
 */
package w3c.dbwg.saxon;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class SaxonTransform {
    public static final String JAXP_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    public static final String W3C_XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";
    public static final String JAXP_SCHEMA_SOURCE = "http://java.sun.com/xml/jaxp/properties/schemaSource";
    private static Document document;
    private static DocumentBuilder parser;

    public static void main(String[] stringArray) {
        Object object;
        System.setProperty("javax.xml.transform.TransformerFactory", "net.sf.saxon.TransformerFactoryImpl");
        Vector vector = new Vector();
        String string = "";
        String string2 = "";
        String string3 = "";
        boolean bl = false;
        try {
            if (stringArray.length < 4) {
                System.out.println("Please provide required parameters ");
                System.out.println("1) xml input eg mkdir-example.xml");
                System.out.println("2) and directory for output eg ../../examples/6/09");
                System.out.println("3) and the output file suffix eg -patterns.xml which results in <example>-patterns.xml");
                System.out.println("4) and the stylesheet eg patternsdetector.xsl");
                System.out.println("5) and OPTIONALLY whether schema validation is required Y or N (default N)");
                System.exit(0);
            } else {
                object = new File(stringArray[0]);
                vector = SaxonTransform.parseFile((File)object);
                string = stringArray[1];
                string2 = stringArray[2];
                string3 = stringArray[3];
            }
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            System.exit(0);
        }
        if (stringArray.length == 5) {
            object = stringArray[4];
            if (((String)(object = ((String)object).toUpperCase())).equalsIgnoreCase("validate")) {
                bl = true;
            }
        }
        object = TransformerFactory.newInstance();
        Transformer transformer = null;
        try {
            transformer = ((TransformerFactory)object).newTransformer(new StreamSource(string3));
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            System.out.println(transformerConfigurationException.getMessage());
        }
        try {
            if (bl) {
                SaxonTransform.setSchemaValidationParser();
            }
        }
        catch (ParserConfigurationException parserConfigurationException) {
            System.out.println(parserConfigurationException.getMessage());
        }
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            String string4 = (String)enumeration.nextElement();
            String string5 = string + "/" + string4 + "/" + string4 + ".xsd";
            File file = new File(string5);
            try {
                if (bl) {
                    System.out.println("Validating schema " + string4 + ".xsd");
                    SaxonTransform.validateSchema(file);
                }
                String string6 = string + "/" + string4 + "/" + string4 + string2;
                File file2 = new File(string6);
                transformer.transform(new StreamSource(string5), new StreamResult(file2));
            }
            catch (TransformerException transformerException) {
                System.out.println(transformerException.getMessage());
            }
            catch (SAXException sAXException) {
                System.out.println(sAXException.getMessage());
            }
            catch (ParserConfigurationException parserConfigurationException) {
                System.out.println(parserConfigurationException.getMessage());
            }
            catch (IOException iOException) {
                System.out.println(iOException.getMessage());
            }
            catch (Exception exception) {
                System.out.println(exception.getMessage());
            }
        }
    }

    public static Vector parseFile(File file) throws Exception, IOException, SAXException, ParserConfigurationException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setValidating(false);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        documentBuilder.setErrorHandler(new ErrorHandler(){

            public void warning(SAXParseException sAXParseException) {
                System.err.println("WARNING: " + sAXParseException.getMessage());
            }

            public void error(SAXParseException sAXParseException) {
                System.err.println("ERROR: " + sAXParseException.getMessage());
            }

            public void fatalError(SAXParseException sAXParseException) throws SAXException {
                System.err.println("FATAL: " + sAXParseException.getMessage());
                throw sAXParseException;
            }
        });
        document = documentBuilder.parse(file);
        NodeList nodeList = document.getElementsByTagName("mkdir");
        int n = nodeList.getLength();
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < n; ++i) {
            Element element = (Element)nodeList.item(i);
            if (element == null) continue;
            String string = element.getAttribute("dir");
            vector.add(string);
        }
        return vector;
    }

    public static void setSchemaValidationParser() throws ParserConfigurationException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setValidating(true);
        documentBuilderFactory.setNamespaceAware(true);
        documentBuilderFactory.setAttribute(JAXP_SCHEMA_LANGUAGE, W3C_XML_SCHEMA);
        File file = new File("XMLSchema.xsd");
        documentBuilderFactory.setAttribute(JAXP_SCHEMA_SOURCE, file);
        parser = documentBuilderFactory.newDocumentBuilder();
        parser.setErrorHandler(new ErrorHandler(){

            public void warning(SAXParseException sAXParseException) {
                System.err.println("WARNING: " + sAXParseException.getMessage() + " at line no. " + sAXParseException.getLineNumber() + " col " + sAXParseException.getColumnNumber());
            }

            public void error(SAXParseException sAXParseException) {
                System.err.println("ERROR: " + sAXParseException.getMessage() + " at line no. " + sAXParseException.getLineNumber() + " col " + sAXParseException.getColumnNumber());
            }

            public void fatalError(SAXParseException sAXParseException) throws SAXException {
                System.err.println("FATAL: " + sAXParseException.getMessage() + " at line no. " + sAXParseException.getLineNumber() + " col " + sAXParseException.getColumnNumber());
                throw sAXParseException;
            }
        });
    }

    public static void validateSchema(File file) throws Exception, IOException, SAXException {
        parser.parse(file);
    }
}

