package missing.examples;

import java.io.File;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;

import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class FindMissingExamples {

	/**
	 * @param args
	 */
	public static void main(String[] args) {
		if (args.length < 2) {
			System.err
					.println("please supply paths to examples and patterns files");
			System.exit(1);
		}
		String patternsFile = args[0];
		String examplesFile = args[1];
		try {

			DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory
					.newInstance();
			DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();

			// patterns
			Document patterns_doc = docBuilder.parse(new File(patternsFile));

			NodeList listOfPatterns = patterns_doc.getElementsByTagName("pattern");
			int totalPatterns = listOfPatterns.getLength();

			System.out.println("========PATTERNS========");
			for (int s = 0; s < listOfPatterns.getLength(); s++) {
				Node patternNode = listOfPatterns.item(s);
				NamedNodeMap patternAttrs = patternNode.getAttributes();
				Node patternId = patternAttrs.getNamedItem("pattern-id");
				System.out.println(patternId.getTextContent());
			}
			
			// examples
			Document examples_doc = docBuilder.parse(new File(examplesFile));

			NodeList listOfExamples = examples_doc.getElementsByTagName("example");
			int totalExamples = listOfExamples.getLength();

			System.out.println("========EXAMPLES========");
			for (int s = 0; s < listOfExamples.getLength(); s++) {
				Node exampleNode = listOfExamples.item(s);
				NamedNodeMap exampleAttrs = exampleNode.getAttributes();
				Node exampleId = exampleAttrs.getNamedItem("ex-id");
				System.out.println(exampleId.getTextContent());
			}
			System.out.println("Total no of patterns : " + totalPatterns);
			System.out.println("Total no of examples : " + totalExamples);

			// now iterate over the patterns and look for matching example
			System.out.println("========MATCHING PATTERNS TO EXAMPLES========");
			System.out.println("========LIST OF MISSING EXAMPLES========");
			int missing = 0;
			for (int s = 0; s < listOfPatterns.getLength(); s++) {
				Node patternNode = listOfPatterns.item(s);
				NamedNodeMap patternAttrs = patternNode.getAttributes();
				Node patternId = patternAttrs.getNamedItem("pattern-id");
				String patternToMatch = patternId.getTextContent();
				boolean found = false;
				for (int t = 0; t < listOfExamples.getLength(); t++) {
					Node exampleNode = listOfExamples.item(t);
					NamedNodeMap exampleAttrs = exampleNode.getAttributes();
					Node exampleId = exampleAttrs.getNamedItem("ex-id");
					Node pattern_exampleId = exampleAttrs.getNamedItem("pattern");
					String example =  exampleId.getTextContent();
					String pattern_example =  pattern_exampleId.getTextContent();
					if (patternToMatch.equals(example) | patternToMatch.equals(pattern_example))  {
						// found it
						found = true;
						break;
					}
				}
				if (!found) {
					missing++;
					System.out.println(patternToMatch);
				}
			}
			System.out.println("Number of missing examples = " + missing);
			
			
			
		} catch (SAXParseException err) {
			System.out.println("** Parsing error" + ", line "
					+ err.getLineNumber() + ", uri " + err.getSystemId());
			System.out.println(" " + err.getMessage());

		} catch (SAXException e) {
			Exception x = e.getException();
			((x == null) ? e : x).printStackTrace();

		} catch (Throwable t) {
			t.printStackTrace();
		}
	}

}
