/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.StringTokenizer;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.DecimalValue;
import net.sf.saxon.value.DurationValue;

public final class SecondsDurationValue
extends DurationValue
implements Comparable {
    static /* synthetic */ Class class$net$sf$saxon$value$DurationValue;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$CharSequence;
    static /* synthetic */ Class class$java$lang$Object;

    private SecondsDurationValue() {
    }

    public SecondsDurationValue(CharSequence charSequence) throws XPathException {
        StringTokenizer stringTokenizer = new StringTokenizer(((Object)SecondsDurationValue.trimWhitespace(charSequence)).toString(), "-+.PDTHMS", true);
        try {
            String string;
            if (!stringTokenizer.hasMoreElements()) {
                this.badDuration("empty string", charSequence);
            }
            if ("+".equals(string = (String)stringTokenizer.nextElement())) {
                string = (String)stringTokenizer.nextElement();
            } else if ("-".equals(string)) {
                this.negative = true;
                string = (String)stringTokenizer.nextElement();
            }
            if (!"P".equals(string)) {
                this.badDuration("missing 'P'", charSequence);
            }
            int n = 0;
            block9: while (stringTokenizer.hasMoreElements()) {
                string = (String)stringTokenizer.nextElement();
                if ("T".equals(string)) {
                    n = 4;
                    string = (String)stringTokenizer.nextElement();
                }
                int n2 = Integer.parseInt(string);
                if (!stringTokenizer.hasMoreElements()) {
                    this.badDuration("missing unit letter at end", charSequence);
                }
                char c = ((String)stringTokenizer.nextElement()).charAt(0);
                switch (c) {
                    case 'D': {
                        if (n > 2) {
                            this.badDuration("D is out of sequence", charSequence);
                        }
                        this.days = n2;
                        n = 3;
                        continue block9;
                    }
                    case 'H': {
                        if (n != 4) {
                            this.badDuration("H is out of sequence", charSequence);
                        }
                        this.hours = n2;
                        n = 5;
                        continue block9;
                    }
                    case 'M': {
                        if (n < 4 || n > 5) {
                            this.badDuration("M is out of sequence", charSequence);
                        }
                        this.minutes = n2;
                        n = 6;
                        continue block9;
                    }
                    case '.': {
                        if (n < 4 || n > 6) {
                            this.badDuration("misplaced decimal point", charSequence);
                        }
                        this.seconds = n2;
                        n = 7;
                        continue block9;
                    }
                    case 'S': {
                        if (n < 4 || n > 7) {
                            this.badDuration("S is out of sequence", charSequence);
                        }
                        if (n == 7) {
                            while (string.length() < 6) {
                                string = string + "0";
                            }
                            if (string.length() > 6) {
                                string = string.substring(0, 6);
                            }
                            this.microseconds = Integer.parseInt(string);
                        } else {
                            this.seconds = n2;
                        }
                        n = 8;
                        continue block9;
                    }
                }
                this.badDuration("misplaced " + c, charSequence);
            }
            this.normalize();
        }
        catch (NumberFormatException numberFormatException) {
            this.badDuration("non-numeric or out-of-range component", charSequence);
        }
    }

    public SecondsDurationValue(int n, int n2, int n3, int n4, int n5, int n6) {
        this.negative = n < 0;
        this.years = 0;
        this.months = 0;
        this.days = n2;
        this.hours = n3;
        this.minutes = n4;
        this.seconds = n5;
        this.microseconds = n6;
    }

    public CharSequence getStringValueCS() {
        double d = this.getLengthInSeconds();
        if (d < 0.0) {
            d = -d;
        }
        long l = (long)Math.floor(d);
        long l2 = (int)(d % 1.0 * 1000000.0);
        long l3 = l % 60L;
        long l4 = l / 60L;
        long l5 = l4 / 60L;
        l4 %= 60L;
        long l6 = l5 / 24L;
        l5 %= 24L;
        FastStringBuffer fastStringBuffer = new FastStringBuffer(32);
        if (this.negative) {
            fastStringBuffer.append('-');
        }
        fastStringBuffer.append('P');
        if (l6 != 0L) {
            fastStringBuffer.append(l6 + "D");
        }
        if (l6 == 0L || l5 != 0L || l4 != 0L || l3 != 0L || l2 != 0L) {
            fastStringBuffer.append('T');
        }
        if (l5 != 0L) {
            fastStringBuffer.append(l5 + "H");
        }
        if (l4 != 0L) {
            fastStringBuffer.append(l4 + "M");
        }
        if (l3 != 0L || l2 != 0L || l6 == 0L && l4 == 0L && l5 == 0L) {
            if (l2 == 0L) {
                fastStringBuffer.append(l3 + "S");
            } else {
                long l7 = l3 * 1000000L + l2;
                String string = l7 + "";
                if (l3 == 0L) {
                    string = "0000000" + string;
                    string = string.substring(string.length() - 7);
                }
                fastStringBuffer.append(string.substring(0, string.length() - 6));
                fastStringBuffer.append('.');
                int n = string.length() - 1;
                while (string.charAt(n) == '0') {
                    --n;
                }
                fastStringBuffer.append(string.substring(string.length() - 6, n + 1));
                fastStringBuffer.append('S');
            }
        }
        return fastStringBuffer;
    }

    public void normalize() throws DynamicError {
        long l = this.seconds;
        long l2 = this.minutes;
        long l3 = this.hours;
        long l4 = this.days;
        if (this.microseconds >= 1000000) {
            l += (long)(this.microseconds / 1000000);
            this.microseconds %= 1000000;
        }
        if (this.seconds >= 60) {
            l2 += l / 60L;
            l = (int)(l % 60L);
        }
        if (l2 >= 60L) {
            l3 += l2 / 60L;
            l2 = (int)(l2 % 60L);
        }
        if (l3 >= 24L) {
            if ((l4 += l3 / 24L) > Integer.MAX_VALUE || l4 < Integer.MIN_VALUE) {
                throw new DynamicError("Duration exceeds implementation-defined limits");
            }
            l3 = (int)(l3 % 24L);
        }
        this.days = (int)l4;
        this.hours = (int)l3;
        this.minutes = (int)l2;
        this.seconds = (int)l;
    }

    public double getLengthInSeconds() {
        double d = this.days;
        d = d * 24.0 + (double)this.hours;
        d = d * 60.0 + (double)this.minutes;
        d = d * 60.0 + (double)this.seconds;
        return this.negative ? -d : (d += (double)this.microseconds / 1000000.0);
    }

    public long getLengthInMilliseconds() {
        long l = this.days;
        l = l * 24L + (long)this.hours;
        l = l * 60L + (long)this.minutes;
        l = l * 60L + (long)this.seconds;
        l = l * 1000L + (long)(this.microseconds / 1000);
        return this.negative ? -l : l;
    }

    public long getLengthInMicroseconds() {
        long l = this.days;
        l = l * 24L + (long)this.hours;
        l = l * 60L + (long)this.minutes;
        l = l * 60L + (long)this.seconds;
        l = l * 1000000L + (long)this.microseconds;
        return this.negative ? -l : l;
    }

    public static SecondsDurationValue fromSeconds(BigDecimal bigDecimal) throws XPathException {
        SecondsDurationValue secondsDurationValue = new SecondsDurationValue();
        secondsDurationValue.negative = bigDecimal.signum() < 0;
        BigDecimal bigDecimal2 = bigDecimal.multiply(DecimalValue.ONE_MILLION);
        if (secondsDurationValue.negative) {
            bigDecimal2 = bigDecimal2.negate();
        }
        BigInteger bigInteger = bigDecimal2.toBigInteger();
        BigInteger[] bigIntegerArray = bigInteger.divideAndRemainder(BigInteger.valueOf(1000000L));
        long l = bigIntegerArray[0].longValue() * (long)(secondsDurationValue.negative ? -1 : 1);
        secondsDurationValue.days = (int)(l / 86400L);
        secondsDurationValue.seconds = (int)(l % 86400L);
        secondsDurationValue.microseconds = bigIntegerArray[1].intValue() * (secondsDurationValue.negative ? -1 : 1);
        secondsDurationValue.normalize();
        return secondsDurationValue;
    }

    public static SecondsDurationValue fromMilliseconds(long l) throws XPathException {
        SecondsDurationValue secondsDurationValue = new SecondsDurationValue();
        secondsDurationValue.negative = l < 0L;
        l = Math.abs(l);
        long l2 = l / 1000L;
        secondsDurationValue.days = (int)(l2 / 86400L);
        secondsDurationValue.seconds = (int)(l2 % 86400L);
        secondsDurationValue.microseconds = (int)(l % 1000L) * 1000;
        secondsDurationValue.normalize();
        return secondsDurationValue;
    }

    public static SecondsDurationValue fromMicroseconds(long l) throws XPathException {
        SecondsDurationValue secondsDurationValue = new SecondsDurationValue();
        secondsDurationValue.negative = l < 0L;
        l = Math.abs(l);
        long l2 = l / 1000000L;
        secondsDurationValue.days = (int)(l2 / 86400L);
        secondsDurationValue.seconds = (int)(l2 % 86400L);
        secondsDurationValue.microseconds = (int)(l % 1000000L);
        secondsDurationValue.normalize();
        return secondsDurationValue;
    }

    public DurationValue multiply(double d, XPathContext xPathContext) throws XPathException {
        double d2 = this.getLengthInMicroseconds();
        double d3 = d * d2;
        if (Double.isInfinite(d3) || d3 > 9.223372036854776E18 || d3 < -9.223372036854776E18) {
            DynamicError dynamicError = new DynamicError("Overflow when multiplying/dividing a duration by a number");
            dynamicError.setErrorCode("FODT0002");
            dynamicError.setXPathContext(xPathContext);
            throw dynamicError;
        }
        return SecondsDurationValue.fromMicroseconds((long)d3);
    }

    public DecimalValue divide(DurationValue durationValue, XPathContext xPathContext) throws XPathException {
        if (durationValue instanceof SecondsDurationValue) {
            BigDecimal bigDecimal = new BigDecimal((double)this.getLengthInMicroseconds());
            BigDecimal bigDecimal2 = new BigDecimal((double)((SecondsDurationValue)durationValue).getLengthInMicroseconds());
            return new DecimalValue(bigDecimal.divide(bigDecimal2, 20, 6));
        }
        throw new DynamicError("Cannot divide two durations of different type");
    }

    public DurationValue add(DurationValue durationValue, XPathContext xPathContext) throws XPathException {
        if (durationValue instanceof SecondsDurationValue) {
            return SecondsDurationValue.fromMicroseconds(this.getLengthInMicroseconds() + ((SecondsDurationValue)durationValue).getLengthInMicroseconds());
        }
        throw new DynamicError("Cannot add two durations of different type");
    }

    public DurationValue subtract(DurationValue durationValue, XPathContext xPathContext) throws XPathException {
        if (durationValue instanceof SecondsDurationValue) {
            return SecondsDurationValue.fromMicroseconds(this.getLengthInMicroseconds() - ((SecondsDurationValue)durationValue).getLengthInMicroseconds());
        }
        throw new DynamicError("Cannot add two durations of different type");
    }

    public int compareTo(Object object) {
        if (object instanceof SecondsDurationValue) {
            long l = this.getLengthInMicroseconds() - ((SecondsDurationValue)object).getLengthInMicroseconds();
            if (l < 0L) {
                return -1;
            }
            if (l > 0L) {
                return 1;
            }
            return 0;
        }
        throw new ClassCastException("Cannot compare a dayTimeDuration to an object of class " + object.getClass());
    }

    public ItemType getItemType(TypeHierarchy typeHierarchy) {
        return Type.DAY_TIME_DURATION_TYPE;
    }

    public Object convertToJava(Class clazz, XPathContext xPathContext) throws XPathException {
        if (clazz.isAssignableFrom(class$net$sf$saxon$value$DurationValue == null ? (class$net$sf$saxon$value$DurationValue = SecondsDurationValue.class$("net.sf.saxon.value.DurationValue")) : class$net$sf$saxon$value$DurationValue)) {
            return this;
        }
        if (clazz == (class$java$lang$String == null ? (class$java$lang$String = SecondsDurationValue.class$("java.lang.String")) : class$java$lang$String) || clazz == (class$java$lang$CharSequence == null ? (class$java$lang$CharSequence = SecondsDurationValue.class$("java.lang.CharSequence")) : class$java$lang$CharSequence)) {
            return this.getStringValue();
        }
        if (clazz == (class$java$lang$Object == null ? (class$java$lang$Object = SecondsDurationValue.class$("java.lang.Object")) : class$java$lang$Object)) {
            return this.getStringValue();
        }
        throw new DynamicError("Conversion of dayTimeDuration to " + clazz.getName() + " is not supported");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

