/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree;

import java.util.ArrayList;
import java.util.HashMap;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.ListIterator;
import net.sf.saxon.om.NameChecker;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.ElementImpl;
import net.sf.saxon.tree.LineNumberMap;
import net.sf.saxon.tree.NodeImpl;
import net.sf.saxon.tree.ParentNodeImpl;
import net.sf.saxon.tree.SystemIdMap;

public final class DocumentImpl
extends ParentNodeImpl
implements DocumentInfo {
    private ElementImpl documentElement;
    private HashMap idTable = null;
    private int documentNumber;
    private HashMap entityTable = null;
    private HashMap elementList = null;
    private Configuration config;
    private LineNumberMap lineNumberMap;
    private SystemIdMap systemIdMap = new SystemIdMap();

    public DocumentImpl() {
        this.parent = null;
    }

    public void setConfiguration(Configuration configuration) {
        this.config = configuration;
        this.documentNumber = configuration.getDocumentNumberAllocator().allocateDocumentNumber();
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public NamePool getNamePool() {
        return this.config.getNamePool();
    }

    public int getDocumentNumber() {
        return this.documentNumber;
    }

    void setDocumentElement(ElementImpl elementImpl) {
        this.documentElement = elementImpl;
    }

    public void setSystemId(String string) {
        if (string == null) {
            string = "";
        }
        this.systemIdMap.setSystemId(this.sequence, string);
    }

    public String getSystemId() {
        return this.systemIdMap.getSystemId(this.sequence);
    }

    public String getBaseURI() {
        return this.getSystemId();
    }

    void setSystemId(int n, String string) {
        if (string == null) {
            string = "";
        }
        this.systemIdMap.setSystemId(n, string);
    }

    String getSystemId(int n) {
        return this.systemIdMap.getSystemId(n);
    }

    public void setLineNumbering() {
        this.lineNumberMap = new LineNumberMap();
        this.lineNumberMap.setLineNumber(this.sequence, 0);
    }

    void setLineNumber(int n, int n2) {
        if (this.lineNumberMap != null) {
            this.lineNumberMap.setLineNumber(n, n2);
        }
    }

    int getLineNumber(int n) {
        if (this.lineNumberMap != null) {
            return this.lineNumberMap.getLineNumber(n);
        }
        return -1;
    }

    public int getLineNumber() {
        return 0;
    }

    public final int getNodeKind() {
        return 9;
    }

    public final NodeInfo getNextSibling() {
        return null;
    }

    public final NodeInfo getPreviousSibling() {
        return null;
    }

    public ElementImpl getDocumentElement() {
        return this.documentElement;
    }

    public NodeInfo getRoot() {
        return this;
    }

    public DocumentInfo getDocumentRoot() {
        return this;
    }

    public String generateId() {
        return "d" + this.documentNumber;
    }

    AxisIterator getAllElements(int n) {
        ArrayList<NodeImpl> arrayList;
        Integer n2 = new Integer(n);
        if (this.elementList == null) {
            this.elementList = new HashMap(500);
        }
        if ((arrayList = (ArrayList<NodeImpl>)this.elementList.get(n2)) == null) {
            arrayList = new ArrayList<NodeImpl>(500);
            for (NodeImpl nodeImpl = this.getNextInDocument(this); nodeImpl != null; nodeImpl = nodeImpl.getNextInDocument(this)) {
                if (nodeImpl.getNodeKind() != 1 || nodeImpl.getFingerprint() != n) continue;
                arrayList.add(nodeImpl);
            }
            this.elementList.put(n2, arrayList);
        }
        return new ListIterator(arrayList);
    }

    private void indexIDs() {
        NodeImpl nodeImpl;
        if (this.idTable != null) {
            return;
        }
        this.idTable = new HashMap(256);
        NameChecker nameChecker = this.getConfiguration().getNameChecker();
        DocumentImpl documentImpl = nodeImpl = this;
        while (nodeImpl != null) {
            if (nodeImpl.getNodeKind() == 1) {
                ElementImpl elementImpl = (ElementImpl)nodeImpl;
                AttributeCollection attributeCollection = elementImpl.getAttributeList();
                for (int i = 0; i < attributeCollection.getLength(); ++i) {
                    if (!attributeCollection.isId(i) || !nameChecker.isValidNCName(attributeCollection.getValue(i).trim())) continue;
                    this.registerID(elementImpl, attributeCollection.getValue(i).trim());
                }
            }
            nodeImpl = nodeImpl.getNextInDocument(documentImpl);
        }
    }

    private void registerID(NodeInfo nodeInfo, String string) {
        Object v = this.idTable.get(string);
        if (v == null) {
            this.idTable.put(string, nodeInfo);
        }
    }

    public NodeInfo selectID(String string) {
        if (this.idTable == null) {
            this.indexIDs();
        }
        return (NodeInfo)this.idTable.get(string);
    }

    void setUnparsedEntity(String string, String string2, String string3) {
        if (this.entityTable == null) {
            this.entityTable = new HashMap(10);
        }
        String[] stringArray = new String[]{string2, string3};
        this.entityTable.put(string, stringArray);
    }

    public String[] getUnparsedEntity(String string) {
        if (this.entityTable == null) {
            return null;
        }
        return (String[])this.entityTable.get(string);
    }

    public void copy(Receiver receiver, int n, boolean bl, int n2) throws XPathException {
        receiver.startDocument(0);
        for (NodeImpl nodeImpl = (NodeImpl)this.getFirstChild(); nodeImpl != null; nodeImpl = (NodeImpl)nodeImpl.getNextSibling()) {
            nodeImpl.copy(receiver, n, bl, n2);
        }
        receiver.endDocument();
    }
}

