/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.sort;

import net.sf.saxon.expr.LastPositionFinder;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.sort.FixedSortKeyDefinition;
import net.sf.saxon.sort.GroupIterator;
import net.sf.saxon.sort.SortedIterator;
import net.sf.saxon.trace.InstructionInfoProvider;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AtomicValue;

public class SortedGroupIterator
extends SortedIterator
implements GroupIterator {
    private InstructionInfoProvider origin;

    public SortedGroupIterator(XPathContext xPathContext, GroupIterator groupIterator, FixedSortKeyDefinition[] fixedSortKeyDefinitionArray, InstructionInfoProvider instructionInfoProvider) throws XPathException {
        super(xPathContext, groupIterator, fixedSortKeyDefinitionArray);
        this.origin = instructionInfoProvider;
        this.recordSize += 2;
    }

    protected void buildArray() throws XPathException {
        Item item;
        int n = (this.base.getProperties() & 2) != 0 ? ((LastPositionFinder)this.base).getLastPosition() : 100;
        this.nodeKeys = new Object[n * this.recordSize];
        this.count = 0;
        XPathContextMajor xPathContextMajor = this.context.newContext();
        xPathContextMajor.setCurrentIterator(this.base);
        xPathContextMajor.setOrigin(this.origin);
        xPathContextMajor.setCurrentGroupIterator((GroupIterator)this.base);
        while ((item = this.base.next()) != null) {
            if (this.count == n) {
                Object[] objectArray = new Object[(n *= 2) * this.recordSize];
                System.arraycopy(this.nodeKeys, 0, objectArray, 0, this.count * this.recordSize);
                this.nodeKeys = objectArray;
            }
            int n2 = this.count * this.recordSize;
            this.nodeKeys[n2] = item;
            for (int i = 0; i < this.sortkeys.length; ++i) {
                this.nodeKeys[n2 + i + 1] = this.sortkeys[i].getSortKey().evaluateItem(xPathContextMajor);
            }
            this.nodeKeys[n2 + this.sortkeys.length + 1] = new Integer(this.count);
            this.nodeKeys[n2 + this.sortkeys.length + 2] = ((GroupIterator)this.base).getCurrentGroupingKey();
            this.nodeKeys[n2 + this.sortkeys.length + 3] = ((GroupIterator)this.base).iterateCurrentGroup();
            ++this.count;
        }
    }

    public AtomicValue getCurrentGroupingKey() {
        return (AtomicValue)this.nodeKeys[(this.index - 1) * this.recordSize + this.sortkeys.length + 2];
    }

    public SequenceIterator iterateCurrentGroup() throws XPathException {
        SequenceIterator sequenceIterator = (SequenceIterator)this.nodeKeys[(this.index - 1) * this.recordSize + this.sortkeys.length + 3];
        return sequenceIterator.getAnother();
    }
}

