/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.sort;

import java.io.Serializable;
import java.util.Iterator;
import net.sf.saxon.sort.IntIterator;

public class IntHashMap
implements Serializable {
    private static final int NBIT = 30;
    private static final int NMAX = 0x40000000;
    private double _factor;
    private int _nmax;
    private int _n;
    private int _nlo;
    private int _nhi;
    private int _shift;
    private int _mask;
    private int[] _key;
    private Object[] _value;

    public IntHashMap() {
        this(8, 0.25);
    }

    public IntHashMap(int n) {
        this(n, 0.25);
    }

    public IntHashMap(int n, double d) {
        this._factor = d;
        this.setCapacity(n);
    }

    public void clear() {
        this._n = 0;
        for (int i = 0; i < this._nmax; ++i) {
            this._value[i] = null;
        }
    }

    public Object get(int n) {
        return this._value[this.indexOf(n)];
    }

    public int size() {
        return this._n;
    }

    public boolean remove(int n) {
        int n2 = this.indexOf(n);
        if (this._value[n2] == null) {
            return false;
        }
        --this._n;
        while (true) {
            int n3;
            this._value[n2] = null;
            int n4 = n2;
            do {
                if (this._value[n2 = n2 - 1 & this._mask] != null) continue;
                return true;
            } while (n2 <= (n3 = this.hash(this._key[n2])) && n3 < n4 || n3 < n4 && n4 < n2 || n4 < n2 && n2 <= n3);
            this._key[n4] = this._key[n2];
            this._value[n4] = this._value[n2];
        }
    }

    public void put(int n, Object object) {
        if (object == null) {
            throw new NullPointerException("IntHashMap does not allow null values");
        }
        int n2 = this.indexOf(n);
        if (this._value[n2] != null) {
            this._value[n2] = object;
        } else {
            this._key[n2] = n;
            this._value[n2] = object;
            this.grow();
        }
    }

    private int hash(int n) {
        return 1327217885 * n >> this._shift & this._mask;
    }

    private int indexOf(int n) {
        int n2 = this.hash(n);
        while (this._value[n2] != null) {
            if (this._key[n2] == n) {
                return n2;
            }
            n2 = n2 - 1 & this._mask;
        }
        return n2;
    }

    private void grow() {
        ++this._n;
        if (this._n > 0x40000000) {
            throw new RuntimeException("number of keys mapped exceeds 1073741824");
        }
        if (this._nlo < this._n && this._n <= this._nhi) {
            this.setCapacity(this._n);
        }
    }

    private void setCapacity(int n) {
        int n2;
        if (n < this._n) {
            n = this._n;
        }
        double d = this._factor < 0.01 ? 0.01 : (this._factor > 0.99 ? 0.99 : this._factor);
        int n3 = 1;
        for (n2 = 2; (double)n2 * d < (double)n && n2 < 0x40000000; n2 *= 2) {
            ++n3;
        }
        int n4 = this._nmax;
        if (n2 == n4) {
            return;
        }
        this._nmax = n2;
        this._nlo = (int)((double)n2 * d);
        this._nhi = (int)(1.073741824E9 * d);
        this._shift = 31 - n3;
        this._mask = n2 - 1;
        int[] nArray = this._key;
        Object[] objectArray = this._value;
        this._n = 0;
        this._key = new int[n2];
        this._value = new Object[n2];
        if (nArray != null) {
            for (int i = 0; i < n4; ++i) {
                if (objectArray[i] == null) continue;
                this.put(nArray[i], objectArray[i]);
            }
        }
    }

    public IntIterator keyIterator() {
        return new IntHashMapKeyIterator();
    }

    public Iterator valueIterator() {
        return new IntHashMapValueIterator();
    }

    public IntHashMap copy() {
        IntHashMap intHashMap = new IntHashMap(this.size());
        IntIterator intIterator = this.keyIterator();
        while (intIterator.hasNext()) {
            int n = intIterator.next();
            intHashMap.put(n, this.get(n));
        }
        return intHashMap;
    }

    private class IntHashMapValueIterator
    implements Iterator,
    Serializable {
        private IntHashMapKeyIterator k;

        public IntHashMapValueIterator() {
            this.k = new IntHashMapKeyIterator();
        }

        public boolean hasNext() {
            return this.k.hasNext();
        }

        public Object next() {
            return IntHashMap.this.get(this.k.next());
        }

        public void remove() {
            throw new UnsupportedOperationException("remove() is not supported on IntHashMapValueIterator");
        }
    }

    private class IntHashMapKeyIterator
    implements IntIterator,
    Serializable {
        private int i = 0;

        public boolean hasNext() {
            while (this.i < IntHashMap.this._key.length) {
                if (IntHashMap.this._value[this.i] != null) {
                    return true;
                }
                ++this.i;
            }
            return false;
        }

        public int next() {
            return IntHashMap.this._key[this.i++];
        }
    }
}

