/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.pattern;

import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.tinytree.TinyTree;
import net.sf.saxon.type.AnySimpleType;
import net.sf.saxon.type.SchemaType;

public class NodeKindTest
extends NodeTest {
    public static final NodeKindTest DOCUMENT = new NodeKindTest(9);
    public static final NodeKindTest ELEMENT = new NodeKindTest(1);
    public static final NodeKindTest ATTRIBUTE = new NodeKindTest(2);
    public static final NodeKindTest TEXT = new NodeKindTest(3);
    public static final NodeKindTest COMMENT = new NodeKindTest(8);
    public static final NodeKindTest PROCESSING_INSTRUCTION = new NodeKindTest(7);
    public static final NodeKindTest NAMESPACE = new NodeKindTest(13);
    private int kind;

    private NodeKindTest(int n) {
        this.kind = n;
    }

    public static NodeTest makeNodeKindTest(int n) {
        switch (n) {
            case 9: {
                return DOCUMENT;
            }
            case 1: {
                return ELEMENT;
            }
            case 2: {
                return ATTRIBUTE;
            }
            case 8: {
                return COMMENT;
            }
            case 3: {
                return TEXT;
            }
            case 7: {
                return PROCESSING_INSTRUCTION;
            }
            case 13: {
                return NAMESPACE;
            }
            case 0: {
                return AnyNodeTest.getInstance();
            }
        }
        throw new IllegalArgumentException("Unknown node kind in NodeKindTest");
    }

    public boolean matches(int n, int n2, int n3) {
        return this.kind == n;
    }

    public boolean matches(TinyTree tinyTree, int n) {
        return tinyTree.getNodeKind(n) == this.kind;
    }

    public boolean matches(NodeInfo nodeInfo) {
        return nodeInfo.getNodeKind() == this.kind;
    }

    public final double getDefaultPriority() {
        return -0.5;
    }

    public int getPrimitiveType() {
        return this.kind;
    }

    public int getNodeKindMask() {
        return 1 << this.kind;
    }

    public SchemaType getContentType() {
        if (this.kind == 2) {
            return AnySimpleType.getInstance();
        }
        return super.getContentType();
    }

    public String toString() {
        return NodeKindTest.toString(this.kind);
    }

    public static String toString(int n) {
        switch (n) {
            case 9: {
                return "document-node()";
            }
            case 1: {
                return "element()";
            }
            case 2: {
                return "attribute()";
            }
            case 8: {
                return "comment()";
            }
            case 3: {
                return "text()";
            }
            case 7: {
                return "processing-instruction()";
            }
            case 13: {
                return "namespace()";
            }
        }
        return "** error **";
    }

    public int hashCode() {
        return this.kind;
    }

    public boolean equals(Object object) {
        return object instanceof NodeKindTest && ((NodeKindTest)object).kind == this.kind;
    }
}

