/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.functions.XSLTFunction;
import net.sf.saxon.instruct.RegexIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.StringValue;

public class RegexGroup
extends SystemFunction
implements XSLTFunction {
    public Expression preEvaluate(StaticContext staticContext) {
        return this;
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        AtomicValue atomicValue = (AtomicValue)this.argument[0].evaluateItem(xPathContext);
        NumericValue numericValue = (NumericValue)atomicValue.getPrimitiveValue();
        RegexIterator regexIterator = xPathContext.getCurrentRegexIterator();
        if (regexIterator == null) {
            return null;
        }
        String string = regexIterator.getRegexGroup((int)numericValue.longValue());
        if (string == null) {
            return null;
        }
        return StringValue.makeStringValue(string);
    }

    public int getIntrinsicDependencies() {
        return 64;
    }
}

