/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.io.File;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Comparator;
import javax.xml.transform.TransformerException;
import net.sf.saxon.Err;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.sort.AtomicComparer;
import net.sf.saxon.sort.CodepointCollator;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.StaticError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Value;

public abstract class CollatingFunction
extends SystemFunction {
    private Comparator collation = null;
    protected XPathContext conversionContext;
    private URI expressionBaseURI = null;

    public void checkArguments(StaticContext staticContext) throws XPathException {
        try {
            String string = staticContext.getBaseURI();
            if (string == null) {
                string = this.getCurrentDirectory();
            }
            if (string != null) {
                this.expressionBaseURI = new URI(string);
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            StaticError staticError = new StaticError("The base URI " + Err.wrap(staticContext.getBaseURI(), 7) + " is not a valid URI");
            staticError.setLocator(this);
            throw staticError;
        }
        super.checkArguments(staticContext);
    }

    private String getCurrentDirectory() {
        String string;
        try {
            string = System.getProperty("user.dir");
        }
        catch (Exception exception) {
            return null;
        }
        if (!string.endsWith("/")) {
            string = string + '/';
        }
        try {
            URL uRL = new File(string).toURL();
            return uRL.toString();
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public Expression preEvaluate(StaticContext staticContext) throws XPathException {
        if (this.getNumberOfArguments() == this.getDetails().maxArguments) {
            Serializable serializable;
            String string = ((Value)this.argument[this.getNumberOfArguments() - 1]).getStringValue();
            try {
                URI uRI = new URI(string);
                if (!uRI.isAbsolute()) {
                    serializable = new URI(staticContext.getBaseURI());
                    uRI = ((URI)serializable).resolve(uRI);
                    string = uRI.toString();
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                StaticError staticError = new StaticError("Collation name '" + string + "' is not a valid URI");
                staticError.setErrorCode("FOCH0002");
                staticError.setLocator(this);
                throw staticError;
            }
            this.collation = staticContext.getCollation(string);
            if (this.collation == null) {
                serializable = new StaticError("Unknown collation " + Err.wrap(string, 7));
                ((XPathException)serializable).setErrorCode("FOCH0002");
                ((TransformerException)serializable).setLocator(this);
                throw serializable;
            }
            return super.preEvaluate(staticContext);
        }
        String string = staticContext.getDefaultCollationName();
        this.collation = staticContext.getCollation(string);
        return super.preEvaluate(staticContext);
    }

    protected AtomicComparer getAtomicComparer(int n, XPathContext xPathContext) throws XPathException {
        return new AtomicComparer(this.getCollator(n, xPathContext), xPathContext == null ? this.conversionContext : xPathContext);
    }

    protected Comparator getCollator(int n, XPathContext xPathContext) throws XPathException {
        if (this.collation != null) {
            return this.collation;
        }
        int n2 = this.argument.length;
        if (n2 > n) {
            AtomicValue atomicValue = (AtomicValue)this.argument[n].evaluateItem(xPathContext);
            StringValue stringValue = (StringValue)atomicValue.getPrimitiveValue();
            String string = stringValue.getStringValue();
            try {
                URI uRI = new URI(string);
                if (!uRI.isAbsolute()) {
                    if (this.expressionBaseURI == null) {
                        DynamicError dynamicError = new DynamicError("Cannot resolve relative collation URI '" + string + "': unknown base URI");
                        dynamicError.setErrorCode("FOCH0002");
                        dynamicError.setXPathContext(xPathContext);
                        dynamicError.setLocator(this);
                        throw dynamicError;
                    }
                    uRI = this.expressionBaseURI.resolve(uRI);
                    string = uRI.toString();
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                DynamicError dynamicError = new DynamicError("Collation name '" + string + "' is not a valid URI");
                dynamicError.setErrorCode("FOCH0002");
                dynamicError.setXPathContext(xPathContext);
                dynamicError.setLocator(this);
                throw dynamicError;
            }
            return xPathContext.getCollation(string);
        }
        Comparator comparator = xPathContext.getDefaultCollation();
        return comparator == null ? CodepointCollator.getInstance() : comparator;
    }
}

