/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.BinaryExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.LastPositionFinder;
import net.sf.saxon.expr.Optimizer;
import net.sf.saxon.expr.ReversibleIterator;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.TypeChecker;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.EmptyIterator;
import net.sf.saxon.om.GroundedIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.LookaheadIterator;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.IntegerRange;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.Value;

public class RangeExpression
extends BinaryExpression {
    public RangeExpression(Expression expression, int n, Expression expression2) {
        super(expression, n, expression2);
    }

    public Expression typeCheck(StaticContext staticContext, ItemType itemType) throws XPathException {
        this.operand0 = this.operand0.typeCheck(staticContext, itemType);
        this.operand1 = this.operand1.typeCheck(staticContext, itemType);
        RoleLocator roleLocator = new RoleLocator(1, "to", 0, null);
        roleLocator.setSourceLocator(this);
        this.operand0 = TypeChecker.staticTypeCheck(this.operand0, SequenceType.OPTIONAL_INTEGER, false, roleLocator, staticContext);
        RoleLocator roleLocator2 = new RoleLocator(1, "to", 1, null);
        roleLocator2.setSourceLocator(this);
        this.operand1 = TypeChecker.staticTypeCheck(this.operand1, SequenceType.OPTIONAL_INTEGER, false, roleLocator2, staticContext);
        return this;
    }

    public Expression optimize(Optimizer optimizer, StaticContext staticContext, ItemType itemType) throws XPathException {
        this.operand0 = this.operand0.optimize(optimizer, staticContext, itemType);
        this.operand1 = this.operand1.optimize(optimizer, staticContext, itemType);
        if (this.operand0 instanceof IntegerValue && this.operand1 instanceof IntegerValue) {
            long l;
            long l2 = ((IntegerValue)this.operand0).longValue();
            if (l2 > (l = ((IntegerValue)this.operand1).longValue())) {
                return EmptySequence.getInstance();
            }
            return new IntegerRange(l2, l);
        }
        return this;
    }

    public ItemType getItemType(TypeHierarchy typeHierarchy) {
        return Type.INTEGER_TYPE;
    }

    public int computeCardinality() {
        return 57344;
    }

    public SequenceIterator iterate(XPathContext xPathContext) throws XPathException {
        AtomicValue atomicValue = (AtomicValue)this.operand0.evaluateItem(xPathContext);
        if (atomicValue == null) {
            return new EmptyIterator();
        }
        NumericValue numericValue = (NumericValue)atomicValue.getPrimitiveValue();
        AtomicValue atomicValue2 = (AtomicValue)this.operand1.evaluateItem(xPathContext);
        if (atomicValue2 == null) {
            return new EmptyIterator();
        }
        NumericValue numericValue2 = (NumericValue)atomicValue2.getPrimitiveValue();
        if (numericValue.compareTo(numericValue2) > 0) {
            return new EmptyIterator();
        }
        return new RangeIterator(numericValue.longValue(), numericValue2.longValue());
    }

    public static class RangeIterator
    implements SequenceIterator,
    ReversibleIterator,
    LastPositionFinder,
    LookaheadIterator,
    GroundedIterator {
        long start;
        long currentValue;
        int increment;
        long limit;

        public RangeIterator(long l, long l2) {
            this.start = l;
            this.increment = l <= l2 ? 1 : -1;
            this.currentValue = l;
            this.limit = l2;
        }

        public boolean hasNext() {
            if (this.increment > 0) {
                return this.currentValue <= this.limit;
            }
            if (this.increment < 0) {
                return this.currentValue >= this.limit;
            }
            return false;
        }

        public Item next() {
            if (!this.hasNext()) {
                this.increment = 0;
                return null;
            }
            long l = this.currentValue;
            this.currentValue += (long)this.increment;
            return new IntegerValue(l);
        }

        public Item current() {
            if (this.increment == 0) {
                return null;
            }
            return new IntegerValue(this.currentValue - (long)this.increment);
        }

        public int position() {
            if (this.increment > 0) {
                return (int)(this.currentValue - this.start);
            }
            if (this.increment < 0) {
                return (int)(this.start - this.currentValue);
            }
            return -1;
        }

        public int getLastPosition() {
            return (int)((this.limit - this.start) * (long)this.increment + 1L);
        }

        public SequenceIterator getAnother() throws XPathException {
            return new RangeIterator(this.start, this.limit);
        }

        public int getProperties() {
            int n = 6;
            if (this.increment == 1) {
                n |= 1;
            }
            return n;
        }

        public SequenceIterator getReverseIterator() {
            return new RangeIterator(this.limit, this.start);
        }

        public Value materialize() throws XPathException {
            if (this.increment == 1) {
                return new IntegerRange(this.start, this.limit);
            }
            return new SequenceExtent(this.getAnother());
        }
    }
}

