/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon;

import java.io.File;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import net.sf.saxon.AugmentedSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.Err;
import net.sf.saxon.NonDelegatingURIResolver;
import net.sf.saxon.event.IDFilter;
import net.sf.saxon.functions.URIQueryParameters;
import net.sf.saxon.om.AllElementStripper;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class StandardURIResolver
implements NonDelegatingURIResolver,
Serializable {
    private Configuration config = null;
    protected boolean recognizeQueryParameters = false;

    public StandardURIResolver() {
        this(null);
    }

    public StandardURIResolver(Configuration configuration) {
        this.config = configuration;
    }

    public void setRecognizeQueryParameters(boolean bl) {
        this.recognizeQueryParameters = bl;
    }

    public boolean queryParametersAreRecognized() {
        return this.recognizeQueryParameters;
    }

    public Source resolve(String string, String string2) throws XPathException {
        Integer n;
        URI uRI;
        String string3 = string;
        String string4 = null;
        int n2 = string.indexOf(35);
        if (n2 >= 0) {
            string3 = string.substring(0, n2);
            string4 = string.substring(n2 + 1);
        }
        URIQueryParameters uRIQueryParameters = null;
        try {
            string3 = StandardURIResolver.escapeSpaces(string3);
            uRI = new URI(string3);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new DynamicError("Invalid relative URI " + Err.wrap(string3), uRISyntaxException);
        }
        String string5 = uRI.getQuery();
        if (string5 != null && this.recognizeQueryParameters) {
            uRIQueryParameters = new URIQueryParameters(string5, this.config);
            int n3 = string3.indexOf(63);
            string3 = string3.substring(0, n3);
        }
        Source source = null;
        if (this.recognizeQueryParameters && string3.endsWith(".ptree")) {
            source = this.getPTreeSource(string3, string2);
        }
        if (source == null) {
            XMLReader xMLReader;
            URI uRI2;
            try {
                uRI2 = StandardURIResolver.makeAbsolute(string3, string2);
            }
            catch (URISyntaxException uRISyntaxException) {
                String string6 = StandardURIResolver.tryToExpand(string2);
                if (!string6.equals(string2)) {
                    return this.resolve(string, string6);
                }
                throw new DynamicError("Invalid URI " + Err.wrap(string3) + " - base " + Err.wrap(string2), uRISyntaxException);
            }
            source = new SAXSource();
            ((SAXSource)source).setInputSource(new InputSource(uRI2.toString()));
            source.setSystemId(uRI2.toString());
            if (uRIQueryParameters != null && (xMLReader = uRIQueryParameters.getXMLReader()) != null) {
                ((SAXSource)source).setXMLReader(xMLReader);
            }
            if (((SAXSource)source).getXMLReader() == null && this.config == null) {
                try {
                    ((SAXSource)source).setXMLReader(SAXParserFactory.newInstance().newSAXParser().getXMLReader());
                }
                catch (Exception exception) {
                    throw new DynamicError(exception);
                }
            }
        }
        if (uRIQueryParameters != null) {
            int n4 = uRIQueryParameters.getStripSpace();
            switch (n4) {
                case 12: {
                    AllElementStripper allElementStripper = AllElementStripper.getInstance();
                    allElementStripper.setStripAll();
                    source = AugmentedSource.makeAugmentedSource(source);
                    ((AugmentedSource)source).addFilter(allElementStripper);
                    break;
                }
                case 10: 
                case 11: {
                    source = AugmentedSource.makeAugmentedSource(source);
                    ((AugmentedSource)source).setStripSpace(n4);
                }
            }
        }
        if (string4 != null) {
            IDFilter iDFilter = new IDFilter(string4);
            source = AugmentedSource.makeAugmentedSource(source);
            ((AugmentedSource)source).addFilter(iDFilter);
        }
        if (uRIQueryParameters != null && (n = uRIQueryParameters.getValidationMode()) != null) {
            source = AugmentedSource.makeAugmentedSource(source);
            ((AugmentedSource)source).setSchemaValidationMode(n);
        }
        return source;
    }

    public static URI makeAbsolute(String string, String string2) throws DynamicError, URISyntaxException {
        URI uRI;
        string = StandardURIResolver.escapeSpaces(string);
        string2 = StandardURIResolver.escapeSpaces(string2);
        try {
            if (string2 == null) {
                String string3;
                uRI = new URI(string);
                if (!uRI.isAbsolute() && !(string3 = StandardURIResolver.tryToExpand(string2)).equals(string2)) {
                    return StandardURIResolver.makeAbsolute(string, string3);
                }
            } else {
                URI uRI2 = new URI(string2);
                uRI = string.length() == 0 ? uRI2 : uRI2.resolve(string);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new DynamicError("Invalid URI " + Err.wrap(string) + " - base " + Err.wrap(string2));
        }
        return uRI;
    }

    public static String escapeSpaces(String string) {
        if (string == null) {
            return string;
        }
        int n = string.indexOf(32);
        if (n < 0) {
            return string;
        }
        return (n == 0 ? "" : string.substring(0, n)) + "%20" + (n == string.length() - 1 ? "" : StandardURIResolver.escapeSpaces(string.substring(n + 1)));
    }

    public static String tryToExpand(String string) {
        if (string == null) {
            string = "";
        }
        try {
            new URL(string);
            return string;
        }
        catch (MalformedURLException malformedURLException) {
            String string2;
            try {
                string2 = System.getProperty("user.dir");
            }
            catch (Exception exception) {
                return string;
            }
            if (!string2.endsWith("/") && !string.startsWith("/")) {
                string2 = string2 + '/';
            }
            try {
                URL uRL = new File(string2).toURL();
                URL uRL2 = new URL(uRL, string);
                return uRL2.toString();
            }
            catch (MalformedURLException malformedURLException2) {
                return string;
            }
        }
    }

    protected Source getPTreeSource(String string, String string2) throws XPathException {
        return null;
    }
}

