#!/usr/bin/perl -w
#
#  fetch logs from remote machines
#

use strict;
use logs;

{
    print "creating Makefile.logs\n";
    open(FILE, "> Makefile.logs");
    print FILE "# generated by fetchlogs.pl\n";
    print FILE 'LOGFILES=\\';

    my $sep = "\n    ";

    foreach my $n (@logs::files)
    {
	my $raw = $n->{raw};
	print FILE "$sep$raw";
        $sep = "\\\n    ";
    }
    print FILE "\n";
    close(FILE);
}

{
    foreach my $n (@logs::files)
    {
	my $source = $n->{source};
	my $client = $n->{client};
	my $server = $n->{server};
	my $href = $n->{href};
	my $raw = $n->{raw};
        my $tmp = "tmp.xml";


        if ($n->{format} eq 'missing')
	{
	    print  "missing $raw\n";
	    open(FILE, "> $tmp");
	    print FILE '<l:log xmlns:l="http://www.w3.org/2002/ws/addressing/logs/"/>';
	    close(FILE);
	}
        else
        {
	    print  "fetching $href\n";
	    `curl -s $href > $tmp`;
	}

  	if (-s $tmp) {
	    if ((! -s $raw) || `cmp $tmp $raw`) {
	    print  "saving as $raw\n";
	    `mv $tmp $raw`;
	    }
	}
	else 
	{
	    print "empty\n";
	}
	`rm -f $tmp`;
    }
}



exit (0);
