/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.tree;

import com.icl.saxon.om.NodeInfo;
import com.icl.saxon.output.Outputter;
import com.icl.saxon.tree.AttributeCollection;
import com.icl.saxon.tree.ElementImpl;
import com.icl.saxon.tree.NodeImpl;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;

final class AttributeImpl
extends NodeImpl
implements Attr {
    private int nameCode;
    private String value;

    public AttributeImpl(ElementImpl elementImpl, int n) {
        this.parent = elementImpl;
        this.index = n;
        AttributeCollection attributeCollection = elementImpl.getAttributeList();
        this.nameCode = attributeCollection.getNameCode(n);
        this.value = attributeCollection.getValue(n);
    }

    public int getNameCode() {
        return this.nameCode;
    }

    public boolean isSameNode(NodeInfo nodeInfo) {
        if (!(nodeInfo instanceof AttributeImpl)) {
            return false;
        }
        if (this == nodeInfo) {
            return true;
        }
        AttributeImpl attributeImpl = (AttributeImpl)nodeInfo;
        return this.parent.isSameNode(attributeImpl.parent) && (this.nameCode & 0xFFFFF) == (attributeImpl.nameCode & 0xFFFFF);
    }

    protected long getSequenceNumber() {
        return this.parent.getSequenceNumber() + 32768L + (long)this.index;
    }

    public final short getNodeType() {
        return 2;
    }

    public String getStringValue() {
        return this.value;
    }

    public Node getNextSibling() {
        return null;
    }

    public Node getPreviousSibling() {
        return null;
    }

    public NodeImpl getPreviousInDocument() {
        return (NodeImpl)this.getParent();
    }

    public NodeImpl getNextInDocument(NodeImpl nodeImpl) {
        return ((NodeImpl)this.getParent()).getNextInDocument(nodeImpl);
    }

    public String generateId() {
        return this.parent.generateId() + "_" + this.getDisplayName();
    }

    public void copy(Outputter outputter) throws TransformerException {
        int n = this.getNameCode();
        if ((n >> 20 & 0xFF) != 0) {
            n = outputter.checkAttributePrefix(n);
        }
        outputter.writeAttribute(n, this.getStringValue());
    }
}

