<!-- ======================================================================= -->
<!-- SMIL Linking Module  ================================================== -->
<!-- file: SMIL-link.mod

     This is SMIL 2.0.
     Copyright 2000 W3C (MIT, INRIA, Keio), All Rights Reserved.

        Author:     Jacco van Ossenbruggen, Lloyd Rutledge, Aaron Cohen
        Revision:   $Id: SMIL-link.mod,v 1.17 2000/10/23 11:55:51 jvanoss Exp $

     This DTD module is identified by the PUBLIC and SYSTEM identifiers:

     PUBLIC "-//W3C//ELEMENTS SMIL 2.0 Linking//EN"
     SYSTEM "SMIL-link.mod"

     ======================================================================= -->

<!-- ======================== LinkingAttributes Entities =================== -->
<!ENTITY % linking-attrs "
	sourceLevel             CDATA               '100&#37;'
	destinationLevel        CDATA               '100&#37;'
	sourcePlaystate         (play|pause|stop)   #IMPLIED
	destinationPlaystate    (play|pause|stop)   'play'
	show                    (new|pause|replace) 'replace'
	accesskey               %Character.datatype; #IMPLIED
	target                  CDATA                #IMPLIED
	external                (true|false)        'false'
	actuate                 (onRequest|onLoad)  'onRequest'
	%Tabindex.attrib;
">



<!-- ========================= BasicLinking Elements ======================= -->
<!ENTITY % BasicLinking.module "IGNORE">
<![%BasicLinking.module;[

  <!-- ======================= BasicLinking Entities ======================= -->
  <!ENTITY % Shape "(rect|circle|poly|default)">
  <!ENTITY % Coords "CDATA">
    <!-- comma separated list of lengths -->

  <!ENTITY % a.attrib  "">
  <!ENTITY % a.content "EMPTY">
  <!ENTITY % a.qname   "a">
  <!ELEMENT %a.qname; %a.content;>
  <!ATTLIST %a.qname; %a.attrib;
    %linking-attrs;
    href                      %URI.datatype;      #IMPLIED
    %Core.attrib;
    %I18n.attrib;
  >

  <!ENTITY % area.attrib  "">
  <!ENTITY % area.content "EMPTY">
  <!ENTITY % area.qname   "area">
  <!ELEMENT %area.qname; %area.content;>
  <!ATTLIST %area.qname; %area.attrib;
    %linking-attrs;
    shape                     %Shape;             'rect'
    coords                    %Coords;            #IMPLIED
    href                      %URI.datatype;      #IMPLIED
    nohref                    (nohref)            #IMPLIED
    %Core.attrib;
    %I18n.attrib;
  >

  <!ENTITY % anchor.attrib  "">
  <!ENTITY % anchor.content "EMPTY">
  <!ENTITY % anchor.qname  "anchor">
  <!ELEMENT %anchor.qname; %anchor.content;>
  <!ATTLIST %anchor.qname; %anchor.attrib;
    %linking-attrs;
    shape                     %Shape;             'rect'
    coords                    %Coords;            #IMPLIED
    href                      %URI.datatype;               #IMPLIED
    nohref                    (nohref)            #IMPLIED
    %Core.attrib;
    %I18n.attrib;
  >
]]> <!-- end of BasicLinking -->

<!-- ======================== ObjectLinking ================================ -->
<!ENTITY % ObjectLinking.module "IGNORE">
<![%ObjectLinking.module;[

  <!ENTITY % Fragment "
    fragment                  CDATA               #IMPLIED
  ">

  <!-- ====================== ObjectLinking Elements ======================= -->
  <!-- add fragment attribute to area, and anchor elements -->
  <!ATTLIST %area.qname;
      %Fragment;
  >

  <!ATTLIST %anchor.qname;
      %Fragment;
  >
]]>
<!-- ======================== End ObjectLinking ============================ -->

<!-- end of SMIL-link.mod -->
