/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.IsaViz;

import com.xerox.VTM.svg.SVGReader;
import java.awt.Color;
import java.util.StringTokenizer;
import org.w3c.IsaViz.GraphStylesheet;
import org.w3c.IsaViz.Utils;

public class Style {
    public static short CSS_FONT_WEIGHT_NORMAL = 0;
    public static short CSS_FONT_WEIGHT_BOLD = 1;
    public static short CSS_FONT_WEIGHT_BOLDER = (short)2;
    public static short CSS_FONT_WEIGHT_LIGHTER = (short)3;
    public static short CSS_FONT_WEIGHT_100 = (short)4;
    public static short CSS_FONT_WEIGHT_200 = (short)5;
    public static short CSS_FONT_WEIGHT_300 = (short)6;
    public static short CSS_FONT_WEIGHT_400 = 0;
    public static short CSS_FONT_WEIGHT_500 = (short)7;
    public static short CSS_FONT_WEIGHT_600 = (short)8;
    public static short CSS_FONT_WEIGHT_700 = 1;
    public static short CSS_FONT_WEIGHT_800 = (short)9;
    public static short CSS_FONT_WEIGHT_900 = (short)10;
    public static short CSS_FONT_STYLE_NORMAL = 0;
    public static short CSS_FONT_STYLE_ITALIC = 1;
    public static short CSS_FONT_STYLE_OBLIQUE = (short)2;
    String styleID;
    protected Color fill;
    protected Color stroke;
    protected Float strokeWidth;
    protected String fontFamily;
    protected Integer fontSize;
    protected Short fontWeight;
    protected Short fontStyle;
    public static Integer ELLIPSE = new Integer(0);
    public static Integer RECTANGLE = new Integer(1);
    public static Integer CIRCLE = new Integer(2);
    public static Integer DIAMOND = new Integer(3);
    public static Integer OCTAGON = new Integer(4);
    public static Integer TRIANGLEN = new Integer(5);
    public static Integer TRIANGLES = new Integer(6);
    public static Integer TRIANGLEE = new Integer(7);
    public static Integer TRIANGLEW = new Integer(8);
    public static Integer CUSTOM_SHAPE = new Integer(9);
    protected Integer shape;
    protected float[] vertices;
    protected Float orientation;

    public Style(String string) {
        this.styleID = string;
    }

    public void setFill(Object object) {
        if (object != null) {
            if (object instanceof String) {
                this.fill = SVGReader.getColor((String)((String)object));
            } else if (object instanceof Color) {
                this.fill = (Color)object;
            }
        } else {
            this.fill = null;
        }
    }

    Color getFill() {
        return this.fill;
    }

    public void setStroke(Object object) {
        if (object != null) {
            if (object instanceof String) {
                this.stroke = SVGReader.getColor((String)((String)object));
            } else if (object instanceof Color) {
                this.stroke = (Color)object;
            }
        } else {
            this.stroke = null;
        }
    }

    public Color getStroke() {
        return this.stroke;
    }

    public void setStrokeWidth(String string) {
        if (string != null && string.length() > 0) {
            if (string.endsWith("px")) {
                string = string.substring(0, string.length() - 2);
            }
            try {
                this.strokeWidth = new Float(string);
            }
            catch (NumberFormatException numberFormatException) {
                this.strokeWidth = null;
            }
        } else {
            this.strokeWidth = null;
        }
    }

    public Float getStrokeWidth() {
        return this.strokeWidth;
    }

    public void setFontFamily(String string) {
        this.fontFamily = string != null && string.length() > 0 ? string : null;
    }

    public String getFontFamily() {
        return this.fontFamily;
    }

    public void setFontSize(String string) {
        if (string != null && string.length() > 0) {
            if (string.endsWith("pt")) {
                string = string.substring(0, string.length() - 2);
            }
            try {
                this.fontSize = new Integer(string);
            }
            catch (NumberFormatException numberFormatException) {
                this.fontSize = null;
            }
        } else {
            this.fontSize = null;
        }
    }

    public Integer getFontSize() {
        return this.fontSize;
    }

    public void setFontWeight(String string) {
        String string2;
        this.fontWeight = string != null && string.length() > 0 ? ((string2 = string.toLowerCase()).equals("normal") || string2.equals("400") ? new Short(CSS_FONT_WEIGHT_NORMAL) : (string2.equals("bold") || string2.equals("700") ? new Short(CSS_FONT_WEIGHT_BOLD) : (string2.equals("bolder") ? new Short(CSS_FONT_WEIGHT_BOLDER) : (string2.equals("lighter") ? new Short(CSS_FONT_WEIGHT_LIGHTER) : (string2.equals("100") ? new Short(CSS_FONT_WEIGHT_100) : (string2.equals("200") ? new Short(CSS_FONT_WEIGHT_200) : (string2.equals("300") ? new Short(CSS_FONT_WEIGHT_300) : (string2.equals("500") ? new Short(CSS_FONT_WEIGHT_500) : (string2.equals("600") ? new Short(CSS_FONT_WEIGHT_600) : (string2.equals("800") ? new Short(CSS_FONT_WEIGHT_800) : (string2.equals("900") ? new Short(CSS_FONT_WEIGHT_900) : null))))))))))) : null;
    }

    public Short getFontWeight() {
        return this.fontWeight;
    }

    public void setFontStyle(String string) {
        String string2;
        this.fontStyle = string != null && string.length() > 0 ? ((string2 = string.toLowerCase()).equals("normal") ? new Short(CSS_FONT_STYLE_NORMAL) : (string2.equals("italic") ? new Short(CSS_FONT_STYLE_ITALIC) : (string2.equals("oblique") ? new Short(CSS_FONT_STYLE_OBLIQUE) : null))) : null;
    }

    public Short getFontStyle() {
        return this.fontStyle;
    }

    public void setPredefShape(String string) {
        if (string.equals(GraphStylesheet._gssEllipse)) {
            this.shape = ELLIPSE;
        } else if (string.equals(GraphStylesheet._gssRectangle)) {
            this.shape = RECTANGLE;
        } else if (string.equals(GraphStylesheet._gssCircle)) {
            this.shape = CIRCLE;
        } else if (string.equals(GraphStylesheet._gssDiamond)) {
            this.shape = DIAMOND;
        } else if (string.equals(GraphStylesheet._gssOctagon)) {
            this.shape = OCTAGON;
        } else if (string.equals(GraphStylesheet._gssTriangleN)) {
            this.shape = TRIANGLEN;
        } else if (string.equals(GraphStylesheet._gssTriangleS)) {
            this.shape = TRIANGLES;
        } else if (string.equals(GraphStylesheet._gssTriangleE)) {
            this.shape = TRIANGLEE;
        } else if (string.equals(GraphStylesheet._gssTriangleW)) {
            this.shape = TRIANGLEW;
        }
    }

    public void setCustomShape(String string) {
        float[] fArray = null;
        if (string.indexOf("[") != -1 && string.indexOf("]") != -1) {
            String string2 = string.substring(string.indexOf("[") + 1, string.indexOf("]"));
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
            int n = stringTokenizer.countTokens();
            if (n >= 3) {
                fArray = new float[n];
                int n2 = 0;
                try {
                    while (stringTokenizer.hasMoreTokens()) {
                        fArray[n2] = Float.parseFloat(stringTokenizer.nextToken());
                        if (fArray[n2] < 0.0f || fArray[n2] > 1.0f) {
                            System.err.println("Error:Style.setCustomShape: " + fArray[n2] + " is not in range [0.0,1.0] in " + string);
                            break;
                        }
                        ++n2;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    System.err.println("Error:Style.setCustomShape: bad float format in " + string2);
                }
                this.vertices = fArray;
                this.shape = CUSTOM_SHAPE;
                String string3 = null;
                if (string.lastIndexOf("]") < string.length() - 1 && !Utils.isWhiteSpaceCharsOnly(string3 = string.substring(string.lastIndexOf("]") + 1))) {
                    try {
                        this.orientation = new Float(string3);
                    }
                    catch (NumberFormatException numberFormatException) {
                        System.err.println("Error:Style.setCustomShape: " + string3 + " in " + string + " is not a well formed orientation value");
                    }
                }
            } else {
                System.err.println("Error:Style.setCustomShape: " + n + " is inferior to the minimum amount of vertices required for a shape (3)");
            }
        }
    }

    Integer getShape() {
        return this.shape;
    }

    float[] getVertexList() {
        return this.vertices;
    }

    Float getShapeOrient() {
        return this.orientation;
    }

    public String toString() {
        String string = "";
        string = string + "ID=" + this.styleID + "\n";
        if (this.fill != null) {
            string = string + "\tfill=" + this.fill.toString() + "\n";
        }
        if (this.stroke != null) {
            string = string + "\tstroke=" + this.stroke.toString() + "\n";
        }
        if (this.strokeWidth != null) {
            string = string + "\tstroke width=" + this.strokeWidth.toString() + "\n";
        }
        if (this.fontFamily != null) {
            string = string + "\tfont family=" + this.fontFamily + "\n";
        }
        if (this.fontWeight != null) {
            string = string + "\tfont weight=" + this.fontWeight.toString() + "\n";
        }
        if (this.fontStyle != null) {
            string = string + "\tfont style=" + this.fontStyle.toString() + "\n";
        }
        if (this.fontSize != null) {
            string = string + "\tfont size=" + this.fontSize.toString() + "\n";
        }
        if (this.shape != null) {
            string = string + "\tshape=" + this.shape.toString();
        }
        return string;
    }
}

