/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.IsaViz;

import com.hp.hpl.jena.datatypes.RDFDatatype;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import org.w3c.IsaViz.ConfigManager;
import org.w3c.IsaViz.Editor;
import org.w3c.IsaViz.ILiteral;
import org.w3c.IsaViz.INode;
import org.w3c.IsaViz.IProperty;
import org.w3c.IsaViz.IResource;
import org.w3c.IsaViz.Utils;

class PropsPanel
extends JFrame {
    Editor application;
    JPanel mainPanel;
    JTextComponent tc;

    PropsPanel(Editor editor, int n, int n2, int n3, int n4) {
        this.application = editor;
        Container container = this.getContentPane();
        this.mainPanel = new JPanel();
        container.add(this.mainPanel);
        WindowAdapter windowAdapter = new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                Editor cfr_ignored_0 = PropsPanel.this.application;
                Editor.cmp.showPropsMn.setSelected(false);
            }

            public void windowActivated(WindowEvent windowEvent) {
                PropsPanel.this.application.alwaysUpdateViews(true);
            }
        };
        this.addWindowListener(windowAdapter);
        this.setTitle("Attributes");
        this.pack();
        this.setLocation(n, n2);
        this.setSize(n3, n4);
    }

    void updateDisplay(INode iNode) {
        if (iNode instanceof IResource) {
            this.showResourceProps((IResource)iNode);
        } else if (iNode instanceof ILiteral) {
            this.showLiteralProps((ILiteral)iNode);
        } else if (iNode instanceof IProperty) {
            this.showPropertyProps((IProperty)iNode);
        }
    }

    void reset() {
        this.mainPanel.removeAll();
        this.paintAll(this.getGraphics());
    }

    void showResourceProps(final IResource iResource) {
        if (iResource != null) {
            final JRadioButton jRadioButton = new JRadioButton("URI");
            final JRadioButton jRadioButton2 = new JRadioButton("ID");
            final JCheckBox jCheckBox = new JCheckBox("bnode", iResource.isAnon());
            String string = iResource.getIdent();
            this.tc = new JTextField(string.startsWith(Editor.BASE_URI) ? string.substring(Editor.BASE_URI.length(), string.length()) : string);
            this.tc.setFont(Editor.swingFont);
            final JButton jButton = new JButton("Delete");
            final JButton jButton2 = new JButton("Show Properties");
            final JLabel jLabel = new JLabel(" ");
            ActionListener actionListener = new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (actionEvent.getSource() == jButton) {
                        PropsPanel.this.application.deleteSelectedEntities();
                        PropsPanel.this.reset();
                    } else if (actionEvent.getSource() == jRadioButton) {
                        jLabel.setText(" ");
                        this.checkAndUpdateResource();
                    } else if (actionEvent.getSource() == jRadioButton2) {
                        jLabel.setText("Base URI=" + Editor.BASE_URI);
                        this.checkAndUpdateResource();
                    } else if (actionEvent.getSource() == jButton2) {
                        PropsPanel.this.application.displayResOutgoingPredicates(iResource);
                    } else if (actionEvent.getSource() == jCheckBox) {
                        if (jCheckBox.isSelected()) {
                            jLabel.setText(" ");
                            PropsPanel.this.tc.setEnabled(false);
                            jRadioButton.setEnabled(false);
                            jRadioButton2.setEnabled(false);
                            PropsPanel.this.application.makeAnonymous(iResource);
                            String string = iResource.getIdent();
                            PropsPanel.this.tc.setText(iResource.getIdent());
                        } else {
                            PropsPanel.this.tc.setText("");
                            PropsPanel.this.tc.setEnabled(true);
                            jRadioButton.setEnabled(true);
                            jRadioButton.setSelected(true);
                            jRadioButton2.setEnabled(true);
                        }
                    }
                }

                void checkAndUpdateResource() {
                    if (PropsPanel.this.tc.getText().length() > 0) {
                        if (!PropsPanel.this.tc.getText().startsWith(Editor.ANON_NODE)) {
                            PropsPanel.this.application.changeResourceURI(iResource, PropsPanel.this.tc.getText(), jRadioButton.isSelected());
                            String string = iResource.getIdent();
                            PropsPanel.this.tc.setText(string.startsWith(Editor.BASE_URI) ? string.substring(Editor.BASE_URI.length(), string.length()) : string);
                        } else {
                            Editor cfr_ignored_0 = PropsPanel.this.application;
                            JOptionPane.showMessageDialog(Editor.propsp, Editor.ANON_NODE + " is reserved for anonymous nodes.");
                        }
                    } else {
                        Editor cfr_ignored_1 = PropsPanel.this.application;
                        JOptionPane.showMessageDialog(Editor.propsp, "You must provide an identifier.\nIf you want to make the resource anonymous, use the above checkbox.");
                    }
                }
            };
            KeyListener keyListener = new KeyListener(){

                public void keyPressed(KeyEvent keyEvent) {
                    if (keyEvent.getKeyCode() == 10 && keyEvent.getSource() == PropsPanel.this.tc) {
                        if (PropsPanel.this.tc.getText().length() > 0) {
                            if (!PropsPanel.this.tc.getText().startsWith(Editor.ANON_NODE)) {
                                if (jRadioButton.isSelected()) {
                                    String string = PropsPanel.this.tc.getText();
                                    if (ConfigManager.ALLOW_PFX_IN_TXTFIELDS) {
                                        string = PropsPanel.this.application.tryToSolveBinding(string);
                                    }
                                    PropsPanel.this.application.changeResourceURI(iResource, string, true);
                                    PropsPanel.this.tc.setText(iResource.getIdent());
                                } else {
                                    PropsPanel.this.application.changeResourceURI(iResource, PropsPanel.this.tc.getText(), false);
                                    String string = iResource.getIdent();
                                    PropsPanel.this.tc.setText(string.startsWith(Editor.BASE_URI) ? string.substring(Editor.BASE_URI.length(), string.length()) : string);
                                }
                            } else {
                                Editor cfr_ignored_0 = PropsPanel.this.application;
                                JOptionPane.showMessageDialog(Editor.propsp, Editor.ANON_NODE + " is reserved for anonymous nodes.");
                            }
                        } else {
                            Editor cfr_ignored_1 = PropsPanel.this.application;
                            JOptionPane.showMessageDialog(Editor.propsp, "You must provide an identifier.\nIf you want to make the resource anonymous, use the above checkbox.");
                        }
                    }
                }

                public void keyReleased(KeyEvent keyEvent) {
                }

                public void keyTyped(KeyEvent keyEvent) {
                }
            };
            this.mainPanel.removeAll();
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            this.mainPanel.setLayout(gridBagLayout);
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 17;
            ButtonGroup buttonGroup = new ButtonGroup();
            this.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 34, 3);
            gridBagLayout.setConstraints(jRadioButton, gridBagConstraints);
            this.mainPanel.add(jRadioButton);
            buttonGroup.add(jRadioButton);
            this.buildConstraints(gridBagConstraints, 1, 0, 1, 1, 33, 0);
            gridBagLayout.setConstraints(jRadioButton2, gridBagConstraints);
            this.mainPanel.add(jRadioButton2);
            buttonGroup.add(jRadioButton2);
            if (!Utils.isWhiteSpaceCharsOnly(Editor.BASE_URI)) {
                if (iResource.getIdent().startsWith(Editor.BASE_URI)) {
                    jRadioButton2.setSelected(true);
                    jLabel.setText("Base URI=" + Editor.BASE_URI);
                } else {
                    jRadioButton.setSelected(true);
                }
            } else if (iResource.getIdent().startsWith("#")) {
                jRadioButton2.setSelected(true);
                jLabel.setText("Base URI=" + Editor.BASE_URI);
            } else {
                jRadioButton.setSelected(true);
            }
            jRadioButton.addActionListener(actionListener);
            jRadioButton2.addActionListener(actionListener);
            gridBagConstraints.anchor = 13;
            jCheckBox.addActionListener(actionListener);
            this.buildConstraints(gridBagConstraints, 2, 0, 1, 1, 33, 0);
            gridBagLayout.setConstraints(jCheckBox, gridBagConstraints);
            this.mainPanel.add(jCheckBox);
            gridBagConstraints.anchor = 10;
            gridBagConstraints.fill = 1;
            this.buildConstraints(gridBagConstraints, 0, 1, 3, 1, 100, 3);
            gridBagLayout.setConstraints(jLabel, gridBagConstraints);
            this.mainPanel.add(jLabel);
            gridBagConstraints.fill = 2;
            this.tc.addKeyListener(keyListener);
            this.buildConstraints(gridBagConstraints, 0, 2, 3, 1, 100, 3);
            gridBagLayout.setConstraints(this.tc, gridBagConstraints);
            this.mainPanel.add(this.tc);
            if (iResource.isAnon()) {
                this.tc.setEnabled(false);
                jRadioButton.setEnabled(false);
                jRadioButton2.setEnabled(false);
            }
            jButton.addActionListener(actionListener);
            this.buildConstraints(gridBagConstraints, 0, 3, 3, 1, 100, 3);
            gridBagLayout.setConstraints(jButton, gridBagConstraints);
            this.mainPanel.add(jButton);
            jButton2.addActionListener(actionListener);
            this.buildConstraints(gridBagConstraints, 0, 4, 3, 1, 100, 3);
            gridBagLayout.setConstraints(jButton2, gridBagConstraints);
            this.mainPanel.add(jButton2);
            gridBagConstraints.fill = 1;
            JPanel jPanel = new JPanel();
            this.buildConstraints(gridBagConstraints, 0, 5, 3, 1, 100, 88);
            gridBagLayout.setConstraints(jPanel, gridBagConstraints);
            this.mainPanel.add(jPanel);
            this.paintAll(this.getGraphics());
        }
    }

    void showLiteralProps(final ILiteral iLiteral) {
        if (iLiteral != null) {
            final JCheckBox jCheckBox = new JCheckBox("Typed Literal", iLiteral.getDatatype() != null);
            final JButton jButton = new JButton("Datatype URI: ");
            final JTextField jTextField = new JTextField(iLiteral.getDatatype() != null ? iLiteral.getDatatype().getURI() : "");
            if (iLiteral.getDatatype() == null) {
                jTextField.setEnabled(false);
                jButton.setEnabled(false);
            }
            final JTextField jTextField2 = new JTextField(iLiteral.getLang() != null ? iLiteral.getLang() : "");
            this.tc = new JTextArea(iLiteral.getValue() != null ? iLiteral.getValue() : "");
            this.tc.setFont(Editor.swingFont);
            final JButton jButton2 = new JButton("Delete");
            ActionListener actionListener = new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    RDFDatatype rDFDatatype;
                    if (actionEvent.getSource() == jButton2) {
                        PropsPanel.this.application.deleteSelectedEntities();
                        PropsPanel.this.reset();
                    } else if (actionEvent.getSource() == jCheckBox) {
                        if (jCheckBox.isSelected()) {
                            jTextField.setEnabled(true);
                            jButton.setEnabled(true);
                        } else {
                            jTextField.setText("");
                            jTextField.setEnabled(false);
                            jButton.setEnabled(false);
                            iLiteral.setDatatype((String)null);
                        }
                    } else if (actionEvent.getSource() == jButton && (rDFDatatype = Editor.displayAvailableDataTypes(jTextField.getText())) != null) {
                        iLiteral.setDatatype(rDFDatatype);
                        jTextField.setText(iLiteral.getDatatype().getURI());
                    }
                }
            };
            KeyListener keyListener = new KeyListener(){

                public void keyPressed(KeyEvent keyEvent) {
                    if (keyEvent.getKeyCode() == 10) {
                        if (keyEvent.getSource() == jTextField2) {
                            iLiteral.setLanguage(jTextField2.getText().length() > 0 ? jTextField2.getText() : null);
                        } else if (keyEvent.getSource() == jTextField) {
                            String string = jTextField.getText();
                            if (ConfigManager.ALLOW_PFX_IN_TXTFIELDS && jCheckBox.isSelected() && string.length() > 0 && !Utils.isWhiteSpaceCharsOnly(string)) {
                                string = PropsPanel.this.application.tryToSolveBinding(string);
                                jTextField.setText(string);
                            }
                            iLiteral.setDatatype(string.length() > 0 ? string : null);
                        }
                    }
                }

                public void keyReleased(KeyEvent keyEvent) {
                }

                public void keyTyped(KeyEvent keyEvent) {
                }
            };
            FocusListener focusListener = new FocusListener(){

                public void focusGained(FocusEvent focusEvent) {
                }

                public void focusLost(FocusEvent focusEvent) {
                    if (focusEvent.getSource() == jTextField2) {
                        iLiteral.setLanguage(jTextField2.getText().length() > 0 ? jTextField2.getText() : null);
                    } else if (focusEvent.getSource() == jTextField) {
                        String string = jTextField.getText();
                        if (ConfigManager.ALLOW_PFX_IN_TXTFIELDS && jCheckBox.isSelected() && string.length() > 0 && !Utils.isWhiteSpaceCharsOnly(string)) {
                            string = PropsPanel.this.application.tryToSolveBinding(string);
                            jTextField.setText(string);
                        }
                        iLiteral.setDatatype(string.length() > 0 ? string : null);
                    } else if (focusEvent.getSource() == PropsPanel.this.tc) {
                        PropsPanel.this.application.setLiteralValue(iLiteral, PropsPanel.this.tc.getText());
                    }
                }
            };
            this.mainPanel.removeAll();
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            this.mainPanel.setLayout(gridBagLayout);
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 17;
            JLabel jLabel = new JLabel("lang: ");
            this.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 10, 3);
            gridBagLayout.setConstraints(jLabel, gridBagConstraints);
            this.mainPanel.add(jLabel);
            gridBagConstraints.fill = 2;
            jTextField2.addKeyListener(keyListener);
            jTextField2.addFocusListener(focusListener);
            this.buildConstraints(gridBagConstraints, 1, 0, 1, 1, 30, 0);
            gridBagLayout.setConstraints(jTextField2, gridBagConstraints);
            this.mainPanel.add(jTextField2);
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 13;
            jCheckBox.addActionListener(actionListener);
            this.buildConstraints(gridBagConstraints, 2, 0, 1, 1, 80, 0);
            gridBagLayout.setConstraints(jCheckBox, gridBagConstraints);
            this.mainPanel.add(jCheckBox);
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 0;
            jButton.setBorder(BorderFactory.createEtchedBorder());
            this.buildConstraints(gridBagConstraints, 0, 1, 1, 1, 10, 3);
            gridBagLayout.setConstraints(jButton, gridBagConstraints);
            this.mainPanel.add(jButton);
            jButton.addActionListener(actionListener);
            gridBagConstraints.fill = 2;
            jTextField.addKeyListener(keyListener);
            jTextField.addFocusListener(focusListener);
            this.buildConstraints(gridBagConstraints, 1, 1, 2, 1, 90, 0);
            gridBagLayout.setConstraints(jTextField, gridBagConstraints);
            this.mainPanel.add(jTextField);
            gridBagConstraints.anchor = 10;
            jButton2.addActionListener(actionListener);
            this.buildConstraints(gridBagConstraints, 0, 2, 3, 1, 100, 3);
            gridBagLayout.setConstraints(jButton2, gridBagConstraints);
            this.mainPanel.add(jButton2);
            gridBagConstraints.fill = 1;
            this.tc.addFocusListener(focusListener);
            JScrollPane jScrollPane = new JScrollPane(this.tc);
            jScrollPane.setVerticalScrollBarPolicy(20);
            jScrollPane.setHorizontalScrollBarPolicy(30);
            this.buildConstraints(gridBagConstraints, 0, 3, 3, 1, 100, 94);
            gridBagLayout.setConstraints(jScrollPane, gridBagConstraints);
            this.mainPanel.add(jScrollPane);
            this.paintAll(this.getGraphics());
        }
    }

    void showPropertyProps(final IProperty iProperty) {
        if (iProperty != null) {
            final JButton jButton = new JButton("Delete");
            Vector vector = this.application.getAllPropertyNS();
            final JComboBox jComboBox = new JComboBox(vector);
            String string = Editor.getNSBinding(iProperty.getNamespace());
            jComboBox.setSelectedItem(string != null ? string : iProperty.getNamespace());
            final JComboBox jComboBox2 = new JComboBox(this.application.getProperties4NS(iProperty.getNamespace()));
            jComboBox2.setSelectedItem(iProperty.getLocalname());
            jComboBox.setMaximumRowCount(10);
            jComboBox2.setMaximumRowCount(10);
            ActionListener actionListener = new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (actionEvent.getSource() == jButton) {
                        PropsPanel.this.application.deleteSelectedEntities();
                        PropsPanel.this.reset();
                    }
                }
            };
            ItemListener itemListener = new ItemListener(){

                public void itemStateChanged(ItemEvent itemEvent) {
                    if (itemEvent.getSource() == jComboBox) {
                        if (itemEvent.getStateChange() == 1) {
                            jComboBox2.removeAllItems();
                            Vector vector = PropsPanel.this.application.getProperties4NS((String)itemEvent.getItem());
                            int n = 0;
                            while (n < vector.size()) {
                                jComboBox2.addItem(vector.elementAt(n));
                                ++n;
                            }
                        }
                    } else if (itemEvent.getStateChange() == 1) {
                        PropsPanel.this.application.changePropertyURI(iProperty, (String)jComboBox.getSelectedItem(), (String)jComboBox2.getSelectedItem());
                    }
                }
            };
            this.mainPanel.removeAll();
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            this.mainPanel.setLayout(gridBagLayout);
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 10;
            jButton.addActionListener(actionListener);
            this.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 100, 5);
            gridBagLayout.setConstraints(jButton, gridBagConstraints);
            this.mainPanel.add(jButton);
            JLabel jLabel = new JLabel("Namespace");
            this.buildConstraints(gridBagConstraints, 0, 1, 1, 1, 100, 5);
            gridBagLayout.setConstraints(jLabel, gridBagConstraints);
            this.mainPanel.add(jLabel);
            jComboBox.addItemListener(itemListener);
            this.buildConstraints(gridBagConstraints, 0, 2, 1, 1, 100, 5);
            gridBagLayout.setConstraints(jComboBox, gridBagConstraints);
            this.mainPanel.add(jComboBox);
            JLabel jLabel2 = new JLabel("Property");
            this.buildConstraints(gridBagConstraints, 0, 3, 1, 1, 100, 5);
            gridBagLayout.setConstraints(jLabel2, gridBagConstraints);
            this.mainPanel.add(jLabel2);
            jComboBox2.addItemListener(itemListener);
            this.buildConstraints(gridBagConstraints, 0, 4, 1, 1, 100, 5);
            gridBagLayout.setConstraints(jComboBox2, gridBagConstraints);
            this.mainPanel.add(jComboBox2);
            gridBagConstraints.fill = 1;
            JPanel jPanel = new JPanel();
            this.buildConstraints(gridBagConstraints, 0, 5, 1, 1, 100, 75);
            gridBagLayout.setConstraints(jPanel, gridBagConstraints);
            this.mainPanel.add(jPanel);
            this.paintAll(this.getGraphics());
        }
    }

    void buildConstraints(GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4, int n5, int n6) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagConstraints.weightx = n5;
        gridBagConstraints.weighty = n6;
    }

    void updateSwingFont() {
        if (this.tc != null) {
            this.tc.setFont(Editor.swingFont);
        }
    }
}

