/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.IsaViz;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.w3c.IsaViz.ConfigManager;
import org.w3c.IsaViz.Editor;
import org.w3c.IsaViz.ILiteral;
import org.w3c.IsaViz.INode;
import org.w3c.IsaViz.IProperty;
import org.w3c.IsaViz.IResource;

class PropertySummary
extends JFrame
implements ActionListener {
    IResource subject;
    Editor application;

    PropertySummary(IResource iResource, Editor editor) {
        this.application = editor;
        this.subject = iResource;
        this.initProperties();
        WindowAdapter windowAdapter = new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
            }
        };
        this.addWindowListener(windowAdapter);
        this.pack();
        this.setTitle("Properties of Resource " + iResource.getIdent());
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setSize(Math.round((float)this.getWidth() * 1.2f), Math.round((float)this.getHeight() * 1.2f));
        this.setLocation((dimension.width - this.getWidth()) / 2, (dimension.height - this.getHeight()) / 2);
        this.setVisible(true);
    }

    private void initProperties() {
        Container container = this.getContentPane();
        Vector vector = this.subject.getOutgoingPredicates();
        if (vector != null) {
            JPanel jPanel = new JPanel();
            JScrollPane jScrollPane = new JScrollPane(jPanel);
            jScrollPane.setVerticalScrollBarPolicy(20);
            jScrollPane.setHorizontalScrollBarPolicy(31);
            jScrollPane.getVerticalScrollBar().setUnitIncrement(5);
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 17;
            jPanel.setLayout(gridBagLayout);
            int n = 0;
            int n2 = 0;
            int n3 = 1;
            int n4 = 1;
            int n5 = 50;
            int n6 = 100 / (vector.size() + 1);
            String string = this.subject.getIdent();
            if (this.subject.getLabel() != null) {
                string = string + " (" + this.subject.getLabel() + ")";
            }
            JLabel jLabel = new JLabel(string);
            jLabel.setFont(Editor.swingFont);
            jLabel.setForeground(ConfigManager.darkerPastelBlue);
            this.buildConstraints(gridBagConstraints, n, n2, 100, n4, n5, n6);
            gridBagLayout.setConstraints(jLabel, gridBagConstraints);
            jPanel.add(jLabel);
            ++n2;
            int n7 = 0;
            while (n7 < vector.size()) {
                IProperty iProperty = (IProperty)vector.elementAt(n7);
                String string2 = Editor.getNSBinding(iProperty.getNamespace());
                JLabel jLabel2 = new JLabel(string2 != null ? string2 + ":" + iProperty.getLocalname() : iProperty.getIdent());
                jLabel2.setFont(Editor.swingFont);
                this.buildConstraints(gridBagConstraints, n, n2, n3, n4, n5, n6);
                gridBagLayout.setConstraints(jLabel2, gridBagConstraints);
                jPanel.add(jLabel2);
                Component component = this.getSwingRepresentation(iProperty.object);
                component.setFont(Editor.swingFont);
                this.buildConstraints(gridBagConstraints, ++n, n2, n3, n4, n5, 0);
                gridBagLayout.setConstraints(component, gridBagConstraints);
                jPanel.add(component);
                n = 0;
                ++n2;
                ++n7;
            }
            container.add(jScrollPane);
        } else {
            container.add(new JLabel("No property is associated to this resource."));
        }
    }

    public Component getSwingRepresentation(INode iNode) {
        if (iNode instanceof IResource) {
            String string;
            final IResource iResource = (IResource)iNode;
            if (iResource.isAnon()) {
                string = "(AR) ";
                if (Editor.SHOW_ANON_ID) {
                    string = string + iResource.getIdent();
                }
            } else {
                string = "(R) " + iResource.getIdent();
            }
            final JLabel jLabel = new JLabel(string);
            MouseAdapter mouseAdapter = new MouseAdapter(){

                public void mousePressed(MouseEvent mouseEvent) {
                    int n = mouseEvent.getModifiers();
                    if ((n & 0x10) == 16) {
                        new PropertySummary(iResource, PropertySummary.this.application);
                    } else if ((n & 4) == 4) {
                        Editor.vsm.centerOnGlyph(iResource.getGlyph(), Editor.vsm.getActiveCamera(), 500);
                    }
                }

                public void mouseReleased(MouseEvent mouseEvent) {
                }

                public void mouseClicked(MouseEvent mouseEvent) {
                }

                public void mouseEntered(MouseEvent mouseEvent) {
                    jLabel.setForeground(ConfigManager.darkerPastelBlue);
                }

                public void mouseExited(MouseEvent mouseEvent) {
                    jLabel.setForeground(Color.black);
                }
            };
            jLabel.addMouseListener(mouseAdapter);
            return jLabel;
        }
        if (iNode instanceof ILiteral) {
            final ILiteral iLiteral = (ILiteral)iNode;
            final JLabel jLabel = new JLabel("(L) " + iLiteral.getValue());
            MouseAdapter mouseAdapter = new MouseAdapter(){

                public void mousePressed(MouseEvent mouseEvent) {
                    int n = mouseEvent.getModifiers();
                    if ((n & 4) == 4) {
                        Editor.vsm.centerOnGlyph(iLiteral.getGlyph(), Editor.vsm.getActiveCamera(), 500);
                    }
                }

                public void mouseReleased(MouseEvent mouseEvent) {
                }

                public void mouseClicked(MouseEvent mouseEvent) {
                }

                public void mouseEntered(MouseEvent mouseEvent) {
                    jLabel.setForeground(ConfigManager.darkerPastelBlue);
                }

                public void mouseExited(MouseEvent mouseEvent) {
                    jLabel.setForeground(Color.black);
                }
            };
            jLabel.addMouseListener(mouseAdapter);
            return jLabel;
        }
        return new JLabel("Unknown kind of object - unable to display " + iNode.toString());
    }

    public void actionPerformed(ActionEvent actionEvent) {
    }

    void buildConstraints(GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4, int n5, int n6) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagConstraints.weightx = n5;
        gridBagConstraints.weighty = n6;
    }
}

