/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.IsaViz;

import com.xerox.VTM.glyphs.Glyph;
import com.xerox.VTM.glyphs.VEllipse;
import com.xerox.VTM.glyphs.VPath;
import com.xerox.VTM.glyphs.VRectangle;
import com.xerox.VTM.glyphs.VText;
import com.xerox.VTM.glyphs.VTriangleOr;
import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.table.DefaultTableModel;
import org.apache.xerces.dom.DOMImplementationImpl;
import org.w3c.IsaViz.ConfigManager;
import org.w3c.IsaViz.Editor;
import org.w3c.IsaViz.ILiteral;
import org.w3c.IsaViz.IProperty;
import org.w3c.IsaViz.IResource;
import org.w3c.IsaViz.ProgPanel;
import org.w3c.IsaViz.Utils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

class ISVManager {
    Editor application;
    Hashtable uniqueIDs2INodes;
    Hashtable inodes2UniqueIDs;
    StringBuffer nextUniqueID;

    ISVManager(Editor editor) {
        this.application = editor;
    }

    public void openProject(File file) {
        ProgPanel progPanel = new ProgPanel("Resetting...", "Loading ISV");
        this.application.reset(true);
        this.application.resetGraphStylesheets();
        Editor.lastOpenPrjDir = file.getParentFile();
        progPanel.setPBValue(10);
        progPanel.setLabel("Loading file " + file.toString() + " ...");
        Editor.projectFile = file;
        Editor.vsm.getView("Graph").setCursorIcon(3);
        Editor.vsm.getView("Graph").setStatusBarText("Loading project to " + file.toString() + " ...");
        this.uniqueIDs2INodes = new Hashtable();
        progPanel.setPBValue(20);
        progPanel.setLabel("Parsing...");
        try {
            Element element;
            int n;
            NodeList nodeList;
            Document document = this.application.xmlMngr.parse(file, false);
            document.normalize();
            Element element2 = document.getDocumentElement();
            progPanel.setPBValue(30);
            progPanel.setLabel("Processing namespace bindings...");
            if (element2.getElementsByTagNameNS(Editor.isavizURI, "nsBindings").getLength() > 0) {
                nodeList = ((Element)element2.getElementsByTagNameNS(Editor.isavizURI, "nsBindings").item(0)).getElementsByTagNameNS(Editor.isavizURI, "nsBinding");
                n = 0;
                while (n < nodeList.getLength()) {
                    element = (Element)nodeList.item(n);
                    this.application.addNamespaceBinding(element.getAttribute("prefix"), element.getAttribute("uri"), new Boolean(element.getAttribute("dispPrefix")), true, true);
                    ++n;
                }
            }
            progPanel.setPBValue(40);
            progPanel.setLabel("Processing property types...");
            if (element2.getElementsByTagNameNS(Editor.isavizURI, "propertyTypes").getLength() > 0) {
                nodeList = ((Element)element2.getElementsByTagNameNS(Editor.isavizURI, "propertyTypes").item(0)).getElementsByTagNameNS(Editor.isavizURI, "propertyType");
                n = 0;
                while (n < nodeList.getLength()) {
                    element = (Element)nodeList.item(n);
                    this.application.addPropertyType(element.getAttribute("ns"), element.getAttribute("name"), true);
                    ++n;
                }
            }
            progPanel.setPBValue(50);
            progPanel.setLabel("Processing resources...");
            if (element2.getElementsByTagNameNS(Editor.isavizURI, "resources").getLength() > 0) {
                nodeList = ((Element)element2.getElementsByTagNameNS(Editor.isavizURI, "resources").item(0)).getElementsByTagNameNS(Editor.isavizURI, "iresource");
                int n2 = 0;
                while (n2 < nodeList.getLength()) {
                    this.createIResourceFromISV((Element)nodeList.item(n2));
                    ++n2;
                }
            }
            progPanel.setPBValue(60);
            progPanel.setLabel("Processing literals...");
            if (element2.getElementsByTagNameNS(Editor.isavizURI, "literals").getLength() > 0) {
                nodeList = ((Element)element2.getElementsByTagNameNS(Editor.isavizURI, "literals").item(0)).getElementsByTagNameNS(Editor.isavizURI, "iliteral");
                int n3 = 0;
                while (n3 < nodeList.getLength()) {
                    this.createILiteralFromISV((Element)nodeList.item(n3));
                    ++n3;
                }
            }
            progPanel.setPBValue(80);
            progPanel.setLabel("Processing properties...");
            if (element2.getElementsByTagNameNS(Editor.isavizURI, "properties").getLength() > 0) {
                nodeList = ((Element)element2.getElementsByTagNameNS(Editor.isavizURI, "properties").item(0)).getElementsByTagNameNS(Editor.isavizURI, "iproperty");
                int n4 = 0;
                while (n4 < nodeList.getLength()) {
                    this.createIPropertyFromISV((Element)nodeList.item(n4));
                    ++n4;
                }
            }
            progPanel.setLabel("Building graphical representation...");
            progPanel.setPBValue(100);
            this.application.cfgMngr.assignColorsToGraph();
            this.application.showAnonIds(Editor.SHOW_ANON_ID);
            this.application.showResourceLabels(Editor.DISP_AS_LABEL);
            this.uniqueIDs2INodes = null;
            Editor.vsm.getGlobalView(Editor.vsm.getVirtualSpace("rdfSpace").getCamera(0), ConfigManager.ANIM_DURATION);
            this.application.centerRadarView();
            Editor.vsm.getView("Graph").setStatusBarText("Loading project to " + file.toString() + " ...done");
        }
        catch (Exception exception) {
            this.application.errorMessages.append("An error occured while loading file " + file + "\nThis might not be a valid ISV project file.\n" + exception);
            this.application.reportError = true;
        }
        if (this.application.reportError) {
            Editor.vsm.getView("Graph").setStatusBarText("There were error/warning messages ('Ctrl+E' to display error log)");
            this.application.reportError = false;
        }
        Editor.vsm.getView("Graph").setCursorIcon(-1);
        progPanel.destroy();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void saveProject(File file) {
        Editor.projectFile = file;
        Editor.lastSavePrjDir = file.getParentFile();
        Editor.vsm.getView("Graph").setCursorIcon(3);
        Editor.vsm.getView("Graph").setStatusBarText("Saving project to " + file.toString() + " ...");
        DOMImplementationImpl dOMImplementationImpl = new DOMImplementationImpl();
        Document document = dOMImplementationImpl.createDocument(Editor.isavizURI, "isv:project", null);
        Element element = document.getDocumentElement();
        element.setAttribute("xmlns:isv", Editor.isavizURI);
        Element element2 = document.createElementNS(Editor.isavizURI, "isv:nsBindings");
        element.appendChild(element2);
        int n = 0;
        while (n < Editor.tblp.nsTableModel.getRowCount()) {
            if (((String)Editor.tblp.nsTableModel.getValueAt(n, 0)).length() > 0) {
                if (((String)Editor.tblp.nsTableModel.getValueAt(n, 1)).length() > 0) {
                    Element element3 = document.createElementNS(Editor.isavizURI, "isv:nsBinding");
                    element3.setAttribute("prefix", (String)Editor.tblp.nsTableModel.getValueAt(n, 0));
                    element3.setAttribute("uri", (String)Editor.tblp.nsTableModel.getValueAt(n, 1));
                    element3.setAttribute("dispPrefix", ((Boolean)Editor.tblp.nsTableModel.getValueAt(n, 2)).toString());
                    element2.appendChild(element3);
                }
            }
            ++n;
        }
        Element element4 = document.createElementNS(Editor.isavizURI, "isv:propertyTypes");
        element.appendChild(element4);
        DefaultTableModel defaultTableModel = (DefaultTableModel)Editor.tblp.prTable.getModel();
        int n2 = 0;
        while (n2 < defaultTableModel.getRowCount()) {
            Element element5 = document.createElementNS(Editor.isavizURI, "isv:propertyType");
            element5.setAttribute("ns", (String)defaultTableModel.getValueAt(n2, 0));
            element5.setAttribute("name", (String)defaultTableModel.getValueAt(n2, 2));
            element4.appendChild(element5);
            ++n2;
        }
        this.inodes2UniqueIDs = new Hashtable();
        this.nextUniqueID = new StringBuffer("0");
        Enumeration enumeration = this.application.resourcesByURI.elements();
        while (enumeration.hasMoreElements()) {
            this.inodes2UniqueIDs.put(enumeration.nextElement(), this.nextUniqueID.toString());
            this.incPrjID();
        }
        Enumeration enumeration2 = this.application.literals.elements();
        while (enumeration2.hasMoreElements()) {
            this.inodes2UniqueIDs.put(enumeration2.nextElement(), this.nextUniqueID.toString());
            this.incPrjID();
        }
        Element element6 = document.createElementNS(Editor.isavizURI, "isv:resources");
        element.appendChild(element6);
        Enumeration enumeration3 = this.application.resourcesByURI.elements();
        while (enumeration3.hasMoreElements()) {
            element6.appendChild(((IResource)enumeration3.nextElement()).toISV(document, this));
        }
        Element element7 = document.createElementNS(Editor.isavizURI, "isv:literals");
        element.appendChild(element7);
        Enumeration enumeration4 = this.application.literals.elements();
        while (enumeration4.hasMoreElements()) {
            element7.appendChild(((ILiteral)enumeration4.nextElement()).toISV(document, this));
        }
        Element element8 = document.createElementNS(Editor.isavizURI, "isv:properties");
        element.appendChild(element8);
        Enumeration enumeration5 = this.application.propertiesByURI.elements();
        while (enumeration5.hasMoreElements()) {
            Vector vector = (Vector)enumeration5.nextElement();
            Enumeration enumeration6 = vector.elements();
            while (enumeration6.hasMoreElements()) {
                element8.appendChild(((IProperty)enumeration6.nextElement()).toISV(document, this));
            }
        }
        this.inodes2UniqueIDs = null;
        this.application.xmlMngr.serialize(document, file);
        Editor.vsm.getView("Graph").setStatusBarText("Saving project to " + file.toString() + " ...done");
        if (this.application.reportError) {
            Editor.vsm.getView("Graph").setStatusBarText("There were error/warning messages ('Ctrl+E' to display error log)");
            this.application.reportError = false;
        }
        Editor.vsm.getView("Graph").setCursorIcon(-1);
    }

    protected String getPrjId(Object object) {
        return (String)this.inodes2UniqueIDs.get(object);
    }

    private void incPrjID() {
        byte by;
        boolean bl = false;
        int n = 0;
        while (n < this.nextUniqueID.length()) {
            by = (byte)this.nextUniqueID.charAt(n);
            if (by < 122) {
                this.nextUniqueID.setCharAt(n, (char)Utils.incByte(by));
                bl = true;
                int n2 = 0;
                while (n2 < n) {
                    this.nextUniqueID.setCharAt(n2, '0');
                    ++n2;
                }
                break;
            }
            ++n;
        }
        if (!bl) {
            by = 0;
            while (by < this.nextUniqueID.length()) {
                this.nextUniqueID.setCharAt(by, '0');
                by = (byte)(by + 1);
            }
            this.nextUniqueID.append('0');
        }
    }

    /*
     * Unable to fully structure code
     */
    IResource createIResourceFromISV(Element var1_1) {
        block12: {
            block11: {
                var2_2 = null;
                var3_3 = new Long(var1_1.getAttribute("x"));
                var5_4 = new Long(var1_1.getAttribute("y"));
                var7_5 = new Long(var1_1.getAttribute("w"));
                var9_6 = new Long(var1_1.getAttribute("h"));
                var11_7 = new VEllipse(var3_3, var5_4, 0.0f, var7_5, var9_6, ConfigManager.resourceColorF);
                var12_8 = false;
                if (var1_1.hasAttribute("isAnon")) {
                    var12_8 = new Boolean(var1_1.getAttribute("isAnon"));
                }
                Editor.vsm.addGlyph((Glyph)var11_7, "rdfSpace");
                var13_9 = var1_1.getElementsByTagNameNS(Editor.isavizURI, "URIorID");
                if (var13_9.getLength() <= 0) break block11;
                var14_10 = (Element)var13_9.item(0);
                var15_12 = new Long(var14_10.getAttribute("x"));
                var17_13 = new Long(var14_10.getAttribute("y"));
                if (var12_8) {
                    var19_14 = null;
                    if (var14_10.getElementsByTagNameNS(Editor.isavizURI, "anonID").getLength() > 0) {
                        var19_14 = Editor.ANON_NODE + var14_10.getElementsByTagNameNS(Editor.isavizURI, "anonID").item(0).getFirstChild().getNodeValue();
                    }
                    var2_2 = this.application.addAnonymousResource(var19_14);
                } else {
                    try {
                        var19_14 = var14_10.getElementsByTagNameNS(Editor.isavizURI, "namespace").item(0).getFirstChild().getNodeValue();
                    }
                    catch (NullPointerException var21_15) {
                        var19_14 = Editor.BASE_URI;
                    }
                    try {
                        var20_19 = var14_10.getElementsByTagNameNS(Editor.isavizURI, "localname").item(0).getFirstChild().getNodeValue();
                    }
                    catch (NullPointerException var21_16) {
                        var20_19 = "";
                    }
                    var2_2 = this.application.addResource(var19_14, var20_19);
                }
                var19_14 = var2_2.getIdent();
                var21_18 = 0;
                if (true) ** GOTO lbl48
                do {
                    var20_19 = (String)Editor.tblp.nsTableModel.getValueAt(var21_18, 1);
                    if (var19_14.startsWith(var20_19)) {
                        if (!((Boolean)Editor.tblp.nsTableModel.getValueAt(var21_18, 2)).booleanValue()) break;
                        var19_14 = (String)Editor.tblp.nsTableModel.getValueAt(var21_18, 0) + ":" + var19_14.substring(var20_19.length(), var19_14.length());
                        break;
                    }
                    ++var21_18;
lbl48:
                    // 2 sources

                } while (var21_18 < Editor.tblp.nsTableModel.getRowCount());
                var22_20 = new VText(var15_12, var17_13, 0.0f, ConfigManager.resourceColorTB, var19_14);
                Editor.vsm.addGlyph((Glyph)var22_20, "rdfSpace");
                var2_2.setGlyphText(var22_20);
                break block12;
            }
            var2_2 = new IResource();
        }
        var2_2.setGlyph((Glyph)var11_7);
        this.uniqueIDs2INodes.put(var1_1.getAttribute("id"), var2_2);
        if (var1_1.hasAttribute("commented") && (var14_11 = new Boolean(var1_1.getAttribute("commented")).booleanValue())) {
            this.application.commentNode(var2_2, true);
        }
        return var2_2;
    }

    ILiteral createILiteralFromISV(Element element) {
        boolean bl;
        NodeList nodeList;
        ILiteral iLiteral = null;
        long l = new Long(element.getAttribute("x"));
        long l2 = new Long(element.getAttribute("y"));
        long l3 = new Long(element.getAttribute("w"));
        long l4 = new Long(element.getAttribute("h"));
        VRectangle vRectangle = new VRectangle(l, l2, 0.0f, l3, l4, ConfigManager.literalColorF);
        Editor.vsm.addGlyph((Glyph)vRectangle, "rdfSpace");
        boolean bl2 = true;
        if (element.hasAttribute("escapeXML")) {
            bl2 = new Boolean(element.getAttribute("escapeXML"));
        }
        if ((nodeList = element.getElementsByTagNameNS(Editor.isavizURI, "value")).getLength() > 0) {
            Element element2 = (Element)nodeList.item(0);
            long l5 = new Long(element2.getAttribute("x"));
            long l6 = new Long(element2.getAttribute("y"));
            String string = element2.getFirstChild().getNodeValue();
            String string2 = string.length() >= Editor.MAX_LIT_CHAR_COUNT ? string.substring(0, Editor.MAX_LIT_CHAR_COUNT) + " ..." : string;
            VText vText = new VText(l5, l6, 0.0f, ConfigManager.literalColorTB, string2);
            Editor.vsm.addGlyph((Glyph)vText, "rdfSpace");
            iLiteral = this.application.addLiteral(string, null, bl2);
            iLiteral.setGlyphText(vText);
        } else {
            iLiteral = this.application.addLiteral("", null, true);
        }
        if (element.hasAttribute("dtURI")) {
            iLiteral.setDatatype(element.getAttribute("dtURI"));
        }
        if (element.hasAttribute("xml:lang")) {
            iLiteral.setLanguage(element.getAttribute("xml:lang"));
        } else if (element.hasAttribute("lang")) {
            iLiteral.setLanguage(element.getAttribute("lang"));
        }
        iLiteral.setGlyph((Glyph)vRectangle);
        this.uniqueIDs2INodes.put(element.getAttribute("id"), iLiteral);
        if (element.hasAttribute("commented") && (bl = new Boolean(element.getAttribute("commented")).booleanValue())) {
            this.application.commentNode(iLiteral, true);
        }
        return iLiteral;
    }

    /*
     * Unable to fully structure code
     */
    IProperty createIPropertyFromISV(Element var1_1) {
        block8: {
            block7: {
                var2_2 = null;
                var3_3 = (Element)var1_1.getElementsByTagNameNS(Editor.isavizURI, "path").item(0);
                var4_4 = var3_3.getAttribute("d");
                var5_5 = (Element)var1_1.getElementsByTagNameNS(Editor.isavizURI, "head").item(0);
                var6_6 = new Long(var5_5.getAttribute("x"));
                var8_7 = new Long(var5_5.getAttribute("y"));
                var10_8 = new Long(var5_5.getAttribute("w"));
                var12_9 = new Float(var5_5.getAttribute("or")).floatValue();
                var13_10 = new VPath(0.0f, ConfigManager.propertyColorB, var4_4);
                var14_11 = new VTriangleOr(var6_6, var8_7, 0.0f, var10_8, ConfigManager.propertyColorB, var12_9);
                Editor.vsm.addGlyph((Glyph)var14_11, "rdfSpace");
                Editor.vsm.addGlyph((Glyph)var13_10, "rdfSpace");
                var15_12 = var1_1.getElementsByTagNameNS(Editor.isavizURI, "uri");
                var16_13 = "";
                var17_14 = "";
                if (var15_12.getLength() <= 0) break block7;
                var18_15 = (Element)var15_12.item(0);
                var16_13 = var18_15.getElementsByTagNameNS(Editor.isavizURI, "namespace").item(0).getFirstChild().getNodeValue();
                var17_14 = var18_15.getElementsByTagNameNS(Editor.isavizURI, "localname").item(0).getFirstChild().getNodeValue();
                var19_16 = new Long(var18_15.getAttribute("x"));
                var21_18 = new Long(var18_15.getAttribute("y"));
                var23_19 = "";
                var24_20 = false;
                var25_21 = 0;
                if (true) ** GOTO lbl37
                do {
                    if (((String)Editor.tblp.nsTableModel.getValueAt(var25_21, 1)).equals(var16_13)) {
                        var23_19 = ((Boolean)Editor.tblp.nsTableModel.getValueAt(var25_21, 2)).booleanValue() ? (String)Editor.tblp.nsTableModel.getValueAt(var25_21, 0) + ":" + var17_14 : var16_13 + var17_14;
                        var24_20 = true;
                        break;
                    }
                    ++var25_21;
lbl37:
                    // 2 sources

                } while (var25_21 < Editor.tblp.nsTableModel.getRowCount());
                if (!var24_20) {
                    var23_19 = var16_13 + var17_14;
                }
                var26_22 = new VText(var19_16, var21_18, 0.0f, ConfigManager.propertyColorT, var23_19);
                Editor.vsm.addGlyph((Glyph)var26_22, "rdfSpace");
                var2_2 = this.application.addProperty(var16_13, var17_14);
                var2_2.setGlyphText(var26_22);
                break block8;
            }
            var2_2 = new IProperty();
        }
        var2_2.setGlyph(var13_10, var14_11);
        var18_15 = (IResource)this.uniqueIDs2INodes.get(var1_1.getAttribute("sb"));
        var2_2.setSubject((IResource)var18_15);
        var18_15.addOutgoingPredicate(var2_2);
        var19_17 = this.uniqueIDs2INodes.get(var1_1.getAttribute("ob"));
        if (var19_17 instanceof IResource) {
            var20_23 = (IResource)var19_17;
            var2_2.setObject((IResource)var20_23);
            var20_23.addIncomingPredicate(var2_2);
        } else {
            var20_23 = (ILiteral)var19_17;
            var2_2.setObject((ILiteral)var20_23);
            var20_23.setIncomingPredicate(var2_2);
            if (var2_2.getIdent().equals(Editor.RDFS_NAMESPACE_URI + "label")) {
                var18_15.setLabel(var20_23.getValue());
            }
        }
        if (var1_1.hasAttribute("commented") && (var20_24 = new Boolean(var1_1.getAttribute("commented")).booleanValue())) {
            this.application.commentPredicate(var2_2, true);
        }
        return var2_2;
    }
}

