/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.IsaViz;

import com.hp.hpl.jena.rdf.model.AnonId;
import com.hp.hpl.jena.rdf.model.RDFException;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.impl.Util;
import com.xerox.VTM.engine.VirtualSpace;
import com.xerox.VTM.glyphs.Glyph;
import com.xerox.VTM.glyphs.RectangularShape;
import com.xerox.VTM.glyphs.VText;
import java.util.Vector;
import org.w3c.IsaViz.ConfigManager;
import org.w3c.IsaViz.Editor;
import org.w3c.IsaViz.GraphStylesheet;
import org.w3c.IsaViz.INode;
import org.w3c.IsaViz.IProperty;
import org.w3c.IsaViz.ISVManager;
import org.w3c.IsaViz.Utils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

class IResource
extends INode {
    int strokeIndex;
    int fillIndex = ConfigManager.defaultRFIndex;
    Vector incomingPredicates;
    Vector outgoingPredicates;
    private boolean anonymous = false;
    private String anonymousID;
    private String namespace;
    private String localname;
    private String label;
    String mapID;
    Glyph gl1;
    VText gl2;

    public static String getJenaAnonId(AnonId anonId) {
        StringBuffer stringBuffer = new StringBuffer(anonId.toString());
        int n = 0;
        while (n < stringBuffer.length()) {
            if (stringBuffer.charAt(n) == '-') {
                stringBuffer.delete(0, n + 1);
                break;
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public IResource(Resource resource) {
        this.strokeIndex = ConfigManager.defaultRTBIndex;
        try {
            if (resource.isAnon()) {
                this.anonymous = true;
                this.anonymousID = Editor.ANON_NODE + IResource.getJenaAnonId(resource.getId());
            } else {
                this.anonymous = false;
                if (resource.getLocalName().length() > 0) {
                    this.namespace = resource.getNameSpace();
                    this.localname = resource.getLocalName();
                } else if (resource.getNameSpace().startsWith("http://")) {
                    this.namespace = resource.getNameSpace();
                    this.localname = "";
                } else {
                    this.namespace = Editor.BASE_URI;
                    this.localname = resource.getNameSpace();
                    if (this.localname.startsWith(Editor.BASE_URI)) {
                        this.localname = this.localname.substring(Editor.BASE_URI.length(), this.localname.length());
                    }
                }
            }
        }
        catch (RDFException rDFException) {
            System.err.println("Error: IResouce(Resource - Jena): " + (Object)((Object)rDFException));
        }
    }

    public IResource() {
        this.strokeIndex = ConfigManager.defaultRTBIndex;
    }

    void setNamespace(String string) {
        this.namespace = string;
        try {
            if (this.namespace.equals(Editor.BASE_URI) && !this.localname.startsWith("#")) {
                this.localname = "#" + this.localname;
            }
        }
        catch (NullPointerException nullPointerException) {}
    }

    void setLocalname(String string) {
        this.localname = string;
        try {
            if (this.namespace.equals(Editor.BASE_URI) && !this.localname.startsWith("#")) {
                this.localname = "#" + this.localname;
            }
        }
        catch (NullPointerException nullPointerException) {}
    }

    void setURI(String string) {
        int n = Util.splitNamespace((String)string);
        if (n == 0) {
            this.namespace = string;
            this.localname = "";
        } else {
            this.namespace = string.substring(0, n);
            this.localname = string.substring(n);
        }
    }

    void setAnonymousID(String string) {
        this.anonymousID = string;
    }

    boolean isAnon() {
        return this.anonymous;
    }

    void setAnon(boolean bl) {
        this.anonymous = bl;
    }

    public String getIdent() {
        if (this.anonymous) {
            return this.anonymousID;
        }
        try {
            String string = this.namespace + this.localname;
            return string.equals("nullnull") ? null : string;
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getLocalname() {
        return this.localname;
    }

    public void setLabel(String string) {
        this.label = string.length() == 0 ? null : string;
    }

    public String getLabel() {
        return this.label;
    }

    public void setMapID(String string) {
        this.mapID = string;
    }

    public String getMapID() {
        return this.mapID;
    }

    public void addIncomingPredicate(IProperty iProperty) {
        if (this.incomingPredicates == null) {
            this.incomingPredicates = new Vector();
            this.incomingPredicates.add(iProperty);
        } else if (!this.incomingPredicates.contains(iProperty)) {
            this.incomingPredicates.add(iProperty);
        }
    }

    public void removeIncomingPredicate(IProperty iProperty) {
        if (this.incomingPredicates != null && this.incomingPredicates.contains(iProperty)) {
            this.incomingPredicates.remove(iProperty);
            if (this.incomingPredicates.isEmpty()) {
                this.incomingPredicates = null;
            }
        }
    }

    public Vector getIncomingPredicates() {
        return this.incomingPredicates;
    }

    public void addOutgoingPredicate(IProperty iProperty) {
        if (this.outgoingPredicates == null) {
            this.outgoingPredicates = new Vector();
            this.outgoingPredicates.add(iProperty);
        } else if (!this.outgoingPredicates.contains(iProperty)) {
            this.outgoingPredicates.add(iProperty);
        }
    }

    public void removeOutgoingPredicate(IProperty iProperty) {
        if (this.outgoingPredicates != null && this.outgoingPredicates.contains(iProperty)) {
            this.outgoingPredicates.remove(iProperty);
            if (this.outgoingPredicates.isEmpty()) {
                this.outgoingPredicates = null;
            }
        }
    }

    public Vector getOutgoingPredicates() {
        return this.outgoingPredicates;
    }

    public void setSelected(boolean bl) {
        super.setSelected(bl);
        if (this.isVisuallyRepresented()) {
            if (this.selected) {
                this.gl1.setHSVColor(ConfigManager.selFh, ConfigManager.selFs, ConfigManager.selFv);
                this.gl1.setHSVbColor(ConfigManager.selTh, ConfigManager.selTs, ConfigManager.selTv);
                if (this.gl2 != null) {
                    this.gl2.setHSVColor(ConfigManager.selTh, ConfigManager.selTs, ConfigManager.selTv);
                }
                VirtualSpace virtualSpace = Editor.vsm.getVirtualSpace("rdfSpace");
                virtualSpace.onTop(this.gl1);
                virtualSpace.onTop((Glyph)this.gl2);
            } else if (this.commented) {
                this.gl1.setHSVColor(ConfigManager.comFh, ConfigManager.comFs, ConfigManager.comFv);
                this.gl1.setHSVbColor(ConfigManager.comTh, ConfigManager.comTs, ConfigManager.comTv);
                if (this.gl2 != null) {
                    this.gl2.setHSVColor(ConfigManager.comTh, ConfigManager.comTs, ConfigManager.comTv);
                }
            } else {
                this.gl1.setColor(ConfigManager.colors[this.fillIndex]);
                this.gl1.setBorderColor(ConfigManager.colors[this.strokeIndex]);
                if (this.gl2 != null) {
                    this.gl2.setColor(ConfigManager.colors[this.strokeIndex]);
                }
            }
        }
    }

    public void comment(boolean bl, Editor editor) {
        block12: {
            int n;
            block11: {
                int n2;
                this.commented = bl;
                if (!this.commented) break block11;
                if (this.isVisuallyRepresented()) {
                    this.gl1.setHSVColor(ConfigManager.comFh, ConfigManager.comFs, ConfigManager.comFv);
                    this.gl1.setHSVbColor(ConfigManager.comTh, ConfigManager.comTs, ConfigManager.comTv);
                    if (this.gl2 != null) {
                        this.gl2.setHSVColor(ConfigManager.comTh, ConfigManager.comTs, ConfigManager.comTv);
                    }
                }
                if (this.incomingPredicates != null) {
                    n2 = 0;
                    while (n2 < this.incomingPredicates.size()) {
                        editor.commentPredicate((IProperty)this.incomingPredicates.elementAt(n2), true);
                        ++n2;
                    }
                }
                if (this.outgoingPredicates == null) break block12;
                n2 = 0;
                while (n2 < this.outgoingPredicates.size()) {
                    editor.commentPredicate((IProperty)this.outgoingPredicates.elementAt(n2), true);
                    ++n2;
                }
                break block12;
            }
            if (this.isVisuallyRepresented()) {
                this.gl1.setColor(ConfigManager.colors[this.fillIndex]);
                this.gl1.setBorderColor(ConfigManager.colors[this.strokeIndex]);
                if (this.gl2 != null) {
                    this.gl2.setColor(ConfigManager.colors[this.strokeIndex]);
                }
            }
            if (this.incomingPredicates != null) {
                n = 0;
                while (n < this.incomingPredicates.size()) {
                    editor.commentPredicate((IProperty)this.incomingPredicates.elementAt(n), false);
                    ++n;
                }
            }
            if (this.outgoingPredicates != null) {
                n = 0;
                while (n < this.outgoingPredicates.size()) {
                    editor.commentPredicate((IProperty)this.outgoingPredicates.elementAt(n), false);
                    ++n;
                }
            }
        }
    }

    public void setVisible(boolean bl) {
        if (this.gl1 != null) {
            this.gl1.setVisible(bl);
            this.gl1.setSensitivity(bl);
        }
        if (this.gl2 != null) {
            this.gl2.setVisible(bl);
            this.gl2.setSensitivity(bl);
        }
    }

    public void setGlyph(Glyph glyph) {
        this.gl1 = glyph;
        this.gl1.setType("resG");
        this.gl1.setOwner((Object)this);
    }

    public void setGlyphText(VText vText) {
        if (vText != null) {
            this.gl2 = vText;
            this.gl2.setType("resT");
            this.gl2.setOwner((Object)this);
        } else {
            this.gl2 = null;
        }
    }

    public Glyph getGlyph() {
        return this.gl1;
    }

    public VText getGlyphText() {
        return this.gl2;
    }

    public Element toISV(Document document, ISVManager iSVManager) {
        Element element = document.createElementNS(Editor.isavizURI, "isv:iresource");
        Element element2 = document.createElementNS(Editor.isavizURI, "isv:URIorID");
        if (!this.anonymous) {
            Element element3;
            if (this.namespace != null && !this.namespace.equals(Editor.BASE_URI)) {
                element3 = document.createElementNS(Editor.isavizURI, "isv:namespace");
                element3.appendChild(document.createTextNode(this.namespace));
                element2.appendChild(element3);
            }
            if (this.localname != null) {
                element3 = document.createElementNS(Editor.isavizURI, "isv:localname");
                element3.appendChild(document.createTextNode(this.localname));
                element2.appendChild(element3);
            }
        } else if (this.anonymousID != null) {
            Element element4 = document.createElementNS(Editor.isavizURI, "isv:anonID");
            element4.appendChild(document.createTextNode(Utils.erasePrefix(this.anonymousID)));
            element2.appendChild(element4);
        }
        if (this.gl2 != null) {
            element2.setAttribute("x", String.valueOf(this.gl2.vx));
            element2.setAttribute("y", String.valueOf(this.gl2.vy));
        }
        element.appendChild(element2);
        element.setAttribute("x", String.valueOf(this.gl1.vx));
        element.setAttribute("y", String.valueOf(this.gl1.vy));
        if (this.gl1 instanceof RectangularShape) {
            element.setAttribute("w", String.valueOf(((RectangularShape)this.gl1).getWidth()));
            element.setAttribute("h", String.valueOf(((RectangularShape)this.gl1).getHeight()));
        } else {
            element.setAttribute("sz", String.valueOf(this.gl1.getSize()));
        }
        if (this.anonymous) {
            element.setAttribute("isAnon", "true");
        }
        if (this.commented) {
            element.setAttribute("commented", "true");
        }
        element.setAttribute("id", iSVManager.getPrjId(this));
        return element;
    }

    public String toString() {
        return super.toString() + " " + this.getIdent();
    }

    public String getText() {
        return this.getIdent() == null ? "" : this.getIdent();
    }

    public void displayOnTop() {
        Editor.vsm.getVirtualSpace("rdfSpace").onTop(this.gl1);
        Editor.vsm.getVirtualSpace("rdfSpace").onTop((Glyph)this.gl2);
    }

    public void setFillColor(int n) {
        this.fillIndex = n;
        this.gl1.setColor(ConfigManager.colors[this.fillIndex]);
    }

    public void setStrokeColor(int n) {
        this.strokeIndex = n;
        this.gl1.setBorderColor(ConfigManager.colors[this.strokeIndex]);
        if (this.gl2 != null) {
            this.gl2.setColor(ConfigManager.colors[this.strokeIndex]);
        }
    }

    public boolean hasRDFType(String string) {
        if (this.outgoingPredicates != null) {
            int n = 0;
            while (n < this.outgoingPredicates.size()) {
                IProperty iProperty = (IProperty)this.outgoingPredicates.elementAt(n);
                if (iProperty.getIdent().equals(GraphStylesheet._rdfType) && iProperty.getObject() instanceof IResource && ((IResource)iProperty.getObject()).getIdent().equals(string)) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }
}

