/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.IsaViz;

import com.hp.hpl.jena.rdf.model.Property;
import com.xerox.VTM.engine.VirtualSpace;
import com.xerox.VTM.glyphs.Glyph;
import com.xerox.VTM.glyphs.VPath;
import com.xerox.VTM.glyphs.VText;
import com.xerox.VTM.glyphs.VTriangleOr;
import org.w3c.IsaViz.ConfigManager;
import org.w3c.IsaViz.Editor;
import org.w3c.IsaViz.ILiteral;
import org.w3c.IsaViz.INode;
import org.w3c.IsaViz.IResource;
import org.w3c.IsaViz.ISVManager;
import org.w3c.IsaViz.Utils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class IProperty
extends INode {
    int strokeIndex = ConfigManager.defaultPBIndex;
    int textIndex = ConfigManager.defaultPTIndex;
    IResource subject;
    INode object;
    private String namespace = "";
    private String localname = "";
    VPath gl1;
    VTriangleOr gl2;
    VText gl3;
    String mapID;

    public IProperty(Property property) {
        this.namespace = property.getNameSpace();
        this.localname = property.getLocalName();
    }

    public IProperty() {
    }

    void setNamespace(String string) {
        this.namespace = string;
    }

    void setLocalname(String string) {
        this.localname = string;
    }

    public String getIdent() {
        try {
            String string = this.namespace + this.localname;
            return string.equals("nullnull") ? null : string;
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getLocalname() {
        return this.localname;
    }

    public void setMapID(String string) {
        this.mapID = string;
    }

    public String getMapID() {
        return this.mapID;
    }

    public void setSubject(IResource iResource) {
        this.subject = iResource;
    }

    public IResource getSubject() {
        return this.subject;
    }

    public void setObject(IResource iResource) {
        this.object = iResource;
    }

    public void setObject(ILiteral iLiteral) {
        this.object = iLiteral;
    }

    public INode getObject() {
        return this.object;
    }

    public void setSelected(boolean bl) {
        super.setSelected(bl);
        if (this.isVisuallyRepresented()) {
            if (this.selected) {
                this.gl1.setHSVColor(ConfigManager.selTh, ConfigManager.selTs, ConfigManager.selTv);
                this.gl2.setHSVColor(ConfigManager.selTh, ConfigManager.selTs, ConfigManager.selTv);
                if (this.gl3 != null) {
                    this.gl3.setHSVColor(ConfigManager.selTh, ConfigManager.selTs, ConfigManager.selTv);
                }
                this.gl1.setStrokeWidth(2.0f);
                VirtualSpace virtualSpace = Editor.vsm.getVirtualSpace("rdfSpace");
                virtualSpace.onTop((Glyph)this.gl1);
                virtualSpace.onTop((Glyph)this.gl2);
                virtualSpace.onTop((Glyph)this.gl3);
            } else {
                if (this.commented) {
                    this.gl1.setHSVColor(ConfigManager.comTh, ConfigManager.comTs, ConfigManager.comTv);
                    this.gl2.setHSVColor(ConfigManager.comTh, ConfigManager.comTs, ConfigManager.comTv);
                    if (this.gl3 != null) {
                        this.gl3.setHSVColor(ConfigManager.comTh, ConfigManager.comTs, ConfigManager.comTv);
                    }
                } else {
                    this.gl1.setColor(ConfigManager.colors[this.strokeIndex]);
                    this.gl2.setColor(ConfigManager.colors[this.strokeIndex]);
                    if (this.gl3 != null) {
                        this.gl3.setColor(ConfigManager.colors[this.textIndex]);
                    }
                }
                this.gl1.setStrokeWidth(1.0f);
            }
        }
    }

    public void comment(boolean bl, Editor editor) {
        if (bl) {
            this.commented = bl;
            if (this.isVisuallyRepresented()) {
                this.gl1.setHSVColor(ConfigManager.comTh, ConfigManager.comTs, ConfigManager.comTv);
                this.gl2.setHSVColor(ConfigManager.comTh, ConfigManager.comTs, ConfigManager.comTv);
                if (this.gl3 != null) {
                    this.gl3.setHSVColor(ConfigManager.comTh, ConfigManager.comTs, ConfigManager.comTv);
                }
            }
        } else if (this.subject != null) {
            if (this.object != null) {
                if (!this.subject.isCommented() && !this.object.isCommented()) {
                    this.commented = bl;
                    if (this.isVisuallyRepresented()) {
                        this.gl1.setColor(ConfigManager.colors[this.strokeIndex]);
                        this.gl2.setColor(ConfigManager.colors[this.strokeIndex]);
                        if (this.gl3 != null) {
                            this.gl3.setColor(ConfigManager.colors[this.textIndex]);
                        }
                    }
                }
            } else if (!this.subject.isCommented()) {
                this.commented = bl;
                if (this.isVisuallyRepresented()) {
                    this.gl1.setColor(ConfigManager.colors[this.strokeIndex]);
                    this.gl2.setColor(ConfigManager.colors[this.strokeIndex]);
                    if (this.gl3 != null) {
                        this.gl3.setColor(ConfigManager.colors[this.textIndex]);
                    }
                }
            }
        } else if (this.object != null && !this.object.isCommented()) {
            this.commented = bl;
            if (this.isVisuallyRepresented()) {
                this.gl1.setColor(ConfigManager.colors[this.strokeIndex]);
                this.gl2.setColor(ConfigManager.colors[this.strokeIndex]);
                if (this.gl3 != null) {
                    this.gl3.setColor(ConfigManager.colors[this.textIndex]);
                }
            }
        }
    }

    public void setVisible(boolean bl) {
        if (this.gl1 != null) {
            this.gl1.setVisible(bl);
            this.gl1.setSensitivity(bl);
        }
        if (this.gl2 != null) {
            this.gl2.setVisible(bl);
            this.gl2.setSensitivity(bl);
        }
        if (this.gl3 != null) {
            this.gl3.setVisible(bl);
            this.gl3.setSensitivity(bl);
        }
    }

    public void setGlyph(VPath vPath, VTriangleOr vTriangleOr) {
        this.gl1 = vPath;
        this.gl1.setType("prdG");
        this.gl1.setOwner((Object)this);
        this.gl2 = vTriangleOr;
        this.gl2.setType("prdH");
        this.gl2.setOwner((Object)this);
        this.gl2.setPaintBorder(false);
    }

    protected void setGlyphHead(VTriangleOr vTriangleOr) {
        this.gl2 = vTriangleOr;
        if (this.gl2 != null) {
            this.gl2.setPaintBorder(false);
            this.gl2.setType("prdH");
            this.gl2.setOwner((Object)this);
        }
    }

    public void setGlyphText(VText vText) {
        this.gl3 = vText;
        this.gl3.setType("prdT");
        this.gl3.setOwner((Object)this);
    }

    public Glyph getGlyph() {
        return this.gl1;
    }

    public VTriangleOr getGlyphHead() {
        return this.gl2;
    }

    public VText getGlyphText() {
        return this.gl3;
    }

    public Element toISV(Document document, ISVManager iSVManager) {
        Object object;
        Object object2;
        Object object3;
        Element element = document.createElementNS(Editor.isavizURI, "isv:iproperty");
        Element element2 = document.createElementNS(Editor.isavizURI, "isv:path");
        Element element3 = document.createElementNS(Editor.isavizURI, "isv:head");
        if (this.gl3 != null) {
            object3 = document.createElementNS(Editor.isavizURI, "isv:uri");
            object3.setAttribute("x", String.valueOf(this.gl3.vx));
            object3.setAttribute("y", String.valueOf(this.gl3.vy));
            object2 = document.createElementNS(Editor.isavizURI, "isv:namespace");
            object2.appendChild(document.createTextNode(this.namespace));
            object = document.createElementNS(Editor.isavizURI, "isv:localname");
            object.appendChild(document.createTextNode(this.localname));
            object3.appendChild((Node)object2);
            object3.appendChild((Node)object);
            element.appendChild((Node)object3);
        }
        object3 = new StringBuffer();
        object2 = this.gl1.getJava2DPathIterator();
        object = new float[6];
        int n = 90;
        while (!object2.isDone()) {
            int n2 = object2.currentSegment((float[])object);
            switch (n2) {
                case 0: {
                    if (n != 77) {
                        ((StringBuffer)object3).append('M');
                    } else {
                        ((StringBuffer)object3).append(' ');
                    }
                    n = 77;
                    ((StringBuffer)object3).append(Utils.abl2c(object[0]) + " " + Utils.abl2c((float)object[1]));
                    break;
                }
                case 1: {
                    if (n != 76) {
                        ((StringBuffer)object3).append('L');
                    } else {
                        ((StringBuffer)object3).append(' ');
                    }
                    n = 76;
                    ((StringBuffer)object3).append(Utils.abl2c(object[0]) + " " + Utils.abl2c((float)object[1]));
                    break;
                }
                case 2: {
                    if (n != 81) {
                        ((StringBuffer)object3).append('Q');
                    } else {
                        ((StringBuffer)object3).append(' ');
                    }
                    n = 81;
                    ((StringBuffer)object3).append(Utils.abl2c(object[0]) + " " + Utils.abl2c((float)object[1]) + " " + Utils.abl2c((float)object[2]) + " " + Utils.abl2c((float)object[3]));
                    break;
                }
                case 3: {
                    if (n != 67) {
                        ((StringBuffer)object3).append('C');
                    } else {
                        ((StringBuffer)object3).append(' ');
                    }
                    n = 67;
                    ((StringBuffer)object3).append(Utils.abl2c(object[0]) + " " + Utils.abl2c((float)object[1]) + " " + Utils.abl2c((float)object[2]) + " " + Utils.abl2c((float)object[3]) + " " + Utils.abl2c((float)object[4]) + " " + Utils.abl2c((float)object[5]));
                }
            }
            object2.next();
        }
        element2.setAttribute("d", ((StringBuffer)object3).toString());
        element.appendChild(element2);
        element3.setAttribute("x", String.valueOf(this.gl2.vx));
        element3.setAttribute("y", String.valueOf(this.gl2.vy));
        element3.setAttribute("w", Utils.abl2c(String.valueOf(this.gl2.getSize())));
        element3.setAttribute("or", String.valueOf(this.gl2.getOrient()));
        element.appendChild(element3);
        if (this.subject != null) {
            element.setAttribute("sb", iSVManager.getPrjId(this.subject));
        }
        if (this.object != null) {
            element.setAttribute("ob", iSVManager.getPrjId(this.object));
        }
        if (this.commented) {
            element.setAttribute("commented", "true");
        }
        return element;
    }

    public String toString() {
        return super.toString() + " " + this.getIdent();
    }

    public String getText() {
        return this.getIdent() != null ? this.getIdent() : "";
    }

    public void displayOnTop() {
        Editor.vsm.getVirtualSpace("rdfSpace").onTop((Glyph)this.gl1);
        Editor.vsm.getVirtualSpace("rdfSpace").onTop((Glyph)this.gl2);
        if (this.gl3 != null) {
            Editor.vsm.getVirtualSpace("rdfSpace").onTop((Glyph)this.gl3);
        }
    }

    public void setTextColor(int n) {
        this.textIndex = n;
        this.gl3.setColor(ConfigManager.colors[this.textIndex]);
    }

    public void setStrokeColor(int n) {
        this.strokeIndex = n;
        this.gl1.setColor(ConfigManager.colors[this.strokeIndex]);
        this.gl2.setColor(ConfigManager.colors[this.strokeIndex]);
    }
}

