/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.IsaViz;

import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFErrorHandler;
import com.hp.hpl.jena.rdf.model.RDFReader;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import java.awt.Color;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.w3c.IsaViz.ConfigManager;
import org.w3c.IsaViz.CustomShape;
import org.w3c.IsaViz.Editor;
import org.w3c.IsaViz.GSSLitSelector;
import org.w3c.IsaViz.GSSPOStatement;
import org.w3c.IsaViz.GSSPrpSelector;
import org.w3c.IsaViz.GSSResSelector;
import org.w3c.IsaViz.GSSSOStatement;
import org.w3c.IsaViz.GSSSPStatement;
import org.w3c.IsaViz.GSSSelector;
import org.w3c.IsaViz.GSSSelectorComparator;
import org.w3c.IsaViz.ILiteral;
import org.w3c.IsaViz.INode;
import org.w3c.IsaViz.IProperty;
import org.w3c.IsaViz.IResource;
import org.w3c.IsaViz.RDFLoader;
import org.w3c.IsaViz.Style;
import org.w3c.IsaViz.Utils;
import org.xml.sax.SAXParseException;

public class GraphStylesheet
implements RDFErrorHandler {
    public static String _gssNS = "http://www.w3.org/2001/11/IsaViz/graphstylesheets#";
    private static String GSS_BASE_URI = "";
    public static String _gssStyle = _gssNS + "style";
    public static String _gssVisibility = _gssNS + "visibility";
    public static String _gssDisplay = _gssNS + "display";
    public static String _gssLayout = _gssNS + "layout";
    public static String _rdfType = Editor.RDFMS_NAMESPACE_URI + "type";
    public static String _gssProperty = _gssNS + "Property";
    public static String _gssResource = _gssNS + "Resource";
    public static String _gssLiteral = _gssNS + "Literal";
    public static String _gssSOS = _gssNS + "subjectOfStatement";
    public static String _gssPOS = _gssNS + "predicateOfStatement";
    public static String _gssOOS = _gssNS + "objectOfStatement";
    public static String _rdfSubject = _gssNS + "subject";
    public static String _rdfObject = _gssNS + "object";
    public static String _rdfPredicate = _gssNS + "predicate";
    public static String _gssURIsw = _gssNS + "uriStartsWith";
    public static String _gssURIeq = _gssNS + "uriEquals";
    public static String _rdfValue = _gssNS + "value";
    public static String _gssClass = _gssNS + "class";
    public static String _gssDatatype = _gssNS + "datatype";
    public static String _gssFill = _gssNS + "fill";
    public static String _gssStroke = _gssNS + "stroke";
    public static String _gssStrokeWidth = _gssNS + "stroke-width";
    public static String _gssFontFamily = _gssNS + "font-family";
    public static String _gssFontSize = _gssNS + "font-size";
    public static String _gssFontWeight = _gssNS + "font-weight";
    public static String _gssFontStyle = _gssNS + "font-style";
    public static String _gssShape = _gssNS + "shape";
    public static String _gssShow = _gssNS + "Visible";
    public static String _gssHide = _gssNS + "Hidden";
    public static String _gssNone = _gssNS + "None";
    public static String _gssTableForm = _gssNS + "TableForm";
    public static String _gssEdgeAndNode = _gssNS + "EdgeAndNode";
    public static String _gssPlainLiterals = _gssNS + "PlainLiterals";
    public static String _gssAllDatatypes = _gssNS + "AllDatatypes";
    public static String _gssAllResourceClasses = _gssNS + "AllResourceClasses";
    public static String _gssAllProperties = _gssNS + "AllProperties";
    public static String _gssEllipse = _gssNS + "Ellipse";
    public static String _gssRectangle = _gssNS + "Rectangle";
    public static String _gssCircle = _gssNS + "Circle";
    public static String _gssDiamond = _gssNS + "Diamond";
    public static String _gssOctagon = _gssNS + "Octagon";
    public static String _gssTriangleN = _gssNS + "TriangleNorth";
    public static String _gssTriangleS = _gssNS + "TriangleSouth";
    public static String _gssTriangleW = _gssNS + "TriangleWest";
    public static String _gssTriangleE = _gssNS + "TriangleEast";
    public static Integer DISPLAY_NONE = new Integer(0);
    public static Integer VISIBILITY_HIDDEN = new Integer(1);
    public static Integer VISIBILITY_VISIBLE = new Integer(2);
    public static Integer TABLE_FORM = new Integer(0);
    public static Integer NODE_EDGE = new Integer(1);
    public static Integer RES_SEL = new Integer(0);
    public static Integer LIT_SEL = new Integer(1);
    public static Integer PRP_SEL = new Integer(2);
    public static Integer DEFAULT_RESOURCE_LAYOUT = NODE_EDGE;
    public static Integer DEFAULT_LITERAL_LAYOUT = NODE_EDGE;
    public static Integer DEFAULT_PROPERTY_LAYOUT = NODE_EDGE;
    public static Integer DEFAULT_RESOURCE_VISIBILITY = VISIBILITY_VISIBLE;
    public static Integer DEFAULT_LITERAL_VISIBILITY = VISIBILITY_VISIBLE;
    public static Integer DEFAULT_PROPERTY_VISIBILITY = VISIBILITY_VISIBLE;
    public static Color DEFAULT_RESOURCE_STROKE = ConfigManager.resourceColorTB;
    public static Color DEFAULT_LITERAL_STROKE = ConfigManager.literalColorTB;
    public static Color DEFAULT_PROPERTY_STROKE = ConfigManager.propertyColorB;
    public static Color DEFAULT_RESOURCE_FILL = ConfigManager.resourceColorF;
    public static Color DEFAULT_LITERAL_FILL = ConfigManager.literalColorF;
    public static Float DEFAULT_RESOURCE_STROKE_WIDTH = new Float(1.0f);
    public static Float DEFAULT_LITERAL_STROKE_WIDTH = new Float(1.0f);
    public static Float DEFAULT_PROPERTY_STROKE_WIDTH = new Float(1.0f);
    public static String DEFAULT_RESOURCE_FONT_FAMILY = Editor.vtmFontName;
    public static String DEFAULT_LITERAL_FONT_FAMILY = Editor.vtmFontName;
    public static String DEFAULT_PROPERTY_FONT_FAMILY = Editor.vtmFontName;
    public static Integer DEFAULT_RESOURCE_FONT_SIZE = new Integer(Editor.vtmFontSize);
    public static Integer DEFAULT_LITERAL_FONT_SIZE = new Integer(Editor.vtmFontSize);
    public static Integer DEFAULT_PROPERTY_FONT_SIZE = new Integer(Editor.vtmFontSize);
    public static Short DEFAULT_RESOURCE_FONT_WEIGHT = new Short(Style.CSS_FONT_WEIGHT_NORMAL);
    public static Short DEFAULT_LITERAL_FONT_WEIGHT = new Short(Style.CSS_FONT_WEIGHT_NORMAL);
    public static Short DEFAULT_PROPERTY_FONT_WEIGHT = new Short(Style.CSS_FONT_WEIGHT_NORMAL);
    public static Short DEFAULT_RESOURCE_FONT_STYLE = new Short(Style.CSS_FONT_STYLE_NORMAL);
    public static Short DEFAULT_LITERAL_FONT_STYLE = new Short(Style.CSS_FONT_STYLE_NORMAL);
    public static Short DEFAULT_PROPERTY_FONT_STYLE = new Short(Style.CSS_FONT_STYLE_NORMAL);
    public static Integer DEFAULT_RESOURCE_SHAPE = Style.ELLIPSE;
    public static Integer DEFAULT_LITERAL_SHAPE = Style.RECTANGLE;
    public static String _dotCircle = "circle";
    public static String _dotEllipse = "ellipse";
    public static String _dotRectangle = "rectangle";
    public static String _dotDiamond = "diamond";
    public static String _dotOctagon = "octagon";
    public static String _dotTriangle = "triangle";
    public static String _dotInvTriangle = "invtriangle";
    public static boolean DEBUG_GSS = false;
    Editor application;
    Hashtable styles = new Hashtable();
    Hashtable rStyleRules = new Hashtable();
    Hashtable lStyleRules;
    Hashtable pStyleRules = new Hashtable();
    Hashtable rVisRules;
    Hashtable lVisRules;
    Hashtable pVisRules;
    Hashtable rLayoutRules;
    Hashtable lLayoutRules;
    Hashtable pLayoutRules;
    Vector resourceSelectors;
    Vector propertySelectors;
    Vector literalSelectors;
    Hashtable styleStatements;
    Hashtable visibilityStatements;
    Hashtable layoutStatements;
    Hashtable selectorTypes;
    Hashtable uriEQConstraints;
    Hashtable uriSWConstraints;
    Hashtable sos;
    Hashtable pos;
    Hashtable oos;
    Hashtable xosSubjects;
    Hashtable xosPredicates;
    Hashtable xosObjects;
    Hashtable valueCnstrnts;
    Hashtable classCnstrnts;
    Hashtable dtCnstrnts;
    Hashtable id2rselector;
    Hashtable id2pselector;
    Hashtable id2lselector;

    public static String gss2dotShape(Object object) {
        if (object instanceof Integer) {
            Integer n = (Integer)object;
            if (n.equals(Style.ELLIPSE)) {
                return _dotEllipse;
            }
            if (n.equals(Style.RECTANGLE)) {
                return _dotRectangle;
            }
            if (n.equals(Style.CIRCLE)) {
                return _dotCircle;
            }
            if (n.equals(Style.DIAMOND)) {
                return _dotCircle;
            }
            if (n.equals(Style.OCTAGON)) {
                return _dotCircle;
            }
            if (n.equals(Style.TRIANGLEN)) {
                return _dotCircle;
            }
            if (n.equals(Style.TRIANGLES)) {
                return _dotCircle;
            }
            if (n.equals(Style.TRIANGLEE)) {
                return _dotCircle;
            }
            if (n.equals(Style.TRIANGLEW)) {
                return _dotCircle;
            }
            if (n.equals(Style.CUSTOM_SHAPE)) {
                return _dotCircle;
            }
            return _dotEllipse;
        }
        if (object instanceof CustomShape) {
            return _dotCircle;
        }
        return _dotEllipse;
    }

    public GraphStylesheet() {
        this.lStyleRules = new Hashtable();
        this.rVisRules = new Hashtable();
        this.pVisRules = new Hashtable();
        this.lVisRules = new Hashtable();
        this.rLayoutRules = new Hashtable();
        this.pLayoutRules = new Hashtable();
        this.lLayoutRules = new Hashtable();
    }

    void load(File file, Editor editor) {
        this.application = editor;
        try {
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)new FileInputStream(file), ConfigManager.ENCODING);
            Model model = ModelFactory.createDefaultModel();
            RDFReader rDFReader = model.getReader(RDFLoader.RDFXMLAB);
            rDFReader.setErrorHandler((RDFErrorHandler)this);
            rDFReader.setProperty(RDFLoader.errorModePropertyName, (Object)"lax");
            rDFReader.read(model, (Reader)inputStreamReader, GSS_BASE_URI);
            this.processStatements(model.listStatements());
        }
        catch (Exception exception) {
            String string = "RDFErrorHandler:Warning:GraphStylehseet " + GraphStylesheet.format(exception);
            this.application.errorMessages.append(string + "\n");
            this.application.reportError = true;
        }
    }

    void load(URL uRL, Editor editor) {
        this.application = editor;
        try {
            Model model = ModelFactory.createDefaultModel();
            RDFReader rDFReader = model.getReader(RDFLoader.RDFXMLAB);
            rDFReader.setErrorHandler((RDFErrorHandler)this);
            rDFReader.setProperty(RDFLoader.errorModePropertyName, (Object)"lax");
            rDFReader.read(model, uRL.toString());
            this.processStatements(model.listStatements());
        }
        catch (Exception exception) {
            String string = "RDFErrorHandler:Warning:GraphStylehseet " + GraphStylesheet.format(exception);
            this.application.errorMessages.append(string + "\n");
            this.application.reportError = true;
        }
    }

    protected void processStatements(StmtIterator stmtIterator) {
        this.styleStatements = new Hashtable();
        this.visibilityStatements = new Hashtable();
        this.layoutStatements = new Hashtable();
        this.selectorTypes = new Hashtable();
        this.uriEQConstraints = new Hashtable();
        this.uriSWConstraints = new Hashtable();
        this.sos = new Hashtable();
        this.pos = new Hashtable();
        this.oos = new Hashtable();
        this.xosSubjects = new Hashtable();
        this.xosPredicates = new Hashtable();
        this.xosObjects = new Hashtable();
        this.valueCnstrnts = new Hashtable();
        this.classCnstrnts = new Hashtable();
        this.dtCnstrnts = new Hashtable();
        try {
            while (stmtIterator.hasNext()) {
                Statement statement = stmtIterator.nextStatement();
                if (statement.getObject() instanceof Resource) {
                    this.processStatement(statement.getSubject(), (Resource)statement.getPredicate(), (Resource)statement.getObject());
                    continue;
                }
                if (!(statement.getObject() instanceof Literal)) continue;
                this.processStatement(statement.getSubject(), (Resource)statement.getPredicate(), (Literal)statement.getObject());
            }
            stmtIterator.close();
            this.buildSelectors();
            this.cleanSelectorTempData();
            this.buildRules();
        }
        catch (Exception exception) {
            System.err.println("GraphStylesheet.processStatements: Error: ");
            exception.printStackTrace();
        }
        this.cleanSelectorMapping();
        this.styleStatements.clear();
        this.styleStatements = null;
        this.visibilityStatements.clear();
        this.visibilityStatements = null;
        this.layoutStatements.clear();
        this.layoutStatements = null;
        this.selectorTypes.clear();
        this.selectorTypes = null;
        if (DEBUG_GSS) {
            this.debug();
        }
    }

    protected void cleanSelectorTempData() {
        this.uriEQConstraints.clear();
        this.uriEQConstraints = null;
        this.uriSWConstraints.clear();
        this.uriSWConstraints = null;
        this.sos.clear();
        this.sos = null;
        this.pos.clear();
        this.pos = null;
        this.oos.clear();
        this.oos = null;
        this.xosSubjects.clear();
        this.xosSubjects = null;
        this.xosPredicates.clear();
        this.xosPredicates = null;
        this.xosObjects.clear();
        this.xosObjects = null;
        this.valueCnstrnts.clear();
        this.valueCnstrnts = null;
        this.classCnstrnts.clear();
        this.classCnstrnts = null;
        this.dtCnstrnts.clear();
        this.dtCnstrnts = null;
    }

    protected void cleanSelectorMapping() {
        this.id2rselector.clear();
        this.id2rselector = null;
        this.id2pselector.clear();
        this.id2pselector = null;
        this.id2lselector.clear();
        this.id2lselector = null;
    }

    protected void processStatement(Resource resource, Resource resource2, Resource resource3) {
        String string;
        String string2 = resource.isAnon() ? resource.getId().toString() : resource.toString();
        String string3 = resource2.getURI();
        String string4 = string = resource3.isAnon() ? resource3.getId().toString() : resource3.toString();
        if (string3.equals(_gssStyle)) {
            this.rememberStyleRule(string2, string);
        } else if (string3.equals(_gssVisibility)) {
            this.rememberVisRule(string2, string);
        } else if (string3.equals(_gssDisplay)) {
            this.rememberVisRule(string2, string);
        } else if (string3.equals(_gssLayout)) {
            this.rememberLayoutRule(string2, string);
        } else if (string3.equals(_gssURIeq)) {
            this.declareURIeqConstraint(string2, string);
        } else if (string3.equals(_gssURIsw)) {
            this.declareURIswConstraint(string2, string);
        } else if (string3.equals(_gssSOS)) {
            this.declareSOS(string2, string);
        } else if (string3.equals(_gssPOS)) {
            this.declarePOS(string2, string);
        } else if (string3.equals(_gssOOS)) {
            this.declareOOS(string2, string);
        } else if (string3.equals(_rdfType)) {
            this.declareSelectorType(string2, string);
        } else if (string3.equals(_rdfSubject)) {
            this.declareXOSSubject(string2, string);
        } else if (string3.equals(_rdfPredicate)) {
            this.declareXOSPredicate(string2, string);
        } else if (string3.equals(_rdfObject)) {
            this.declareXOSObject(string2, string);
        } else if (string3.equals(_rdfValue)) {
            this.declareValueConstraint(string2, string);
        } else if (string3.equals(_gssClass)) {
            this.declareClassConstraint(string2, string);
        } else if (string3.equals(_gssDatatype)) {
            this.declareDatatypeConstraint(string2, string);
        } else if (string3.equals(_gssShape)) {
            this.addPredefShapeAttributeToStyle(string2, string);
        }
    }

    protected void processStatement(Resource resource, Resource resource2, Literal literal) {
        String string = resource.isAnon() ? resource.getId().toString() : resource.toString();
        String string2 = resource2.getURI();
        StringBuffer stringBuffer = new StringBuffer(literal.getLexicalForm());
        Utils.delLeadingAndTrailingSpaces(stringBuffer);
        if (string2.equals(_gssFill)) {
            this.addFillAttributeToStyle(string, stringBuffer.toString());
        } else if (string2.equals(_gssStroke)) {
            this.addStrokeAttributeToStyle(string, stringBuffer.toString());
        } else if (string2.equals(_gssStrokeWidth)) {
            this.addStrokeWAttributeToStyle(string, stringBuffer.toString());
        } else if (string2.equals(_rdfValue)) {
            this.declareValueConstraint(string, stringBuffer.toString());
        } else if (string2.equals(_gssFontWeight)) {
            this.addFontWAttributeToStyle(string, stringBuffer.toString());
        } else if (string2.equals(_gssFontStyle)) {
            this.addFontStAttributeToStyle(string, stringBuffer.toString());
        } else if (string2.equals(_gssFontFamily)) {
            this.addFontFAttributeToStyle(string, stringBuffer.toString());
        } else if (string2.equals(_gssFontSize)) {
            this.addFontSzAttributeToStyle(string, stringBuffer.toString());
        } else if (string2.equals(_gssShape)) {
            this.addCustomShapeAttributeToStyle(string, stringBuffer.toString());
        } else if (string2.equals(_gssURIsw)) {
            this.declareURIswConstraint(string, stringBuffer.toString());
        }
    }

    protected void rememberStyleRule(String string, String string2) {
        if (this.styleStatements.containsKey(string)) {
            Vector vector = (Vector)this.styleStatements.get(string);
            if (!Utils.containsString(vector, string2)) {
                vector.add(string2);
            }
        } else {
            Vector<String> vector = new Vector<String>();
            vector.add(string2);
            this.styleStatements.put(string, vector);
        }
    }

    protected void rememberVisRule(String string, String string2) {
        if (string2.equals(_gssHide)) {
            this.visibilityStatements.put(string, VISIBILITY_HIDDEN);
        } else if (string2.equals(_gssNone)) {
            this.visibilityStatements.put(string, DISPLAY_NONE);
        } else if (string2.equals(_gssShow)) {
            this.visibilityStatements.put(string, VISIBILITY_VISIBLE);
        } else {
            this.visibilityStatements.put(string, VISIBILITY_VISIBLE);
        }
    }

    protected void rememberLayoutRule(String string, String string2) {
        if (string2.equals(_gssTableForm)) {
            this.layoutStatements.put(string, TABLE_FORM);
        } else if (string2.equals(_gssEdgeAndNode)) {
            this.layoutStatements.put(string, NODE_EDGE);
        } else {
            this.layoutStatements.put(string, NODE_EDGE);
        }
    }

    protected void declareSelectorType(String string, String string2) {
        if (string2.equals(_gssResource)) {
            this.selectorTypes.put(string, RES_SEL);
        } else if (string2.equals(_gssProperty)) {
            this.selectorTypes.put(string, PRP_SEL);
        } else if (string2.equals(_gssLiteral)) {
            this.selectorTypes.put(string, LIT_SEL);
        }
    }

    protected void declareURIeqConstraint(String string, String string2) {
        this.uriEQConstraints.put(string, string2);
    }

    protected void declareURIswConstraint(String string, String string2) {
        this.uriSWConstraints.put(string, string2);
    }

    protected void declareSOS(String string, String string2) {
        if (this.sos.containsKey(string)) {
            Vector vector = (Vector)this.sos.get(string);
            vector.add(string2);
        } else {
            Vector<String> vector = new Vector<String>();
            vector.add(string2);
            this.sos.put(string, vector);
        }
    }

    protected void declarePOS(String string, String string2) {
        this.pos.put(string, string2);
    }

    protected void declareOOS(String string, String string2) {
        if (this.oos.containsKey(string)) {
            Vector vector = (Vector)this.oos.get(string);
            vector.add(string2);
        } else {
            Vector<String> vector = new Vector<String>();
            vector.add(string2);
            this.oos.put(string, vector);
        }
    }

    protected void declareXOSSubject(String string, String string2) {
        this.xosSubjects.put(string, string2);
    }

    protected void declareXOSPredicate(String string, String string2) {
        this.xosPredicates.put(string, string2);
    }

    protected void declareXOSObject(String string, String string2) {
        this.xosObjects.put(string, string2);
    }

    protected void declareValueConstraint(String string, String string2) {
        this.valueCnstrnts.put(string, string2);
    }

    protected void declareClassConstraint(String string, String string2) {
        this.classCnstrnts.put(string, string2);
    }

    protected void declareDatatypeConstraint(String string, String string2) {
        this.dtCnstrnts.put(string, string2);
    }

    protected Style createAndGetStyle(String string) {
        Style style;
        if (this.styles.containsKey(string)) {
            style = (Style)this.styles.get(string);
        } else {
            style = new Style(string);
            this.styles.put(string, style);
        }
        return style;
    }

    protected void addFillAttributeToStyle(String string, String string2) {
        this.createAndGetStyle(string).setFill(string2);
    }

    protected void addStrokeAttributeToStyle(String string, String string2) {
        this.createAndGetStyle(string).setStroke(string2);
    }

    protected void addStrokeWAttributeToStyle(String string, String string2) {
        this.createAndGetStyle(string).setStrokeWidth(string2);
    }

    protected void addFontFAttributeToStyle(String string, String string2) {
        this.createAndGetStyle(string).setFontFamily(string2);
    }

    protected void addFontStAttributeToStyle(String string, String string2) {
        this.createAndGetStyle(string).setFontStyle(string2);
    }

    protected void addFontSzAttributeToStyle(String string, String string2) {
        this.createAndGetStyle(string).setFontSize(string2);
    }

    protected void addFontWAttributeToStyle(String string, String string2) {
        this.createAndGetStyle(string).setFontWeight(string2);
    }

    protected void addPredefShapeAttributeToStyle(String string, String string2) {
        this.createAndGetStyle(string).setPredefShape(string2);
    }

    protected void addCustomShapeAttributeToStyle(String string, String string2) {
        this.createAndGetStyle(string).setCustomShape(string2);
    }

    protected void buildSelectors() {
        this.id2rselector = new Hashtable();
        this.id2pselector = new Hashtable();
        this.id2lselector = new Hashtable();
        this.resourceSelectors = new Vector();
        this.literalSelectors = new Vector();
        this.propertySelectors = new Vector();
        Enumeration enumeration = this.selectorTypes.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Integer n = (Integer)this.selectorTypes.get(string);
            if (n.equals(RES_SEL)) {
                this.buildResourceSelector(string);
                continue;
            }
            if (n.equals(LIT_SEL)) {
                this.buildLiteralSelector(string);
                continue;
            }
            this.buildPropertySelector(string);
        }
    }

    protected void buildResourceSelector(String string) {
        String string2;
        String string3;
        String string4;
        String string5;
        Object object;
        Vector vector = (Vector)this.sos.get(string);
        Vector vector2 = (Vector)this.oos.get(string);
        Vector<GSSPOStatement> vector3 = null;
        Vector<GSSSPStatement> vector4 = null;
        if (vector != null && vector.size() > 0) {
            vector3 = new Vector<GSSPOStatement>();
            object = null;
            string5 = null;
            string4 = null;
            string3 = null;
            string2 = null;
            String string6 = null;
            int n = 0;
            while (n < vector.size()) {
                object = (String)vector.elementAt(n);
                string5 = (String)this.xosObjects.get(object);
                if (string5 != null) {
                    string4 = (String)this.classCnstrnts.get(string5);
                    string3 = (String)this.dtCnstrnts.get(string5);
                    string2 = (String)this.valueCnstrnts.get(string5);
                }
                if ((string6 = (String)this.xosPredicates.get(object)) != null || string4 != null || string3 != null || string2 != null) {
                    if (string3 != null && string4 == null) {
                        vector3.add(new GSSPOStatement(string6, string3, string2, new Boolean(true)));
                    } else if (string4 != null && string3 == null) {
                        vector3.add(new GSSPOStatement(string6, string4, string2, new Boolean(false)));
                    } else if (string4 == null && string3 == null) {
                        vector3.add(new GSSPOStatement(string6, null, string2, null));
                    } else {
                        System.err.println("GraphStylesheet.buildResourceSelector(): Error: resource class and literal datatype constraints on the same resource selector's statement's object cannot coexist :" + string + " " + string4 + " " + string3);
                    }
                }
                string5 = null;
                string4 = null;
                string3 = null;
                string2 = null;
                string6 = null;
                ++n;
            }
        }
        if (vector2 != null && vector2.size() > 0) {
            vector4 = new Vector<GSSSPStatement>();
            string5 = null;
            string4 = null;
            string3 = null;
            string2 = null;
            int n = 0;
            while (n < vector2.size()) {
                object = (String)vector2.elementAt(n);
                string5 = (String)this.xosSubjects.get(object);
                if (string5 != null) {
                    string4 = (String)this.classCnstrnts.get(string5);
                    string3 = (String)this.valueCnstrnts.get(string5);
                }
                string2 = (String)this.xosPredicates.get(object);
                if (string4 != null || string3 != null || string2 != null) {
                    vector4.add(new GSSSPStatement(string4, string3, string2));
                }
                string5 = null;
                string4 = null;
                string3 = null;
                string2 = null;
                ++n;
            }
        }
        object = new GSSResSelector((String)this.uriEQConstraints.get(string), (String)this.uriSWConstraints.get(string), vector3, vector4);
        this.id2rselector.put(string, object);
        this.resourceSelectors.add(object);
    }

    protected void buildLiteralSelector(String string) {
        Object object;
        GSSSPStatement gSSSPStatement = null;
        Vector vector = (Vector)this.oos.get(string);
        if (vector != null && vector.size() > 0) {
            object = (String)vector.firstElement();
            String string2 = (String)this.xosSubjects.get(object);
            String string3 = null;
            String string4 = null;
            if (string2 != null) {
                string3 = (String)this.classCnstrnts.get(string2);
                string4 = (String)this.valueCnstrnts.get(string2);
            }
            String string5 = (String)this.xosPredicates.get(object);
            if (string3 != null || string4 != null || string5 != null) {
                gSSSPStatement = new GSSSPStatement(string3, string4, string5);
            }
        }
        object = new GSSLitSelector((String)this.dtCnstrnts.get(string), (String)this.valueCnstrnts.get(string), gSSSPStatement);
        this.id2lselector.put(string, object);
        this.literalSelectors.add(object);
    }

    protected void buildPropertySelector(String string) {
        Object object;
        GSSSOStatement gSSSOStatement = null;
        String string2 = (String)this.pos.get(string);
        if (string2 != null) {
            object = (String)this.xosSubjects.get(string2);
            String string3 = null;
            String string4 = null;
            if (object != null) {
                string3 = (String)this.classCnstrnts.get(object);
                string4 = (String)this.valueCnstrnts.get(object);
            }
            String string5 = (String)this.xosObjects.get(string2);
            String string6 = null;
            String string7 = null;
            String string8 = null;
            if (string5 != null) {
                string6 = (String)this.classCnstrnts.get(string5);
                string7 = (String)this.dtCnstrnts.get(string5);
                string8 = (String)this.valueCnstrnts.get(string5);
            }
            if (string3 != null || string6 != null || string7 != null || string8 != null || string4 != null) {
                if (string7 != null && string6 == null) {
                    gSSSOStatement = new GSSSOStatement(string3, string4, string7, string8, new Boolean(true));
                } else if (string6 != null && string7 == null) {
                    gSSSOStatement = new GSSSOStatement(string3, string4, string6, string8, new Boolean(false));
                } else if (string6 == null && string7 == null) {
                    gSSSOStatement = new GSSSOStatement(string3, string4, null, string8, null);
                } else {
                    System.err.println("GraphStylesheet.buildPropertySelector(): Error: resource class and literal datatype constraints on the same property selector's statement's object cannot coexist :" + string + " " + string6 + " " + string7);
                }
            }
        }
        object = new GSSPrpSelector((String)this.uriEQConstraints.get(string), (String)this.uriSWConstraints.get(string), gSSSOStatement);
        this.id2pselector.put(string, object);
        this.propertySelectors.add(object);
    }

    protected void buildRules() {
        Object v;
        Object v2;
        Vector vector;
        Object v3;
        Object k;
        Enumeration enumeration = this.id2rselector.keys();
        while (enumeration.hasMoreElements()) {
            k = enumeration.nextElement();
            v3 = this.id2rselector.get(k);
            if (this.styleStatements.containsKey(k) && (vector = (Vector)this.styleStatements.get(k)) != null && vector.size() > 0) {
                this.rStyleRules.put(v3, vector);
            }
            if (this.visibilityStatements.containsKey(k) && (v2 = this.visibilityStatements.get(k)) != null) {
                this.rVisRules.put(v3, v2);
            }
            if (!this.layoutStatements.containsKey(k) || (v = this.layoutStatements.get(k)) == null) continue;
            this.rLayoutRules.put(v3, v);
        }
        Enumeration enumeration2 = this.id2lselector.keys();
        while (enumeration2.hasMoreElements()) {
            k = enumeration2.nextElement();
            v3 = this.id2lselector.get(k);
            if (this.styleStatements.containsKey(k) && (vector = (Vector)this.styleStatements.get(k)) != null && vector.size() > 0) {
                this.lStyleRules.put(v3, vector);
            }
            if (this.visibilityStatements.containsKey(k) && (v2 = this.visibilityStatements.get(k)) != null) {
                this.lVisRules.put(v3, v2);
            }
            if (!this.layoutStatements.containsKey(k) || (v = this.layoutStatements.get(k)) == null) continue;
            this.lLayoutRules.put(v3, v);
        }
        Enumeration enumeration3 = this.id2pselector.keys();
        while (enumeration3.hasMoreElements()) {
            k = enumeration3.nextElement();
            v3 = this.id2pselector.get(k);
            if (this.styleStatements.containsKey(k) && (vector = (Vector)this.styleStatements.get(k)) != null && vector.size() > 0) {
                this.pStyleRules.put(v3, vector);
            }
            if (this.visibilityStatements.containsKey(k) && (v2 = this.visibilityStatements.get(k)) != null) {
                this.pVisRules.put(v3, v2);
            }
            if (!this.layoutStatements.containsKey(k) || (v = this.layoutStatements.get(k)) == null) continue;
            this.pLayoutRules.put(v3, v);
        }
    }

    Vector evaluateRules(IResource iResource) {
        Vector<Object> vector = new Vector<Object>();
        Vector<GSSResSelector> vector2 = new Vector<GSSResSelector>();
        int n = 0;
        while (n < this.resourceSelectors.size()) {
            GSSResSelector gSSResSelector = (GSSResSelector)this.resourceSelectors.elementAt(n);
            if (gSSResSelector.selects(iResource)) {
                vector2.add(gSSResSelector);
            }
            ++n;
        }
        Object[] objectArray = new Object[vector2.size()];
        int n2 = 0;
        while (n2 < vector2.size()) {
            objectArray[n2] = vector2.elementAt(n2);
            ++n2;
        }
        Arrays.sort(objectArray, new GSSSelectorComparator());
        int n3 = 0;
        while (n3 < objectArray.length) {
            vector.add(objectArray[n3]);
            ++n3;
        }
        if (DEBUG_GSS) {
            this.debugWeight(iResource, vector);
        }
        return vector;
    }

    Vector evaluateRules(IProperty iProperty) {
        Vector<Object> vector = new Vector<Object>();
        Vector<GSSPrpSelector> vector2 = new Vector<GSSPrpSelector>();
        int n = 0;
        while (n < this.propertySelectors.size()) {
            GSSPrpSelector gSSPrpSelector = (GSSPrpSelector)this.propertySelectors.elementAt(n);
            if (gSSPrpSelector.selects(iProperty)) {
                vector2.add(gSSPrpSelector);
            }
            ++n;
        }
        Object[] objectArray = new Object[vector2.size()];
        int n2 = 0;
        while (n2 < vector2.size()) {
            objectArray[n2] = vector2.elementAt(n2);
            ++n2;
        }
        Arrays.sort(objectArray, new GSSSelectorComparator());
        int n3 = 0;
        while (n3 < objectArray.length) {
            vector.add(objectArray[n3]);
            ++n3;
        }
        if (DEBUG_GSS) {
            this.debugWeight(iProperty, vector);
        }
        return vector;
    }

    Vector evaluateRules(ILiteral iLiteral) {
        Vector<Object> vector = new Vector<Object>();
        Vector<GSSLitSelector> vector2 = new Vector<GSSLitSelector>();
        int n = 0;
        while (n < this.literalSelectors.size()) {
            GSSLitSelector gSSLitSelector = (GSSLitSelector)this.literalSelectors.elementAt(n);
            if (gSSLitSelector.selects(iLiteral)) {
                vector2.add(gSSLitSelector);
            }
            ++n;
        }
        Object[] objectArray = new Object[vector2.size()];
        int n2 = 0;
        while (n2 < vector2.size()) {
            objectArray[n2] = vector2.elementAt(n2);
            ++n2;
        }
        Arrays.sort(objectArray, new GSSSelectorComparator());
        int n3 = 0;
        while (n3 < objectArray.length) {
            vector.add(objectArray[n3]);
            ++n3;
        }
        if (DEBUG_GSS) {
            this.debugWeight(iLiteral, vector);
        }
        return vector;
    }

    void cleanSelectors() {
        this.resourceSelectors.removeAllElements();
        this.literalSelectors.removeAllElements();
        this.propertySelectors.removeAllElements();
        this.resourceSelectors = null;
        this.literalSelectors = null;
        this.propertySelectors = null;
    }

    public void error(Exception exception) {
        String string = "RDFErrorHandler:Error:GraphStylehseet " + GraphStylesheet.format(exception);
        this.application.errorMessages.append(string + "\n");
        this.application.reportError = true;
    }

    public void fatalError(Exception exception) {
        String string = "RDFErrorHandler:Fatal Error:GraphStylehseet " + GraphStylesheet.format(exception);
        this.application.errorMessages.append(string + "\n");
        this.application.reportError = true;
    }

    public void warning(Exception exception) {
        String string = "RDFErrorHandler:Warning:GraphStylehseet " + GraphStylesheet.format(exception);
        this.application.errorMessages.append(string + "\n");
        this.application.reportError = true;
    }

    private static String format(Exception exception) {
        String string = exception.getMessage();
        if (string == null) {
            string = exception.toString();
        }
        if (exception instanceof SAXParseException) {
            SAXParseException sAXParseException = (SAXParseException)exception;
            return string + "[Line = " + sAXParseException.getLineNumber() + ", Column = " + sAXParseException.getColumnNumber() + "]";
        }
        return exception.toString();
    }

    public void debug() {
        Object k;
        System.err.println("------------------------- Styles -------------------------");
        Enumeration enumeration = this.styles.keys();
        while (enumeration.hasMoreElements()) {
            k = enumeration.nextElement();
            System.out.println(this.styles.get(k).toString());
        }
        System.err.println("--------------------- Resource Styling -------------------");
        Enumeration enumeration2 = this.rStyleRules.keys();
        while (enumeration2.hasMoreElements()) {
            k = enumeration2.nextElement();
            System.out.println("-- " + k.getClass().getName() + "@" + Integer.toHexString(k.hashCode()));
            System.out.print(k.toString());
            System.out.println("\t " + Utils.vectorOfStringAsCSStrings((Vector)this.rStyleRules.get(k)));
        }
        System.err.println("--------------------- Property Styling -------------------");
        Enumeration enumeration3 = this.pStyleRules.keys();
        while (enumeration3.hasMoreElements()) {
            k = enumeration3.nextElement();
            System.out.println("-- " + k.getClass().getName() + "@" + Integer.toHexString(k.hashCode()));
            System.out.print(k.toString());
            System.out.println("\t " + Utils.vectorOfStringAsCSStrings((Vector)this.pStyleRules.get(k)));
        }
        System.err.println("--------------------- Literal Styling  -------------------");
        Enumeration enumeration4 = this.lStyleRules.keys();
        while (enumeration4.hasMoreElements()) {
            k = enumeration4.nextElement();
            System.out.println("-- " + k.getClass().getName() + "@" + Integer.toHexString(k.hashCode()));
            System.out.print(k.toString());
            System.out.println("\t " + Utils.vectorOfStringAsCSStrings((Vector)this.lStyleRules.get(k)));
        }
        System.err.println("------------------- Resource Visibility ------------------");
        Enumeration enumeration5 = this.rVisRules.keys();
        while (enumeration5.hasMoreElements()) {
            k = enumeration5.nextElement();
            System.out.println("-- " + k.getClass().getName() + "@" + Integer.toHexString(k.hashCode()));
            System.out.print(k.toString());
            System.out.println("\t (0=display_none,1=visibility_hidden,2=visibility_visible) = " + this.rVisRules.get(k).toString());
        }
        System.err.println("------------------- Property Visibility ------------------");
        Enumeration enumeration6 = this.pVisRules.keys();
        while (enumeration6.hasMoreElements()) {
            k = enumeration6.nextElement();
            System.out.println("-- " + k.getClass().getName() + "@" + Integer.toHexString(k.hashCode()));
            System.out.print(k.toString());
            System.out.println("\t (0=display_none,1=visibility_hidden,2=visibility_visible) = " + this.pVisRules.get(k).toString());
        }
        System.err.println("------------------- Literal Visibility  ------------------");
        Enumeration enumeration7 = this.lVisRules.keys();
        while (enumeration7.hasMoreElements()) {
            k = enumeration7.nextElement();
            System.out.println("-- " + k.getClass().getName() + "@" + Integer.toHexString(k.hashCode()));
            System.out.print(k.toString());
            System.out.println("\t (0=display_none,1=visibility_hidden,2=visibility_visible) = " + this.lVisRules.get(k).toString());
        }
        System.err.println("--------------------- Resource Layout --------------------");
        Enumeration enumeration8 = this.rLayoutRules.keys();
        while (enumeration8.hasMoreElements()) {
            k = enumeration8.nextElement();
            System.out.println("-- " + k.getClass().getName() + "@" + Integer.toHexString(k.hashCode()));
            System.out.print(k.toString());
            System.out.println("\t (0=table_form,1=node_edge) = " + this.rLayoutRules.get(k).toString());
        }
        System.err.println("--------------------- Property Layout --------------------");
        Enumeration enumeration9 = this.pLayoutRules.keys();
        while (enumeration9.hasMoreElements()) {
            k = enumeration9.nextElement();
            System.out.println("-- " + k.getClass().getName() + "@" + Integer.toHexString(k.hashCode()));
            System.out.print(k.toString());
            System.out.println("\t (0=table_form,1=node_edge) = " + this.pLayoutRules.get(k).toString());
        }
        System.err.println("--------------------- Literal Layout  --------------------");
        Enumeration enumeration10 = this.lLayoutRules.keys();
        while (enumeration10.hasMoreElements()) {
            k = enumeration10.nextElement();
            System.out.println("-- " + k.getClass().getName() + "@" + Integer.toHexString(k.hashCode()));
            System.out.print(k.toString());
            System.out.println("\t (0=table_form,1=node_edge) = " + this.lLayoutRules.get(k).toString());
        }
    }

    void debugWeight(INode iNode, Vector vector) {
        if (vector.size() > 0) {
            Object e;
            System.out.println("Selector list (selector object[weight]) for " + iNode.toString());
            int n = 0;
            while (n < vector.size() - 1) {
                e = vector.elementAt(n);
                System.out.print(e.getClass().getName() + "@" + Integer.toHexString(e.hashCode()) + "[" + ((GSSSelector)e).getWeight() + "],");
                ++n;
            }
            e = vector.lastElement();
            System.out.println(e.getClass().getName() + "@" + Integer.toHexString(e.hashCode()) + "[" + ((GSSSelector)e).getWeight() + "]");
        } else {
            System.out.println("No selector for " + iNode.toString());
        }
    }
}

