/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.IsaViz;

import java.util.Vector;
import org.w3c.IsaViz.GSSPOStatement;
import org.w3c.IsaViz.GSSSPStatement;
import org.w3c.IsaViz.GSSSelector;
import org.w3c.IsaViz.IResource;

public class GSSResSelector
extends GSSSelector {
    String resourceURIequals;
    String resourceURIstartsWith;
    GSSPOStatement[] subjectOfStatements;
    GSSSPStatement[] objectOfStatements;

    GSSResSelector(String string, String string2, Vector vector, Vector vector2) {
        int n;
        this.resourceURIequals = string;
        if (this.resourceURIequals != null && this.resourceURIequals.length() == 0) {
            this.resourceURIequals = null;
        }
        this.resourceURIstartsWith = string2;
        if (this.resourceURIstartsWith != null && this.resourceURIstartsWith.length() == 0) {
            this.resourceURIstartsWith = null;
        }
        if (vector != null && vector.size() > 0) {
            this.subjectOfStatements = new GSSPOStatement[vector.size()];
            n = 0;
            while (n < vector.size()) {
                this.subjectOfStatements[n] = (GSSPOStatement)vector.elementAt(n);
                ++n;
            }
        }
        if (vector2 != null && vector2.size() > 0) {
            this.objectOfStatements = new GSSSPStatement[vector2.size()];
            n = 0;
            while (n < vector2.size()) {
                this.objectOfStatements[n] = (GSSSPStatement)vector2.elementAt(n);
                ++n;
            }
        }
        this.computeWeight();
    }

    protected void computeWeight() {
        int n;
        this.weight = 0;
        if (this.resourceURIequals != null) {
            this.weight += GSSSelector.rSelURIeq;
        }
        if (this.resourceURIstartsWith != null) {
            this.weight += GSSSelector.rSelURIsw;
        }
        if (this.subjectOfStatements != null) {
            n = 0;
            while (n < this.subjectOfStatements.length) {
                if (this.subjectOfStatements[n].getPredicateURI() != null) {
                    this.weight += GSSSelector.rSelPredicateURI;
                }
                if (this.subjectOfStatements[n].getObjectValueOrURI() != null) {
                    this.weight += GSSSelector.rSelObjectValueURI;
                }
                if (this.subjectOfStatements[n].getObjectType() != null) {
                    this.weight += GSSSelector.rSelObjectType;
                }
                ++n;
            }
        }
        if (this.objectOfStatements != null) {
            n = 0;
            while (n < this.objectOfStatements.length) {
                if (this.objectOfStatements[n].getPredicateURI() != null) {
                    this.weight += GSSSelector.rSelPredicateURI;
                }
                if (this.objectOfStatements[n].getSubjectURI() != null) {
                    this.weight += GSSSelector.rSelSubjectURI;
                }
                if (this.objectOfStatements[n].getSubjectType() != null) {
                    this.weight += GSSSelector.rSelSubjectType;
                }
                ++n;
            }
        }
    }

    boolean selects(IResource iResource) {
        int n;
        boolean bl = true;
        String string = iResource.getIdent();
        if (this.resourceURIequals != null && !string.equals(this.resourceURIequals)) {
            return false;
        }
        if (this.resourceURIstartsWith != null && !string.startsWith(this.resourceURIstartsWith)) {
            return false;
        }
        if (this.subjectOfStatements != null) {
            n = 0;
            while (n < this.subjectOfStatements.length) {
                if (!this.subjectOfStatements[n].selects(iResource)) {
                    return false;
                }
                ++n;
            }
        }
        if (this.objectOfStatements != null) {
            n = 0;
            while (n < this.objectOfStatements.length) {
                if (!this.objectOfStatements[n].selects(iResource)) {
                    return false;
                }
                ++n;
            }
        }
        return bl;
    }

    public String toString() {
        int n;
        String string = "";
        string = string + "\t selector weight=" + this.weight + "\n";
        string = string + "\t uri must be equal to=" + this.resourceURIequals + "\n";
        string = string + "\t uri must start with=" + this.resourceURIstartsWith + "\n";
        if (this.subjectOfStatements != null) {
            n = 0;
            while (n < this.subjectOfStatements.length) {
                string = string + "\t subjectOfStatement [predicate URI,object value or URI,object (data)type] " + n + " =[" + this.subjectOfStatements[n].getPredicateURI() + "," + this.subjectOfStatements[n].getObjectValueOrURI() + "," + this.subjectOfStatements[n].getObjectType() + "]\n";
                ++n;
            }
        }
        if (this.objectOfStatements != null) {
            n = 0;
            while (n < this.objectOfStatements.length) {
                string = string + "\t objectOfStatement [subject URI,subject type,predicate URI] " + n + " =[" + this.objectOfStatements[n].getSubjectURI() + "," + this.objectOfStatements[n].getSubjectType() + "," + this.objectOfStatements[n].getPredicateURI() + "]\n";
                ++n;
            }
        }
        return string;
    }
}

