/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.IsaViz;

import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.xerox.VTM.engine.SwingWorker;
import java.awt.Cursor;
import java.io.File;
import java.net.URL;
import java.util.Hashtable;
import java.util.Vector;
import org.w3c.IsaViz.Editor;
import org.w3c.IsaViz.GraphStylesheet;
import org.w3c.IsaViz.ILiteral;
import org.w3c.IsaViz.INode;
import org.w3c.IsaViz.IProperty;
import org.w3c.IsaViz.IResource;
import org.w3c.IsaViz.RDFLoader;
import org.w3c.IsaViz.Style;
import org.w3c.IsaViz.StyleInfoL;
import org.w3c.IsaViz.StyleInfoP;
import org.w3c.IsaViz.StyleInfoR;
import org.w3c.IsaViz.Utils;

class GSSManager {
    static File lastStyleDir = null;
    Editor application;
    Hashtable stylesheetFiles;
    Hashtable resource2styleTable;
    Hashtable property2styleTable;
    Hashtable literal2styleTable;
    GraphStylesheet[] stylesheets;

    public static String getType(Resource resource) {
        String string = null;
        StmtIterator stmtIterator = resource.listProperties();
        while (stmtIterator.hasNext()) {
            Statement statement = stmtIterator.nextStatement();
            if (!statement.getPredicate().getURI().equals(GraphStylesheet._rdfType)) continue;
            RDFNode rDFNode = statement.getObject();
            if (rDFNode == null) break;
            string = rDFNode.toString();
            break;
        }
        stmtIterator.close();
        return string;
    }

    public static String getType(IResource iResource) {
        String string = null;
        Vector vector = iResource.getOutgoingPredicates();
        if (vector != null) {
            int n = 0;
            while (n < vector.size()) {
                IProperty iProperty = (IProperty)vector.elementAt(n);
                if (iProperty.getIdent().equals(GraphStylesheet._rdfType)) {
                    INode iNode = iProperty.getObject();
                    if (iNode instanceof IResource) {
                        string = ((IResource)iNode).getIdent();
                        break;
                    }
                    if (iNode instanceof ILiteral) {
                        string = ((ILiteral)iNode).getValue();
                        break;
                    }
                }
                ++n;
            }
        }
        return string;
    }

    GSSManager(Editor editor) {
        this.application = editor;
        this.stylesheetFiles = new Hashtable();
    }

    void reset() {
        this.stylesheetFiles.clear();
    }

    public void loadStylesheet(final File file) {
        lastStyleDir = file.getParentFile();
        SwingWorker swingWorker = new SwingWorker(){

            public Object construct() {
                Editor cfr_ignored_0 = GSSManager.this.application;
                Editor.tblp.setCursor(new Cursor(3));
                GraphStylesheet graphStylesheet = new GraphStylesheet();
                graphStylesheet.load(file, GSSManager.this.application.isvMngr.application);
                if (GSSManager.this.application.reportError) {
                    Editor.vsm.getView("Graph").setStatusBarText("There were error/warning messages ('Ctrl+E' to display error log)");
                    GSSManager.this.application.reportError = false;
                }
                GSSManager.this.stylesheetFiles.put(file, graphStylesheet);
                Editor cfr_ignored_1 = GSSManager.this.application;
                Editor.tblp.addStylesheet(file);
                Editor cfr_ignored_2 = GSSManager.this.application;
                Editor.tblp.setCursor(Cursor.getDefaultCursor());
                return null;
            }
        };
        swingWorker.start();
    }

    public void loadStylesheet(final URL uRL) {
        SwingWorker swingWorker = new SwingWorker(){

            public Object construct() {
                Editor cfr_ignored_0 = GSSManager.this.application;
                Editor.tblp.setCursor(new Cursor(3));
                GraphStylesheet graphStylesheet = new GraphStylesheet();
                graphStylesheet.load(uRL, GSSManager.this.application.isvMngr.application);
                if (GSSManager.this.application.reportError) {
                    Editor.vsm.getView("Graph").setStatusBarText("There were error/warning messages ('Ctrl+E' to display error log)");
                    GSSManager.this.application.reportError = false;
                }
                GSSManager.this.stylesheetFiles.put(uRL, graphStylesheet);
                Editor cfr_ignored_1 = GSSManager.this.application;
                Editor.tblp.addStylesheet(uRL);
                Editor cfr_ignored_2 = GSSManager.this.application;
                Editor.tblp.setCursor(Cursor.getDefaultCursor());
                return null;
            }
        };
        swingWorker.start();
    }

    void removeSelectedStylesheet() {
        Object object = Editor.tblp.removeSelectedStylesheet();
        if (object != null) {
            this.stylesheetFiles.remove(object);
        }
    }

    void editSelectedStylesheet() {
        System.out.println("Sorry, the Graph Stylesheet Editor is not implemented yet");
    }

    Vector getStylesheetList() {
        Vector vector = Editor.tblp.getStylesheetList();
        Vector vector2 = new Vector();
        int n = 0;
        while (n < vector.size()) {
            vector2.addElement(this.stylesheetFiles.get(vector.elementAt(n)));
            ++n;
        }
        return vector2;
    }

    void applyStylesheets() {
        Vector vector = this.getStylesheetList();
        if (vector.size() > 0) {
            SwingWorker swingWorker = new SwingWorker(){

                public Object construct() {
                    Editor.vsm.getView("Graph").setCursorIcon(3);
                    GSSManager.this.application.generateJenaModel();
                    File file = Utils.createTempFile(Editor.m_TmpDir.toString(), "mrg", ".rdf");
                    boolean bl = Editor.ABBREV_SYNTAX;
                    Editor.ABBREV_SYNTAX = true;
                    GSSManager.this.application.rdfLdr.save(GSSManager.this.application.rdfModel, file);
                    if (!bl) {
                        Editor.ABBREV_SYNTAX = false;
                    }
                    GSSManager.this.application.reset(false);
                    GSSManager.this.application.rdfLdr.loadAndStyle(file, RDFLoader.RDF_XML_READER);
                    if (Editor.dltOnExit && file != null) {
                        file.deleteOnExit();
                    }
                    GSSManager.this.application.updatePrefixBindingsInGraph();
                    Editor.vsm.getView("Graph").setCursorIcon(-1);
                    return null;
                }
            };
            swingWorker.start();
        }
    }

    protected void initStyleTables() {
        Vector vector = this.getStylesheetList();
        this.stylesheets = new GraphStylesheet[vector.size()];
        int n = vector.size() - 1;
        while (n >= 0) {
            this.stylesheets[vector.size() - 1 - n] = (GraphStylesheet)vector.elementAt(n);
            --n;
        }
        this.resource2styleTable = new Hashtable();
        this.property2styleTable = new Hashtable();
        this.literal2styleTable = new Hashtable();
    }

    protected void cleanStyleTables() {
        this.resource2styleTable.clear();
        this.property2styleTable.clear();
        this.literal2styleTable.clear();
        this.resource2styleTable = null;
        this.property2styleTable = null;
        this.literal2styleTable = null;
    }

    StyleInfoR getStyle(IResource iResource) {
        return (StyleInfoR)this.resource2styleTable.get(iResource);
    }

    StyleInfoR computeAndGetStyle(IResource iResource) {
        StyleInfoR styleInfoR;
        if (this.resource2styleTable.containsKey(iResource)) {
            styleInfoR = (StyleInfoR)this.resource2styleTable.get(iResource);
        } else {
            styleInfoR = new StyleInfoR();
            this.resource2styleTable.put(iResource, styleInfoR);
            int n = 0;
            while (n < this.stylesheets.length) {
                Vector vector = this.stylesheets[n].evaluateRules(iResource);
                int n2 = 0;
                while (n2 < vector.size()) {
                    Object e = vector.elementAt(n2);
                    if (this.stylesheets[n].rStyleRules.containsKey(e)) {
                        Vector vector2 = (Vector)this.stylesheets[n].rStyleRules.get(e);
                        int n3 = 0;
                        while (n3 < vector2.size()) {
                            styleInfoR.applyStyle((Style)this.stylesheets[n].styles.get(vector2.elementAt(n3)));
                            ++n3;
                        }
                    }
                    styleInfoR.applyLayout((Integer)this.stylesheets[n].rLayoutRules.get(e));
                    styleInfoR.applyVisibility((Integer)this.stylesheets[n].rVisRules.get(e));
                    if (styleInfoR.isFullySpecified() || styleInfoR.isDisplayNone() || styleInfoR.isVisibilityHiddenAndShapeSpecified()) {
                        return styleInfoR;
                    }
                    ++n2;
                }
                ++n;
            }
        }
        return styleInfoR;
    }

    StyleInfoP getStyle(IProperty iProperty) {
        return (StyleInfoP)this.property2styleTable.get(iProperty);
    }

    StyleInfoP computeAndGetStyle(IProperty iProperty) {
        StyleInfoP styleInfoP;
        if (this.property2styleTable.containsKey(iProperty)) {
            styleInfoP = (StyleInfoP)this.property2styleTable.get(iProperty);
        } else {
            styleInfoP = new StyleInfoP();
            this.property2styleTable.put(iProperty, styleInfoP);
            int n = 0;
            while (n < this.stylesheets.length) {
                Vector vector = this.stylesheets[n].evaluateRules(iProperty);
                int n2 = 0;
                while (n2 < vector.size()) {
                    Object e = vector.elementAt(n2);
                    if (this.stylesheets[n].pStyleRules.containsKey(e)) {
                        Vector vector2 = (Vector)this.stylesheets[n].pStyleRules.get(e);
                        int n3 = 0;
                        while (n3 < vector2.size()) {
                            styleInfoP.applyStyle((Style)this.stylesheets[n].styles.get(vector2.elementAt(n3)));
                            ++n3;
                        }
                    }
                    styleInfoP.applyLayout((Integer)this.stylesheets[n].pLayoutRules.get(e));
                    styleInfoP.applyVisibility((Integer)this.stylesheets[n].pVisRules.get(e));
                    if (styleInfoP.isFullySpecified() || styleInfoP.isDisplayNone() || styleInfoP.isVisibilityHidden()) {
                        return styleInfoP;
                    }
                    ++n2;
                }
                ++n;
            }
        }
        return styleInfoP;
    }

    StyleInfoL getStyle(ILiteral iLiteral) {
        return (StyleInfoL)this.literal2styleTable.get(iLiteral);
    }

    StyleInfoL computeAndGetStyle(ILiteral iLiteral) {
        StyleInfoL styleInfoL;
        if (this.literal2styleTable.containsKey(iLiteral)) {
            styleInfoL = (StyleInfoL)this.literal2styleTable.get(iLiteral);
        } else {
            styleInfoL = new StyleInfoL();
            this.literal2styleTable.put(iLiteral, styleInfoL);
            int n = 0;
            while (n < this.stylesheets.length) {
                Vector vector = this.stylesheets[n].evaluateRules(iLiteral);
                int n2 = 0;
                while (n2 < vector.size()) {
                    Object e = vector.elementAt(n2);
                    if (this.stylesheets[n].lStyleRules.containsKey(e)) {
                        Vector vector2 = (Vector)this.stylesheets[n].lStyleRules.get(e);
                        int n3 = 0;
                        while (n3 < vector2.size()) {
                            styleInfoL.applyStyle((Style)this.stylesheets[n].styles.get(vector2.elementAt(n3)));
                            ++n3;
                        }
                    }
                    styleInfoL.applyLayout((Integer)this.stylesheets[n].lLayoutRules.get(e));
                    styleInfoL.applyVisibility((Integer)this.stylesheets[n].lVisRules.get(e));
                    if (styleInfoL.isFullySpecified() || styleInfoL.isDisplayNone() || styleInfoL.isVisibilityHiddenAndShapeSpecified()) {
                        return styleInfoL;
                    }
                    ++n2;
                }
                ++n;
            }
        }
        return styleInfoL;
    }
}

