/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.IsaViz;

import org.w3c.IsaViz.GSSSPStatement;
import org.w3c.IsaViz.GSSSelector;
import org.w3c.IsaViz.GraphStylesheet;
import org.w3c.IsaViz.ILiteral;
import org.w3c.IsaViz.Utils;

public class GSSLitSelector
extends GSSSelector {
    String datatype;
    String value;
    GSSSPStatement objectOfStatement;

    GSSLitSelector(String string, String string2, GSSSPStatement gSSSPStatement) {
        this.datatype = string;
        if (this.datatype != null && this.datatype.length() == 0) {
            this.datatype = null;
        }
        this.value = string2;
        if (this.value != null) {
            if (this.value.length() > 0) {
                this.value = Utils.delLeadingAndTrailingSpaces(this.value);
            }
            if (this.value.length() == 0) {
                this.value = null;
            }
        }
        this.objectOfStatement = gSSSPStatement;
        if (this.objectOfStatement != null && this.objectOfStatement.getSubjectType() == null && this.objectOfStatement.getSubjectURI() == null && this.objectOfStatement.getPredicateURI() == null) {
            this.objectOfStatement = null;
        }
        this.computeWeight();
    }

    protected void computeWeight() {
        this.weight = 0;
        if (this.value != null) {
            this.weight += GSSSelector.lSelValue;
        }
        if (this.datatype != null) {
            this.weight += GSSSelector.lSelDatatype;
        }
        if (this.objectOfStatement != null) {
            if (this.objectOfStatement.getPredicateURI() != null) {
                this.weight += GSSSelector.lSelPredicateURI;
            }
            if (this.objectOfStatement.getSubjectURI() != null) {
                this.weight += GSSSelector.lSelSubjectURI;
            }
            if (this.objectOfStatement.getSubjectType() != null) {
                this.weight += GSSSelector.lSelSubjectType;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean selects(ILiteral iLiteral) {
        Object object;
        boolean bl = true;
        if (this.datatype != null) {
            object = iLiteral.getDatatype();
            if (this.datatype.equals(GraphStylesheet._gssPlainLiterals)) {
                if (object != null) {
                    return false;
                }
            } else if (this.datatype.equals(GraphStylesheet._gssAllDatatypes)) {
                if (object == null) {
                    return false;
                }
            } else {
                if (object == null) {
                    return false;
                }
                if (!this.datatype.equals(object.getURI())) {
                    return false;
                }
            }
        }
        if (this.value != null) {
            object = iLiteral.getValue();
            if (object == null) return false;
            if (((String)(object = Utils.delLeadingAndTrailingSpaces((String)object))).length() <= 0) return false;
            if (!this.value.equals(object)) {
                return false;
            }
        }
        if (this.objectOfStatement == null) return bl;
        return this.objectOfStatement.selects(iLiteral);
    }

    public String toString() {
        String string = "";
        string = string + "\t selector weight=" + this.weight + "\n";
        string = string + "\t datatype=" + this.datatype + "\n";
        string = string + "\t value=" + this.value + "\n";
        if (this.objectOfStatement != null) {
            string = string + "\t objectOfStatement [subject URI,subject type,predicate URI] = [" + this.objectOfStatement.getSubjectURI() + "," + this.objectOfStatement.getSubjectType() + "," + this.objectOfStatement.getPredicateURI() + "]\n";
        }
        return string;
    }
}

