/*
 * Decompiled with CFR 0.152.
 */
package net.claribole.zvtm.glyphs;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import net.claribole.zvtm.glyphs.GlyphFactory;
import net.claribole.zvtm.glyphs.GlyphPanel;

class VEllPanel
extends GlyphPanel
implements MouseMotionListener,
MouseListener {
    int cw;
    int ch;
    int arhx = -1;
    int arhy = -1;
    int hdx2;
    int hdy2;
    double ratioAngle;

    VEllPanel(GlyphFactory glyphFactory) {
        super(glyphFactory);
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this.arhx == -1 && this.arhy == -1) {
            this.hdx2 = Math.round((float)this.cx * 0.707f);
            this.hdy2 = Math.round((float)this.cy * 0.707f);
            this.hdx = Math.abs(this.hdx2);
            this.hdy = Math.abs(this.hdy2);
            this.updateRatioHandle();
        }
        this.gf.aspectRatio = this.hdx == 0 && this.hdy == 0 ? 1.0 : Math.abs((double)this.hdx / (double)this.hdy);
        if (this.gf.aspectRatio == 1.0) {
            this.cw = this.cs;
            this.ch = this.cs;
        } else if (this.gf.aspectRatio > 1.0) {
            this.cw = this.cs;
            this.ch = (int)Math.round((double)this.cs / this.gf.aspectRatio);
        } else {
            this.cw = (int)Math.round((double)this.cs * this.gf.aspectRatio);
            this.ch = this.cs;
        }
        if (this.alpha > 0.0) {
            if (this.alpha == 1.0) {
                this.g2d.setColor(this.fColor);
                this.g2d.fillOval(this.cx - this.cw, this.cy - this.ch, 2 * this.cw, 2 * this.ch);
            } else {
                this.g2d.setColor(this.fColor);
                this.g2d.setComposite(this.acST);
                this.g2d.fillOval(this.cx - this.cw, this.cy - this.ch, 2 * this.cw, 2 * this.ch);
                this.g2d.setComposite(acO);
            }
        }
        this.g2d.setColor(this.bColor);
        this.g2d.drawOval(this.cx - this.cw, this.cy - this.ch, 2 * this.cw, 2 * this.ch);
        if (this.displayIndicators) {
            if (this.selectedVertex == 0) {
                this.g2d.setColor(Color.red);
                this.g2d.fillRect(this.arhx - 3, this.arhy - 3, 6, 6);
                this.g2d.setColor(Color.black);
            } else {
                this.g2d.setColor(Color.black);
                this.g2d.fillRect(this.arhx - 3, this.arhy - 3, 6, 6);
            }
            this.g2d.setStroke(dashed);
            this.g2d.drawOval(0, 0, this.pw - 1, this.ph - 1);
            this.g2d.drawLine(this.cx, this.cy, this.arhx, this.arhy);
        }
    }

    void updateRatioHandle() {
        this.ratioAngle = this.hdy2 != 0 ? (this.hdy2 < 0 ? (this.hdx2 < 0 ? Math.atan((double)this.hdx2 / (double)this.hdy2) : Math.PI * 2 + Math.atan((double)this.hdx2 / (double)this.hdy2)) : (this.hdx2 < 0 ? Math.PI + Math.atan((double)this.hdx2 / (double)this.hdy2) : Math.PI + Math.atan((double)this.hdx2 / (double)this.hdy2))) : (this.hdx2 > 0 ? 4.71238898038469 : 1.5707963267948966);
        this.arhx = this.cx - (int)Math.round(Math.sin(this.ratioAngle) * (double)this.cx);
        this.arhy = this.cy - (int)Math.round(Math.cos(this.ratioAngle) * (double)this.cy);
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.selectedVertex == 0) {
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            this.hdx2 = n - this.cx;
            this.hdy2 = n2 - this.cy;
            this.hdx = Math.abs(this.hdx2);
            this.hdy = Math.abs(this.hdy2);
            this.updateRatioHandle();
            this.repaint();
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        boolean bl = false;
        if (GlyphFactory.hasEditableVertexValues() && this.arhx - 3 <= n && n <= this.arhx + 3 && this.arhy - 3 <= n2 && n2 <= this.arhy + 3) {
            this.selectedVertex = 0;
            bl = true;
        }
        if (!bl) {
            this.selectedVertex = -1;
        }
        this.repaint();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.setCursor(new Cursor(1));
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }
}

