/*
 * Decompiled with CFR 0.152.
 */
package net.claribole.zvtm.glyphs;

import com.xerox.VTM.glyphs.Glyph;
import com.xerox.VTM.glyphs.VCircle;
import com.xerox.VTM.glyphs.VDiamond;
import com.xerox.VTM.glyphs.VEllipse;
import com.xerox.VTM.glyphs.VOctagon;
import com.xerox.VTM.glyphs.VRectangle;
import com.xerox.VTM.glyphs.VShape;
import com.xerox.VTM.glyphs.VTriangle;
import com.xerox.VTM.glyphs.VTriangleOr;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;

public class GlyphUtils {
    public static Shape getJava2DShape(Glyph glyph) {
        if (glyph instanceof VEllipse) {
            VEllipse vEllipse = (VEllipse)glyph;
            return new Ellipse2D.Double(vEllipse.vx - vEllipse.getWidth(), vEllipse.vy - vEllipse.getHeight(), vEllipse.getWidth() * 2L, vEllipse.getHeight() * 2L);
        }
        if (glyph instanceof VRectangle) {
            VRectangle vRectangle = (VRectangle)glyph;
            return new Rectangle2D.Double(vRectangle.vx - vRectangle.getWidth(), vRectangle.vy - vRectangle.getHeight(), vRectangle.getWidth() * 2L, vRectangle.getHeight() * 2L);
        }
        if (glyph instanceof VCircle) {
            return new Ellipse2D.Double((float)glyph.vx - glyph.getSize(), (float)glyph.vy - glyph.getSize(), glyph.getSize() * 2.0f, glyph.getSize() * 2.0f);
        }
        if (glyph instanceof VShape) {
            VShape vShape = (VShape)glyph;
            float f = vShape.getOrient();
            float[] fArray = vShape.getVertices();
            int[] nArray = new int[fArray.length];
            int[] nArray2 = new int[fArray.length];
            float f2 = glyph.getSize();
            for (int i = 0; i < fArray.length - 1; ++i) {
                nArray[i] = (int)Math.round((double)vShape.vx + (double)f2 * Math.cos(f) * (double)fArray[i]);
                nArray2[i] = (int)Math.round((double)vShape.vy + (double)f2 * Math.sin(f) * (double)fArray[i]);
                f = (float)((double)f + Math.PI * 2 / (double)fArray.length);
            }
            nArray[fArray.length - 1] = (int)Math.round((double)vShape.vx + (double)f2 * Math.cos(f) * (double)fArray[fArray.length - 1]);
            nArray2[fArray.length - 1] = (int)Math.round((double)vShape.vy + (double)f2 * Math.sin(f) * (double)fArray[fArray.length - 1]);
            return new Polygon(nArray, nArray2, fArray.length);
        }
        if (glyph instanceof VTriangle) {
            int n = Math.round(glyph.getSize());
            int n2 = Math.round(0.866f * glyph.getSize());
            int n3 = Math.round(0.5f * glyph.getSize());
            if (glyph instanceof VTriangleOr) {
                float f = glyph.getOrient();
                int[] nArray = new int[3];
                int[] nArray3 = new int[3];
                nArray[0] = (int)Math.round((double)glyph.vx - (double)n * Math.sin(f));
                nArray[1] = (int)Math.round((double)glyph.vx - (double)n2 * Math.cos(f) + (double)n3 * Math.sin(f));
                nArray[2] = (int)Math.round((double)glyph.vx + (double)n2 * Math.cos(f) + (double)n3 * Math.sin(f));
                nArray3[0] = (int)Math.round((double)glyph.vy + (double)n * Math.cos(f));
                nArray3[1] = (int)Math.round((double)glyph.vy - (double)n3 * Math.cos(f) + (double)n2 * Math.sin(f));
                nArray3[2] = (int)Math.round((double)glyph.vy - (double)n3 * Math.cos(f) - (double)n2 * Math.sin(f));
                return new Polygon(nArray, nArray3, 3);
            }
            int[] nArray = new int[]{(int)glyph.vx, (int)glyph.vx - n2, (int)glyph.vx + n2};
            int[] nArray4 = new int[]{(int)glyph.vy + n, (int)glyph.vy - n3, (int)glyph.vy - n3};
            return new Polygon(nArray, nArray4, 3);
        }
        if (glyph instanceof VDiamond) {
            int n = Math.round(glyph.getSize());
            int[] nArray = new int[]{(int)glyph.vx + n, (int)glyph.vx, (int)glyph.vx - n, (int)glyph.vx};
            int[] nArray5 = new int[]{(int)glyph.vy, (int)glyph.vy - n, (int)glyph.vy, (int)glyph.vy + n};
            return new Polygon(nArray, nArray5, 4);
        }
        if (glyph instanceof VOctagon) {
            int n = Math.round(glyph.getSize());
            int n4 = Math.round(0.5f * glyph.getSize());
            int[] nArray = new int[]{(int)glyph.vx + n, (int)glyph.vx + n4, (int)glyph.vx - n4, (int)glyph.vx - n, (int)glyph.vx - n, (int)glyph.vx - n4, (int)glyph.vx + n4, (int)glyph.vx + n};
            int[] nArray6 = new int[]{(int)glyph.vy + n4, (int)glyph.vy + n, (int)glyph.vy + n, (int)glyph.vy + n4, (int)glyph.vy - n4, (int)glyph.vy - n, (int)glyph.vy - n, (int)glyph.vy - n4};
            return new Polygon(nArray, nArray6, 8);
        }
        return new Rectangle2D.Double(glyph.vx, glyph.vy, 1.0, 1.0);
    }
}

