/*
 * Decompiled with CFR 0.152.
 */
package net.claribole.zvtm.glyphs;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import javax.swing.JPanel;
import net.claribole.zvtm.glyphs.GlyphFactory;

class GlyphPanel
extends JPanel {
    GlyphFactory gf;
    int pw;
    int ph;
    int cx;
    int cy;
    int cs;
    double vertexAngle;
    double[] vertices;
    int[] xcoords;
    int[] ycoords;
    Color fColor;
    Color bColor;
    double alpha = 1.0;
    int selectedVertex = -1;
    int hdx;
    int hdy;
    int xorientHandle;
    int yorientHandle;
    Object alias = RenderingHints.VALUE_ANTIALIAS_OFF;
    boolean displayGrid = false;
    boolean displayIndicators = true;
    Stroke continuous;
    static float[] dash1 = new float[]{5.0f};
    static Stroke dashed = new BasicStroke(1.0f, 0, 0, 10.0f, dash1, 0.0f);
    static AlphaComposite acO = AlphaComposite.getInstance(3);
    AlphaComposite acST = AlphaComposite.getInstance(3, (float)this.alpha);
    static Color gridGray = new Color(190, 190, 190);
    Graphics2D g2d;

    GlyphPanel(GlyphFactory glyphFactory) {
        super(true);
        this.gf = glyphFactory;
        this.fColor = this.gf.fillColor;
        this.bColor = this.gf.borderColor;
        this.alpha = this.gf.alpha;
        this.acST = AlphaComposite.getInstance(3, (float)this.alpha);
    }

    void setColor(Color color, Color color2) {
        this.fColor = color;
        this.bColor = color2;
        this.repaint();
    }

    void setAngle(double d) {
        this.vertexAngle = d;
        this.repaint();
    }

    void setTransparency(double d) {
        this.alpha = d;
        this.acST = AlphaComposite.getInstance(3, (float)this.alpha);
        this.repaint();
    }

    void setVertices(double[] dArray) {
        this.vertices = new double[dArray.length];
        this.xcoords = new int[this.vertices.length];
        this.ycoords = new int[this.vertices.length];
        System.arraycopy(dArray, 0, this.vertices, 0, dArray.length);
        this.repaint();
    }

    void setAntialiasing(boolean bl) {
        this.alias = bl ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF;
        this.repaint();
    }

    void setGrid(boolean bl) {
        this.displayGrid = bl;
        this.repaint();
    }

    void setGeom(boolean bl) {
        this.displayIndicators = bl;
        this.repaint();
    }

    public void paint(Graphics graphics) {
        this.pw = this.getSize().width;
        this.ph = this.getSize().height;
        this.g2d = (Graphics2D)graphics;
        this.g2d.clearRect(0, 0, this.pw, this.ph);
        this.g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, this.alias);
        this.continuous = this.g2d.getStroke();
        this.vertexAngle = this.gf.angle;
        this.cs = Math.round(Math.min(this.pw, this.ph) / 2 - 20);
        this.cx = this.pw / 2;
        this.cy = this.ph / 2;
        if (this.displayGrid) {
            this.g2d.setColor(gridGray);
            for (int i = 0; i < this.pw; i += 30) {
                this.g2d.drawLine(0, i, this.pw, i);
                this.g2d.drawLine(i, 0, i, this.ph);
            }
        }
        if (this.gf.orientable && this.displayIndicators) {
            this.g2d.setColor(Color.black);
            this.xorientHandle = (int)Math.round(-Math.sin(this.gf.angle) * (double)this.cs * 1.1) + this.cx;
            this.yorientHandle = -((int)Math.round(Math.cos(this.gf.angle) * (double)this.cs * 1.1)) + this.cy;
            this.g2d.drawLine(this.cx, this.cy, this.xorientHandle, this.yorientHandle);
            if (this.selectedVertex == -2) {
                this.g2d.setColor(Color.red);
            }
            this.g2d.fillOval(this.xorientHandle - 4, this.yorientHandle - 4, 8, 8);
        }
    }

    void orientDrag(MouseEvent mouseEvent) {
        if (this.selectedVertex == -2) {
            this.hdx = mouseEvent.getX() - this.cx;
            this.hdy = mouseEvent.getY() - this.cy;
            if (this.hdy != 0) {
                if (this.hdy < 0) {
                    if (this.hdx < 0) {
                        this.gf.updateAngleSpin(Math.atan((double)this.hdx / (double)this.hdy));
                    } else {
                        this.gf.updateAngleSpin(Math.PI * 2 + Math.atan((double)this.hdx / (double)this.hdy));
                    }
                } else if (this.hdx < 0) {
                    this.gf.updateAngleSpin(Math.PI + Math.atan((double)this.hdx / (double)this.hdy));
                } else {
                    this.gf.updateAngleSpin(Math.PI + Math.atan((double)this.hdx / (double)this.hdy));
                }
            } else if (this.hdx > 0) {
                this.gf.updateAngleSpin(4.71238898038469);
            } else {
                this.gf.updateAngleSpin(1.5707963267948966);
            }
        }
    }
}

